from DefAnalysisLib import *
import cv2 as cv
from timeit import default_timer as timer
from ast import literal_eval



if __name__ == '__main__':
    print('Start')
    algolist = ['all of the below','defectSegGradThresholding', 'cellStdThresholding', 'imgProjection', 'otsuThresholding', 'adaptiveThresholding',
                'gaborFilterSegmentation', 'morphologicalSegmentation']
    print('The following algorithms can be analysed:\n#  algorithm\n')
    for i in range(len(algolist)):
        print('{}: {}'.format(i, algolist[i]))
    print('\n')
    
    algolist = [algolist[num] for num in list(map(int,(input('Enter your defectdetectionalgorithms of choice: ').split(',')))) if num != 0]
    print('\n')
    
    
    if len(algolist) == 0:
       # algolist = ['defectSegGradThresholding', 'cellStdThresholding', 
       #             'imgProjection', 'otsuThresholding', 'adaptiveThresholding', 
        #            'gaborFilterSegmentation', 'morphologicalSegmentation']
        
        algolist = ['defectSegGradThresholding', 
                    'imgProjection', 'adaptiveThresholding', 
                    'morphologicalSegmentation']
    
    images = {}
    configData = configHandler('config.ini', 'r')
    
    
    
    labeledImg = readImagesdWithLabelData(configData)
    
    labeledImg = Utils.addNoise(labeledImg, configData)
        
    
    allDefects = extractAllDefcropedImg(configData, labeledImg)
    
    
    images = extractAllDefImgs(labeledImg, configData) 
    
  
    #Preprocessing
    preProcImgs = imgPreProcessing(images, configData)
   
    print('Length: ', len(preProcImgs), '\n')
    #showImgs(preProcImgs, configData)
    print('Beginning Error Detection...\n')
    reports = []
    for c, algo in enumerate(algolist):
        
        print('...with {} and...\n'.format(algo))  
        start = timer()
        temp = vars()[algolist[c]]
        threshMatDict, rep = imgDictToImgWrapper(preProcImgs, vars()[algo], configData, timing=True)
        
        threshMatDict = imgDictToImgWrapper(threshMatDict, maskThresholding, configData)
        calctime = timer() - start
        rep["calctime"] =  calctime
        bondBoxDict = imgDictToImgWrapper(threshMatDict, mergeDefectAreas, configData)
        ovlp = segmentComp(labeledImg, bondBoxDict, configData)
        
        vars()[algo] = utils.DefDet(configData, algo, allDefects, images, labeledImg, preProcImgs, bondBoxDict, ovlp, threshMatDict, rep)
        reports.append(vars()[algo])
        vars()[algolist[c]] = temp
        
        if literal_eval(configData['Defect Segmentation: gridBasedAlgoHandler']['doGridBased']) == True:
            print('...with grid based {} and...\n'.format(algo))
            start = timer()
            
            grid_threshMatDict, grid_rep = gridBasedAlgoHandler(preProcImgs, vars()[algolist[c]], configData, timing=True)
            grid_threshMatDict = imgDictToImgWrapper(grid_threshMatDict, maskThresholding, configData)
            
            grid_bondBoxDict = imgDictToImgWrapper(grid_threshMatDict, mergeDefectAreas, configData)
            grid_ovlp = segmentComp(labeledImg, grid_bondBoxDict, configData)
            grid_calctime = timer() - start
            grid_rep["calctime"] =  calctime
            
            
            vars()[algo] = utils.DefDet(configData, 'grid ' + algo, allDefects, images, labeledImg, preProcImgs, grid_bondBoxDict, grid_ovlp, grid_threshMatDict, grid_rep)
            reports.append(vars()[algo])
            
        else: pass
            
            
    print('done.') 

    img_text, all_plots, names, newreport, comparison, f = report(reports)
   
    
    print('End!')