function hmS=create_heatmaps_raven(sX, sY)

Xres = 0:5:1920;
Yres = 0:5:1080;

hmS=NaN(size(sX,1),length(Xres),length(Yres));

for pp=1:size(sX,1)
    tempX=reshape(sX(pp,:,:),[12*42000,1]);
    tempY=reshape(sY(pp,:,:),[12*42000,1]);
    tempXY = hist3([tempX tempY],'ctrs',{Xres Yres});
    hmS(pp,:,:) = tempXY;
end

hmS=squeeze(sum(hmS,'omitnan')); % Participants with correct answer

figure
set(gcf,'Renderer','Painters')
surf(Xres,Yres,hmS'./size(sX,1),'edgecolor','none','FaceAlpha',1) % show heatmap; sum of data points is 10 seconds

hold on
% horizontal lines - response alternatives
plot3([458 715],[603 603],[-1000 -1000],'g--')
plot3([458 715],[827 827],[-1000 -1000],'g--')

plot3([716 972],[603 603],[-1000 -1000],'g--')
plot3([716 972],[827 827],[-1000 -1000],'g--')

plot3([973 1230],[603 603],[-1000 -1000],'g--')
plot3([973 1230],[827 827],[-1000 -1000],'g--')

plot3([1231 1488],[603 603],[-1000 -1000],'g--')
plot3([1231 1488],[827 827],[-1000 -1000],'g--')

% horizontal lines - response alternatives
plot3([458 715],[833 833],[-1000 -1000],'g--')
plot3([458 715],[1057 1057],[-1000 -1000],'g--')

plot3([716 972],[833 833],[-1000 -1000],'g--')
plot3([716 972],[1057 1057],[-1000 -1000],'g--')

plot3([973 1230],[833 833],[-1000 -1000],'g--')
plot3([973 1230],[1057 1057],[-1000 -1000],'g--')

plot3([1231 1488],[833 833],[-1000 -1000],'g--')
plot3([1231 1488],[1057 1057],[-1000 -1000],'g--')

% vertical lines - response alternatives
plot3([458 458],[603 827],[-1000 -1000],'g--')
plot3([715 715],[603 827],[-1000 -1000],'g--')

plot3([716 716],[603 827],[-1000 -1000],'g--')
plot3([972 972],[603 827],[-1000 -1000],'g--')

plot3([973 973],[603 827],[-1000 -1000],'g--')
plot3([1230 1230],[603 827],[-1000 -1000],'g--')

plot3([1231 1231],[603 827],[-1000 -1000],'g--')
plot3([1488 1488],[603 827],[-1000 -1000],'g--')

% vertical lines - response alternatives
plot3([458 458],[833 1057],[-1000 -1000],'g--')
plot3([715 715],[833 1057],[-1000 -1000],'g--')

plot3([716 716],[833 1057],[-1000 -1000],'g--')
plot3([972 972],[833 1057],[-1000 -1000],'g--')

plot3([973 973],[833 1057],[-1000 -1000],'g--')
plot3([1230 1230],[833 1057],[-1000 -1000],'g--')

plot3([1231 1231],[833 1057],[-1000 -1000],'g--')
plot3([1488 1488],[833 1057],[-1000 -1000],'g--')

% horizontal lines - matrix
plot3([599 846],[51 51],[-1000 -1000],'g--')
plot3([847 1094],[51 51],[-1000 -1000],'g--')
plot3([1095 1342],[51 51],[-1000 -1000],'g--')

plot3([599 846],[213 213],[-1000 -1000],'g--')
plot3([847 1094],[213 213],[-1000 -1000],'g--')
plot3([1095 1342],[213 213],[-1000 -1000],'g--')

plot3([599 846],[214 214],[-1000 -1000],'g--')
plot3([847 1094],[214 214],[-1000 -1000],'g--')
plot3([1095 1342],[214 214],[-1000 -1000],'g--')

plot3([599 846],[376 376],[-1000 -1000],'g--')
plot3([847 1094],[376 376],[-1000 -1000],'g--')
plot3([1095 1342],[376 376],[-1000 -1000],'g--')

plot3([599 846],[377 377],[-1000 -1000],'g--')
plot3([847 1094],[377 377],[-1000 -1000],'g--')
plot3([1095 1342],[377 377],[-1000 -1000],'g--')

plot3([599 846],[539 539],[-1000 -1000],'g--')
plot3([847 1094],[539 539],[-1000 -1000],'g--')
plot3([1095 1342],[539 539],[-1000 -1000],'g--')

% vertical lines - matrix
plot3([599 599],[51 213],[-1000 -1000],'g--')
plot3([599 599],[214 376],[-1000 -1000],'g--')
plot3([599 599],[377 539],[-1000 -1000],'g--')

plot3([846 846],[51 213],[-1000 -1000],'g--')
plot3([846 846],[214 376],[-1000 -1000],'g--')
plot3([846 846],[377 539],[-1000 -1000],'g--')

plot3([846 846],[51 213],[-1000 -1000],'g--')
plot3([846 846],[214 376],[-1000 -1000],'g--')
plot3([846 846],[377 539],[-1000 -1000],'g--')

plot3([847 847],[51 213],[-1000 -1000],'g--')
plot3([847 847],[214 376],[-1000 -1000],'g--')
plot3([847 847],[377 539],[-1000 -1000],'g--')

plot3([1094 1094],[51 213],[-1000 -1000],'g--')
plot3([1094 1094],[214 376],[-1000 -1000],'g--')
plot3([1094 1094],[377 539],[-1000 -1000],'g--')

plot3([1095 1095],[51 213],[-1000 -1000],'g--')
plot3([1095 1095],[214 376],[-1000 -1000],'g--')
plot3([1095 1095],[377 539],[-1000 -1000],'g--')

plot3([1342 1342],[51 213],[-1000 -1000],'g--')
plot3([1342 1342],[214 376],[-1000 -1000],'g--')
plot3([1342 1342],[377 539],[-1000 -1000],'g--')

view(0,270);box on;
a=colorbar;
a.Label.String = 'Heatmap value';
colormap(jet)
xlabel('\it{x}\rm-coordinate')
ylabel('\it{y}\rm-coordinate')
set(gca,'xlim',[0 1920])
set(gca,'ylim',[0 1080])
h=findobj('FontName','Helvetica'); set(h,'FontSize',26,'Fontname','Arial')
set(gca,'TickDir','out','LooseInset',[0.01 0.01 0.04 0.01])

end
