# -*- coding: utf-8 -*-
"""
Created on Fri Apr 11 11:59:09 2025

@author: bagch002
"""



import tkinter as tk
from tkinter import filedialog
import os
import numpy as np
import matplotlib.pyplot as plt
import pandas as pd
import os as os
import matplotlib.gridspec as gridspec
import scipy.stats as stats



#%% functions 

# Function to handle button click
def open_ascii_files():
    # Open file dialog to select folder
    root = tk.Tk()
    root.withdraw()
    folder_path = filedialog.askdirectory()
 
    # Dictionary to store NumPy arrays with filenames as keys
    array_time = {}
    array_DAS = {} 
 
    # Loop through all files in the selected folder
    for filename in os.listdir(folder_path):
        # Check if the file has a .ascii extension (ASCII file)
        if filename.endswith(".ascii"):
            # Extract the NumPy array from the ASCII file
            file_path = os.path.join(folder_path, filename)
            with open(file_path, 'r') as file:
                # Skip the first row (header) in the ASCII file
                lines = file.readlines()[1:]
                data = np.array([list(map(float, line.split())) for line in lines])
 
                # Get the indices of columns with same content as the first column
                duplicate_indices = [i for i in range(1, data.shape[1]) if np.array_equal(data[:, 0], data[:, i])]
 
                # Create a new array without the duplicate columns
                unique_indices = list(set(range(data.shape[1])) - set(duplicate_indices))
                new_data = data[:, unique_indices]

 
                if 'time' in filename: 
                    array_time[filename] = new_data

                if 'DAS' in filename: 
                    array_DAS[filename] = new_data
 
 
    # Return the dictionary of NumPy arrays
    return array_time, array_DAS,folder_path

def plot_DAS(array,title_string,array_lt):
    #determine the average and standard deviation of the DAS
    average_columns = np.mean(array,axis=0)
    std_colums=np.std(array,axis=0)
    
    #get the standard deviation and average of the lifetimes 
    average_lt = np.mean(array_lt,axis=0)
    std_lt=np.std(array_lt,axis=0)
    
    
    colours=['steelblue', 'lightsalmon','orangered','#af2f0d']

    plt.figure()
    for x in range(0,len(array[0][0,:])-1):
        labels='{:.1f}'.format(average_lt[x])+' ± '+'{:.1f}'.format(std_lt[x])+' ps'
        plt.plot(average_columns[:,0],average_columns[:,x+1],color=colours[x],label=labels)
        plt.fill_between(average_columns[:,0],average_columns[:,x+1]-(std_colums[:,x+1]/2),average_columns[:,x+1]+(std_colums[:,x+1]/2),color=colours[x],alpha=0.6)
    plt.xlabel('Wavelength (nm)')
    plt.ylabel('Intensity')
    #plt.ylim(-0.1,2)
    plt.title(title_string) 
    plt.legend()
    plt.tight_layout()

    plt.savefig(folder_path+'/'+title_string+'_unmixed.png',dpi=1200,bbox_inches='tight')
    plt.show()  
    
    if 'F0' in title_string: 
        contribution=[arr[:, -1:].sum() for arr in array]
        print(title_string+str(np.mean(contribution))+'+/-'+str(np.std(contribution)))

def plot_DAS_PSI(array1,array2,array_lt1,array_lt2, title_string):
    
    
    #divide the arrays by the max PSI value to get the normalized PSI spectrum 
    max_PSI1=np.max(array1[:,:,1],axis=1)
    max_PSI2=np.max(array2[:,:,1],axis=1)
    
    max_PSI1=max_PSI1[:, np.newaxis]
    max_PSI2=max_PSI2[:, np.newaxis]

    array1[:, :, 1] = array1[:, :, 1] / max_PSI1
    array2[:, :, 1] = array2[:, :, 1] / max_PSI2
    
    #determine the average and standard deviation of the DAS
    average_columns1 = np.mean(array1,axis=0)
    std_colums1=np.std(array1,axis=0)
    
    average_columns2 = np.mean(array2,axis=0)
    std_colums2=np.std(array2,axis=0)
    
    
    
    
    #get the standard deviation and average of the lifetimes 
    average_lt1 = np.mean(array_lt1,axis=0)
    std_lt1=np.std(array_lt1,axis=0)
    average_lt2 = np.mean(array_lt2,axis=0)
    std_lt2=np.std(array_lt2,axis=0)
    
    #define things for the plot 
    colours=['#4D6F8B','steelblue']
    label1='Dark | '+'{:.1f}'.format(average_lt1[0])+' ± '+'{:.1f}'.format(std_lt1[0])+' ps'
    label2='2h HL | '+'{:.1f}'.format(average_lt2[0])+' ± '+'{:.1f}'.format(std_lt2[0])+' ps'

    

    plt.figure()
    plt.plot(average_columns1[:,0],average_columns1[:,1],color=colours[0],label=label1)
    plt.fill_between(average_columns1[:,0],average_columns1[:,1]-(std_colums1[:,1]/2),average_columns1[:,1]+(std_colums1[:,1]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columns2[:,0],average_columns2[:,1],color=colours[1],label=label2)
    plt.fill_between(average_columns2[:,0],average_columns2[:,1]-(std_colums2[:,1]/2),average_columns2[:,1]+(std_colums2[:,1]/2),color=colours[1],alpha=0.6)

    
    
    plt.xlabel('Wavelength (nm)')
    plt.ylabel('Intensity')
    #plt.ylim(-0.1,2)
    plt.title('PSI Fm '+title_string) 
    plt.legend()
    plt.savefig(folder_path+'/'+title_string+'_PSI_Fm_unmixed.png',dpi=1200,bbox_inches='tight')
    plt.show()  
    
    
    
def plot_DAS_PSII(array1,array2,array_lt1,array_lt2,title_string,title_string2):
    
    
    if 'Fm' in title_string:
        #divide the arrays by the max PSII value to get the normalized PSII spectrum 
        max_PSII1=np.max(array1[:,:,2],axis=1)
        max_PSII2=np.max(array2[:,:,2],axis=1)
        
        max_PSII1=max_PSII1[:, np.newaxis]
        max_PSII2=max_PSII2[:, np.newaxis]
        
    if 'F0' in title_string:
        #divide the arrays by the max PSII value to get the normalized PSII spectrum 
        max_PSII1=np.max(array1[:,:,3],axis=1)
        max_PSII2=np.max(array2[:,:,3],axis=1)

        
        max_PSII1=max_PSII1[:, np.newaxis]
        max_PSII2=max_PSII2[:, np.newaxis]

    

    array1[:, :, 2] = array1[:, :, 2] / max_PSII1
    array2[:, :, 2] = array2[:, :, 2] / max_PSII2
    
    array1[:, :, 3] = array1[:, :, 3] / max_PSII1
    array2[:, :, 3] = array2[:, :, 3] / max_PSII2
    
    if 'F0' in title_string:
        array1[:, :, 4] = array1[:, :, 4] / max_PSII1
        array2[:, :, 4] = array2[:, :, 4] / max_PSII2
    
    #determine the average and standard deviation of the DAS
    average_columns1 = np.mean(array1,axis=0)
    std_colums1=np.std(array1,axis=0)
    
    average_columns2 = np.mean(array2,axis=0)
    std_colums2=np.std(array2,axis=0)
    
    
    
    #define things for the plot 
    colours=['orangered', 'lightsalmon']
    label1='Dark'
    label2='2h HL'

    

    plt.figure()
    
    plt.plot(average_columns1[:,0],average_columns1[:,2],color=colours[0],label=label1)
    plt.fill_between(average_columns1[:,0],average_columns1[:,2]-(std_colums1[:,2]/2),average_columns1[:,2]+(std_colums1[:,2]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columns2[:,0],average_columns2[:,2],color=colours[1],label=label2)
    plt.fill_between(average_columns2[:,0],average_columns2[:,2]-(std_colums2[:,2]/2),average_columns2[:,2]+(std_colums2[:,2]/2),color=colours[1],alpha=0.6)

    
    plt.plot(average_columns1[:,0],average_columns1[:,3],color=colours[0])
    plt.fill_between(average_columns1[:,0],average_columns1[:,3]-(std_colums1[:,3]/2),average_columns1[:,3]+(std_colums1[:,3]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columns2[:,0],average_columns2[:,3],color=colours[1])
    plt.fill_between(average_columns2[:,0],average_columns2[:,3]-(std_colums2[:,3]/2),average_columns2[:,3]+(std_colums2[:,3]/2),color=colours[1],alpha=0.6)

    if 'F0' in title_string: 
        plt.plot(average_columns1[:,0],average_columns1[:,4],color=colours[0])
        plt.fill_between(average_columns1[:,0],average_columns1[:,4]-(std_colums1[:,4]/2),average_columns1[:,4]+(std_colums1[:,4]/2),color=colours[0],alpha=0.6)
        
        plt.plot(average_columns2[:,0],average_columns2[:,4],color=colours[1])
        plt.fill_between(average_columns2[:,0],average_columns2[:,4]-(std_colums2[:,4]/2),average_columns2[:,4]+(std_colums2[:,4]/2),color=colours[1],alpha=0.6)


    
    plt.xlabel('Wavelength (nm)')
    plt.ylabel('Intensity')
    #plt.ylim(-0.1,2)
    plt.title('PSII '+title_string+' '+title_string2) 
    plt.legend()
    plt.savefig(folder_path+'/'+title_string+title_string2+'_PSII_unmixed.png',dpi=1200,bbox_inches='tight')
    plt.show()  
    
    
def plot_DAS_F0_Fm(arrayFm,arrayF0,title_string,title_string2):
    
    
    #divide the arrays by the max PSII value to get the normalized PSII spectrum 
    max_PSII_Fm=np.max(arrayFm[:,:,2],axis=1)
    max_PSII_Fm=max_PSII_Fm[:, np.newaxis]
       
        
    max_PSII_F0=np.max(arrayF0[:,:,3],axis=1)
    max_PSII_F0=max_PSII_F0[:, np.newaxis]
       
    
    

    arrayFm[:, :, 2] = arrayFm[:, :, 2] / max_PSII_Fm
    arrayF0[:, :, 2] = arrayF0[:, :, 2] / max_PSII_F0
    

    arrayFm[:, :, 3] = arrayFm[:, :, 3] / max_PSII_Fm
    arrayF0[:, :, 3] = arrayF0[:, :, 3] / max_PSII_F0
    
    arrayF0[:, :, 4] = arrayF0[:, :, 4] / max_PSII_F0
    
    
    #determine the average and standard deviation of the DAS
    average_columnsFm = np.mean(arrayFm,axis=0)
    std_columsFm=np.std(arrayFm,axis=0)
    
    average_columnsF0 = np.mean(arrayF0,axis=0)
    std_columsF0=np.std(arrayF0,axis=0)
    

    
    #define things for the plot 
    colours=['orangered', 'lightsalmon']
    labelFm='Fm'
    labelF0='F0'
    

    plt.figure()
    
    plt.plot(average_columnsFm[:,0],average_columnsFm[:,2],color=colours[0],label=labelFm)
    plt.fill_between(average_columnsFm[:,0],average_columnsFm[:,2]-(std_columsFm[:,2]/2),average_columnsFm[:,2]+(std_columsFm[:,2]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columnsF0[:,0],average_columnsF0[:,2],color=colours[1],label=labelF0)
    plt.fill_between(average_columnsF0[:,0],average_columnsF0[:,2]-(std_columsF0[:,2]/2),average_columnsF0[:,2]+(std_columsF0[:,2]/2),color=colours[1],alpha=0.6)

    
    plt.plot(average_columnsFm[:,0],average_columnsFm[:,3],color=colours[0])
    plt.fill_between(average_columnsFm[:,0],average_columnsFm[:,3]-(std_columsFm[:,3]/2),average_columnsFm[:,3]+(std_columsFm[:,3]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columnsF0[:,0],average_columnsF0[:,3],color=colours[1])
    plt.fill_between(average_columnsF0[:,0],average_columnsF0[:,3]-(std_columsF0[:,3]/2),average_columnsF0[:,3]+(std_columsF0[:,3]/2),color=colours[1],alpha=0.6)

    plt.plot(average_columnsF0[:,0],average_columnsF0[:,4],color=colours[1])
    plt.fill_between(average_columnsF0[:,0],average_columnsF0[:,4]-(std_columsF0[:,4]/2),average_columnsF0[:,4]+(std_columsF0[:,4]/2),color=colours[1],alpha=0.6)

    
    plt.xlabel('Wavelength (nm)')
    plt.ylabel('Intensity')
    #plt.ylim(-0.1,2)
    plt.title('PSII F0 vs. Fm '+title_string+' '+title_string2) 
    plt.legend()
    plt.savefig(folder_path+'/'+title_string+title_string2+'_PSII_unmixed.png',dpi=1200,bbox_inches='tight')
    plt.show()          
        
#%% start code 

# Call the function to open ASCII files & store their contents as NumPy arrays
dict_time,dict_DAS,folder_path = open_ascii_files()



# Read plot labels from Excel file
excel_file_path = filedialog.askopenfilename(filetypes=[("Excel Files", "*.xlsx")])
lifetimes = pd.read_excel(excel_file_path)


#%% Normalise 
dict_DAS_norm={}
#get the amplitudes of the PSII spectra in case of Fm and F0 
dict_ampli={}

for key in dict_DAS: 
    #normalise the DAS 
    dict_DAS_norm[key]=dict_DAS[key]
    dict_DAS_norm[key][:,1:]=dict_DAS[key][:,1:]/np.sum(dict_DAS[key][:,1:])
    
for key in dict_DAS_norm: 
    x_data=dict_DAS_norm[key][:,0]
    y_data=dict_DAS_norm[key][:,1:]
    
    PSII_short_max=max(y_data[:,1])
    PSII_long_max=max(y_data[:,2])
    dict_ampli[key]=(PSII_short_max/(PSII_short_max+PSII_long_max),PSII_long_max/(PSII_short_max+PSII_long_max))
    

        
#%% make arrays with all the situations
#water

dark_Fm_w=[dict_DAS_norm[key] for key in dict_DAS_norm.keys() if 'Fm' in key and 'DA_' in key and 'water' in key]
dark_F0_w=[dict_DAS_norm[key] for key in dict_DAS_norm.keys() if 'Fo' in key and 'DA_' in key and 'water' in key]
HL_2h_Fm_w=[dict_DAS_norm[key] for key in dict_DAS_norm.keys() if 'Fm' in key and 'HL' in key and 'water' in key]
HL_2h_F0_w=[dict_DAS_norm[key] for key in dict_DAS_norm.keys() if 'Fo' in key and 'HL' in key and 'water' in key]

#make similar arrays for the lifetime 
dark_Fm_w_lt=np.asarray([lifetimes[lifetimes.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes['Ascii name'] if 'Fm' in key and 'DA_' in key and 'water' in key],dtype= 'float')
dark_F0_w_lt=np.asarray([lifetimes[lifetimes.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes['Ascii name'] if 'Fo' in key and 'DA_' in key and 'water' in key],dtype= 'float')
HL_2h_Fm_w_lt=np.asarray([lifetimes[lifetimes.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes['Ascii name'] if 'Fm' in key and 'HL' in key and 'water' in key],dtype= 'float')
HL_2h_F0_w_lt=np.asarray([lifetimes[lifetimes.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes['Ascii name'] if 'Fo' in key and 'HL' in key and 'water' in key],dtype= 'float')


#linco
dark_Fm_l=[dict_DAS_norm[key] for key in dict_DAS_norm.keys() if 'Fm' in key and 'DA_' in key and 'linco' in key]
dark_F0_l=[dict_DAS_norm[key] for key in dict_DAS_norm.keys() if 'Fo' in key and 'DA_' in key and 'linco' in key]
HL_2h_Fm_l=[dict_DAS_norm[key] for key in dict_DAS_norm.keys() if 'Fm' in key and 'HL' in key and 'linco' in key]
HL_2h_F0_l=[dict_DAS_norm[key] for key in dict_DAS_norm.keys() if 'Fo' in key and 'HL' in key and 'linco' in key]

#make similar arrays for the lifetime 
dark_Fm_l_lt=np.asarray([lifetimes[lifetimes.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes['Ascii name'] if 'Fm' in key and 'DA_' in key and 'linco' in key],dtype= 'float')
dark_F0_l_lt=np.asarray([lifetimes[lifetimes.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes['Ascii name'] if 'Fo' in key and 'DA_' in key and 'linco' in key],dtype= 'float')
HL_2h_Fm_l_lt=np.asarray([lifetimes[lifetimes.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes['Ascii name'] if 'Fm' in key and 'HL' in key and 'linco' in key],dtype= 'float')
HL_2h_F0_l_lt=np.asarray([lifetimes[lifetimes.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes['Ascii name'] if 'Fo' in key and 'HL' in key and 'linco' in key],dtype= 'float')

#%% plot the data 


plot_DAS(dark_Fm_w, 'Fm Dark water',dark_Fm_w_lt)
plot_DAS(dark_F0_w, 'F0 Dark water',dark_F0_w_lt)
plot_DAS(HL_2h_Fm_w, 'Fm 2h HL water',HL_2h_Fm_w_lt)
plot_DAS(HL_2h_F0_w, 'F0 2h HL water',HL_2h_F0_w_lt)

plot_DAS(dark_Fm_l, 'Fm Dark linco',dark_Fm_l_lt)
plot_DAS(dark_F0_l, 'F0 Dark linco',dark_F0_l_lt)
plot_DAS(HL_2h_Fm_l, 'Fm 2h HL linco',HL_2h_Fm_l_lt)
plot_DAS(HL_2h_F0_l, 'F0 2h HL linco',HL_2h_F0_l_lt)

#%% plot the different conditions together 

# plot_DAS_PSI(np.asarray(dark_Fm_l),np.asarray(HL_2h_Fm_l),dark_Fm_l_lt,HL_2h_Fm_l_lt, 'Lincomycin')

# plot_DAS_PSII(np.asarray(dark_Fm_l),np.asarray(HL_2h_Fm_l),dark_Fm_l_lt,HL_2h_Fm_l_lt,'Fm', 'Lincomycin')
# plot_DAS_PSII(np.asarray(dark_F0_l),np.asarray(HL_2h_F0_l),dark_F0_l_lt,HL_2h_F0_l_lt, 'F0', 'Lincomycin')

# plot_DAS_F0_Fm(np.asarray(dark_Fm_l),np.asarray(dark_F0_l),'Dark', 'Lincomycin')
# plot_DAS_F0_Fm(np.asarray(HL_2h_Fm_l),np.asarray(HL_2h_F0_l),'2h HL', 'Lincomycin')

# plot_DAS_PSI(np.asarray(dark_Fm_w),np.asarray(HL_2h_Fm_w),dark_Fm_w_lt,HL_2h_Fm_w_lt, 'Water')

# plot_DAS_PSII(np.asarray(dark_Fm_w),np.asarray(HL_2h_Fm_w),dark_Fm_w_lt,HL_2h_Fm_w_lt,'Fm', 'Water')
# plot_DAS_PSII(np.asarray(dark_F0_w),np.asarray(HL_2h_F0_w),dark_F0_w_lt,HL_2h_F0_w_lt, 'F0', 'Water')

# plot_DAS_F0_Fm(np.asarray(dark_Fm_w),np.asarray(dark_F0_w),'Dark', 'Water')
# plot_DAS_F0_Fm(np.asarray(HL_2h_Fm_w),np.asarray(HL_2h_F0_w),'2h HL', 'Water')



#%% Make dictionaries for the lifetimes and the amplitudes 

dict_contributions={}
dict_contributions_PSII={}

dict_lifetimes={}
dict_average_PSII={}
dict_average_all={}


for key in dict_DAS_norm.keys():
    #sum the total of the collumns with DAS spectra 
    length=len(dict_DAS_norm[key][0])-1
    total_sum=np.sum(dict_DAS_norm[key][:, -length:])
    total_sum_PSII=np.sum(dict_DAS_norm[key][:, -length+1:])

    
    #make an empty array  for the contributions 
    contributions=np.zeros(length)
    contributions_PSII=np.zeros(length-1)
    lifetime_values=np.zeros(length)
    
    for x in range(1,len(dict_DAS_norm[key][0])):
        contributions[x-1]=np.sum(dict_DAS_norm[key][:,x])/total_sum
        
    for x in range(2,len(dict_DAS_norm[key][0])):
        contributions_PSII[x-2]=np.sum(dict_DAS_norm[key][:,x])/total_sum_PSII

    
    dict_contributions[key] = contributions
    dict_contributions_PSII[key] = contributions_PSII

    
    
    

    #plot the numer of lines 
    #get the lifetimes from the excel 
    
    if key in lifetimes.iloc[:,0].values:
        #lifetime_values=lifetimes[]
        for i in range(length):
            lifetime_values[i] = lifetimes[lifetimes.iloc[:, 0] == key].iloc[0, i+1]
            
    if length>3:
        dict_average_PSII[key]=np.sum(dict_contributions_PSII[key]*lifetime_values[-3:])
        
    else:
        dict_average_PSII[key]=np.sum(dict_contributions_PSII[key]*lifetime_values[-2:])
        
    dict_average_all[key]=np.sum(dict_contributions[key]*lifetime_values)

    dict_lifetimes[key] = lifetime_values
    
    
#%% plot the files for the lifetimes 

#separate them into PSI, PSII short and PSII long components
# PSI 
dark_Fm_w_lt_PSI=dark_Fm_w_lt[:,0]
dark_F0_w_lt_PSI=dark_F0_w_lt[:,0]
HL_2h_Fm_w_lt_PSI=HL_2h_Fm_w_lt[:,0]
HL_2h_F0_w_lt_PSI=HL_2h_F0_w_lt[:,0]

dark_Fm_l_lt_PSI=dark_Fm_l_lt[:,0]
dark_F0_l_lt_PSI=dark_F0_l_lt[:,0]
HL_2h_Fm_l_lt_PSI=HL_2h_Fm_l_lt[:,0]
HL_2h_F0_l_lt_PSI=HL_2h_F0_l_lt[:,0]





# PSII short 
dark_Fm_w_lt_PSIIs=dark_Fm_w_lt[:,1]
dark_F0_w_lt_PSIIs=dark_F0_w_lt[:,1]
HL_2h_Fm_w_lt_PSIIs=HL_2h_Fm_w_lt[:,1]
HL_2h_F0_w_lt_PSIIs=HL_2h_F0_w_lt[:,1]

dark_Fm_l_lt_PSIIs=dark_Fm_l_lt[:,1]
dark_F0_l_lt_PSIIs=dark_F0_l_lt[:,1]
HL_2h_Fm_l_lt_PSIIs=HL_2h_Fm_l_lt[:,1]
HL_2h_F0_l_lt_PSIIs=HL_2h_F0_l_lt[:,1]


# PSII long
dark_Fm_w_lt_PSIIl=dark_Fm_w_lt[:,2]
HL_2h_Fm_w_lt_PSIIl=HL_2h_Fm_w_lt[:,2]
dark_F0_w_lt_PSIIl=dark_F0_w_lt[:,2]
HL_2h_F0_w_lt_PSIIl=HL_2h_F0_w_lt[:,2]

dark_Fm_l_lt_PSIIl=dark_Fm_l_lt[:,2]
HL_2h_Fm_l_lt_PSIIl=HL_2h_Fm_l_lt[:,2]
dark_F0_l_lt_PSIIl=dark_F0_l_lt[:,2]
HL_2h_F0_l_lt_PSIIl=HL_2h_F0_l_lt[:,2]

#%%
#amplitudes of the PSII components in Fm

#water
dark_Fm_w_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fm' in key and 'DA_' in key and 'water' in key])
HL_2h_Fm_w_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fm' in key and 'HL' in key and 'water' in key])

#linco
dark_Fm_l_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fm' in key and 'DA_' in key and 'linco' in key])
HL_2h_Fm_l_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fm' in key and 'HL' in key and 'linco' in key])


#short PSII
dark_Fm_w_c_PSIIs=dark_Fm_w_c[:,0]
HL_2h_Fm_w_c_PSIIs=HL_2h_Fm_w_c[:,0]

dark_Fm_l_c_PSIIs=dark_Fm_l_c[:,0]
HL_2h_Fm_l_c_PSIIs=HL_2h_Fm_l_c[:,0]

#long PSII
dark_Fm_w_c_PSIIl=dark_Fm_w_c[:,1]
HL_2h_Fm_w_c_PSIIl=HL_2h_Fm_w_c[:,1]

dark_Fm_l_c_PSIIl=dark_Fm_l_c[:,1]
HL_2h_Fm_l_c_PSIIl=HL_2h_Fm_l_c[:,1]




#%%
#amplitudes of the PSII F0 components after unmixing

#water
dark_F0_w_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fo' in key and 'DA_' in key and 'water' in key])
HL_2h_F0_w_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fo' in key and 'HL' in key and 'water' in key])

#linco
dark_F0_l_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fo' in key and 'DA_' in key and 'linco' in key])
HL_2h_F0_l_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fo' in key and 'HL' in key and 'linco' in key])

#short PSII
dark_F0_w_c_PSIIs=dark_F0_w_c[:,0]
HL_2h_F0_w_c_PSIIs=HL_2h_F0_w_c[:,0]

dark_F0_l_c_PSIIs=dark_F0_l_c[:,0]
HL_2h_F0_l_c_PSIIs=HL_2h_F0_l_c[:,0]

#long PSII
dark_F0_w_c_PSIIl=dark_F0_w_c[:,1]
HL_2h_F0_w_c_PSIIl=HL_2h_F0_w_c[:,1]

dark_F0_l_c_PSIIl=dark_F0_l_c[:,1]
HL_2h_F0_l_c_PSIIl=HL_2h_F0_l_c[:,1]

#%% amplitudes of all the DAS values for the linco samples 
dark_F0_l_c_PSI_PSII=np.asarray([dict_contributions[key] for key in dict_contributions.keys() if 'Fo' in key and 'DA_' in key and 'linco' in key])
HL_2h_F0_l_c_PSI_PSII=np.asarray([dict_contributions[key] for key in dict_contributions.keys() if 'Fo' in key and 'HL' in key and 'linco' in key])

dark_Fm_l_c_PSI_PSII=np.asarray([dict_contributions[key] for key in dict_contributions.keys() if 'Fm' in key and 'DA_' in key and 'linco' in key])
HL_2h_Fm_l_c_PSI_PSII=np.asarray([dict_contributions[key] for key in dict_contributions.keys() if 'Fm' in key and 'HL' in key and 'linco' in key])

dark_F0_c1=dark_F0_l_c_PSI_PSII[:,0]
dark_F0_c2=dark_F0_l_c_PSI_PSII[:,1]
dark_F0_c3=dark_F0_l_c_PSI_PSII[:,2]

HL_F0_c1=HL_2h_F0_l_c_PSI_PSII[:,0]
HL_F0_c2=HL_2h_F0_l_c_PSI_PSII[:,1]
HL_F0_c3=HL_2h_F0_l_c_PSI_PSII[:,2]

dark_Fm_c1=dark_Fm_l_c_PSI_PSII[:,0]
dark_Fm_c2=dark_Fm_l_c_PSI_PSII[:,1]
dark_Fm_c3=dark_Fm_l_c_PSI_PSII[:,2]

HL_Fm_c1=HL_2h_Fm_l_c_PSI_PSII[:,0]
HL_Fm_c2=HL_2h_Fm_l_c_PSI_PSII[:,1]
HL_Fm_c3=HL_2h_Fm_l_c_PSI_PSII[:,2]

F0_c1=[dark_F0_c1,HL_F0_c1]
F0_c2=[dark_F0_c2,HL_F0_c2]
F0_c3=[dark_F0_c3,HL_F0_c3]

Fm_c1=[dark_Fm_c1,HL_Fm_c1]
Fm_c2=[dark_Fm_c2,HL_Fm_c2]
Fm_c3=[dark_Fm_c3,HL_Fm_c3]


#%% average PSII Fm

#water
dark_Fm_w_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fm' in key and 'DA_' in key and 'water' in key])
HL_2h_Fm_w_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fm' in key and 'HL' in key and 'water' in key])

#linco
dark_Fm_l_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fm' in key and 'DA_' in key and 'linco' in key])
HL_2h_Fm_l_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fm' in key and 'HL' in key and 'linco' in key])

#%% average PSII F0

#water
dark_F0_w_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fo' in key and 'DA_' in key and 'water' in key])
HL_2h_F0_w_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fo' in key and 'HL' in key and 'water' in key])

#linco
dark_F0_l_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fo' in key and 'DA_' in key and 'linco' in key])
HL_2h_F0_l_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fo' in key and 'HL' in key and 'linco' in key])


#%% average Fm & F0 taking into account PSI and PSII 

#water
dark_PSI_PSII_F0_w_al=np.asarray([dict_average_all[key] for key in dict_average_all.keys() if 'Fo' in key and 'DA_' in key and 'water' in key])
HL_2h_PSI_PSII_F0_w_al=np.asarray([dict_average_all[key] for key in dict_average_PSII.keys() if 'Fo' in key and 'HL' in key and 'water' in key])

#linco
dark_PSI_PSII_F0_l_al=np.asarray([dict_average_all[key] for key in dict_average_all.keys() if 'Fo' in key and 'DA_' in key and 'linco' in key])
HL_2h_PSI_PSII_F0_l_al=np.asarray([dict_average_all[key] for key in dict_average_all.keys() if 'Fo' in key and 'HL' in key and 'linco' in key])

#water
dark_PSI_PSII_Fm_w_al=np.asarray([dict_average_all[key] for key in dict_average_all.keys() if 'Fm' in key and 'DA_' in key and 'water' in key])
HL_2h_PSI_PSII_Fm_w_al=np.asarray([dict_average_all[key] for key in dict_average_all.keys() if 'Fm' in key and 'HL' in key and 'water' in key])

#linco
dark_PSI_PSII_Fm_l_al=np.asarray([dict_average_all[key] for key in dict_average_all.keys() if 'Fm' in key and 'DA_' in key and 'linco' in key])
HL_2h_PSI_PSII_Fm_l_al=np.asarray([dict_average_all[key] for key in dict_average_all.keys() if 'Fm' in key and 'HL' in key and 'linco' in key])




#%%#make them together in lists for the boxplots
 
PSI_F0_w=[dark_F0_w_lt_PSI,HL_2h_F0_w_lt_PSI]
PSI_Fm_w=[dark_Fm_w_lt_PSI,HL_2h_Fm_w_lt_PSI]

PSIIs_F0_w=[dark_F0_w_lt_PSIIs,HL_2h_F0_w_lt_PSIIs]
PSIIs_Fm_w=[dark_Fm_w_lt_PSIIs,HL_2h_Fm_w_lt_PSIIs]

PSIIl_Fm_w=[dark_Fm_w_lt_PSIIl,HL_2h_Fm_w_lt_PSIIl]
PSIIl_F0_w=[dark_F0_w_lt_PSIIl,HL_2h_F0_w_lt_PSIIl]


PSI_F0_l=[dark_F0_l_lt_PSI,HL_2h_F0_l_lt_PSI]
PSI_Fm_l=[dark_Fm_l_lt_PSI,HL_2h_Fm_l_lt_PSI]

PSIIs_F0_l=[dark_F0_l_lt_PSIIs,HL_2h_F0_l_lt_PSIIs]
PSIIs_Fm_l=[dark_Fm_l_lt_PSIIs,HL_2h_Fm_l_lt_PSIIs]

PSIIl_Fm_l=[dark_Fm_l_lt_PSIIl,HL_2h_Fm_l_lt_PSIIl]
PSIIl_F0_l=[dark_F0_l_lt_PSIIl,HL_2h_F0_l_lt_PSIIl]


PSIIs_c_w=[dark_Fm_w_c_PSIIs,HL_2h_Fm_w_c_PSIIs]
PSIIl_c_w=[dark_Fm_w_c_PSIIl,HL_2h_Fm_w_c_PSIIl]
PSIIs_c_l=[dark_Fm_l_c_PSIIs,HL_2h_Fm_l_c_PSIIs]
PSIIl_c_l=[dark_Fm_l_c_PSIIl,HL_2h_Fm_l_c_PSIIl]

PSIIs_c_w_F0=[dark_F0_w_c_PSIIs,HL_2h_F0_w_c_PSIIs]
PSIIl_c_w_F0=[dark_F0_w_c_PSIIl,HL_2h_F0_w_c_PSIIl]
PSIIs_c_l_F0=[dark_F0_l_c_PSIIs,HL_2h_F0_l_c_PSIIs]
PSIIl_c_l_F0=[dark_F0_l_c_PSIIl,HL_2h_F0_l_c_PSIIl]


PSII_w_al=[dark_Fm_w_al,HL_2h_Fm_w_al]
PSII_l_al=[dark_Fm_l_al,HL_2h_Fm_l_al]

PSII_F0_w_al=[dark_F0_w_al,HL_2h_F0_w_al]
PSII_F0_l_al=[dark_F0_l_al,HL_2h_F0_l_al]



PSI_PSII_Fm_w_al=[dark_PSI_PSII_Fm_w_al,HL_2h_PSI_PSII_Fm_w_al]
PSI_PSII_Fm_l_al=[dark_PSI_PSII_Fm_l_al,HL_2h_PSI_PSII_Fm_l_al]

PSI_PSII_F0_w_al=[dark_PSI_PSII_F0_w_al,HL_2h_PSI_PSII_F0_w_al]
PSI_PSII_F0_l_al=[dark_PSI_PSII_F0_l_al,HL_2h_PSI_PSII_F0_l_al]

#%% make the graphs for the lifetimes 

ticks = ["Dark", '2h']

# F0 PSI 
plt.figure()

#bpl=plt.boxplot(PSI_F0_w, positions=np.array(range(len(PSI_F0_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=plt.boxplot(PSI_F0_l, positions=np.array(range(len(PSI_F0_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

positions_w=np.array(range(len(PSI_F0_w)))*2.0-0.4
positions_l=np.array(range(len(PSI_F0_w)))*2.0+0.4


count=0
for x in np.array(range(len(PSI_F0_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_F0_w[count]))-0.2)/10
    plt.scatter(scatter,PSI_F0_w[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_F0_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSI_F0_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_F0_l[count]))-0.2)/10
    plt.scatter(scatter,PSI_F0_l[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_F0_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

plt.title('PSI Open RC')
plt.ylabel ('Lifetime (ps)',fontsize=14)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-1, 3)
plt.ylim(0,100)
plt.tight_layout()
plt.savefig(folder_path+'/'+'lifetimes_F0_PSI_unmix_scatter.png',dpi=1200,bbox_inches='tight')


# Fm PSI 
plt.figure()



positions_w=np.array(range(len(PSI_Fm_w)))*2.0-0.4
positions_l=np.array(range(len(PSI_Fm_l)))*2.0+0.4

count=0
for x in np.array(range(len(PSI_Fm_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_F0_w[count]))-0.2)/10
    plt.scatter(scatter,PSI_Fm_w[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_Fm_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSI_Fm_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_Fm_l[count]))-0.2)/10
    plt.scatter(scatter,PSI_Fm_l[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_Fm_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

plt.ylabel ('Lifetime (ps)',fontsize=14)

plt.title('PSI Closed RC')
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)

plt.xlim(-1, 3)
plt.ylim(0,100)
plt.tight_layout()

plt.savefig(folder_path+'/'+'lifetimes_Fm_PSI.png',dpi=1200,bbox_inches='tight')



#%% lifetimes PSI without water 
# F0 PSI 
plt.figure()


positions=np.array(range(len(PSI_F0_w)))*2.0
    
count=0
for x in np.array(range(len(PSI_F0_l)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_F0_l[count]))-0.2)/10
    plt.scatter(scatter,PSI_F0_l[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_F0_l[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

plt.title('PSI Open RC')
plt.ylabel ('Lifetime (ps)',fontsize=14)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-1, 3)
plt.ylim(0,100)
plt.tight_layout()
plt.savefig(folder_path+'/'+'lifetimes_F0_PSI_linco_scatter.png',dpi=1200,bbox_inches='tight')


# Fm PSI 
plt.figure()




count=0
for x in np.array(range(len(PSI_Fm_l)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_Fm_l[count]))-0.2)/10
    plt.scatter(scatter,PSI_Fm_l[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_Fm_l[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

plt.ylabel ('Lifetime (ps)',fontsize=14)

plt.title('PSI Closed RC')
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)

plt.xlim(-1, 3)
plt.ylim(0,100)
plt.tight_layout()

plt.savefig(folder_path+'/'+'lifetimes_Fm_PSI_linco.png',dpi=1200,bbox_inches='tight')



#%% lifetime + amplitude PSII Fm 
# Fm PSII 
labels=["Dark",'2h']
figure1 = plt.figure(constrained_layout=True,figsize=(8,6))
gs = gridspec.GridSpec(2, 2, figure=figure1)
ax1 = figure1.add_subplot(gs[0,0])
ax2 = figure1.add_subplot(gs[1,0])
ax3 = figure1.add_subplot(gs[0,1])
ax4 = figure1.add_subplot(gs[1,1])

ax1.set_ylabel('Lifetime (ps)',fontsize=12)
ax1.set_title('Short Component PSII',fontsize=12)

#bpl=ax1.boxplot(PSIIs_Fm_w, positions=np.array(range(len(PSIIs_Fm_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=ax1.boxplot(PSIIs_Fm_l, positions=np.array(range(len(PSIIs_Fm_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')
ax1.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=12)
ax1.set_xticklabels(labels)
#ax1.set_ylim(0,6000)

positions_w=np.array(range(len(PSIIs_Fm_w)))*2.0-0.4
positions_l=np.array(range(len(PSIIs_Fm_l)))*2.0+0.4


count=0
for x in np.array(range(len(PSIIs_Fm_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_Fm_w[count]))-0.2)/10
    ax1.scatter(scatter,PSIIs_Fm_w[count],linewidth=1,color='white',edgecolor='black')
    ax1.hlines(np.mean(PSIIs_Fm_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSIIs_Fm_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_Fm_l[count]))-0.2)/10
    ax1.scatter(scatter,PSIIs_Fm_l[count],linewidth=1,color='white',edgecolor='black')
    ax1.hlines(np.mean(PSIIs_Fm_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)
#short component amplitude
ax2.set_ylabel('Contribution',fontsize=14)

#bpl=ax2.boxplot(PSIIs_c_w, positions=np.array(range(len(PSIIs_c_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=ax2.boxplot(PSIIs_c_l, positions=np.array(range(len(PSIIs_c_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

count=0
for x in np.array(range(len(PSIIs_c_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_c_w[count]))-0.2)/10
    ax2.scatter(scatter,PSIIs_c_w[count],linewidth=1,color='white',edgecolor='black')
    ax2.hlines(np.mean(PSIIs_c_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSIIs_c_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_c_l[count]))-0.2)/10
    ax2.scatter(scatter,PSIIs_c_l[count],linewidth=1,color='white',edgecolor='black')
    ax2.hlines(np.mean(PSIIs_c_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

ax2.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax2.set_xticklabels(labels)
ax2.set_ylim(0,1)
#ax1.set_ylim(0,6000)


#box plot average lifetime and amplitudes
ax3.set_title('Long Component PSII',fontsize=14)
ax3.set_ylabel('Lifetime (ps)',fontsize=14)
#bpl=ax3.boxplot(PSIIl_Fm_w, positions=np.array(range(len(PSIIl_Fm_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=ax3.boxplot(PSIIl_Fm_l, positions=np.array(range(len(PSIIl_Fm_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

count=0
for x in np.array(range(len(PSIIl_Fm_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_Fm_w[count]))-0.2)/10
    ax3.scatter(scatter,PSIIl_Fm_w[count],linewidth=1,color='white',edgecolor='black')
    ax3.hlines(np.mean(PSIIl_Fm_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSIIl_Fm_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_Fm_l[count]))-0.2)/10
    ax3.scatter(scatter,PSIIl_Fm_l[count],linewidth=1,color='white',edgecolor='black')
    ax3.hlines(np.mean(PSIIl_Fm_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
ax3.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax3.set_xticklabels(labels)

#long component amplitude
ax4.set_ylabel('Contribution',fontsize=14)

#bpl=ax4.boxplot(PSIIl_c_w, positions=np.array(range(len(PSIIl_c_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=ax4.boxplot(PSIIl_c_l, positions=np.array(range(len(PSIIl_c_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

count=0
for x in np.array(range(len(PSIIl_c_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_c_w[count]))-0.2)/10
    ax4.scatter(scatter,PSIIl_c_w[count],linewidth=1,color='white',edgecolor='black')
    ax4.hlines(np.mean(PSIIl_c_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSIIl_c_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_c_l[count]))-0.2)/10
    ax4.scatter(scatter,PSIIl_c_l[count],linewidth=1,color='white',edgecolor='black')
    ax4.hlines(np.mean(PSIIl_c_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
ax4.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax4.set_xticklabels(labels)
ax4.set_ylim(0,1)


plt.savefig(folder_path+'/''lifetimes_Fm_PSII_scatter.png',dpi=1200,bbox_inches='tight')
plt.show()



#%% average lifetime PSII Fm


# average lifetime PSII 
plt.figure()

#bpl=plt.boxplot(PSII_w_al, positions=np.array(range(len(PSIIl_Fm_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=plt.boxplot(PSII_l_al, positions=np.array(range(len(PSIIl_Fm_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')


count=0
for x in np.array(range(len(PSII_w_al)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSII_w_al[count]))-0.2)/10
    plt.scatter(scatter,PSII_w_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSII_w_al[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSII_l_al)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSII_l_al[count]))-0.2)/10
    plt.scatter(scatter,PSII_l_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSII_l_al[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)



plt.legend(fontsize=14)



plt.title('Average lifetime PSII - Closed RC')
plt.ylabel ('Average Lifetime (ps)',fontsize=14)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-1,3)
#plt.ylim(75,100)
plt.tight_layout()
plt.savefig(folder_path+'/'+'lifetimes_average_Fm_PSII_scatter.png',dpi=1200,bbox_inches='tight')
plt.savefig(folder_path+'/'+'lifetimes_average_Fm_PSII_scatter.svg',dpi=1200,bbox_inches='tight')

#%% average lifetime PSII F0 


plt.figure()

#bpl=plt.boxplot(PSII_F0_w_al, positions=np.array(range(len(PSII_F0_w_al)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=plt.boxplot(PSII_F0_l_al, positions=np.array(range(len(PSII_F0_w_al)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

count=0
for x in np.array(range(len(PSII_F0_w_al)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSII_F0_w_al[count]))-0.2)/10
    plt.scatter(scatter,PSII_F0_w_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSII_F0_w_al[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSII_F0_l_al)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSII_F0_l_al[count]))-0.2)/10
    plt.scatter(scatter,PSII_F0_l_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSII_F0_l_al[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

plt.title('Average lifetime PSII - Open RC')
plt.ylabel ('Average Lifetime (ps)',fontsize=14)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-1, 3)
#plt.ylim(75,100)
plt.tight_layout()
plt.savefig(folder_path+'/'+'lifetimes_average_F0_PSII_unmixing_scatter.png',dpi=1200,bbox_inches='tight')
plt.savefig(folder_path+'/'+'lifetimes_average_F0_PSII_unmixing_scatter.svg',dpi=1200,bbox_inches='tight')

#%% lifetime + amplitude PSII Fo 
# F0 PSII 
labels=["Dark",'2h']
figure1 = plt.figure(constrained_layout=True,figsize=(8,6))
gs = gridspec.GridSpec(2, 2, figure=figure1)
ax1 = figure1.add_subplot(gs[0,0])
ax2 = figure1.add_subplot(gs[1,0])
ax3 = figure1.add_subplot(gs[0,1])
ax4 = figure1.add_subplot(gs[1,1])

ax1.set_ylabel('Lifetime (ps)',fontsize=12)
ax1.set_title('Short Component PSII',fontsize=12)

#bpl=ax1.boxplot(PSIIs_Fm_w, positions=np.array(range(len(PSIIs_Fm_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=ax1.boxplot(PSIIs_Fm_l, positions=np.array(range(len(PSIIs_Fm_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')
ax1.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=12)
ax1.set_xticklabels(labels)
#ax1.set_ylim(0,6000)

positions_w=np.array(range(len(PSIIs_F0_w)))*2.0-0.4
positions_l=np.array(range(len(PSIIs_F0_l)))*2.0+0.4


count=0
for x in np.array(range(len(PSIIs_F0_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_F0_w[count]))-0.2)/10
    ax1.scatter(scatter,PSIIs_F0_w[count],linewidth=1,color='white',edgecolor='black')
    ax1.hlines(np.mean(PSIIs_F0_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSIIs_F0_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_F0_l[count]))-0.2)/10
    ax1.scatter(scatter,PSIIs_F0_l[count],linewidth=1,color='white',edgecolor='black')
    ax1.hlines(np.mean(PSIIs_F0_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)
#short component amplitude
ax2.set_ylabel('Contribution',fontsize=14)

#bpl=ax2.boxplot(PSIIs_c_w, positions=np.array(range(len(PSIIs_c_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=ax2.boxplot(PSIIs_c_l, positions=np.array(range(len(PSIIs_c_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

count=0
for x in np.array(range(len(PSIIs_c_w_F0)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_c_w_F0[count]))-0.2)/10
    ax2.scatter(scatter,PSIIs_c_w_F0[count],linewidth=1,color='white',edgecolor='black')
    ax2.hlines(np.mean(PSIIs_c_w_F0[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSIIs_c_l_F0)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_c_l_F0[count]))-0.2)/10
    ax2.scatter(scatter,PSIIs_c_l_F0[count],linewidth=1,color='white',edgecolor='black')
    ax2.hlines(np.mean(PSIIs_c_l_F0[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

ax2.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax2.set_xticklabels(labels)
ax2.set_ylim(0,1)
#ax1.set_ylim(0,6000)


#box plot average lifetime and amplitudes
ax3.set_title('Long Component PSII',fontsize=14)
ax3.set_ylabel('Lifetime (ps)',fontsize=14)
#bpl=ax3.boxplot(PSIIl_Fm_w, positions=np.array(range(len(PSIIl_Fm_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=ax3.boxplot(PSIIl_Fm_l, positions=np.array(range(len(PSIIl_Fm_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

count=0
for x in np.array(range(len(PSIIl_F0_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_F0_w[count]))-0.2)/10
    ax3.scatter(scatter,PSIIl_F0_w[count],linewidth=1,color='white',edgecolor='black')
    ax3.hlines(np.mean(PSIIl_F0_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSIIl_F0_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_F0_l[count]))-0.2)/10
    ax3.scatter(scatter,PSIIl_F0_l[count],linewidth=1,color='white',edgecolor='black')
    ax3.hlines(np.mean(PSIIl_F0_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
ax3.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax3.set_xticklabels(labels)

#long component amplitude
ax4.set_ylabel('Contribution',fontsize=14)

#bpl=ax4.boxplot(PSIIl_c_w, positions=np.array(range(len(PSIIl_c_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=ax4.boxplot(PSIIl_c_l, positions=np.array(range(len(PSIIl_c_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

count=0
for x in np.array(range(len(PSIIl_c_w_F0)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_c_w_F0[count]))-0.2)/10
    ax4.scatter(scatter,PSIIl_c_w_F0[count],linewidth=1,color='white',edgecolor='black')
    ax4.hlines(np.mean(PSIIl_c_w_F0[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSIIl_c_l_F0)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_c_l_F0[count]))-0.2)/10
    ax4.scatter(scatter,PSIIl_c_l_F0[count],linewidth=1,color='white',edgecolor='black')
    ax4.hlines(np.mean(PSIIl_c_l_F0[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
ax4.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax4.set_xticklabels(labels)
ax4.set_ylim(0,1)

 
plt.savefig(folder_path+'/'+'lifetimes_F0_PSII_scatter.png',dpi=1200,bbox_inches='tight')
plt.show()

#%% average lifetime PSI+PSII Fm


# average lifetime PSII 
plt.figure()

#bpl=plt.boxplot(PSII_w_al, positions=np.array(range(len(PSIIl_Fm_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=plt.boxplot(PSII_l_al, positions=np.array(range(len(PSIIl_Fm_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')


count=0
for x in np.array(range(len(PSI_PSII_Fm_w_al)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_PSII_Fm_w_al[count]))-0.2)/10
    plt.scatter(scatter,PSI_PSII_Fm_w_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_PSII_Fm_w_al[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSI_PSII_Fm_l_al)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_PSII_Fm_l_al[count]))-0.2)/10
    plt.scatter(scatter,PSI_PSII_Fm_l_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_PSII_Fm_l_al[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)



plt.legend(fontsize=14)



plt.title('Average lifetime - Closed RC')
plt.ylabel ('Average Lifetime (ps)',fontsize=14)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-1,3)
#plt.ylim(75,100)
plt.tight_layout()
plt.savefig(folder_path+'/'+'lifetimes_average_Fm_PSI_PSII_scatter.png',dpi=1200,bbox_inches='tight')
plt.savefig(folder_path+'/'+'lifetimes_average_Fm_PSI_PSII_scatter.svg',dpi=1200,bbox_inches='tight')

#%% average lifetime PSI+PSII F0 


plt.figure()

#bpl=plt.boxplot(PSII_F0_w_al, positions=np.array(range(len(PSII_F0_w_al)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=plt.boxplot(PSII_F0_l_al, positions=np.array(range(len(PSII_F0_w_al)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

count=0
for x in np.array(range(len(PSI_PSII_F0_w_al)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_PSII_F0_w_al[count]))-0.2)/10
    plt.scatter(scatter,PSI_PSII_F0_w_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_PSII_F0_w_al[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSI_PSII_F0_l_al)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_PSII_F0_l_al[count]))-0.2)/10
    plt.scatter(scatter,PSI_PSII_F0_l_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_PSII_F0_l_al[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

plt.title('Average lifetime - Open RC')
plt.ylabel ('Average Lifetime (ps)',fontsize=14)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-1, 3)
#plt.ylim(75,100)
plt.tight_layout()
plt.savefig(folder_path+'/'+'lifetimes_average_F0_PSI_PSII_unmixing_scatter.png',dpi=1200,bbox_inches='tight')
plt.savefig(folder_path+'/'+'lifetimes_average_F0_PSI_PSII_unmixing_scatter.svg',dpi=1200,bbox_inches='tight')

#%% average lifetime PSI+PSII Fm only linco

positions=np.array(range(len(PSIIs_F0_l)))*2.0

# average lifetime PSI+PSII only linco
plt.figure()

    
count=0
for x in np.array(range(len(PSI_PSII_Fm_l_al)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_PSII_Fm_l_al[count]))-0.2)/10
    plt.scatter(scatter,PSI_PSII_Fm_l_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_PSII_Fm_l_al[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)



plt.legend(fontsize=16)



plt.title(r" Average lifetime - $F_{m}$ Conditions - $\it{chlorina}$", fontsize=16)
plt.ylabel ('Average Lifetime (ps)',fontsize=18)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=18)
plt.yticks(fontsize=18)
plt.xlim(-1,3)
plt.ylim(0,600)
plt.tight_layout()
plt.savefig(folder_path+'/'+'lifetimes_average_Fm_PSI_PSII_only_linco_scatter.png',dpi=1200,bbox_inches='tight')
plt.savefig(folder_path+'/'+'lifetimes_average_Fm_PSI_PSII_only_linco_scatter.svg',dpi=1200,bbox_inches='tight')

#%% average lifetime PSI+PSII F0 only linco


plt.figure()

    
count=0
for x in np.array(range(len(PSI_PSII_F0_l_al)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_PSII_F0_l_al[count]))-0.2)/10
    plt.scatter(scatter,PSI_PSII_F0_l_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_PSII_F0_l_al[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=16)

plt.title(r" Average lifetime - $F_{o}$ Conditions - $\it{chlorina}$", fontsize=16)
plt.ylabel ('Average Lifetime (ps)',fontsize=18)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=18)
plt.yticks(fontsize=18)
plt.xlim(-1, 3)
plt.ylim(0,160)
plt.tight_layout()
plt.savefig(folder_path+'/'+'lifetimes_average_F0_PSI_PSII_only_linco_unmixing_scatter.png',dpi=1200,bbox_inches='tight')
plt.savefig(folder_path+'/'+'lifetimes_average_F0_PSI_PSII_only_linco_unmixing_scatter.svg',dpi=1200,bbox_inches='tight')


#%% graph lifetime + contribution all three DAS F0 just linco

labels=["Dark",'2h']
figure1 = plt.figure(constrained_layout=True,figsize=(9,6))
gs = gridspec.GridSpec(2, 3, figure=figure1)
ax1 = figure1.add_subplot(gs[0,0])
ax2 = figure1.add_subplot(gs[1,0])
ax3 = figure1.add_subplot(gs[0,1])
ax4 = figure1.add_subplot(gs[1,1])
ax5 = figure1.add_subplot(gs[0,2])
ax6 = figure1.add_subplot(gs[1,2])

# graph lifetime PSI 

ax1.set_ylabel('Lifetime (ps)',fontsize=14)
ax1.set_title('Component',fontsize=14)
ax1.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax1.set_xticklabels(labels)
#ax1.set_ylim(0,6000)

positions=np.array(range(len(PSI_F0_l)))*2.0

count=0
for x in np.array(range(len(PSI_F0_l)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_F0_l[count]))-0.2)/10
    ax1.scatter(scatter,PSI_F0_l[count],linewidth=1,color='white',edgecolor='black')
    ax1.hlines(np.mean(PSI_F0_l[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

#graph contribution PSI 
ax2.set_ylabel('Contribution',fontsize=14)
    
count=0
for x in np.array(range(len(F0_c1)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(F0_c1[count]))-0.2)/10
    ax2.scatter(scatter,F0_c1[count],linewidth=1,color='white',edgecolor='black')
    ax2.hlines(np.mean(F0_c1[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

ax2.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax2.set_xticklabels(labels)
ax2.set_ylim(0,1)
#ax1.set_ylim(0,6000)


#box plot middle lifetime
ax3.set_title('Component',fontsize=14)
ax3.set_ylabel('Lifetime (ps)',fontsize=14)

count=0
for x in np.array(range(len(PSIIs_F0_l)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_F0_l[count]))-0.2)/10
    ax3.scatter(scatter,PSIIs_F0_l[count],linewidth=1,color='white',edgecolor='black')
    ax3.hlines(np.mean(PSIIs_F0_l[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
ax3.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax3.set_xticklabels(labels)

#middle component amplitude
ax4.set_ylabel('Contribution',fontsize=14)

    
count=0
for x in np.array(range(len(F0_c2)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(F0_c2[count]))-0.2)/10
    ax4.scatter(scatter,F0_c2[count],linewidth=1,color='white',edgecolor='black')
    ax4.hlines(np.mean(F0_c2[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
ax4.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax4.set_xticklabels(labels)
ax4.set_ylim(0,1)

 
#box plot longest lifetime
ax5.set_title('Component',fontsize=14)
ax5.set_ylabel('Lifetime (ps)',fontsize=14)

count=0
for x in np.array(range(len(PSIIl_F0_l)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_F0_l[count]))-0.2)/10
    ax5.scatter(scatter,PSIIl_F0_l[count],linewidth=1,color='white',edgecolor='black')
    ax5.hlines(np.mean(PSIIl_F0_l[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
ax5.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax5.set_xticklabels(labels)

#long component amplitude
ax6.set_ylabel('Contribution',fontsize=14)

    
count=0
for x in np.array(range(len(F0_c3)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(F0_c3[count]))-0.2)/10
    ax6.scatter(scatter,F0_c3[count],linewidth=1,color='white',edgecolor='black')
    ax6.hlines(np.mean(F0_c3[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
ax6.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax6.set_xticklabels(labels)
ax6.set_ylim(0,1)

 
plt.tight_layout()


plt.savefig(folder_path+'/'+'lifetimes_contributions_F0_PSI_PSII.png',dpi=1200,bbox_inches='tight')
plt.show()


#%% graph lifetime + contribution all three DAS Fm just linco

labels=["Dark",'2h']
figure1 = plt.figure(constrained_layout=True,figsize=(9,6))
gs = gridspec.GridSpec(2, 3, figure=figure1)
ax1 = figure1.add_subplot(gs[0,0])
ax2 = figure1.add_subplot(gs[1,0])
ax3 = figure1.add_subplot(gs[0,1])
ax4 = figure1.add_subplot(gs[1,1])
ax5 = figure1.add_subplot(gs[0,2])
ax6 = figure1.add_subplot(gs[1,2])

# graph lifetime PSI 

ax1.set_ylabel('Lifetime (ps)',fontsize=14)
ax1.set_title('Component',fontsize=14)
ax1.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax1.set_xticklabels(labels)
#ax1.set_ylim(0,6000)

positions=np.array(range(len(PSI_Fm_l)))*2.0

count=0
for x in np.array(range(len(PSI_Fm_l)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_Fm_l[count]))-0.2)/10
    ax1.scatter(scatter,PSI_Fm_l[count],linewidth=1,color='white',edgecolor='black')
    ax1.hlines(np.mean(PSI_Fm_l[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

#graph contribution PSI 
ax2.set_ylabel('Contribution',fontsize=14)
    
count=0
for x in np.array(range(len(Fm_c1)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(Fm_c1[count]))-0.2)/10
    ax2.scatter(scatter,Fm_c1[count],linewidth=1,color='white',edgecolor='black')
    ax2.hlines(np.mean(Fm_c1[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

ax2.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax2.set_xticklabels(labels)
ax2.set_ylim(0,1)
#ax1.set_ylim(0,6000)


#box plot middle lifetime
ax3.set_title('Component',fontsize=14)
ax3.set_ylabel('Lifetime (ps)',fontsize=14)

count=0
for x in np.array(range(len(PSIIs_Fm_l)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_Fm_l[count]))-0.2)/10
    ax3.scatter(scatter,PSIIs_Fm_l[count],linewidth=1,color='white',edgecolor='black')
    ax3.hlines(np.mean(PSIIs_Fm_l[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
ax3.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax3.set_xticklabels(labels)

#middle component amplitude
ax4.set_ylabel('Contribution',fontsize=14)

    
count=0
for x in np.array(range(len(Fm_c2)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(Fm_c2[count]))-0.2)/10
    ax4.scatter(scatter,Fm_c2[count],linewidth=1,color='white',edgecolor='black')
    ax4.hlines(np.mean(Fm_c2[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
ax4.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax4.set_xticklabels(labels)
ax4.set_ylim(0,1)

 
#box plot longest lifetime
ax5.set_title('Component',fontsize=14)
ax5.set_ylabel('Lifetime (ps)',fontsize=14)

count=0
for x in np.array(range(len(PSIIl_Fm_l)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_Fm_l[count]))-0.2)/10
    ax5.scatter(scatter,PSIIl_Fm_l[count],linewidth=1,color='white',edgecolor='black')
    ax5.hlines(np.mean(PSIIl_Fm_l[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
ax5.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax5.set_xticklabels(labels)

#long component amplitude
ax6.set_ylabel('Contribution',fontsize=14)

    
count=0
for x in np.array(range(len(Fm_c3)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(Fm_c3[count]))-0.2)/10
    ax6.scatter(scatter,Fm_c3[count],linewidth=1,color='white',edgecolor='black')
    ax6.hlines(np.mean(Fm_c3[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
ax6.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax6.set_xticklabels(labels)
ax6.set_ylim(0,1)

 
plt.tight_layout()

plt.savefig(folder_path+'/'+'lifetimes_contributions_Fm_PSI_PSII.png',dpi=1200,bbox_inches='tight')
plt.show()


#%% Fv/Fm calculation 

dict_F_PAM={}

for key in dict_DAS_norm.keys(): 
        
    #find the index of 700 nm 
    index=np.argmax(dict_DAS_norm[key][:,0]>700)
    
    
    
    #sum the total of the collumns with DAS spectra 
    length=len(dict_DAS_norm[key][0])-1
    total_sum_700=np.sum(dict_DAS_norm[key][index:, -length:])

    #get the contributions 
    #make an empty array  for the contributions 
    contributions_700=np.zeros(length)
    for x in range(1,len(dict_DAS_norm[key][0])):
        contributions_700[x-1]=np.sum(dict_DAS_norm[key][index:,x])/total_sum_700
    
    #multiply the contributions with the lifetimes 
    np.sum(dict_lifetimes[key]*contributions_700)
    
    
    dict_F_PAM[key] = np.sum(dict_lifetimes[key]*contributions_700)



#water
dark_Fm_w_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fm' in key and 'DA_' in key and 'water' in key]
dark_F0_w_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fo' in key and 'DA_' in key and 'water' in key]
HL_2h_Fm_w_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fm' in key and 'HL' in key and 'water' in key]
HL_2h_F0_w_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fo' in key and 'HL' in key and 'water' in key]


#linco
dark_Fm_l_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fm' in key and 'DA_' in key and 'linco' in key]
dark_F0_l_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fo' in key and 'DA_' in key and 'linco' in key]
HL_2h_Fm_l_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fm' in key and 'HL' in key and 'linco' in key]
HL_2h_F0_l_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fo' in key and 'HL' in key and 'linco' in key]
       

dark_FvFm_w=(np.asarray(dark_Fm_w_FvFm)-np.asarray(dark_F0_w_FvFm))/np.asarray(dark_Fm_w_FvFm)
HL_2h_FvFm_w=(np.asarray(HL_2h_Fm_w_FvFm)-np.asarray(HL_2h_F0_w_FvFm))/np.asarray(HL_2h_Fm_w_FvFm)

dark_FvFm_l=(np.asarray(dark_Fm_l_FvFm)-np.asarray(dark_F0_l_FvFm[1:]))/np.asarray(dark_Fm_l_FvFm)
HL_2h_FvFm_l=(np.asarray(HL_2h_Fm_l_FvFm)-np.asarray(HL_2h_F0_l_FvFm))/np.asarray(HL_2h_Fm_l_FvFm)

FvFm_w=[dark_FvFm_w,HL_2h_FvFm_w]
FvFm_l=[dark_FvFm_l,HL_2h_FvFm_l]


#%% graph FvFm 


plt.figure()

#bpl=plt.boxplot(FvFm_w, positions=np.array(range(len(FvFm_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=plt.boxplot(FvFm_l, positions=np.array(range(len(FvFm_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')


count=0
for x in np.array(range(len(FvFm_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(FvFm_w[count]))-0.2)/10
    plt.scatter(scatter,FvFm_w[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(FvFm_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(FvFm_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(FvFm_l[count]))-0.2)/10
    plt.scatter(scatter,FvFm_l[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(FvFm_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

plt.title('FvFm Streak Camera')
plt.ylabel ('Fv/Fm',fontsize=14)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-1, 3)
plt.ylim((0,0.9))
plt.tight_layout()
plt.savefig(folder_path+'/'+'Fv_Fm_streak_unmixed_scatter.png',dpi=1200,bbox_inches='tight')


#%% FvFm Streak Figure just linco 

plt.figure()

    
count=0
for x in np.array(range(len(FvFm_l)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(FvFm_l[count]))-0.2)/10
    plt.scatter(scatter,FvFm_l[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(FvFm_l[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

plt.title('FvFm Streak Camera')
plt.ylabel ('Fv/Fm',fontsize=14)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-1, 3)
plt.ylim((0,0.9))
plt.tight_layout()
plt.savefig(folder_path+'/'+'Fv_Fm_streak_unmixed_scatter_linco.png',dpi=1200,bbox_inches='tight')

#%% FvFm PAM
plt.figure()


FvFm_w_PAM=[[0.792,0.789,0.793,0.798,0.802,0.761],[0.25775,0.30475,0.36025,0.3215]]
FvFm_l_PAM=[[0.776,0.787,0.751,0.768,0.711,0.661],[0.373,	0.325333,0.394,0.272333]]


count=0
for x in np.array(range(len(FvFm_w_PAM)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(FvFm_w_PAM[count]))-0.2)/10
    plt.scatter(scatter,FvFm_w_PAM[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(FvFm_w_PAM[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(FvFm_l_PAM)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(FvFm_l_PAM[count]))-0.2)/10
    plt.scatter(scatter,FvFm_l_PAM[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(FvFm_l_PAM[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

plt.title('FvFm PAM')
plt.ylabel ('Fv/Fm',fontsize=14)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-1, 3)
plt.ylim((0,0.9))
plt.tight_layout()
plt.savefig(folder_path+'/'+'Fv_Fm_PAM_scatter.png',dpi=1200,bbox_inches='tight')


#%% Fv/Fm PAM just linco 

plt.figure()

    
count=0
for x in np.array(range(len(FvFm_l_PAM)))*2.0: 
    
    scatter=x+(np.random.normal(0, 1, len(FvFm_l_PAM[count]))-0.2)/10
    plt.scatter(scatter,FvFm_l_PAM[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(FvFm_l_PAM[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

plt.title('FvFm PAM')
plt.ylabel ('Fv/Fm',fontsize=14)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-1, 3)
plt.ylim((0,0.9))
plt.tight_layout()
plt.savefig(folder_path+'/'+'Fv_Fm_PAM_scatter_linco.png',dpi=1200,bbox_inches='tight')