# -*- coding: utf-8 -*-
"""
Created on Mon May 13 16:19:31 2024

@author: bagch002
"""

import tkinter as tk
from tkinter import filedialog
import os
import numpy as np
import matplotlib.pyplot as plt
import pandas as pd
import os as os
import matplotlib.gridspec as gridspec
import scipy.stats as stats

 
# Function to handle button click
def open_ascii_files():
    # Open file dialog to select folder
    root = tk.Tk()
    root.withdraw()
    folder_path = filedialog.askdirectory()
 
    # Dictionary to store NumPy arrays with filenames as keys
    array_time = {}
    array_DAS = {} 
 
    # Loop through all files in the selected folder
    for filename in os.listdir(folder_path):
        # Check if the file has a .ascii extension (ASCII file)
        if filename.endswith(".ascii"):
            # Extract the NumPy array from the ASCII file
            file_path = os.path.join(folder_path, filename)
            with open(file_path, 'r') as file:
                # Skip the first row (header) in the ASCII file
                lines = file.readlines()[1:]
                data = np.array([list(map(float, line.split())) for line in lines])
 
                # Get the indices of columns with same content as the first column
                duplicate_indices = [i for i in range(1, data.shape[1]) if np.array_equal(data[:, 0], data[:, i])]
 
                # Create a new array without the duplicate columns
                unique_indices = list(set(range(data.shape[1])) - set(duplicate_indices))
                new_data = data[:, unique_indices]

 
                if 'time' in filename: 
                    array_time[filename] = new_data
                if 'DAS' in filename: 
                    #switch the collumns that went wrong in the streak 
                    #get PSI, PSII short and PSII long in each sample
                    if '0327' in filename and'Fm' in filename: 
                        new_data[:,[1,3]]=new_data[:,[3,1]]
                    
                    if '0327_16' in filename: 
                        new_data[:,[2,3]]=new_data[:,[3,2]]
                       
                    if '0227_04' in filename: 
                        new_data[:,[2,3]]=new_data[:,[3,2]]
                        
                    if '0227_05' in filename:
                        new_data[:,[2,3]]=new_data[:,[3,2]]
                        
                    if '0405_10' in filename: 
                        new_data[:,[1,3]]=new_data[:,[3,1]]
                        new_data[:,[2,3]]=new_data[:,[3,2]]
                    
                    max_PSII_short=max(new_data[:,2])
                    new_data[:,1:]=new_data[:,1:]/max_PSII_short
                    array_DAS[filename] = new_data
 
    # Return the dictionary of NumPy arrays
    return array_time, array_DAS,folder_path
 
def plot_DAS(array,title_string,array_lt):
    #determine the average and standard deviation of the DAS
    average_columns = np.mean(array,axis=0)
    std_colums=np.std(array,axis=0)
    
    #get the standard deviation and average of the lifetimes 
    average_lt = np.mean(array_lt,axis=0)
    std_lt=np.std(array_lt,axis=0)
    
    
    colours=['steelblue', 'lightsalmon','orangered','#af2f0d']

    plt.figure()
    for x in range(0,len(array[0][0,:])-1):
        # labels='{:.1f}'.format(average_lt[x])+' ± '+'{:.1f}'.format(std_lt[x])+' ps'
        labels='{:.3f}'.format(average_lt[x]/1000)+' ± '+'{:.3f}'.format(std_lt[x]/1000)+' ns'

        plt.plot(average_columns[:,0],average_columns[:,x+1],color=colours[x],label=labels)
        plt.fill_between(average_columns[:,0],average_columns[:,x+1]-(std_colums[:,x+1]/2),average_columns[:,x+1]+(std_colums[:,x+1]/2),color=colours[x],alpha=0.6)
    plt.xlabel('Wavelength (nm)', fontsize=14)
    plt.ylabel('Intensity', fontsize=14)
    plt.ylim(-0.001,0.015)
    plt.title(title_string, fontsize=16) 
    plt.legend(fontsize=12)
    plt.xticks(fontsize=12)
    plt.yticks(fontsize=12)

    plt.savefig(folder_path+'/'+title_string+'_unmixed.png', dpi=1200,bbox_inches='tight')
    plt.show()   
    
def plot_DAS_t0(array,title_string):
    #determine the average and standard deviation of the DAS
    av_array=[np.column_stack((arr[:, 0], arr[:, 1:].sum(axis=1))) for arr in array]
    average_columns = np.mean(av_array,axis=0)
    std_colums=np.std(av_array,axis=0)
    
    

    plt.figure()

    plt.plot(average_columns[:,0],average_columns[:,1],color='steelblue')
    plt.fill_between(average_columns[:,0],average_columns[:,1]-(std_colums[:,1]/2),average_columns[:,1]+(std_colums[:,1]/2),color='steelblue',alpha=0.6)
    plt.xlabel('Wavelength (nm)', fontsize=14)
    plt.ylabel('Intensity', fontsize=14)
    plt.ylim(-0.001,0.02)
    plt.title(title_string+' t=0 spectrum', fontsize=16) 
    #plt.legend(fontsize=12)
    plt.xticks(fontsize=12)
    plt.yticks(fontsize=12)

    plt.savefig(folder_path+'/'+title_string+'_t0.png', dpi=1200,bbox_inches='tight')
    plt.show()    



medianprops = dict(linestyle='-', linewidth=3)
            
def set_box_color(bp, color):
    plt.setp(bp['boxes'], color='white',linewidth=0)
    plt.setp(bp['whiskers'], color='white',linewidth=0)
    plt.setp(bp['caps'], color='white',linewidth=0)
    plt.setp(bp['medians'], color=color) 
    
def plot_DAS_PSI(array1,array2,array3,array4,array_lt1,array_lt2,array_lt3, array_lt4,title_string):
    
    
    #divide the arrays by the max PSI value to get the normalized PSI spectrum 
    max_PSI1=np.max(array1[:,:,1],axis=1)
    max_PSI2=np.max(array2[:,:,1],axis=1)
    max_PSI3=np.max(array3[:,:,1],axis=1)
    max_PSI4=np.max(array4[:,:,1],axis=1)

    
    max_PSI1=max_PSI1[:, np.newaxis]
    max_PSI2=max_PSI2[:, np.newaxis]
    max_PSI3=max_PSI3[:, np.newaxis]
    max_PSI4=max_PSI4[:, np.newaxis]


    array1[:, :, 1] = array1[:, :, 1] / max_PSI1
    array2[:, :, 1] = array2[:, :, 1] / max_PSI2
    array3[:, :, 1] = array3[:, :, 1] / max_PSI3
    array4[:, :, 1] = array4[:, :, 1] / max_PSI4

    
    #determine the average and standard deviation of the DAS
    average_columns1 = np.mean(array1,axis=0)
    std_colums1=np.std(array1,axis=0)
    
    average_columns2 = np.mean(array2,axis=0)
    std_colums2=np.std(array2,axis=0)
    
    average_columns3 = np.mean(array3,axis=0)
    std_colums3=np.std(array3,axis=0)
    
    average_columns4 = np.mean(array4,axis=0)
    std_colums4=np.std(array4,axis=0)
    
    #get the standard deviation and average of the lifetimes 
    average_lt1 = np.mean(array_lt1,axis=0)
    std_lt1=np.std(array_lt1,axis=0)
    average_lt2 = np.mean(array_lt2,axis=0)
    std_lt2=np.std(array_lt2,axis=0)
    average_lt3 = np.mean(array_lt3,axis=0)
    std_lt3=np.std(array_lt3,axis=0)
    average_lt4 = np.mean(array_lt4,axis=0)
    std_lt4=np.std(array_lt4,axis=0)
    
    
    #define things for the plot 
    colours=['#262D33','#4D6F8B','steelblue', 'lightsteelblue']
    # label1='Dark | '+'{:.1f}'.format(average_lt1[0])+' ± '+'{:.1f}'.format(std_lt1[0])+' ps'
    # label2='1h HL | '+'{:.1f}'.format(average_lt2[0])+' ± '+'{:.1f}'.format(std_lt2[0])+' ps'
    # label3='2h HL | '+'{:.1f}'.format(average_lt3[0])+' ± '+'{:.1f}'.format(std_lt3[0])+' ps'
    # label4='4h HL | '+'{:.1f}'.format(average_lt4[0])+' ± '+'{:.1f}'.format(std_lt4[0])+' ps'
    
    label1='Dark'
    label2='1h HL'
    label3='2h HL'
    label4='4h HL'


    

    plt.figure()
    plt.plot(average_columns1[:,0],average_columns1[:,1],color=colours[0],label=label1)
    plt.fill_between(average_columns1[:,0],average_columns1[:,1]-(std_colums1[:,1]/2),average_columns1[:,1]+(std_colums1[:,1]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columns2[:,0],average_columns2[:,1],color=colours[1],label=label2)
    plt.fill_between(average_columns2[:,0],average_columns2[:,1]-(std_colums2[:,1]/2),average_columns2[:,1]+(std_colums2[:,1]/2),color=colours[1],alpha=0.6)

    plt.plot(average_columns3[:,0],average_columns3[:,1],color=colours[2],label=label3)
    plt.fill_between(average_columns3[:,0],average_columns3[:,1]-(std_colums3[:,1]/2),average_columns3[:,1]+(std_colums3[:,1]/2),color=colours[2],alpha=0.6)
    
    plt.plot(average_columns4[:,0],average_columns4[:,1],color=colours[3],label=label4)
    plt.fill_between(average_columns4[:,0],average_columns4[:,1]-(std_colums4[:,1]/2),average_columns4[:,1]+(std_colums4[:,1]/2),color=colours[3],alpha=0.6)
    
    
    plt.xlabel('Wavelength (nm)')
    plt.ylabel('Intensity')
    #plt.ylim(-0.1,2)
    plt.title('PSI Fm '+title_string) 
    plt.legend()
    plt.savefig(folder_path+'/'+title_string+'PSI_Fm_unmixed.png',dpi=1200,bbox_inches='tight')
    plt.show()  
    
    
    
def plot_DAS_PSII(array1,array2,array3,array4,array_lt1,array_lt2,array_lt3,array_lt4,title_string,title_string_2):
    
    
    if 'Fm' in title_string:
        #divide the arrays by the max PSII value to get the normalized PSII spectrum 
        max_PSII1=np.max(array1[:,:,2],axis=1)
        max_PSII2=np.max(array2[:,:,2],axis=1)
        max_PSII3=np.max(array3[:,:,2],axis=1)
        max_PSII4=np.max(array4[:,:,2],axis=1)

        max_PSII1=max_PSII1[:, np.newaxis]
        max_PSII2=max_PSII2[:, np.newaxis]
        max_PSII3=max_PSII3[:, np.newaxis]
        max_PSII4=max_PSII4[:, np.newaxis]

    if 'F0' in title_string:
        #divide the arrays by the max PSII value to get the normalized PSII spectrum 
        max_PSII1=np.max(array1[:,:,3],axis=1)
        max_PSII2=np.max(array2[:,:,3],axis=1)
        max_PSII3=np.max(array3[:,:,3],axis=1)
        max_PSII4=np.max(array4[:,:,3],axis=1)

        max_PSII1=max_PSII1[:, np.newaxis]
        max_PSII2=max_PSII2[:, np.newaxis]
        max_PSII3=max_PSII3[:, np.newaxis]
        max_PSII4=max_PSII4[:, np.newaxis]

    

    array1[:, :, 2] = array1[:, :, 2] / max_PSII1
    array2[:, :, 2] = array2[:, :, 2] / max_PSII2
    array3[:, :, 2] = array3[:, :, 2] / max_PSII3
    array4[:, :, 2] = array4[:, :, 2] / max_PSII4

    array1[:, :, 3] = array1[:, :, 3] / max_PSII1
    array2[:, :, 3] = array2[:, :, 3] / max_PSII2
    array3[:, :, 3] = array3[:, :, 3] / max_PSII3
    array4[:, :, 3] = array4[:, :, 3] / max_PSII4

    #determine the average and standard deviation of the DAS
    average_columns1 = np.mean(array1,axis=0)
    std_colums1=np.std(array1,axis=0)
    
    average_columns2 = np.mean(array2,axis=0)
    std_colums2=np.std(array2,axis=0)
    
    average_columns3 = np.mean(array3,axis=0)
    std_colums3=np.std(array3,axis=0)
    
    average_columns4 = np.mean(array4,axis=0)
    std_colums4=np.std(array4,axis=0)
    
    
    #define things for the plot 
    colours=['black','maroon','orangered', 'lightsalmon']
    label1='Dark'
    label2='1h HL'
    label3='2h HL'
    label4='4h HL'
    

    plt.figure()
    
    plt.plot(average_columns1[:,0],average_columns1[:,2],color=colours[0],label=label1)
    plt.fill_between(average_columns1[:,0],average_columns1[:,2]-(std_colums1[:,2]/2),average_columns1[:,2]+(std_colums1[:,2]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columns2[:,0],average_columns2[:,2],color=colours[1],label=label2)
    plt.fill_between(average_columns2[:,0],average_columns2[:,2]-(std_colums2[:,2]/2),average_columns2[:,2]+(std_colums2[:,2]/2),color=colours[1],alpha=0.6)

    plt.plot(average_columns3[:,0],average_columns3[:,2],color=colours[2],label=label3)
    plt.fill_between(average_columns3[:,0],average_columns3[:,2]-(std_colums3[:,2]/2),average_columns3[:,2]+(std_colums3[:,2]/2),color=colours[2],alpha=0.6)
    
    plt.plot(average_columns4[:,0],average_columns4[:,2],color=colours[3],label=label4)
    plt.fill_between(average_columns4[:,0],average_columns4[:,2]-(std_colums4[:,2]/2),average_columns4[:,2]+(std_colums4[:,2]/2),color=colours[3],alpha=0.6)
    
    
    plt.plot(average_columns1[:,0],average_columns1[:,3],color=colours[0])
    plt.fill_between(average_columns1[:,0],average_columns1[:,3]-(std_colums1[:,3]/2),average_columns1[:,3]+(std_colums1[:,3]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columns2[:,0],average_columns2[:,3],color=colours[1])
    plt.fill_between(average_columns2[:,0],average_columns2[:,3]-(std_colums2[:,3]/2),average_columns2[:,3]+(std_colums2[:,3]/2),color=colours[1],alpha=0.6)

    plt.plot(average_columns3[:,0],average_columns3[:,3],color=colours[2])
    plt.fill_between(average_columns3[:,0],average_columns3[:,3]-(std_colums3[:,3]/2),average_columns3[:,3]+(std_colums3[:,3]/2),color=colours[2],alpha=0.6)

    plt.plot(average_columns4[:,0],average_columns4[:,3],color=colours[3])
    plt.fill_between(average_columns4[:,0],average_columns4[:,3]-(std_colums4[:,3]/2),average_columns4[:,3]+(std_colums4[:,3]/2),color=colours[3],alpha=0.6)

    
    plt.xlabel('Wavelength (nm)')
    plt.ylabel('Intensity')
    #plt.ylim(-0.1,2)
    plt.title('PSII '+title_string+ ' '+title_string_2) 
    plt.legend()
    plt.savefig(folder_path+'/'+title_string+'_'+title_string_2+'_PSII_unmixed.png',dpi=1200,bbox_inches='tight')
    plt.show()  
    
    
def plot_DAS_F0_Fm(arrayFm,arrayF0,title_string):
    
    
    #divide the arrays by the max PSII value to get the normalized PSII spectrum 
    max_PSII_Fm=np.max(arrayFm[:,:,2],axis=1)
        
    max_PSII_Fm=max_PSII_Fm[:, np.newaxis]
       
        
    max_PSII_F0=np.max(arrayF0[:,:,3],axis=1)
    max_PSII_F0=max_PSII_F0[:, np.newaxis]
       
    
    

    arrayFm[:, :, 2] = arrayFm[:, :, 2] / max_PSII_Fm
    arrayF0[:, :, 2] = arrayF0[:, :, 2] / max_PSII_F0
    

    arrayFm[:, :, 3] = arrayFm[:, :, 3] / max_PSII_Fm
    arrayF0[:, :, 3] = arrayF0[:, :, 3] / max_PSII_F0
    
    
    
    #determine the average and standard deviation of the DAS
    average_columnsFm = np.mean(arrayFm,axis=0)
    std_columsFm=np.std(arrayFm,axis=0)
    
    average_columnsF0 = np.mean(arrayF0,axis=0)
    std_columsF0=np.std(arrayF0,axis=0)
    

    
    #define things for the plot 
    colours=['orangered', 'lightsalmon']
    labelFm='Fm'
    labelF0='F0'
    

    plt.figure()
    
    plt.plot(average_columnsFm[:,0],average_columnsFm[:,2],color=colours[0],label=labelFm)
    plt.fill_between(average_columnsFm[:,0],average_columnsFm[:,2]-(std_columsFm[:,2]/2),average_columnsFm[:,2]+(std_columsFm[:,2]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columnsF0[:,0],average_columnsF0[:,2],color=colours[1],label=labelF0)
    plt.fill_between(average_columnsF0[:,0],average_columnsF0[:,2]-(std_columsF0[:,2]/2),average_columnsF0[:,2]+(std_columsF0[:,2]/2),color=colours[1],alpha=0.6)

    
    plt.plot(average_columnsFm[:,0],average_columnsFm[:,3],color=colours[0])
    plt.fill_between(average_columnsFm[:,0],average_columnsFm[:,3]-(std_columsFm[:,3]/2),average_columnsFm[:,3]+(std_columsFm[:,3]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columnsF0[:,0],average_columnsF0[:,3],color=colours[1])
    plt.fill_between(average_columnsF0[:,0],average_columnsF0[:,3]-(std_columsF0[:,3]/2),average_columnsF0[:,3]+(std_columsF0[:,3]/2),color=colours[1],alpha=0.6)


    
    plt.xlabel('Wavelength (nm)')
    plt.ylabel('Intensity')
    #plt.ylim(-0.1,2)
    plt.title('PSII F0 vs. Fm '+title_string) 
    plt.legend()
    plt.savefig(folder_path+'/'+title_string+'_PSII_unmixed.png',dpi=1200,bbox_inches='tight')
    plt.show()  
    
    

def plot_DAS_water_linco_Fm(array_w,array_l,title_string):
    
    
    #divide the arrays by the max PSII and max PSI value to get the normalized PSII spectrum 
    max_PSII_w=np.max(array_w[:,:,2],axis=1)   
    max_PSII_w=max_PSII_w[:, np.newaxis]
    
    max_PSII_l=np.max(array_l[:,:,2],axis=1)   
    max_PSII_l=max_PSII_l[:, np.newaxis]
    
    max_PSI_w=np.max(array_w[:,:,1],axis=1)   
    max_PSI_w=max_PSI_w[:, np.newaxis]
    
    max_PSI_l=np.max(array_l[:,:,1],axis=1)   
    max_PSI_l=max_PSI_l[:, np.newaxis]
       
       
        

    array_w[:, :, 1] = array_w[:, :, 1] / max_PSI_w
    array_l[:, :, 1] = array_l[:, :, 1] / max_PSI_l
    
    array_w[:, :, 2] = array_w[:, :, 2] / max_PSII_w
    array_l[:, :, 2] = array_l[:, :, 2] / max_PSII_l


    array_w[:, :, 3] = array_w[:, :, 3] / max_PSII_w
    array_l[:, :, 3] = array_l[:, :, 3] / max_PSII_l
    
    
    
    #determine the average and standard deviation of the DAS
    average_columns_w = np.mean(array_w,axis=0)
    std_colums_w=np.std(array_w,axis=0)
    
    average_columns_l = np.mean(array_l,axis=0)
    std_colums_l=np.std(array_l,axis=0)
    

    
    #define things for the plot 
    colours=['steelblue','orangered']
    label_w='Water'
    label_l='Lincomycin'
    

    plt.figure()
    
    plt.plot(average_columns_w[:,0],average_columns_w[:,2],color=colours[0],label=label_w)
    plt.fill_between(average_columns_w[:,0],average_columns_w[:,2]-(std_colums_w[:,2]/2),average_columns_w[:,2]+(std_colums_w[:,2]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columns_w[:,0],average_columns_l[:,2],color=colours[1],label=label_l)
    plt.fill_between(average_columns_l[:,0],average_columns_l[:,2]-(std_colums_l[:,2]/2),average_columns_l[:,2]+(std_colums_l[:,2]/2),color=colours[1],alpha=0.6)

    
    plt.plot(average_columns_w[:,0],average_columns_w[:,3],color=colours[0])
    plt.fill_between(average_columns_w[:,0],average_columns_w[:,3]-(std_colums_w[:,3]/2),average_columns_w[:,3]+(std_colums_w[:,3]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columns_l[:,0],average_columns_l[:,3],color=colours[1])
    plt.fill_between(average_columns_l[:,0],average_columns_l[:,3]-(std_colums_l[:,3]/2),average_columns_l[:,3]+(std_colums_l[:,3]/2),color=colours[1],alpha=0.6)


    
    plt.xlabel('Wavelength (nm)')
    plt.ylabel('Intensity')
    #plt.ylim(-0.1,2)
    plt.title('PSII Water vs. Linco '+title_string) 
    plt.legend()
    plt.savefig(folder_path+'/'+title_string+'_PSII_unmixed_watervslinco.png',dpi=1200,bbox_inches='tight')
    plt.show()  
    
    
    #plot PSI
    plt.figure()
    
    plt.plot(average_columns_w[:,0],average_columns_w[:,1],color=colours[0],label=label_w)
    plt.fill_between(average_columns_w[:,0],average_columns_w[:,1]-(std_colums_w[:,1]/2),average_columns_w[:,1]+(std_colums_w[:,1]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columns_w[:,0],average_columns_l[:,1],color=colours[1],label=label_l)
    plt.fill_between(average_columns_l[:,0],average_columns_l[:,1]-(std_colums_l[:,1]/2),average_columns_l[:,1]+(std_colums_l[:,1]/2),color=colours[1],alpha=0.6)

    
    


    
    plt.xlabel('Wavelength (nm)')
    plt.ylabel('Intensity')
    #plt.ylim(-0.1,2)
    plt.title('PSI Water vs. Linco '+title_string) 
    plt.legend()
    plt.savefig(folder_path+'/'+title_string+'_PSI_unmixed_watervslinco.png',dpi=1200,bbox_inches='tight')
    plt.show()  

#%%
# Call the function to open ASCII files & store their contents as NumPy arrays
dict_time,dict_DAS,folder_path = open_ascii_files()



# Read plot labels from Excel file
excel_file_path = filedialog.askopenfilename(filetypes=[("Excel Files", "*.xlsx")])
lifetimes_unmixed = pd.read_excel(excel_file_path)





#%% Normalise 
dict_DAS_norm={}
unmixed_DAS={}
#get the amplitudes of the PSII spectra in case of Fm and F0 (due to unmixing)
dict_ampli={}

for key in dict_DAS: 
    #normalise the DAS 
    dict_DAS_norm[key]=dict_DAS[key]
    dict_DAS_norm[key][:,1:]=dict_DAS[key][:,1:]/np.sum(dict_DAS[key][:,1:])

for key in dict_DAS: 
    
    #substract F0 PSI from Fm PSI 
    if 'F0' in key: 
        PSI_F0=dict_DAS_norm[key][:,1]
        
        for key2 in dict_DAS_norm:
            if key[0:4] in key2 and 'Fm' in key2 and key[10:30] in key2:
                PSI_Fm=dict_DAS_norm[key2][:,1]
                
        PSI_diff=PSI_F0-PSI_Fm 
        
        unmixed_DAS[key]=np.stack((dict_DAS_norm[key][:,0],PSI_Fm,PSI_diff,dict_DAS_norm[key][:,2])).T
    else: 
        unmixed_DAS[key]=dict_DAS_norm[key]
      
    #make a new dictionary 

    x_data=unmixed_DAS[key][:,0]
    y_data=unmixed_DAS[key][:,1:]
    
    
    if np.size(y_data[1])==3:
        PSII_short_max=np.sum(y_data[:,1])
        PSII_long_max=np.sum(y_data[:,2])
        dict_ampli[key]=(PSII_short_max/(PSII_short_max+PSII_long_max),PSII_long_max/(PSII_short_max+PSII_long_max))
    
        
#export the amplitude data as a .csv

f = open(folder_path[:-10]+'amplitudes.csv','w')
for key in dict_ampli.keys():
    f.write(str(key)+';'+str(dict_ampli[key])+'\n')
f.close()
        
        
#%% from now the old code 

#%% plot the DAS on top of each other 

#make arrays with all the situations
#water

test=[dict_DAS[key] for key in dict_DAS.keys() if 'Fm' in key and 'DA_' in key and 'water' in key]

dark_Fm_w=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'Fm' in key and 'DA_' in key and 'water' in key]
dark_F0_w=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'F0' in key and 'DA_' in key and 'water' in key]
HL_1h_Fm_w=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'Fm' in key and 'HL_1h' in key and 'water' in key]
HL_1h_F0_w=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'F0' in key and 'HL_1h' in key and 'water' in key]
HL_2h_Fm_w=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'Fm' in key and 'HL_2h' in key and 'water' in key]
HL_2h_F0_w=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'F0' in key and 'HL_2h' in key and 'water' in key]
HL_4h_Fm_w=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'Fm' in key and 'HL_4h' in key and 'water' in key]
HL_4h_F0_w=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'F0' in key and 'HL_4h' in key and 'water' in key]

#make similar arrays for the lifetime 
dark_Fm_w_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'Fm' in key and 'DA_' in key and 'water' in key],dtype= 'float')
dark_F0_w_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'F0' in key and 'DA_' in key and 'water' in key],dtype= 'float')
HL_1h_Fm_w_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'Fm' in key and 'HL_1h' in key and 'water' in key],dtype= 'float')
HL_1h_F0_w_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'F0' in key and 'HL_1h' in key and 'water' in key],dtype= 'float')
HL_2h_Fm_w_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'Fm' in key and 'HL_2h' in key and 'water' in key],dtype= 'float')
HL_2h_F0_w_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'F0' in key and 'HL_2h' in key and 'water' in key],dtype= 'float')
HL_4h_Fm_w_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'Fm' in key and 'HL_4h' in key and 'water' in key],dtype= 'float')
HL_4h_F0_w_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'F0' in key and 'HL_4h' in key and 'water' in key],dtype= 'float')



#linco
dark_Fm_l=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'Fm' in key and 'DA_' in key and 'linco' in key]
dark_F0_l=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'F0' in key and 'DA_' in key and 'linco' in key]
HL_1h_Fm_l=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'Fm' in key and 'HL_1h' in key and 'linco' in key]
HL_1h_F0_l=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'F0' in key and 'HL_1h' in key and 'linco' in key]
HL_2h_Fm_l=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'Fm' in key and 'HL_2h' in key and 'linco' in key]
HL_2h_F0_l=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'F0' in key and 'HL_2h' in key and 'linco' in key]
HL_4h_Fm_l=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'Fm' in key and 'HL_4h' in key and 'linco' in key]
HL_4h_F0_l=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'F0' in key and 'HL_4h' in key and 'linco' in key]

#make similar arrays for the lifetime 
dark_Fm_l_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'Fm' in key and 'DA_' in key and 'linco' in key],dtype= 'float')
dark_F0_l_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'F0' in key and 'DA_' in key and 'linco' in key],dtype= 'float')
HL_1h_Fm_l_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'Fm' in key and 'HL_1h' in key and 'linco' in key],dtype= 'float')
HL_1h_F0_l_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'F0' in key and 'HL_1h' in key and 'linco' in key],dtype= 'float')
HL_2h_Fm_l_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'Fm' in key and 'HL_2h' in key and 'linco' in key],dtype= 'float')
HL_2h_F0_l_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'F0' in key and 'HL_2h' in key and 'linco' in key],dtype= 'float')
HL_4h_Fm_l_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'Fm' in key and 'HL_4h' in key and 'linco' in key],dtype= 'float')
HL_4h_F0_l_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'F0' in key and 'HL_4h' in key and 'linco' in key],dtype= 'float')

#%% plot the data 


plot_DAS(dark_Fm_w, '$F_{m}$ Conditions DA water WT',dark_Fm_w_lt)
plot_DAS(dark_F0_w, 'Open RC DA water',dark_F0_w_lt)
plot_DAS(HL_1h_Fm_w, 'Closed RC 1h HL water',HL_1h_Fm_w_lt)
plot_DAS(HL_1h_F0_w, 'Open RC 1h HL water',HL_1h_F0_w_lt)
plot_DAS(HL_2h_Fm_w, 'Closed RC 2h HL water',HL_2h_Fm_w_lt)
plot_DAS(HL_2h_F0_w, 'Open RC 2h HL water',HL_2h_F0_w_lt)
plot_DAS(HL_4h_Fm_w, 'Closed RC 4h HL water',HL_4h_Fm_w_lt)
plot_DAS(HL_4h_F0_w, 'Open RC 4h HL water',HL_4h_F0_w_lt)


plot_DAS(dark_Fm_l, '$F_{m}$ Conditions - Dark - Lincomycin',dark_Fm_l_lt)
plot_DAS(dark_F0_l, '$F_{o}$ Conditions - Dark - Lincomycin',dark_F0_l_lt)
plot_DAS(HL_1h_Fm_l, 'Closed RC 1h HL lincomycin',HL_1h_Fm_l_lt)
plot_DAS(HL_1h_F0_l, 'Open RC 1h HL lincomycin',HL_1h_F0_l_lt)
plot_DAS(HL_2h_Fm_l, 'Closed RC 2h HL lincomycin',HL_2h_Fm_l_lt)
plot_DAS(HL_2h_F0_l, 'Open RC 2h HL lincomycin',HL_2h_F0_l_lt)
plot_DAS(HL_4h_Fm_l, '$F_{m}$ Conditions - 4h HL - Lincomycin',HL_4h_Fm_l_lt)
plot_DAS(HL_4h_F0_l, '$F_{o}$ Conditions - 4h HL - Lincomycin',HL_4h_F0_l_lt)


#%% plot the t=0 spectra 
#start here tomorrow!! 

plot_DAS_t0(dark_Fm_w, 'Closed RC DA water')
plot_DAS_t0(dark_F0_w, 'Open RC DA water')
plot_DAS_t0(HL_1h_Fm_w, 'Closed RC 1h HL water')
plot_DAS_t0(HL_1h_F0_w, 'Open RC 1h HL water')
plot_DAS_t0(HL_2h_Fm_w, 'Closed RC 2h HL water')
plot_DAS_t0(HL_2h_F0_w, 'Open RC 2h HL water')
plot_DAS_t0(HL_4h_Fm_w, 'Closed RC 4h HL water')
plot_DAS_t0(HL_4h_F0_w, 'Open RC 4h HL water')


plot_DAS_t0(dark_Fm_l, 'Closed RC Dark lincomycin')
plot_DAS_t0(dark_F0_l, 'Open RC Dark lincomycin')
plot_DAS_t0(HL_1h_Fm_l, 'Closed RC 1h HL lincomycin')
plot_DAS_t0(HL_1h_F0_l, 'Open RC 1h HL lincomycin')
plot_DAS_t0(HL_2h_Fm_l, 'Closed RC 2h HL lincomycin')
plot_DAS_t0(HL_2h_F0_l, 'Open RC 2h HL lincomycin')
plot_DAS_t0(HL_4h_Fm_l, 'Closed RC 4h HL lincomycin')
plot_DAS_t0(HL_4h_F0_l, 'Open RC 4h HL lincomycin')

#%% plot the DAS for different conditions 



# plot_DAS_PSI(np.asarray(dark_Fm_l),np.asarray(HL_1h_Fm_l),np.asarray(HL_2h_Fm_l),np.asarray(HL_4h_Fm_l),dark_Fm_l_lt,HL_1h_Fm_l_lt,HL_2h_Fm_l_lt, HL_4h_Fm_l_lt,'Lincomycin')
# plot_DAS_PSI(np.asarray(dark_Fm_w),np.asarray(HL_1h_Fm_w),np.asarray(HL_2h_Fm_w),np.asarray(HL_4h_Fm_w),dark_Fm_w_lt,HL_1h_Fm_w_lt,HL_2h_Fm_w_lt, HL_4h_Fm_w_lt,'Water')

# plot_DAS_PSII(np.asarray(dark_Fm_l),np.asarray(HL_1h_Fm_l),np.asarray(HL_2h_Fm_l),np.asarray(HL_4h_Fm_l),dark_Fm_l_lt,HL_1h_Fm_l_lt,HL_2h_Fm_l_lt, HL_4h_Fm_l_lt,'Fm','Lincomycin')
# plot_DAS_PSII(np.asarray(dark_Fm_w),np.asarray(HL_1h_Fm_w),np.asarray(HL_2h_Fm_w),np.asarray(HL_4h_Fm_w),dark_Fm_w_lt,HL_1h_Fm_w_lt,HL_2h_Fm_w_lt, HL_4h_Fm_w_lt,'Fm','Water')

# plot_DAS_PSII(np.asarray(dark_F0_l),np.asarray(HL_1h_F0_l),np.asarray(HL_2h_F0_l),np.asarray(HL_4h_F0_l),dark_F0_l_lt,HL_1h_F0_l_lt,HL_2h_F0_l_lt, HL_4h_F0_l_lt,'F0','Lincomycin')
# plot_DAS_PSII(np.asarray(dark_F0_w),np.asarray(HL_1h_F0_w),np.asarray(HL_2h_F0_w),np.asarray(HL_4h_F0_w),dark_F0_w_lt,HL_1h_F0_w_lt,HL_2h_F0_w_lt, HL_4h_F0_w_lt,'F0','Water')

# plot_DAS_F0_Fm(np.asarray(dark_Fm_l),np.asarray(dark_F0_l),'Dark Lincomycin')
# plot_DAS_F0_Fm(np.asarray(HL_1h_Fm_l),np.asarray(HL_1h_F0_l),'1h HL Lincomycin')
# plot_DAS_F0_Fm(np.asarray(HL_2h_Fm_l),np.asarray(HL_2h_F0_l),'2h HL Lincomycin')
# plot_DAS_F0_Fm(np.asarray(HL_4h_Fm_l),np.asarray(HL_4h_F0_l),'4h HL Lincomycin')

# plot_DAS_F0_Fm(np.asarray(dark_Fm_w),np.asarray(dark_F0_w),'Dark Water')
# plot_DAS_F0_Fm(np.asarray(HL_1h_Fm_w),np.asarray(HL_1h_F0_w),'1h HL Water')
# plot_DAS_F0_Fm(np.asarray(HL_2h_Fm_w),np.asarray(HL_2h_F0_w),'2h HL Water')
# plot_DAS_F0_Fm(np.asarray(HL_4h_Fm_w),np.asarray(HL_4h_F0_w),'4h HL Water')

# plot_DAS_water_linco_Fm(np.asarray(dark_Fm_w),np.asarray(dark_Fm_l), 'Dark')
# plot_DAS_water_linco_Fm(np.asarray(HL_1h_Fm_w),np.asarray(HL_1h_Fm_l), '1h HL')
# plot_DAS_water_linco_Fm(np.asarray(HL_2h_Fm_w),np.asarray(HL_2h_Fm_l), '2h HL')
# plot_DAS_water_linco_Fm(np.asarray(HL_4h_Fm_w),np.asarray(HL_4h_Fm_l), '4h HL')



#%% Make dictionaries for the lifetimes and the amplitudes 

dict_contributions={}
dict_lifetimes={}
dict_average_PSII={}
dict_contributions_PSII={}



for key in unmixed_DAS.keys():
    #sum the total of the collumns with DAS spectra 
    length=len(unmixed_DAS[key][0])-1
    total_sum=np.sum(unmixed_DAS[key][:, -length:])
    total_sum_PSII=np.sum(unmixed_DAS[key][:, -length+1:])

    
    #make an empty array  for the contributions 
    contributions=np.zeros(length)
    lifetime_values=np.zeros(length)
    contributions_PSII=np.zeros(length-1)

    
    for x in range(1,len(unmixed_DAS[key][0])):
        contributions[x-1]=np.sum(unmixed_DAS[key][:,x])/total_sum
    for x in range(2,len(unmixed_DAS[key][0])):
        contributions_PSII[x-2]=np.sum(unmixed_DAS[key][:,x])/total_sum_PSII

    
    dict_contributions[key] = contributions
    dict_contributions_PSII[key] = contributions_PSII

    
    
    

    #plot the numer of lines 
    #get the lifetimes from the excel 
    
    if key in lifetimes_unmixed.iloc[:,0].values:
        for i in range(length):
            lifetime_values[i] = lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, i+1]
    
    if length==3:
        dict_average_PSII[key]=np.sum(dict_contributions_PSII[key]*lifetime_values[-2:])
        
    dict_lifetimes[key] = lifetime_values

#%% plot the files for the lifetimes 

#separate them into PSI, PSII short and PSII long components
# PSI 
dark_Fm_w_lt_PSI=dark_Fm_w_lt[:,0]
dark_F0_w_lt_PSI=dark_F0_w_lt[:,0]
HL_1h_Fm_w_lt_PSI=HL_1h_Fm_w_lt[:,0]
HL_1h_F0_w_lt_PSI=HL_1h_F0_w_lt[:,0]
HL_2h_Fm_w_lt_PSI=HL_2h_Fm_w_lt[:,0]
HL_2h_F0_w_lt_PSI=HL_2h_F0_w_lt[:,0]
HL_4h_Fm_w_lt_PSI=HL_4h_Fm_w_lt[:,0]
HL_4h_F0_w_lt_PSI=HL_4h_F0_w_lt[:,0]

dark_Fm_l_lt_PSI=dark_Fm_l_lt[:,0]
dark_F0_l_lt_PSI=dark_F0_l_lt[:,0]
HL_1h_Fm_l_lt_PSI=HL_1h_Fm_l_lt[:,0]
HL_1h_F0_l_lt_PSI=HL_1h_F0_l_lt[:,0]
HL_2h_Fm_l_lt_PSI=HL_2h_Fm_l_lt[:,0]
HL_2h_F0_l_lt_PSI=HL_2h_F0_l_lt[:,0]
HL_4h_Fm_l_lt_PSI=HL_4h_Fm_l_lt[:,0]
HL_4h_F0_l_lt_PSI=HL_4h_F0_l_lt[:,0]

# PSII short 
dark_Fm_w_lt_PSIIs=dark_Fm_w_lt[:,1]
dark_F0_w_lt_PSIIs=dark_F0_w_lt[:,1]
HL_1h_Fm_w_lt_PSIIs=HL_1h_Fm_w_lt[:,1]
HL_1h_F0_w_lt_PSIIs=HL_1h_F0_w_lt[:,1]
HL_2h_Fm_w_lt_PSIIs=HL_2h_Fm_w_lt[:,1]
HL_2h_F0_w_lt_PSIIs=HL_2h_F0_w_lt[:,1]
HL_4h_Fm_w_lt_PSIIs=HL_4h_Fm_w_lt[:,1]
HL_4h_F0_w_lt_PSIIs=HL_4h_F0_w_lt[:,1]

dark_Fm_l_lt_PSIIs=dark_Fm_l_lt[:,1]
dark_F0_l_lt_PSIIs=dark_F0_l_lt[:,1]
HL_1h_Fm_l_lt_PSIIs=HL_1h_Fm_l_lt[:,1]
HL_1h_F0_l_lt_PSIIs=HL_1h_F0_l_lt[:,1]
HL_2h_Fm_l_lt_PSIIs=HL_2h_Fm_l_lt[:,1]
HL_2h_F0_l_lt_PSIIs=HL_2h_F0_l_lt[:,1]
HL_4h_Fm_l_lt_PSIIs=HL_4h_Fm_l_lt[:,1]
HL_4h_F0_l_lt_PSIIs=HL_4h_F0_l_lt[:,1]


# PSII long
dark_Fm_w_lt_PSIIl=dark_Fm_w_lt[:,2]
HL_1h_Fm_w_lt_PSIIl=HL_1h_Fm_w_lt[:,2]
HL_2h_Fm_w_lt_PSIIl=HL_2h_Fm_w_lt[:,2]
HL_4h_Fm_w_lt_PSIIl=HL_4h_Fm_w_lt[:,2]
dark_F0_w_lt_PSIIl=dark_F0_w_lt[:,2]
HL_1h_F0_w_lt_PSIIl=HL_1h_F0_w_lt[:,2]
HL_2h_F0_w_lt_PSIIl=HL_2h_F0_w_lt[:,2]
HL_4h_F0_w_lt_PSIIl=HL_4h_F0_w_lt[:,2]

dark_Fm_l_lt_PSIIl=dark_Fm_l_lt[:,2]
HL_1h_Fm_l_lt_PSIIl=HL_1h_Fm_l_lt[:,2]
HL_2h_Fm_l_lt_PSIIl=HL_2h_Fm_l_lt[:,2]
HL_4h_Fm_l_lt_PSIIl=HL_4h_Fm_l_lt[:,2]
dark_F0_l_lt_PSIIl=dark_F0_l_lt[:,2]
HL_1h_F0_l_lt_PSIIl=HL_1h_F0_l_lt[:,2]
HL_2h_F0_l_lt_PSIIl=HL_2h_F0_l_lt[:,2]
HL_4h_F0_l_lt_PSIIl=HL_4h_F0_l_lt[:,2]

#%%
#amplitudes of the PSII Fm components 

#water
dark_Fm_w_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fm' in key and 'DA_' in key and 'water' in key])
HL_1h_Fm_w_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fm' in key and 'HL_1h' in key and 'water' in key])
HL_2h_Fm_w_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fm' in key and 'HL_2h' in key and 'water' in key])
HL_4h_Fm_w_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fm' in key and 'HL_4h' in key and 'water' in key])

#linco
dark_Fm_l_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fm' in key and 'DA_' in key and 'linco' in key])
HL_1h_Fm_l_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fm' in key and 'HL_1h' in key and 'linco' in key])
HL_2h_Fm_l_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fm' in key and 'HL_2h' in key and 'linco' in key])
HL_4h_Fm_l_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fm' in key and 'HL_4h' in key and 'linco' in key])


#short PSII
dark_Fm_w_c_PSIIs=dark_Fm_w_c[:,0]
HL_1h_Fm_w_c_PSIIs=HL_1h_Fm_w_c[:,0]
HL_2h_Fm_w_c_PSIIs=HL_2h_Fm_w_c[:,0]
HL_4h_Fm_w_c_PSIIs=HL_4h_Fm_w_c[:,0]

dark_Fm_l_c_PSIIs=dark_Fm_l_c[:,0]
HL_1h_Fm_l_c_PSIIs=HL_1h_Fm_l_c[:,0]
HL_2h_Fm_l_c_PSIIs=HL_2h_Fm_l_c[:,0]
HL_4h_Fm_l_c_PSIIs=HL_4h_Fm_l_c[:,0]

#long PSII
dark_Fm_w_c_PSIIl=dark_Fm_w_c[:,1]
HL_1h_Fm_w_c_PSIIl=HL_1h_Fm_w_c[:,1]
HL_2h_Fm_w_c_PSIIl=HL_2h_Fm_w_c[:,1]
HL_4h_Fm_w_c_PSIIl=HL_4h_Fm_w_c[:,1]

dark_Fm_l_c_PSIIl=dark_Fm_l_c[:,1]
HL_1h_Fm_l_c_PSIIl=HL_1h_Fm_l_c[:,1]
HL_2h_Fm_l_c_PSIIl=HL_2h_Fm_l_c[:,1]
HL_4h_Fm_l_c_PSIIl=HL_4h_Fm_l_c[:,1]



#%%
#amplitudes of the PSII F0 components after unmixing

#water
dark_F0_w_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'F0' in key and 'DA_' in key and 'water' in key])
HL_1h_F0_w_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'F0' in key and 'HL_1h' in key and 'water' in key])
HL_2h_F0_w_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'F0' in key and 'HL_2h' in key and 'water' in key])
HL_4h_F0_w_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'F0' in key and 'HL_4h' in key and 'water' in key])

#linco
dark_F0_l_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'F0' in key and 'DA_' in key and 'linco' in key])
HL_1h_F0_l_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'F0' in key and 'HL_1h' in key and 'linco' in key])
HL_2h_F0_l_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'F0' in key and 'HL_2h' in key and 'linco' in key])
HL_4h_F0_l_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'F0' in key and 'HL_4h' in key and 'linco' in key])


#short PSII
dark_F0_w_c_PSIIs=dark_F0_w_c[:,0]
HL_1h_F0_w_c_PSIIs=HL_1h_F0_w_c[:,0]
HL_2h_F0_w_c_PSIIs=HL_2h_F0_w_c[:,0]
HL_4h_F0_w_c_PSIIs=HL_4h_F0_w_c[:,0]

dark_F0_l_c_PSIIs=dark_F0_l_c[:,0]
HL_1h_F0_l_c_PSIIs=HL_1h_F0_l_c[:,0]
HL_2h_F0_l_c_PSIIs=HL_2h_F0_l_c[:,0]
HL_4h_F0_l_c_PSIIs=HL_4h_F0_l_c[:,0]

#long PSII
dark_F0_w_c_PSIIl=dark_F0_w_c[:,1]
HL_1h_F0_w_c_PSIIl=HL_1h_F0_w_c[:,1]
HL_2h_F0_w_c_PSIIl=HL_2h_F0_w_c[:,1]
HL_4h_F0_w_c_PSIIl=HL_4h_F0_w_c[:,1]

dark_F0_l_c_PSIIl=dark_F0_l_c[:,1]
HL_1h_F0_l_c_PSIIl=HL_1h_F0_l_c[:,1]
HL_2h_F0_l_c_PSIIl=HL_2h_F0_l_c[:,1]
HL_4h_F0_l_c_PSIIl=HL_4h_F0_l_c[:,1]

#%% average PSII Fm

#water
dark_Fm_w_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fm' in key and 'DA_' in key and 'water' in key])
HL_1h_Fm_w_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fm' in key and 'HL_1h' in key and 'water' in key])
HL_2h_Fm_w_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fm' in key and 'HL_2h' in key and 'water' in key])
HL_4h_Fm_w_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fm' in key and 'HL_4h' in key and 'water' in key])

#linco
dark_Fm_l_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fm' in key and 'DA_' in key and 'linco' in key])
HL_1h_Fm_l_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fm' in key and 'HL_1h' in key and 'linco' in key])
HL_2h_Fm_l_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fm' in key and 'HL_2h' in key and 'linco' in key])
HL_4h_Fm_l_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fm' in key and 'HL_4h' in key and 'linco' in key])

#%% average PSII F0

#water
dark_F0_w_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'F0' in key and 'DA_' in key and 'water' in key])
HL_1h_F0_w_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'F0' in key and 'HL_1h' in key and 'water' in key])
HL_2h_F0_w_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'F0' in key and 'HL_2h' in key and 'water' in key])
HL_4h_F0_w_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'F0' in key and 'HL_4h' in key and 'water' in key])

#linco
dark_F0_l_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'F0' in key and 'DA_' in key and 'linco' in key])
HL_1h_F0_l_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'F0' in key and 'HL_1h' in key and 'linco' in key])
HL_2h_F0_l_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'F0' in key and 'HL_2h' in key and 'linco' in key])
HL_4h_F0_l_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'F0' in key and 'HL_4h' in key and 'linco' in key])



#%%#make them together in lists for the boxplots
 
PSI_F0_w=[dark_F0_w_lt_PSI,HL_1h_F0_w_lt_PSI,HL_2h_F0_w_lt_PSI,HL_4h_F0_w_lt_PSI]
PSI_Fm_w=[dark_Fm_w_lt_PSI,HL_1h_Fm_w_lt_PSI,HL_2h_Fm_w_lt_PSI,HL_4h_Fm_w_lt_PSI]

PSIIs_F0_w=[dark_F0_w_lt_PSIIs,HL_1h_F0_w_lt_PSIIs,HL_2h_F0_w_lt_PSIIs,HL_4h_F0_w_lt_PSIIs]
PSIIs_Fm_w=[dark_Fm_w_lt_PSIIs,HL_1h_Fm_w_lt_PSIIs,HL_2h_Fm_w_lt_PSIIs,HL_4h_Fm_w_lt_PSIIs]

PSIIl_Fm_w=[dark_Fm_w_lt_PSIIl,HL_1h_Fm_w_lt_PSIIl,HL_2h_Fm_w_lt_PSIIl,HL_4h_Fm_w_lt_PSIIl]

PSI_F0_l=[dark_F0_l_lt_PSI,HL_1h_F0_l_lt_PSI,HL_2h_F0_l_lt_PSI,HL_4h_F0_l_lt_PSI]
PSI_Fm_l=[dark_Fm_l_lt_PSI,HL_1h_Fm_l_lt_PSI,HL_2h_Fm_l_lt_PSI,HL_4h_Fm_l_lt_PSI]

PSIIs_F0_l=[dark_F0_l_lt_PSIIs,HL_1h_F0_l_lt_PSIIs,HL_2h_F0_l_lt_PSIIs,HL_4h_F0_l_lt_PSIIs]
PSIIs_Fm_l=[dark_Fm_l_lt_PSIIs,HL_1h_Fm_l_lt_PSIIs,HL_2h_Fm_l_lt_PSIIs,HL_4h_Fm_l_lt_PSIIs]

PSIIl_Fm_l=[dark_Fm_l_lt_PSIIl,HL_1h_Fm_l_lt_PSIIl,HL_2h_Fm_l_lt_PSIIl,HL_4h_Fm_l_lt_PSIIl]

PSIIs_c_w=[dark_Fm_w_c_PSIIs,HL_1h_Fm_w_c_PSIIs,HL_2h_Fm_w_c_PSIIs,HL_4h_Fm_w_c_PSIIs]
PSIIl_c_w=[dark_Fm_w_c_PSIIl,HL_1h_Fm_w_c_PSIIl,HL_2h_Fm_w_c_PSIIl,HL_4h_Fm_w_c_PSIIl]
PSIIs_c_l=[dark_Fm_l_c_PSIIs,HL_1h_Fm_l_c_PSIIs,HL_2h_Fm_l_c_PSIIs,HL_4h_Fm_l_c_PSIIs]
PSIIl_c_l=[dark_Fm_l_c_PSIIl,HL_1h_Fm_l_c_PSIIl,HL_2h_Fm_l_c_PSIIl,HL_4h_Fm_l_c_PSIIl]


PSII_w_al=[dark_Fm_w_al,HL_1h_Fm_w_al,HL_2h_Fm_w_al,HL_4h_Fm_w_al]
PSII_l_al=[dark_Fm_l_al,HL_1h_Fm_l_al,HL_2h_Fm_l_al,HL_4h_Fm_l_al]

PSII_F0_w_al=[dark_F0_w_al,HL_1h_F0_w_al,HL_2h_F0_w_al,HL_4h_F0_w_al]
PSII_F0_l_al=[dark_F0_l_al,HL_1h_F0_l_al,HL_2h_F0_l_al,HL_4h_F0_l_al]

#%% make the graphs for the lifetimes 

ticks = ["Dark", "1h",'2h', '4h']
positions_w=np.array(range(len(PSI_F0_w)))*2.0-0.4
positions_l=np.array(range(len(PSI_F0_l)))*2.0+0.4


# F0 PSI 
plt.figure()

#bpl=plt.boxplot(PSI_F0_w, positions=np.array(range(len(PSI_F0_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=plt.boxplot(PSI_F0_l, positions=np.array(range(len(PSI_F0_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

count=0
for x in np.array(range(len(PSI_F0_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_F0_w[count]))-0.2)/10
    plt.scatter(scatter,PSI_F0_w[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_F0_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSI_F0_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_F0_l[count]))-0.2)/10
    plt.scatter(scatter,PSI_F0_l[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_F0_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

plt.title('PSI Open RC')
plt.ylabel ('Lifetime (ps)',fontsize=14)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-2, len(ticks)*2)
plt.ylim(0,110)
plt.tight_layout()
plt.savefig(folder_path+'/'+'lifetimes_F0_PSI_unmix_scatter.png',dpi=1200,bbox_inches='tight')


# Fm PSI 
plt.figure()

#bpl=plt.boxplot(PSI_Fm_w, positions=np.array(range(len(PSI_Fm_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=plt.boxplot(PSI_Fm_l, positions=np.array(range(len(PSI_Fm_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

count=0
for x in np.array(range(len(PSI_Fm_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_F0_w[count]))-0.2)/10
    plt.scatter(scatter,PSI_Fm_w[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_Fm_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSI_Fm_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_F0_l[count]))-0.2)/10
    plt.scatter(scatter,PSI_Fm_l[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_Fm_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

plt.ylabel ('Lifetime (ps)',fontsize=14)

plt.title('PSI Closed RC')
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)

plt.xlim(-2, len(ticks)*2)
plt.ylim(0,110)
plt.tight_layout()

plt.savefig(folder_path+'/'+'lifetimes_Fm_PSI.png',dpi=1200,bbox_inches='tight')

# F0 PSII 
plt.figure()

#bpl=plt.boxplot(PSIIs_F0_w, positions=np.array(range(len(PSIIs_F0_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=plt.boxplot(PSIIs_F0_l, positions=np.array(range(len(PSIIs_F0_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

count=0
for x in np.array(range(len(PSIIs_F0_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_F0_w[count]))-0.2)/10
    plt.scatter(scatter,PSIIs_F0_w[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSIIs_F0_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSIIs_F0_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_F0_l[count]))-0.2)/10
    plt.scatter(scatter,PSIIs_F0_l[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSIIs_F0_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)


plt.ylabel ('Lifetime (ps)',fontsize=14)

plt.title('PSII Open RC')
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)

plt.xlim(-2, len(ticks)*2)
#plt.ylim(75,100)
plt.tight_layout()

plt.savefig(folder_path+'/''lifetimes_F0_PSII_unmix.png',dpi=1200,bbox_inches='tight')


#%% lifetime + amplitude PSII Fm 
# Fm PSII 
labels=["Dark", "1h",'2h', '4h']
figure1 = plt.figure(constrained_layout=True,figsize=(8,6))
gs = gridspec.GridSpec(2, 2, figure=figure1)
ax1 = figure1.add_subplot(gs[0,0])
ax2 = figure1.add_subplot(gs[1,0])
ax3 = figure1.add_subplot(gs[0,1])
ax4 = figure1.add_subplot(gs[1,1])

ax1.set_ylabel('Lifetime (ps)',fontsize=12)
ax1.set_title('Short Component PSII',fontsize=12)

#bpl=ax1.boxplot(PSIIs_Fm_w, positions=np.array(range(len(PSIIs_Fm_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=ax1.boxplot(PSIIs_Fm_l, positions=np.array(range(len(PSIIs_Fm_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')
ax1.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=12)
ax1.set_xticklabels(labels)
#ax1.set_ylim(0,6000)

count=0
for x in np.array(range(len(PSIIs_Fm_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_Fm_w[count]))-0.2)/10
    ax1.scatter(scatter,PSIIs_Fm_w[count],linewidth=1,color='white',edgecolor='black')
    ax1.hlines(np.mean(PSIIs_Fm_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSIIs_Fm_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_Fm_l[count]))-0.2)/10
    ax1.scatter(scatter,PSIIs_Fm_l[count],linewidth=1,color='white',edgecolor='black')
    ax1.hlines(np.mean(PSIIs_Fm_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)
#short component amplitude
ax2.set_ylabel('Contribution',fontsize=14)

#bpl=ax2.boxplot(PSIIs_c_w, positions=np.array(range(len(PSIIs_c_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=ax2.boxplot(PSIIs_c_l, positions=np.array(range(len(PSIIs_c_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

count=0
for x in np.array(range(len(PSIIs_c_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_c_w[count]))-0.2)/10
    ax2.scatter(scatter,PSIIs_c_w[count],linewidth=1,color='white',edgecolor='black')
    ax2.hlines(np.mean(PSIIs_c_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)
    count+=1
    
count=0
for x in np.array(range(len(PSIIs_c_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_c_l[count]))-0.2)/10
    ax2.scatter(scatter,PSIIs_c_l[count],linewidth=1,color='white',edgecolor='black')
    ax2.hlines(np.mean(PSIIs_c_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

ax2.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax2.set_xticklabels(labels)
ax2.set_ylim(0,1)
#ax1.set_ylim(0,6000)


#box plot average lifetime and amplitudes
ax3.set_title('Long Component PSII',fontsize=14)
ax3.set_ylabel('Lifetime (ps)',fontsize=14)
#bpl=ax3.boxplot(PSIIl_Fm_w, positions=np.array(range(len(PSIIl_Fm_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=ax3.boxplot(PSIIl_Fm_l, positions=np.array(range(len(PSIIl_Fm_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

count=0
for x in np.array(range(len(PSIIl_Fm_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_Fm_w[count]))-0.2)/10
    ax3.scatter(scatter,PSIIl_Fm_w[count],linewidth=1,color='white',edgecolor='black')
    ax3.hlines(np.mean(PSIIl_Fm_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSIIl_Fm_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_Fm_l[count]))-0.2)/10
    ax3.scatter(scatter,PSIIl_Fm_l[count],linewidth=1,color='white',edgecolor='black')
    ax3.hlines(np.mean(PSIIl_Fm_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
ax3.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax3.set_xticklabels(labels)

#long component amplitude
ax4.set_ylabel('Contribution',fontsize=14)

#bpl=ax4.boxplot(PSIIl_c_w, positions=np.array(range(len(PSIIl_c_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=ax4.boxplot(PSIIl_c_l, positions=np.array(range(len(PSIIl_c_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

count=0
for x in np.array(range(len(PSIIl_c_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_c_w[count]))-0.2)/10
    ax4.scatter(scatter,PSIIl_c_w[count],linewidth=1,color='white',edgecolor='black')
    ax4.hlines(np.mean(PSIIl_c_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSIIl_c_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_c_l[count]))-0.2)/10
    ax4.scatter(scatter,PSIIl_c_l[count],linewidth=1,color='white',edgecolor='black')
    ax4.hlines(np.mean(PSIIl_c_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
ax4.set_xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
ax4.set_xticklabels(labels)
ax4.set_ylim(0,1)


plt.savefig(folder_path+'/''lifetimes_Fm_PSII_scatter.png',dpi=1200,bbox_inches='tight')
plt.show()



#%% average lifetime PSII Fm


# average lifetime PSII 
plt.figure()

#bpl=plt.boxplot(PSII_w_al, positions=np.array(range(len(PSIIl_Fm_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=plt.boxplot(PSII_l_al, positions=np.array(range(len(PSIIl_Fm_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')


count=0
for x in np.array(range(len(PSII_w_al)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSII_w_al[count]))-0.2)/10
    plt.scatter(scatter,PSII_w_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSII_w_al[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSII_l_al)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSII_l_al[count]))-0.2)/10
    plt.scatter(scatter,PSII_l_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSII_l_al[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)



plt.legend(fontsize=16)



plt.title(r" Average lifetime PSII - $F_{m}$ Conditions - WT", fontsize=16)
plt.ylabel ('Average Lifetime (ps)',fontsize=18)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=18)
plt.yticks(fontsize=18)
plt.xlim(-2, len(ticks)*2)
#plt.ylim(75,100)
plt.tight_layout()
plt.savefig(folder_path+'/'+'lifetimes_average_Fm_PSII_scatter.png',dpi=1200,bbox_inches='tight')
plt.savefig(folder_path+'/'+'lifetimes_average_Fm_PSII_scatter.svg',dpi=1200,bbox_inches='tight')

#%% average lifetime PSII F0 


plt.figure()

#bpl=plt.boxplot(PSII_F0_w_al, positions=np.array(range(len(PSII_F0_w_al)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=plt.boxplot(PSII_F0_l_al, positions=np.array(range(len(PSII_F0_w_al)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')

count=0
for x in np.array(range(len(PSII_F0_w_al)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSII_F0_w_al[count]))-0.2)/10
    plt.scatter(scatter,PSII_F0_w_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSII_F0_w_al[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(PSII_F0_l_al)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(PSII_F0_l_al[count]))-0.2)/10
    plt.scatter(scatter,PSII_F0_l_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSII_F0_l_al[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1

# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=16)

plt.title(r" Average lifetime PSII - $F_{o}$ Conditions - WT", fontsize=16)
plt.ylabel ('Average Lifetime (ps)',fontsize=18)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=18)
plt.yticks(fontsize=18)
plt.xlim(-2, len(ticks)*2)
#plt.ylim(75,100)
plt.tight_layout()
plt.savefig(folder_path+'/'+'lifetimes_average_F0_PSII_unmixing_scatter.png',dpi=1200,bbox_inches='tight')
plt.savefig(folder_path+'/'+'lifetimes_average_F0_PSII_unmixing_scatter.svg',dpi=1200,bbox_inches='tight')




#%% Fv/Fm calculation 

dict_F_PAM={}

for key in unmixed_DAS.keys(): 
        
    #find the index of 700 nm 
    index=np.argmax(unmixed_DAS[key][:,0]>700)
    
    
    
    #sum the total of the collumns with DAS spectra 
    length=len(unmixed_DAS[key][0])-1
    total_sum_700=np.sum(unmixed_DAS[key][index:, -length:])

    #get the contributions 
    #make an empty array  for the contributions 
    contributions_700=np.zeros(length)
    for x in range(1,len(unmixed_DAS[key][0])):
        contributions_700[x-1]=np.sum(unmixed_DAS[key][index:,x])/total_sum_700
    
    #multiply the contributions with the lifetimes 
    np.sum(dict_lifetimes[key]*contributions_700)
    
    
    dict_F_PAM[key] = np.sum(dict_lifetimes[key]*contributions_700)



#water
dark_Fm_w_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fm' in key and 'DA_' in key and 'water' in key]
dark_F0_w_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'F0' in key and 'DA_' in key and 'water' in key]
HL_1h_Fm_w_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fm' in key and 'HL_1h' in key and 'water' in key]
HL_1h_F0_w_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'F0' in key and 'HL_1h' in key and 'water' in key]
HL_2h_Fm_w_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fm' in key and 'HL_2h' in key and 'water' in key]
HL_2h_F0_w_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'F0' in key and 'HL_2h' in key and 'water' in key]
HL_4h_Fm_w_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fm' in key and 'HL_4h' in key and 'water' in key]
HL_4h_F0_w_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'F0' in key and 'HL_4h' in key and 'water' in key]


#linco
dark_Fm_l_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fm' in key and 'DA_' in key and 'linco' in key]
dark_F0_l_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'F0' in key and 'DA_' in key and 'linco' in key]
HL_1h_Fm_l_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fm' in key and 'HL_1h' in key and 'linco' in key]
HL_1h_F0_l_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'F0' in key and 'HL_1h' in key and 'linco' in key]
HL_2h_Fm_l_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fm' in key and 'HL_2h' in key and 'linco' in key]
HL_2h_F0_l_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'F0' in key and 'HL_2h' in key and 'linco' in key]
HL_4h_Fm_l_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fm' in key and 'HL_4h' in key and 'linco' in key]
HL_4h_F0_l_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'F0' in key and 'HL_4h' in key and 'linco' in key]
       

dark_FvFm_w=(np.asarray(dark_Fm_w_FvFm)-np.asarray(dark_F0_w_FvFm))/np.asarray(dark_Fm_w_FvFm)
HL_1h_FvFm_w=(np.asarray(HL_1h_Fm_w_FvFm)-np.asarray(HL_1h_F0_w_FvFm))/np.asarray(HL_1h_Fm_w_FvFm)
HL_2h_FvFm_w=(np.asarray(HL_2h_Fm_w_FvFm)-np.asarray(HL_2h_F0_w_FvFm))/np.asarray(HL_2h_Fm_w_FvFm)
HL_4h_FvFm_w=(np.asarray(HL_4h_Fm_w_FvFm)-np.asarray(HL_4h_F0_w_FvFm))/np.asarray(HL_4h_Fm_w_FvFm)

dark_FvFm_l=(np.asarray(dark_Fm_l_FvFm)-np.asarray(dark_F0_l_FvFm))/np.asarray(dark_Fm_l_FvFm)
HL_1h_FvFm_l=(np.asarray(HL_1h_Fm_l_FvFm)-np.asarray(HL_1h_F0_l_FvFm))/np.asarray(HL_1h_Fm_l_FvFm)
HL_2h_FvFm_l=(np.asarray(HL_2h_Fm_l_FvFm)-np.asarray(HL_2h_F0_l_FvFm))/np.asarray(HL_2h_Fm_l_FvFm)
HL_4h_FvFm_l=(np.asarray(HL_4h_Fm_l_FvFm)-np.asarray(HL_4h_F0_l_FvFm))/np.asarray(HL_4h_Fm_l_FvFm)

FvFm_w=[dark_FvFm_w,HL_1h_FvFm_w,HL_2h_FvFm_w,HL_4h_FvFm_w]
FvFm_l=[dark_FvFm_l,HL_1h_FvFm_l,HL_2h_FvFm_l,HL_4h_FvFm_l]


#%% graph FvFm 


plt.figure()

#bpl=plt.boxplot(FvFm_w, positions=np.array(range(len(FvFm_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=plt.boxplot(FvFm_l, positions=np.array(range(len(FvFm_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')


count=0
for x in np.array(range(len(FvFm_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(FvFm_w[count]))-0.2)/10
    plt.scatter(scatter,FvFm_w[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(FvFm_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(FvFm_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(FvFm_l[count]))-0.2)/10
    plt.scatter(scatter,FvFm_l[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(FvFm_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
    
# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

plt.title('FvFm Streak Camera')
plt.ylabel ('Fv/Fm',fontsize=14)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-2, len(ticks)*2)
plt.ylim((0,0.9))
plt.tight_layout()
plt.savefig(folder_path+'/'+'Fv_Fm_streak_unmixed_scatter.png',dpi=1200,bbox_inches='tight')




#%% PAM data Fv/Fm 


dark_FvFm_PAM_w=[0.793,0.796,0.802,0.8,0.816,0.814,0.815,0.812,0.799,0.796,0.805]
HL_1h_FvFm_PAM_w=[0.621,0.606,0.69,0.697]
HL_2h_FvFm_PAM_w=[0.655,0.659,0.605]
HL_4h_FvFm_PAM_w=[0.606,0.599,0.484,0.633]


dark_FvFm_PAM_l=[0.791,0.797,0.784,0.811,0.819,0.815,0.816,0.8,0.821,0.817,0.839]
HL_1h_FvFm_PAM_l=[0.735,0.653,0.668,0.658]
HL_2h_FvFm_PAM_l=[0.387,0.322,0.423]
HL_4h_FvFm_PAM_l=[0.431,0.319,0.343,0.227]

FvFm_PAM_w=[dark_FvFm_PAM_w,HL_1h_FvFm_PAM_w,HL_2h_FvFm_PAM_w,HL_4h_FvFm_PAM_w]
FvFm_PAM_l=[dark_FvFm_PAM_l,HL_1h_FvFm_PAM_l,HL_2h_FvFm_PAM_l,HL_4h_FvFm_PAM_l]


plt.figure()

#bpl=plt.boxplot(FvFm_PAM_w, positions=np.array(range(len(FvFm_PAM_w)))*2.0-0.4, sym='', widths=0.6,medianprops=medianprops)
#bpr=plt.boxplot(FvFm_PAM_l, positions=np.array(range(len(FvFm_PAM_l)))*2.0+0.4, sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
#set_box_color(bpr, 'orangered')


count=0
for x in np.array(range(len(FvFm_PAM_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(FvFm_PAM_w[count]))-0.2)/10
    plt.scatter(scatter,FvFm_PAM_w[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(FvFm_PAM_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(FvFm_PAM_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(FvFm_PAM_l[count]))-0.2)/10
    plt.scatter(scatter,FvFm_PAM_l[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(FvFm_PAM_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
plt.legend(fontsize=14)

plt.title('FvFm PAM')
plt.ylabel ('Fv/Fm',fontsize=14)
plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-2, len(ticks)*2)
plt.ylim((0,0.9))
plt.tight_layout()
plt.savefig(folder_path+'/'+'Fv_Fm_PAM_unmixed_scatter.png', dpi=1200,bbox_inches='tight')


#%% Make plots with only linco for presentations 


# #Fm 

# # average lifetime PSII 
# plt.figure()

# bpr=plt.boxplot(PSII_l_al, positions=np.array(range(len(PSIIl_Fm_l)))*2.0, sym='', widths=0.6,medianprops=medianprops)
# set_box_color(bpr, 'orangered')

    
# count=0
# for x in np.array(range(len(PSII_l_al)))*2.0: 
    
#     scatter=x+(np.random.normal(0, 1, len(PSII_l_al[count]))-0.2)/10
#     plt.scatter(scatter,PSII_l_al[count],linewidth=1,color='white',edgecolor='black')
#     count+=1
    
    
# # draw temporary red and blue lines and use them to create a legend
# plt.plot([], c='orangered', label='Lincomycin',linewidth=3)



# plt.legend(fontsize=14)



# plt.title('Average lifetime Fm PSII')
# plt.ylabel ('Average Lifetime (ps)',fontsize=14)
# plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
# plt.yticks(fontsize=14)
# plt.xlim(-2, len(ticks)*2)
# #plt.ylim(75,100)
# plt.tight_layout()
# plt.savefig(folder_path+'/'+'lifetimes_average_Fm_PSII_scatter_lincomycin.png')

# #%% average lifetime PSII F0 


# plt.figure()

# bpr=plt.boxplot(PSII_F0_l_al, positions=np.array(range(len(PSII_F0_w_al)))*2.0, sym='', widths=0.6,medianprops=medianprops)
# set_box_color(bpr, 'orangered')


# count=0
# for x in np.array(range(len(PSII_F0_l_al)))*2.0: 
    
#     scatter=x+(np.random.normal(0, 1, len(PSII_F0_l_al[count]))-0.2)/10
#     plt.scatter(scatter,PSII_F0_l_al[count],linewidth=1,color='white',edgecolor='black')
#     count+=1

# # draw temporary red and blue lines and use them to create a legend
# plt.plot([], c='orangered', label='Lincomycin',linewidth=3)
# plt.legend(fontsize=14)

# plt.title('Average lifetime F0 PSII')
# plt.ylabel ('Average Lifetime (ps)',fontsize=14)
# plt.xticks(range(0, len(ticks) * 2, 2), ticks,fontsize=14)
# plt.yticks(fontsize=14)
# plt.xlim(-2, len(ticks)*2)
# #plt.ylim(75,100)
# plt.tight_layout()
# plt.savefig(folder_path+'/'+'lifetimes_average_F0_PSII_unmixing_scatter_lincomycin.png')


#%% Look at the PSI and PSII contributions before and after HL in Fm 


dict_PSI_PSII_cont={}

for key in dict_DAS_norm: 
    if 'Fm' in key: 
        PSI_sum=sum(dict_DAS_norm[key][:,1:])[0]
        PSII_sum=sum(dict_DAS_norm[key][:,1:])[1]+sum(dict_DAS_norm[key][:,1:])[2]
        
        dict_PSI_PSII_cont[key]=[PSI_sum,PSII_sum]


dark_PSI_PSII_1h_w=[dict_PSI_PSII_cont[key][0]/(dict_PSI_PSII_cont[key][0]+dict_PSI_PSII_cont[key][1]) for key in dict_PSI_PSII_cont.keys() if  'DA_1h' in key and 'water' in key]
dark_PSI_PSII_2h_w=[dict_PSI_PSII_cont[key][0]/(dict_PSI_PSII_cont[key][0]+dict_PSI_PSII_cont[key][1]) for key in dict_PSI_PSII_cont.keys() if  'DA_2h' in key and 'water' in key]
dark_PSI_PSII_4h_w=[dict_PSI_PSII_cont[key][0]/(dict_PSI_PSII_cont[key][0]+dict_PSI_PSII_cont[key][1]) for key in dict_PSI_PSII_cont.keys() if 'DA_4h' in key and 'water' in key]
HL_PSI_PSII_1h_w=[dict_PSI_PSII_cont[key][0]/(dict_PSI_PSII_cont[key][0]+dict_PSI_PSII_cont[key][1]) for key in dict_PSI_PSII_cont.keys() if  'HL_1h' in key and 'water' in key]
HL_PSI_PSII_2h_w=[dict_PSI_PSII_cont[key][0]/(dict_PSI_PSII_cont[key][0]+dict_PSI_PSII_cont[key][1]) for key in dict_PSI_PSII_cont.keys() if 'HL_2h' in key and 'water' in key]
HL_PSI_PSII_4h_w=[dict_PSI_PSII_cont[key][0]/(dict_PSI_PSII_cont[key][0]+dict_PSI_PSII_cont[key][1]) for key in dict_PSI_PSII_cont.keys() if 'HL_4h' in key and 'water' in key]

dark_PSI_PSII_1h_l=[dict_PSI_PSII_cont[key][0]/(dict_PSI_PSII_cont[key][0]+dict_PSI_PSII_cont[key][1]) for key in dict_PSI_PSII_cont.keys() if  'DA_1h' in key and 'linco' in key]
dark_PSI_PSII_2h_l=[dict_PSI_PSII_cont[key][0]/(dict_PSI_PSII_cont[key][0]+dict_PSI_PSII_cont[key][1]) for key in dict_PSI_PSII_cont.keys() if  'DA_2h' in key and 'linco' in key]
dark_PSI_PSII_4h_l=[dict_PSI_PSII_cont[key][0]/(dict_PSI_PSII_cont[key][0]+dict_PSI_PSII_cont[key][1]) for key in dict_PSI_PSII_cont.keys() if 'DA_4h' in key and 'linco' in key]
HL_PSI_PSII_1h_l=[dict_PSI_PSII_cont[key][0]/(dict_PSI_PSII_cont[key][0]+dict_PSI_PSII_cont[key][1]) for key in dict_PSI_PSII_cont.keys() if  'HL_1h' in key and 'linco' in key]
HL_PSI_PSII_2h_l=[dict_PSI_PSII_cont[key][0]/(dict_PSI_PSII_cont[key][0]+dict_PSI_PSII_cont[key][1]) for key in dict_PSI_PSII_cont.keys() if 'HL_2h' in key and 'linco' in key]
HL_PSI_PSII_4h_l=[dict_PSI_PSII_cont[key][0]/(dict_PSI_PSII_cont[key][0]+dict_PSI_PSII_cont[key][1]) for key in dict_PSI_PSII_cont.keys() if 'HL_4h' in key and 'linco' in key]


#%% graphs for the PSI fraction 

dark_PSI_PSII_w=[dark_PSI_PSII_1h_w,dark_PSI_PSII_2h_w,dark_PSI_PSII_4h_w]
dark_PSI_PSII_l=[dark_PSI_PSII_1h_l,dark_PSI_PSII_2h_l,dark_PSI_PSII_4h_l]

HL_PSI_PSII_w=[HL_PSI_PSII_1h_w,HL_PSI_PSII_2h_w,HL_PSI_PSII_4h_w]
HL_PSI_PSII_l=[HL_PSI_PSII_1h_l,HL_PSI_PSII_2h_l,HL_PSI_PSII_4h_l]

ticks_PSI_contribution = ["1h",'2h', '4h']

#water figure
plt.figure()

count=0
for x in np.array(range(len(dark_PSI_PSII_w)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(dark_PSI_PSII_w[count]))-0.2)/10
    plt.scatter(scatter,dark_PSI_PSII_w[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(dark_PSI_PSII_w[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(HL_PSI_PSII_w)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(HL_PSI_PSII_w[count]))-0.2)/10
    plt.scatter(scatter,HL_PSI_PSII_w[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(HL_PSI_PSII_w[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='lightsteelblue', linestyle='-',linewidth=3)

    count+=1
# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Dark',linewidth=3)
plt.plot([], c='lightsteelblue', label='HL',linewidth=3)
plt.legend(fontsize=14)

plt.title('PSI contribution Water')
plt.ylabel ('PSI Contribution',fontsize=14)
plt.xticks(range(0, len(ticks_PSI_contribution) * 2, 2), ticks_PSI_contribution,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-2, len(ticks_PSI_contribution)*2)
plt.ylim((0.45,0.7))
plt.tight_layout()
plt.savefig(folder_path+'/'+'PSI_contribution_water.png', dpi=1200,bbox_inches='tight')


#linco figure
plt.figure()

count=0
for x in np.array(range(len(dark_PSI_PSII_l)))*2.0-0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(dark_PSI_PSII_l[count]))-0.2)/10
    plt.scatter(scatter,dark_PSI_PSII_l[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(dark_PSI_PSII_l[count]), xmin=positions_w[count]-0.3, xmax=positions_w[count]+0.3, color='orangered', linestyle='-',linewidth=3)

    count+=1
    
count=0
for x in np.array(range(len(HL_PSI_PSII_l)))*2.0+0.4: 
    
    scatter=x+(np.random.normal(0, 1, len(HL_PSI_PSII_l[count]))-0.2)/10
    plt.scatter(scatter,HL_PSI_PSII_l[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(HL_PSI_PSII_l[count]), xmin=positions_l[count]-0.3, xmax=positions_l[count]+0.3, color='lightsalmon', linestyle='-',linewidth=3)

    count+=1
# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='orangered', label='Dark',linewidth=3)
plt.plot([], c='lightsalmon', label='HL',linewidth=3)
plt.legend(fontsize=14)

plt.title('PSI contribution Lincomycin')
plt.ylabel ('PSI Contribution',fontsize=14)
plt.xticks(range(0, len(ticks_PSI_contribution) * 2, 2), ticks_PSI_contribution,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-2, len(ticks_PSI_contribution)*2)
plt.ylim((0.45,0.7))
plt.tight_layout()
plt.savefig(folder_path+'/'+'PSI_contribution_linco.png', dpi=1200,bbox_inches='tight')

