# -*- coding: utf-8 -*-
"""
Created on Mon May 13 16:19:31 2024

@author: bagch002
"""

import tkinter as tk
from tkinter import filedialog
import os
import numpy as np
import matplotlib.pyplot as plt
import pandas as pd
import os as os
import matplotlib.gridspec as gridspec
import scipy.stats as stats

 
# Function to handle button click
def open_ascii_files():
    # Open file dialog to select folder
    root = tk.Tk()
    root.withdraw()
    folder_path = filedialog.askdirectory()
 
    # Dictionary to store NumPy arrays with filenames as keys
    array_time = {}
    array_DAS = {} 
 
    # Loop through all files in the selected folder
    for filename in os.listdir(folder_path):
        # Check if the file has a .ascii extension (ASCII file)
        if filename.endswith(".ascii"):
            # Extract the NumPy array from the ASCII file
            file_path = os.path.join(folder_path, filename)
            with open(file_path, 'r') as file:
                # Skip the first row (header) in the ASCII file
                lines = file.readlines()[1:]
                data = np.array([list(map(float, line.split())) for line in lines])
 
                # Get the indices of columns with same content as the first column
                duplicate_indices = [i for i in range(1, data.shape[1]) if np.array_equal(data[:, 0], data[:, i])]
 
                # Create a new array without the duplicate columns
                unique_indices = list(set(range(data.shape[1])) - set(duplicate_indices))
                new_data = data[:, unique_indices]

 
                if 'time' in filename: 
                    array_time[filename] = new_data
                if 'DAS' in filename: 
                    #switch the collumns that went wrong in the streak 
                    #get PSI, PSII short and PSII long in each sample
                    if '_01_' in filename and'Fm' in filename: 
                        new_data[:,[1,2]]=new_data[:,[2,1]]
                    

                    
                    max_PSII_short=max(new_data[:,2])
                    new_data[:,1:]=new_data[:,1:]/max_PSII_short
                    array_DAS[filename] = new_data
 
    # Return the dictionary of NumPy arrays
    return array_time, array_DAS,folder_path
 
def plot_DAS(array,title_string,array_lt):
    #determine the average and standard deviation of the DAS
    average_columns = np.mean(array,axis=0)
    std_colums=np.std(array,axis=0)
    
    #get the standard deviation and average of the lifetimes 
    average_lt = np.mean(array_lt,axis=0)
    std_lt=np.std(array_lt,axis=0)
    
    
    colours=['steelblue', 'lightsalmon','orangered','#af2f0d']

    plt.figure()
    for x in range(0,len(array[0][0,:])-1):
        labels='{:.1f}'.format(average_lt[x])+' ± '+'{:.1f}'.format(std_lt[x])+' ps'
        plt.plot(average_columns[:,0],average_columns[:,x+1],color=colours[x],label=labels)
        plt.fill_between(average_columns[:,0],average_columns[:,x+1]-(std_colums[:,x+1]/2),average_columns[:,x+1]+(std_colums[:,x+1]/2),color=colours[x],alpha=0.6)
    plt.xlabel('Wavelength (nm)')
    plt.ylabel('Intensity')
    #plt.ylim(-0.1,2)
    plt.title(title_string) 
    plt.legend()
    plt.savefig(folder_path+'/'+title_string+'_unmixed.png')
    plt.show()    


medianprops = dict(linestyle='-', linewidth=3)
            
def set_box_color(bp, color):
    plt.setp(bp['boxes'], color='white',linewidth=0)
    plt.setp(bp['whiskers'], color='white',linewidth=0)
    plt.setp(bp['caps'], color='white',linewidth=0)
    plt.setp(bp['medians'], color=color) 



def plot_DAS_PSI(array1,array2,array_lt1,array_lt2):
    
    
    #divide the arrays by the max PSI value to get the normalized PSI spectrum 
    max_PSI1=np.max(array1[:,:,1],axis=1)
    max_PSI2=np.max(array2[:,:,1],axis=1)
    
    max_PSI1=max_PSI1[:, np.newaxis]
    max_PSI2=max_PSI2[:, np.newaxis]

    array1[:, :, 1] = array1[:, :, 1] / max_PSI1
    array2[:, :, 1] = array2[:, :, 1] / max_PSI2
    
    #determine the average and standard deviation of the DAS
    average_columns1 = np.mean(array1,axis=0)
    std_colums1=np.std(array1,axis=0)
    
    average_columns2 = np.mean(array2,axis=0)
    std_colums2=np.std(array2,axis=0)
    
    
    
    
    #get the standard deviation and average of the lifetimes 
    average_lt1 = np.mean(array_lt1,axis=0)
    std_lt1=np.std(array_lt1,axis=0)
    average_lt2 = np.mean(array_lt2,axis=0)
    std_lt2=np.std(array_lt2,axis=0)
    
    #define things for the plot 
    colours=['#4D6F8B','steelblue', 'lightsteelblue']
    label1='Dark | '+'{:.1f}'.format(average_lt1[0])+' ± '+'{:.1f}'.format(std_lt1[0])+' ps'
    label2='1h HL | '+'{:.1f}'.format(average_lt2[0])+' ± '+'{:.1f}'.format(std_lt2[0])+' ps'

    

    plt.figure()
    plt.plot(average_columns1[:,0],average_columns1[:,1],color=colours[0],label=label1)
    plt.fill_between(average_columns1[:,0],average_columns1[:,1]-(std_colums1[:,1]/2),average_columns1[:,1]+(std_colums1[:,1]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columns2[:,0],average_columns2[:,1],color=colours[1],label=label2)
    plt.fill_between(average_columns2[:,0],average_columns2[:,1]-(std_colums2[:,1]/2),average_columns2[:,1]+(std_colums2[:,1]/2),color=colours[1],alpha=0.6)

    
    
    plt.xlabel('Wavelength (nm)')
    plt.ylabel('Intensity')
    #plt.ylim(-0.1,2)
    plt.title('PSI Fm') 
    plt.legend()
    plt.savefig(folder_path+'/'+'PSI_Fm_unmixed.png')
    plt.show()  
    
    
    
def plot_DAS_PSII(array1,array2,array_lt1,array_lt2,title_string):
    
    
    if 'Fm' in title_string:
        #divide the arrays by the max PSII value to get the normalized PSII spectrum 
        max_PSII1=np.max(array1[:,:,2],axis=1)
        max_PSII2=np.max(array2[:,:,2],axis=1)
        
        max_PSII1=max_PSII1[:, np.newaxis]
        max_PSII2=max_PSII2[:, np.newaxis]
        
    if 'F0' in title_string:
        #divide the arrays by the max PSII value to get the normalized PSII spectrum 
        max_PSII1=np.max(array1[:,:,3],axis=1)
        max_PSII2=np.max(array2[:,:,3],axis=1)
        
        max_PSII1=max_PSII1[:, np.newaxis]
        max_PSII2=max_PSII2[:, np.newaxis]
    
    

    array1[:, :, 2] = array1[:, :, 2] / max_PSII1
    array2[:, :, 2] = array2[:, :, 2] / max_PSII2
    
    array1[:, :, 3] = array1[:, :, 3] / max_PSII1
    array2[:, :, 3] = array2[:, :, 3] / max_PSII2
    
    #determine the average and standard deviation of the DAS
    average_columns1 = np.mean(array1,axis=0)
    std_colums1=np.std(array1,axis=0)
    
    average_columns2 = np.mean(array2,axis=0)
    std_colums2=np.std(array2,axis=0)
    
    
    
    #define things for the plot 
    colours=['maroon','orangered', 'lightsalmon']
    label1='Dark'
    label2='1h HL'

    

    plt.figure()
    
    plt.plot(average_columns1[:,0],average_columns1[:,2],color=colours[0],label=label1)
    plt.fill_between(average_columns1[:,0],average_columns1[:,2]-(std_colums1[:,2]/2),average_columns1[:,2]+(std_colums1[:,2]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columns2[:,0],average_columns2[:,2],color=colours[1],label=label2)
    plt.fill_between(average_columns2[:,0],average_columns2[:,2]-(std_colums2[:,2]/2),average_columns2[:,2]+(std_colums2[:,2]/2),color=colours[1],alpha=0.6)

    
    plt.plot(average_columns1[:,0],average_columns1[:,3],color=colours[0])
    plt.fill_between(average_columns1[:,0],average_columns1[:,3]-(std_colums1[:,3]/2),average_columns1[:,3]+(std_colums1[:,3]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columns2[:,0],average_columns2[:,3],color=colours[1])
    plt.fill_between(average_columns2[:,0],average_columns2[:,3]-(std_colums2[:,3]/2),average_columns2[:,3]+(std_colums2[:,3]/2),color=colours[1],alpha=0.6)


    
    plt.xlabel('Wavelength (nm)')
    plt.ylabel('Intensity')
    #plt.ylim(-0.1,2)
    plt.title('PSII '+title_string) 
    plt.legend()
    plt.savefig(folder_path+'/'+title_string+'_PSII_unmixed.png')
    plt.show()  
    
    
def plot_DAS_F0_Fm(arrayFm,arrayF0,title_string):
    
    
    #divide the arrays by the max PSII value to get the normalized PSII spectrum 
    max_PSII_Fm=np.max(arrayFm[:,:,2],axis=1)
        
    max_PSII_Fm=max_PSII_Fm[:, np.newaxis]
       
        
    max_PSII_F0=np.max(arrayF0[:,:,3],axis=1)
    max_PSII_F0=max_PSII_F0[:, np.newaxis]
       
    
    

    arrayFm[:, :, 2] = arrayFm[:, :, 2] / max_PSII_Fm
    arrayF0[:, :, 2] = arrayF0[:, :, 2] / max_PSII_F0
    

    arrayFm[:, :, 3] = arrayFm[:, :, 3] / max_PSII_Fm
    arrayF0[:, :, 3] = arrayF0[:, :, 3] / max_PSII_F0
    
    
    
    #determine the average and standard deviation of the DAS
    average_columnsFm = np.mean(arrayFm,axis=0)
    std_columsFm=np.std(arrayFm,axis=0)
    
    average_columnsF0 = np.mean(arrayF0,axis=0)
    std_columsF0=np.std(arrayF0,axis=0)
    

    
    #define things for the plot 
    colours=['orangered', 'lightsalmon']
    labelFm='Fm'
    labelF0='F0'
    

    plt.figure()
    
    plt.plot(average_columnsFm[:,0],average_columnsFm[:,2],color=colours[0],label=labelFm)
    plt.fill_between(average_columnsFm[:,0],average_columnsFm[:,2]-(std_columsFm[:,2]/2),average_columnsFm[:,2]+(std_columsFm[:,2]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columnsF0[:,0],average_columnsF0[:,2],color=colours[1],label=labelF0)
    plt.fill_between(average_columnsF0[:,0],average_columnsF0[:,2]-(std_columsF0[:,2]/2),average_columnsF0[:,2]+(std_columsF0[:,2]/2),color=colours[1],alpha=0.6)

    
    plt.plot(average_columnsFm[:,0],average_columnsFm[:,3],color=colours[0])
    plt.fill_between(average_columnsFm[:,0],average_columnsFm[:,3]-(std_columsFm[:,3]/2),average_columnsFm[:,3]+(std_columsFm[:,3]/2),color=colours[0],alpha=0.6)
    
    plt.plot(average_columnsF0[:,0],average_columnsF0[:,3],color=colours[1])
    plt.fill_between(average_columnsF0[:,0],average_columnsF0[:,3]-(std_columsF0[:,3]/2),average_columnsF0[:,3]+(std_columsF0[:,3]/2),color=colours[1],alpha=0.6)


    
    plt.xlabel('Wavelength (nm)')
    plt.ylabel('Intensity')
    #plt.ylim(-0.1,2)
    plt.title('PSII F0 vs. Fm '+title_string) 
    plt.legend()
    plt.savefig(folder_path+'/'+title_string+'_PSII_unmixed.png')
    plt.show()  
    


#%%
# Call the function to open ASCII files & store their contents as NumPy arrays
dict_time,dict_DAS,folder_path = open_ascii_files()



# Read plot labels from Excel file
excel_file_path = filedialog.askopenfilename(filetypes=[("Excel Files", "*.xlsx")])
lifetimes_unmixed = pd.read_excel(excel_file_path)





#%% Normalise 
dict_DAS_norm={}
unmixed_DAS={}
#get the amplitudes of the PSII spectra in case of Fm and F0 (due to unmixing)
dict_ampli={}

for key in dict_DAS: 
    #normalise the DAS 
    dict_DAS_norm[key]=dict_DAS[key]
    dict_DAS_norm[key][:,1:]=dict_DAS[key][:,1:]/np.sum(dict_DAS[key][:,1:])

for key in dict_DAS: 
    
    #substract F0 PSI from Fm PSI 
    if 'F0' in key: 
        PSI_F0=dict_DAS_norm[key][:,1]
        print('This is key1 '+key)
        
        for key2 in dict_DAS_norm:
            if key[0:4] in key2 and 'Fm' in key2 and key[10:30] in key2:
                print('This is key2 '+key2)
                PSI_Fm=dict_DAS_norm[key2][:,1]
                
        PSI_diff=PSI_F0-PSI_Fm 
        
        unmixed_DAS[key]=np.stack((dict_DAS_norm[key][:,0],PSI_Fm,PSI_diff,dict_DAS_norm[key][:,2])).T
    else: 
        unmixed_DAS[key]=dict_DAS_norm[key]
      
    #make a new dictionary 

    x_data=unmixed_DAS[key][:,0]
    y_data=unmixed_DAS[key][:,1:]
    
    
    if np.size(y_data[1])==3:
        PSII_short_max=max(y_data[:,1])
        PSII_long_max=max(y_data[:,2])
        dict_ampli[key]=(PSII_short_max/(PSII_short_max+PSII_long_max),PSII_long_max/(PSII_short_max+PSII_long_max))
    
        
#export the amplitude data as a .csv

f = open(folder_path[:-10]+'amplitudes.csv','w')
for key in dict_ampli.keys():
    f.write(str(key)+';'+str(dict_ampli[key])+'\n')
f.close()
        
        
#%% from now the old code 

#%% plot the DAS on top of each other 

#make arrays with all the situations
dark_Fm=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'Fm' in key and 'DA_' in key]
dark_F0=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'F0' in key and 'DA_' in key]
HL_1h_Fm=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'Fm' in key and 'HL' in key]
HL_1h_F0=[unmixed_DAS[key] for key in unmixed_DAS.keys() if 'F0' in key and 'HL' in key]

#make similar arrays for the lifetime 
dark_Fm_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'Fm' in key and 'DA_' in key],dtype= 'float')
dark_F0_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'F0' in key and 'DA_' in key],dtype= 'float')
HL_1h_Fm_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'Fm' in key and 'HL' in key],dtype= 'float')
HL_1h_F0_lt=np.asarray([lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, 1:] for key in lifetimes_unmixed['Ascii name'] if 'F0' in key and 'HL' in key],dtype= 'float')

#%%plot the data
plot_DAS(dark_Fm, 'Fm Dark',dark_Fm_lt)
plot_DAS(dark_F0, 'F0 Dark',dark_F0_lt)
plot_DAS(HL_1h_Fm, 'Fm HL',HL_1h_Fm_lt)
plot_DAS(HL_1h_F0, 'F0 HL',HL_1h_F0_lt)


plot_DAS_PSI(np.asarray(dark_Fm),np.asarray(HL_1h_Fm),dark_Fm_lt,HL_1h_Fm_lt)

plot_DAS_PSII(np.asarray(dark_Fm),np.asarray(HL_1h_Fm),dark_Fm_lt,HL_1h_Fm_lt,'Fm')
plot_DAS_PSII(np.asarray(dark_F0),np.asarray(HL_1h_F0),dark_F0_lt,HL_1h_F0_lt, 'F0')

plot_DAS_F0_Fm(np.asarray(dark_Fm),np.asarray(dark_F0),'Dark')
plot_DAS_F0_Fm(np.asarray(HL_1h_Fm),np.asarray(HL_1h_F0),'1h HL')



#%% Make dictionaries for the lifetimes and the amplitudes 

dict_contributions={}
dict_lifetimes={}
dict_average_PSII={}
dict_contributions_PSII={}



for key in unmixed_DAS.keys():
    #sum the total of the collumns with DAS spectra 
    length=len(unmixed_DAS[key][0])-1
    total_sum=np.sum(unmixed_DAS[key][:, -length:])
    total_sum_PSII=np.sum(unmixed_DAS[key][:, -length+1:])

    
    #make an empty array  for the contributions 
    contributions=np.zeros(length)
    lifetime_values=np.zeros(length)
    contributions_PSII=np.zeros(length-1)

    
    for x in range(1,len(unmixed_DAS[key][0])):
        contributions[x-1]=np.sum(unmixed_DAS[key][:,x])/total_sum
    for x in range(2,len(unmixed_DAS[key][0])):
        contributions_PSII[x-2]=np.sum(unmixed_DAS[key][:,x])/total_sum_PSII

    
    dict_contributions[key] = contributions
    dict_contributions_PSII[key] = contributions_PSII

    
    
    

    #plot the numer of lines 
    #get the lifetimes from the excel 
    
    if key in lifetimes_unmixed.iloc[:,0].values:
        for i in range(length):
            lifetime_values[i] = lifetimes_unmixed[lifetimes_unmixed.iloc[:, 0] == key].iloc[0, i+1]
    
    if length==3:
        dict_average_PSII[key]=np.sum(dict_contributions_PSII[key]*lifetime_values[-2:])
        
    dict_lifetimes[key] = lifetime_values

#%% plot the files for the lifetimes 

#separate them into PSI, PSII short and PSII long components
# PSI 
dark_Fm_lt_PSI=dark_Fm_lt[:,0]
dark_F0_lt_PSI=dark_F0_lt[:,0]
HL_1h_Fm_lt_PSI=HL_1h_Fm_lt[:,0]
HL_1h_F0_lt_PSI=HL_1h_F0_lt[:,0]


# PSII short 
dark_Fm_lt_PSIIs=dark_Fm_lt[:,1]
dark_F0_lt_PSIIs=dark_F0_lt[:,1]
HL_1h_Fm_lt_PSIIs=HL_1h_Fm_lt[:,1]
HL_1h_F0_lt_PSIIs=HL_1h_F0_lt[:,1]




# PSII long
dark_Fm_lt_PSIIl=dark_Fm_lt[:,2]
HL_1h_Fm_lt_PSIIl=HL_1h_Fm_lt[:,2]


#%%
#amplitudes of the PSII Fm components 

#water
dark_Fm_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fm' in key and 'DA_' in key])
HL_1h_Fm_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'Fm' in key and 'HL' in key])



#short PSII
dark_Fm_c_PSIIs=dark_Fm_c[:,0]
HL_1h_Fm_c_PSIIs=HL_1h_Fm_c[:,0]


#long PSII
dark_Fm_c_PSIIl=dark_Fm_c[:,1]
HL_1h_Fm_c_PSIIl=HL_1h_Fm_c[:,1]



#%%
#amplitudes of the PSII F0 components after unmixing

#water
dark_F0_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'F0' in key and 'DA_' in key])
HL_1h_F0_c=np.asarray([dict_ampli[key] for key in dict_ampli.keys() if 'F0' in key and 'HL' in key])


#short PSII
dark_F0_c_PSIIs=dark_F0_c[:,0]
HL_1h_F0_c_PSIIs=HL_1h_F0_c[:,0]


#long PSII
dark_F0_c_PSIIl=dark_F0_c[:,1]
HL_1h_F0_c_PSIIl=HL_1h_F0_c[:,1]


#%% average PSII Fm

#water
dark_Fm_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fm' in key and 'DA_' in key])
HL_1h_Fm_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'Fm' in key and 'HL' in key])


#%% average PSII F0

#water
dark_F0_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'F0' in key and 'DA_' in key])
HL_1h_F0_al=np.asarray([dict_average_PSII[key] for key in dict_average_PSII.keys() if 'F0' in key and 'HL' in key])


#%%#make them together in lists for the boxplots
 
PSI_F0=[dark_F0_lt_PSI,HL_1h_F0_lt_PSI]
PSI_Fm=[dark_Fm_lt_PSI,HL_1h_Fm_lt_PSI]

PSIIs_F0=[dark_F0_lt_PSIIs,HL_1h_F0_lt_PSIIs]
PSIIs_Fm=[dark_Fm_lt_PSIIs,HL_1h_Fm_lt_PSIIs]

PSIIl_Fm=[dark_Fm_lt_PSIIl,HL_1h_Fm_lt_PSIIl]



PSIIs_c=[dark_Fm_c_PSIIs,HL_1h_Fm_c_PSIIs]
PSIIl_c=[dark_Fm_c_PSIIl,HL_1h_Fm_c_PSIIl]


PSII_al=[dark_Fm_al,HL_1h_Fm_al]

PSII_F0_al=[dark_F0_al,HL_1h_F0_al]

#%% make the graphs for the lifetimes 

ticks = ["Dark", "HL"]

# F0 PSI 
plt.figure()

#bpl=plt.boxplot(PSI_F0, positions=np.array(range(len(PSI_F0))), sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 

positions=np.array(range(len(PSI_F0)))

count=0
for x in np.array(range(len(PSI_F0))): 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_F0[count]))-0.2)/10
    plt.scatter(scatter,PSI_F0[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_F0[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    


# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='FtsH2 KO',linewidth=3)
plt.legend(fontsize=14)

plt.title('PSI Open RC')
plt.ylabel ('Lifetime (ps)',fontsize=14)
plt.xticks(range(0, len(ticks) , 1), ticks,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-0.5, len(ticks)-0.5)
plt.ylim(0,100)
plt.tight_layout()
plt.savefig(folder_path+'/'+'lifetimes_F0_PSI_unmix_scatter.png')


# Fm PSI 
plt.figure()

#bpl=plt.boxplot(PSI_Fm, positions=np.array(range(len(PSI_Fm))), sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 

count=0
for x in np.array(range(len(PSI_Fm))): 
    
    scatter=x+(np.random.normal(0, 1, len(PSI_F0[count]))-0.2)/10
    plt.scatter(scatter,PSI_Fm[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSI_Fm[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    


# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='FtsH2 KO',linewidth=3)
plt.legend(fontsize=14)

plt.ylabel ('Lifetime (ps)',fontsize=14)

plt.title('PSI Closed RC')
plt.xticks(range(0, len(ticks), 1), ticks,fontsize=14)
plt.yticks(fontsize=14)

plt.xlim(-0.5, len(ticks)-0.5)
plt.ylim(0,100)
plt.tight_layout()

plt.savefig(folder_path+'/'+'lifetimes_Fm_PSI.png')



#%% lifetime + amplitude PSII Fm 
# Fm PSII 
labels=["Dark", "1h"]
figure1 = plt.figure(constrained_layout=True,figsize=(8,6))
gs = gridspec.GridSpec(2, 2, figure=figure1)
ax1 = figure1.add_subplot(gs[0,0])
ax2 = figure1.add_subplot(gs[1,0])
ax3 = figure1.add_subplot(gs[0,1])
ax4 = figure1.add_subplot(gs[1,1])

ax1.set_ylabel('Lifetime (ps)',fontsize=12)
ax1.set_title('Short Component PSII',fontsize=12)

#bpl=ax1.boxplot(PSIIs_Fm, positions=np.array(range(len(PSIIs_Fm))), sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 
ax1.set_xticks(range(0, len(ticks), 1), ticks,fontsize=12)
ax1.set_xticklabels(labels)
#ax1.set_ylim(0,6000)

count=0
for x in np.array(range(len(PSIIs_Fm))): 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_Fm[count]))-0.2)/10
    ax1.scatter(scatter,PSIIs_Fm[count],linewidth=1,color='white',edgecolor='black')
    ax1.hlines(np.mean(PSIIs_Fm[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    


# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='FtsH2 KO',linewidth=3)
plt.legend(fontsize=14)
#short component amplitude
ax2.set_ylabel('Contribution',fontsize=14)

#bpl=ax2.boxplot(PSIIs_c, positions=np.array(range(len(PSIIs_c))), sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 

count=0
for x in np.array(range(len(PSIIs_c))): 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIs_c[count]))-0.2)/10
    ax2.scatter(scatter,PSIIs_c[count],linewidth=1,color='white',edgecolor='black')
    ax2.hlines(np.mean(PSIIs_c[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    


ax2.set_xticks(range(0, len(ticks), 1), ticks,fontsize=14)
ax2.set_xticklabels(labels)
ax2.set_ylim(0,1)
#ax1.set_ylim(0,6000)


#box plot average lifetime and amplitudes
ax3.set_title('Long Component PSII',fontsize=14)
ax3.set_ylabel('Lifetime (ps)',fontsize=14)
#bpl=ax3.boxplot(PSIIl_Fm, positions=np.array(range(len(PSIIl_Fm))), sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 

count=0
for x in np.array(range(len(PSIIl_Fm))): 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_Fm[count]))-0.2)/10
    ax3.scatter(scatter,PSIIl_Fm[count],linewidth=1,color='white',edgecolor='black')
    ax3.hlines(np.mean(PSIIl_Fm[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    

    
    
ax3.set_xticks(range(0, len(ticks), 1), ticks,fontsize=14)
ax3.set_xticklabels(labels)

#long component amplitude
ax4.set_ylabel('Contribution',fontsize=14)

#bpl=ax4.boxplot(PSIIl_c, positions=np.array(range(len(PSIIl_c))), sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 

count=0
for x in np.array(range(len(PSIIl_c))): 
    
    scatter=x+(np.random.normal(0, 1, len(PSIIl_c[count]))-0.2)/10
    ax4.scatter(scatter,PSIIl_c[count],linewidth=1,color='white',edgecolor='black')
    ax4.hlines(np.mean(PSIIl_c[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    

ax4.set_xticks(range(0, len(ticks), 1), ticks,fontsize=14)
ax4.set_xticklabels(labels)
ax4.set_ylim(0,1)


plt.savefig(folder_path+'/''lifetimes_Fm_PSII_scatter.png')
plt.show()



#%% average lifetime PSII Fm


# average lifetime PSII 
plt.figure()

#bpl=plt.boxplot(PSII_al, positions=np.array(range(len(PSIIl_Fm))), sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 


count=0
for x in np.array(range(len(PSII_al))): 
    
    scatter=x+(np.random.normal(0, 1, len(PSII_al[count]))-0.2)/10
    plt.scatter(scatter,PSII_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSII_al[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    

    
    
# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)



plt.legend(fontsize=16)



plt.title(r" Average lifetime PSII - $F_{m}$ Conditions - $\it{var2}$-$\it{1}$", fontsize=15)
plt.ylabel ('Average Lifetime (ps)',fontsize=18)
plt.xticks(range(0, len(ticks) , 1), ticks,fontsize=18)
plt.yticks(fontsize=18)
plt.xlim(-0.5, len(ticks)-0.5)
plt.ylim(500,2500)
plt.tight_layout()
plt.savefig(folder_path+'/'+'lifetimes_average_Fm_PSII_scatter.png')
plt.savefig(folder_path+'/'+'lifetimes_average_Fm_PSII_scatter.svg')

#%% average lifetime PSII F0 


plt.figure()

#bpl=plt.boxplot(PSII_F0_al, positions=np.array(range(len(PSII_F0_al))), sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 

count=0
for x in np.array(range(len(PSII_F0_al))): 
    
    scatter=x+(np.random.normal(0, 1, len(PSII_F0_al[count]))-0.2)/10
    plt.scatter(scatter,PSII_F0_al[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(PSII_F0_al[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    


# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='Water',linewidth=3)
plt.legend(fontsize=16)

plt.title(r" Average lifetime PSII - $F_{o}$ Conditions - $\it{var2}$-$\it{1}$", fontsize=15)
plt.ylabel ('Average Lifetime (ps)',fontsize=18)
plt.xticks(range(0, len(ticks) , 1), ticks,fontsize=18)
plt.yticks(fontsize=18)
plt.xlim(-0.5, len(ticks)-0.5)
plt.ylim(200,500)
plt.tight_layout()
plt.savefig(folder_path+'/'+'lifetimes_average_F0_PSII_unmixing_scatter.png')
plt.savefig(folder_path+'/'+'lifetimes_average_F0_PSII_unmixing_scatter.svg')




#%% Fv/Fm calculation 

dict_F_PAM={}

for key in unmixed_DAS.keys(): 
        
    #find the index of 700 nm 
    index=np.argmax(unmixed_DAS[key][:,0]>700)
    
    
    
    #sum the total of the collumns with DAS spectra 
    length=len(unmixed_DAS[key][0])-1
    total_sum_700=np.sum(unmixed_DAS[key][index:, -length:])

    #get the contributions 
    #make an empty array  for the contributions 
    contributions_700=np.zeros(length)
    for x in range(1,len(unmixed_DAS[key][0])):
        contributions_700[x-1]=np.sum(unmixed_DAS[key][index:,x])/total_sum_700
    
    #multiply the contributions with the lifetimes 
    np.sum(dict_lifetimes[key]*contributions_700)
    
    
    dict_F_PAM[key] = np.sum(dict_lifetimes[key]*contributions_700)



#water
dark_Fm_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fm' in key and 'DA_' in key]
dark_F0_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'F0' in key and 'DA_' in key]
HL_1h_Fm_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'Fm' in key and 'HL' in key]
HL_1h_F0_FvFm=[dict_F_PAM[key] for key in dict_F_PAM.keys() if 'F0' in key and 'HL' in key ]


dark_FvFm=(np.asarray(dark_Fm_FvFm)-np.asarray(dark_F0_FvFm))/np.asarray(dark_Fm_FvFm)
HL_1h_FvFm=(np.asarray(HL_1h_Fm_FvFm)-np.asarray(HL_1h_F0_FvFm))/np.asarray(HL_1h_Fm_FvFm)

FvFm=[dark_FvFm,HL_1h_FvFm]


#%% graph FvFm 


plt.figure()

#bpl=plt.boxplot(FvFm, positions=np.array(range(len(FvFm))), sym='', widths=0.6,medianprops=medianprops)
#set_box_color(bpl, 'steelblue') 


count=0
for x in np.array(range(len(FvFm))): 
    
    scatter=x+(np.random.normal(0, 1, len(FvFm[count]))-0.2)/10
    plt.scatter(scatter,FvFm[count],linewidth=1,color='white',edgecolor='black')
    plt.hlines(np.mean(FvFm[count]), xmin=positions[count]-0.3, xmax=positions[count]+0.3, color='steelblue', linestyle='-',linewidth=3)

    count+=1
    

    
    
# draw temporary red and blue lines and use them to create a legend
plt.plot([], c='steelblue', label='FtsH2 KO',linewidth=3)
plt.legend(fontsize=14)

plt.title('FvFm Streak Camera')
plt.ylabel ('Fv/Fm',fontsize=14)
plt.xticks(range(0, len(ticks), 1), ticks,fontsize=14)
plt.yticks(fontsize=14)
plt.xlim(-0.5, len(ticks)-0.5)
plt.ylim((0,0.9))
plt.tight_layout()
plt.savefig(folder_path+'/'+'Fv_Fm_streak_unmixed_scatter.png')

