%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                              %%%  
%%% fit 1 value for K and AC for all experiments %%%
%%%                                              %%%  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Script takes a long time to run

clear all;close all; clc; format compact;
set(0,'DefaultLegendAutoUpdate','off')
%set(0,'DefaultFigureWindowStyle','docked')
set(0,'DefaultFigureWindowStyle','normal')

global alpha rad D1 P L1 boundaryreaction Fmeasurements S   % General globals used in all scripts
global All_L2 Exp_Data                                      % Globals specific for this script
global itK Ktest AC                                         % Globals required for the fit of k
global itAC ACtest AnsmindevK                               % Globals required for the fit of AC

%% script control
basecaseonly     = false ;                  % Do not fit any datapoints - just generatre profiles or plot graphs for the set variables
comparebasecase  = false ;%                  % Compare set parameters manually to chosen measurment (see below)
plots            = false ;                  % Plot individual membrane graph for each flowrate
feedback         = false ;                  % Show bvp solver statistics of MembraneModelFunction.m
boundaryreaction = false ;                  % Include boundary reaction flux in flux boundary condition
Kfit             = true  ;                  % Determine the fit for K using LSQ
ACfit            = true;%                  % Determine the fit for AC using LSQ (after fitting K)
justplotfinal    = false ;                 % Can be used if Kfit and ACfit have previously been determined and fittings are turned off
fcomparison = false;
multilayer = true;
usepreviousfit = false;
% Choose for which membrane measurement you want to get a fit for K (and AC)
Measurements = {'d21_9' 'd10_6' 'd4_3' 'd3_4' 'd2_74' 'd1_69' 'd1_17' 'd0_65' 'd0_26'};
Measurement = 'd21_9' ;                      % Chosen measurement - can be changed as desired Shu:not when checking K for high thickness

% The number of datapoints in the model can be adjusted if desired
Fcomparison = [0.001:.25:12];                    % Values of the flow rate to plot in comparing graphs
%Fcomparison = [1 2 4 6 8 10];               % Default to match measurement points

%% Variables (set values for base case)
Fmeasurements =[1 2 4 6 8 10];% [1.6 3.2 6.5 9.7 13.0 16.2];     % g/h (assumed to be equal to ml/h)
k = 3.44e-8; %1e-6;                                  % Surface reaction rate (m/s)
alpha = 1;                                  % Concentration ratio at the boundary
L2 = 21.9E-6;                               % Membrane thickness (m)
AC = 1.073E6;                               % Absorption coefficient (1/m)
maxdev_AC = 0.25;                           % Maximum deviation from literary AC when fitting (fraction)

%% constants
rad = 0.01;                            % Radius membrane (m)
D1 = 4.6e-10;                           % Diffusion coefficient pre-membrane (m2/s)
P = 0.45;                               % Porosity
L1 = 0.01;                                   % Thickness of the mass transfer boundary layer (m)
S = 192802500;                                % Specific surface area of the catalyst (m2/m3)

%% Importing Experimental data
Data = readmatrix('dataV2.xlsx','range','A1:K91');
All_L2 = [21.9 10.6 4.3 3.4 2.74 1.69 1.17 0.65 0.26]*1e-6; %(m)
nmeasurements = length(All_L2);

for n = 1:nmeasurements
    idx1 = 10*n-10;
    nrepeats(n) = find(isnan(Data(5+idx1,:)),1)-1; % Number of (experimental repeats+1) for 1 membrane
    Exp_Data{n}=Data([5:10]+idx1,[2:nrepeats(n)]);
    %Exp_Data{n}
end

%If it is desired that only the 7 thinner membranes are considered, uncomment this part: 
if multilayer
% % %If it is desired that only the 2 thicker membranes are considered, uncomment this part: 
% Exp_Data = Exp_Data(1:2);
% nrepeats = nrepeats(1:2);
% All_L2 = [21.9 10.6]*1e-6;
% nmeasurements = length(All_L2);

Exp_Data = Exp_Data(9:9);
nrepeats = nrepeats(9:9);
All_L2 = [0.26]*1e-6;
nmeasurements = length(All_L2);

AC = 1.073E6;%0.30544E6;
AC_previousfit = 1.073E6; %previously fitted
k_previousfit = 3.4475E-8;
else

Exp_Data = Exp_Data(3:end);
nrepeats = nrepeats(3:end);
All_L2 = [4.3 3.4 2.74 1.69 1.17 0.65 0.26]*1e-6;
nmeasurements = length(All_L2);
AC = 1.073E6;
AC_previousfit = 1.073E6; % previously fitted
k_previousfit = 3.4487E-8;
end

mstring = '*xods';

%% Base case: Calculation of concentration as function of flow rate for given K AC alpha values
if fcomparison
for n = 1:length(Fcomparison)
    Cpoints(n,:) = MembraneModelFunction(Fcomparison(n),L1,L2,rad,P,k,alpha,D1,AC,S,plots,feedback,boundaryreaction);
end

% Plotting results from base case with set K
figure(); hold on; grid on
plot(Fcomparison,Cpoints(:,1),'-*k','Markersize',16,'Linewidth',3);
plot(Fcomparison,Cpoints(:,2),'-ok','Markersize',16,'Linewidth',3);
plot(Fcomparison,Cpoints(:,3),'-xk','Markersize',16,'Linewidth',3);
plot(Fcomparison,Cpoints(:,4),'-dk','Markersize',16,'Linewidth',3);
legend('Cbulk','Cmem-','Cmem+','Cout','fontsize', 20, 'Location', 'southeast');
h = gca; set(h,'fontsize',24,'FontName','GillSansMT');
ylabel({'Dimensionless concentration [C = c/c_i_n]'});
xlabel('Flow rate [mL/h]')
title('Concentrations within system (base case)')

% Comparing base case with experimental data
idx2 = find(contains(Measurements,Measurement));

legendset = [];

if comparebasecase == true %&& justplotfinal == false
    figure(); hold on; grid on
    plot(Fcomparison,Cpoints(:,4),'-b','Markersize',35,'Linewidth',3);

    for m = 1:nrepeats(idx2)-1
        plot(Fmeasurements,Exp_Data{idx2}(:,m),'--k','Marker',mstring(m),'Markersize',16,'Linewidth',3);
        legendset = [legendset, {[' Experiment ' num2str(m)]}];
    end

    legend([' Model',legendset],'fontsize', 20, 'Location', 'southeast');
    h = gca; set(h,'fontsize',24,'FontName','GillSansMT');
    ylim([0  1]); ylabel({'c_p/c_b'}); 
    xlim([0 17]); xlabel('Flow rate [mL/h]');
    title('Comparing c_p with experiments (base case)');
    text(1.1,.9925,{['k_o      = ' num2str(k) ' m/s'];['\alpha      = ' num2str(alpha)];['L_m      = ' num2str(L2*1e6) ' μm'];['AC     = ' num2str(AC/1e6) '\times10\^6/m'];['\epsilon       = ' num2str(P)]},'fontsize', 20,'HorizontalAlignment', 'left','VerticalAlignment', 'top');
    text(10*0.9925,1*0.9925,'Note that k has been set and not fit using fminsearch','fontsize', 20,'HorizontalAlignment', 'right','VerticalAlignment', 'top')

elseif comparebasecase == false
    figure(); hold on; grid on
    plot(Fcomparison,Cpoints(:,4),'.-b','Markersize',35,'Linewidth',3);
    legend(' Model','fontsize', 20, 'Location', 'southeast');
    h = gca; set(h,'fontsize',24,'FontName','GillSansMT');
    ylim([0  1]); ylabel({'Dimensionless concentration [C = c/c_i_n]'}); 
    xlim([1 10]); xlabel('Flow rate [mL/h]');
    title('Plotting Cout (base case)');
    text(1.1,.9925,{['k0      = ' num2str(k) ' m/s'];['alpha = ' num2str(alpha)];['L2      = ' num2str(L2*1e6) ' μm'];['AC     = ' num2str(AC/1e6) '\times10\^6/m'];['P       = ' num2str(P)]},'fontsize', 20,'HorizontalAlignment', 'left','VerticalAlignment', 'top');
    text(10*0.9925,1*0.9925,'Note that k has been set and not fit using fminsearch','fontsize', 20,'HorizontalAlignment', 'right','VerticalAlignment', 'top')

end

if basecaseonly == 1
    warning('Basecaseonly = true. No fitting of data')
    % In order to fit data, use Basecaseonly = false at top of script
    return
end
end
%% Optimization K fit
if Kfit == true && justplotfinal == false

itK = 0; Ktest = [];
% options = optimset('Display','iter','TolFun',1e-6,'TolX',1e-6,'MaxFunEvals',1000);
% Can be used as alternative to display iteration results
options = optimset('Display','none','TolFun',1e-9,'TolX',1e-9,'MaxFunEvals',150);

if usepreviousfit
AnsmindevK =k_previousfit;
else
AnsmindevK =3.62E-08% 3.4E-08 3.25E-08	3.62E-08]fminsearchbnd(@balanceK,k,0,+inf,options); % searches for the K giving the lowest deviation from the datapoints \We change it here for iterations
disp(['LSQ fit value for k: ' num2str(AnsmindevK)])
end

%% plotting comparison%I made a new section
figure(); hold on; grid on
legendset = [];
% lightBLUE = [0.24 0.812 0.72];%[0.969 0.984 1.000];
% darkBLUE = [0 0.256 0.668];
% 
% blueGRADIENTflexible = @(n2,nmeasurements) darkBLUE + 0.5*(lightBLUE-darkBLUE)*((n2-1)/(nmeasurements-1));

for n2 = 1:nmeasurements
%     legendset = [legendset, {[ num2str(All_L2(n2)*1e6) ' μm']}]; %we removed this and add in the plot for the legend
        for n = 1:length(Fcomparison)
            Cpoints(n,:) = MembraneModelFunction(Fcomparison(n),L1,All_L2(n2),rad,P,AnsmindevK,alpha,D1,AC,S,plots,feedback,boundaryreaction);
        end
        ModelDataK{n2}=Cpoints;
        %plot(Fcomparison,Cpoints(:,4),'-','Linewidth',3, 'Color', blueGRADIENTflexible(n2,nmeasurements),'HandleVisibility','off');
        plot(Fcomparison,Cpoints(:,4),'-','Linewidth',3, 'Color', [0 0.256 0.668],'HandleVisibility','off');
        for m = 1:nrepeats(n2)-1
            if m == 1
            %plot(Fmeasurements,Exp_Data{n2}(:,m),'.', 'MarkerSize', 30, 'Color', blueGRADIENTflexible(n2,nmeasurements), 'DisplayName',  [ num2str(All_L2(n2)*1e6) ' μm']); % ,'MarkerEdgeColor','#3f007d','MarkerFaceColor','#3f007d');
            plot(Fmeasurements,Exp_Data{n2}(:,m),'.', 'MarkerSize', 30, 'Color', [0 0.256 0.668], 'DisplayName',  [ num2str(All_L2(n2)*1e6) ' μm']); % ,'MarkerEdgeColor','#3f007d','MarkerFaceColor','#3f007d');
            else
            %plot(Fmeasurements,Exp_Data{n2}(:,m),'.', 'MarkerSize', 30, 'Color', blueGRADIENTflexible(n2,nmeasurements), 'HandleVisibility','off'); % ,'MarkerEdgeColor','#3f007d','MarkerFaceColor','#3f007d');
            plot(Fmeasurements,Exp_Data{n2}(:,m),'.', 'MarkerSize', 30, 'Color', [0 0.256 0.668], 'HandleVisibility','off'); % ,'MarkerEdgeColor','#3f007d','MarkerFaceColor','#3f007d');
            end
        end
    

        h = gca; set(h,'fontsize',20,'YTick', 0:0.2:1);
        ylim([0  1]); ylabel('\it{c_p/c_b}'); 
        xlim([0 11]); xlabel('Flow rate [mL.h^{-1}]');
        set(gcf,'position',[0,0,650,700])
        %title('Comparing modeled c_p with experiments (K fit)')
        %text(1.1,.9925,{['k0      = ' num2str(AnsmindevK) ' m/s'];['alpha = ' num2str(alpha)];['L2      = ' num2str(All_L2(n2)*1e6) ' μm'];['AC     = ' num2str(AC/1e6) '\times10\^6/m'];['P       = ' num2str(P)]},'fontsize', 20,'HorizontalAlignment', 'left','VerticalAlignment', 'top');
        
end
box on
legend('fontsize', 20, 'Location', 'southeast')
text(0.1,.9925,{['k''_0    = ' num2str(AnsmindevK/1e-8) '\times10^{-8} m.s^{-1}'];['AC   = ' num2str(AC/1e6) '\times10^6 m^{-1}']},'fontsize', 20,'HorizontalAlignment', 'left','VerticalAlignment', 'top'); %;['\epsilon      = ' num2str(P)];['\alpha     = ' num2str(alpha)]
end

%% Optimization AC fit
if ACfit == true && justplotfinal == false
if Kfit == false
    error('Cannot fit AC without fitting K first')
    % Change Kfit to true at the beginning of the script
end 

itAC = 0; ACtest = [];
% options = optimset('Display','iter','TolFun',1e-6,'TolX',1e-6,'MaxFunEvals',1000);
% Can be used as alternative to display iteration results
options = optimset('Display','none','TolFun',1e-3,'TolX',1e-3,'MaxFunEvals',150);

if usepreviousfit
AnsmindevAC = AC_previousfit;
else
AnsmindevAC = fminsearchbnd(@balanceAC,AC,AC*(1-maxdev_AC),AC*(1+maxdev_AC),options); % searches for the K giving the lowest deviation from the datapoints
disp(['LSQ fit value for AC: ' num2str(AnsmindevAC)])
end

% plotting comparison
for n2 = 1:nmeasurements
    legendset = [];
    figure(); hold on; grid on
        for n = 1:length(Fcomparison)
            Cpoints(n,:) = MembraneModelFunction(Fcomparison(n),L1,All_L2(n2),rad,P,AnsmindevK,alpha,D1,AnsmindevAC,S,plots,feedback,boundaryreaction);
        end
        ModelDataK{n2}=Cpoints;
        plot(Fcomparison,Cpoints(:,4),'.-b','Markersize',35,'Linewidth',3);
        for m = 1:nrepeats(n2)-1
            plot(Fmeasurements,Exp_Data{n2}(:,m),'--k','Marker',mstring(m),'Markersize',16,'Linewidth',3);
            legendset = [legendset, {[' Experiment ' num2str(m)]}];
        end

        legend([' Model',legendset],'fontsize', 20, 'Location', 'southeast')
        h = gca; set(h,'fontsize',24,'FontName','GillSansMT');
        ylim([0  1]); ylabel({'Dimensionless concentration [C = c/c_i_n]'}); 
        xlim([1 10]); xlabel('Flow rate [mL/h]');
        title('Comparing modeled Cout with experiments (AC+K fit)')
        text(1.1,.9925,{['k''0      = ' num2str(AnsmindevK) ' m/s'];['alpha = ' num2str(alpha)];['L2      = ' num2str(All_L2(n2)*1e6) ' μm'];['AC     = ' num2str(AnsmindevAC/1e6) '\times10\^6/m'];['P       = ' num2str(P)]},'fontsize', 20,'HorizontalAlignment', 'left','VerticalAlignment', 'top');
end
end

%% Additional processing unique to script 2 and 3

if justplotfinal == true
     if boundaryreaction == false
         if length(All_L2) == 9 % value for k and AC considering all datasets
             AnsmindevK = 0.298118598574132
             AnsmindevAC= 1018650.64216400
         elseif length(All_L2) == 7 % value for k and AC only considering low membrane thickness
             AnsmindevK = 0.220336608961574
             AnsmindevAC= 1148424.01444539
         elseif length(All_L2) == 2 % value for k and AC only considering high membrane thickness
             AnsmindevK = 0.640762752743438
             AnsmindevAC= 1081932.67171037
         end
    elseif boundaryreaction == true
        if length(All_L2) == 9 % value for k and AC considering all datasets
            AnsmindevK = 0.000305557381840350
            AnsmindevAC= 804956.811028330
        elseif length(All_L2) == 7 % value for k and AC only considering low membrane thickness
            AnsmindevK = 0.000206791733192534
            AnsmindevAC= 804963.323500820
        elseif length(All_L2) == 2 % value for k and AC only considering high membrane thickness
            AnsmindevK = 0.00107581368193496
            AnsmindevAC= 1341249.94950254
        end
     end

for mk = 1:length(All_L2)
    L2_fit = All_L2(mk);
    tofit = Exp_Data{mk};
    legendset = [];

    for n = 1:length(Fcomparison) % Compare the found optimal value of k with experimental data
        Cpoints(n,:) = MembraneModelFunction(Fcomparison(n),L1,L2_fit,rad,P,AnsmindevK,alpha,D1,AnsmindevAC,S,plots,feedback,boundaryreaction);
    end

    % plotting comparison
    figure(); hold on; grid on 
        plot(Fcomparison,Cpoints(:,4),'.-b','Markersize',35,'Linewidth',3);

        for m = 1:nrepeats(mk)-1
            plot(Fmeasurements,Exp_Data{mk}(:,m),'--k','Marker',mstring(m),'Markersize',16,'Linewidth',3);
            legendset = [legendset, {[' Experiment ' num2str(m)]}];
        end
    
        legend([' Model',legendset],'fontsize', 20, 'Location', 'southeast');
        h = gca; set(h,'fontsize',24,'FontName','GillSansMT');
        ylim([0  1]); ylabel({'Dimensionless concentration [C = c/c_i_n]'}); 
        xlim([1 10]); xlabel('Flow rate [mL/h]');
        title('Comparing modeled Cout with experiments');
        text(1.1,.9925,{['k0      = ' num2str(AnsmindevK) ' m/s'];['alpha = ' num2str(alpha)];['L2      = ' num2str(L2_fit*1e6) ' μm'];['AC     = ' num2str(AnsmindevAC/1e6) '\times10\^6/m'];['P       = ' num2str(P)]},'fontsize', 20,'HorizontalAlignment', 'left','VerticalAlignment', 'top');
end
end


%% Functions

function f = balanceK(k2)
global alpha rad D1 P L1 boundaryreaction Fmeasurements S      % General globals used in all scripts
global All_L2 Exp_Data                                         % Globals specific for this script
global itK Ktest AC                                            % Globals required for the fit of k

    Fmeasurements = [1 2 4 6 8 10];
    itK = [itK+ 1];
    Ktest = [Ktest, k2];
    Ktestpoints = zeros(length(Fmeasurements),4);
    disp(['Iteration number ' num2str(itK) ', Value for K: ' num2str(k2)])

    for m = 1:length(All_L2)
        L2_fit = All_L2(m);
        for n = 1:length(Fmeasurements)
            Ktestpoints(n,:) = MembraneModelFunction(Fmeasurements(n),L1,L2_fit,rad,P,k2,alpha,D1,AC,S,false,false,boundaryreaction);
        end        
        Ymodel = Ktestpoints(:,4);
%         Ydata = Exp_Data{m}                   % Can be uncommented for debugging purposes
%         deviation = (Ymodel-Exp_Data{m}).^2
%        sum((Ymodel-Exp_Data{m}).^2) 
        SumOfSquares(m) = sum((Ymodel-Exp_Data{m}).^2,'all');   
    end
    fullsum = sum(SumOfSquares,'all');
    f = abs(fullsum);
end

function f = balanceAC(AC2)
global alpha rad D1 P L1 boundaryreaction Fmeasurements S     % General globals used in all scripts
global All_L2 Exp_Data                                        % Globals specific for this script
global itAC ACtest AnsmindevK                                 % Globals required for the fit of AC

    Fmeasurements = [1 2 4 6 8 10];
    itAC = [itAC+ 1];
    ACtest = [ACtest, AC2];
    ACtestpoints = zeros(length(Fmeasurements),4);
    disp(['Iteration number ' num2str(itAC) ', Value for AC: ' num2str(AC2)])
    for m = 1:length(All_L2)
        L2_fit = All_L2(m);
        for n = 1:length(Fmeasurements)
            ACtestpoints(n,:) = MembraneModelFunction(Fmeasurements(n),L1,L2_fit,rad,P,AnsmindevK,alpha,D1,AC2,S,false,false,boundaryreaction);
        end        
        Ymodel = ACtestpoints(:,4);
        SumOfSquares(m) = sum((Ymodel-Exp_Data{m}).^2,'all');   
    end
    fullsum = sum(SumOfSquares,'all');
    f = abs(fullsum);
end