%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                       %%%  
%%% fit unique value for K and AC for 1 chosen experiment %%%
%%%                                                       %%%  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Script takes a normal time to run

clear all;%close all; clc; format compact;
set(0,'DefaultLegendAutoUpdate','off')
set(0,'DefaultFigureWindowStyle','docked')
%set(0,'DefaultFigureWindowStyle','normal')

global alpha rad D1 P L1 boundaryreaction Fmeasurements S   % General globals used in all scripts
global L2_fit tofit                                         % Globals specific for this script
global itK Ktest AC                                         % Globals required for the fit of k
global itAC ACtest AnsmindevK                               % Globals required for the fit of AC

%% script control
basecaseonly     = false ;                  % Do not fit any datapoints - just generatre profiles or plot graphs for the set variables
comparebasecase  = true  ;                  % Compare set parameters manually to chosen measurment (see below)
plots            = false ;                  % Plot individual membrane graph for each flowrate
feedback         = false ;                  % Show bvp solver statistics of MembraneModelFunction.m
boundaryreaction = false ;                  % Include boundary reaction flux in flux boundary condition
Kfit             = true ;                  % Determine the fit for K using LSQ
ACfit            = true  ; %                 % Determine the fit for AC using LSQ (after fitting K)
Sensitivity      = true  ;                  % Sensitivity analysis for k and AC

% Choose for which membrane measurement you want to get a fit for K (and AC)
Measurements = {'d21_9' 'd10_6' 'd4_3' 'd3_4' 'd2_74' 'd1_69' 'd1_17' 'd0_65' 'd0_26'};
Measurement = 'd21_9';                      % Chosen measurement - can be changed as desired

% The number of datapoints in the model can be adjusted if desired
%Fcomparison = [1:.25:10];                    % Values of the flow rate to plot in comparing graphs
Fcomparison = [1 2 4 6 8 10];               % Default to match measurement points

%% Variables (set values for base case)
Fmeasurements = [1 2 4 6 8 10];             % g/h (assumed to be equal to ml/h)
k = 3.45e-8;  %1e-6                          % Surface reaction rate (m/s)
alpha = 1 ;                                  % Concentration ratio at the boundary
L2 = 21.9E-6; %19.5E-6;                      % Membrane thickness (m) Shu:I changed this
AC = 2.5E5;                               % Absorption coefficient (1/m) Shu same as 0.001073 nm from Visan 2014
maxdev_AC = 0.25;                           % Maximum deviation from literary AC when fitting

%% constants
rad = 0.01; %0.002;                     % Radius membrane (m) %Shu: I changed this value 20/2/1000
D1 = 4.6e-10;                           % Diffusion coefficient pre-membrane (m2/s)%Shu: I changed from the literature value
P = 0.45;                               % Porosity
L1 = 0.01; %200e-6;                     % Thickness of the mass transfer boundary layer (m)%Shu: I changed this value 1/100 reactor heoght on top of the membrane
S =192802500;%700;                      % Specific surface area of the catalyst (m2/m3)% Shu: chanded to (1/L)VIsan 2014 k'=k/(S*p(1-P)) ((3895*(1-P))*9e4)

%% Importing Experimental data
Data = readmatrix('dataV2.xlsx','range','A1:K91');
%All_L2 = [19.5 11.6 4.4 3.44 2.6 1.5 1.14 0.56 0.194]*1e-6;
All_L2 = [21.9 10.6 4.3 3.4 2.74 1.69 1.17 0.65 0.26]*1e-6; %(m)
nmeasurements = length(All_L2);

for n = 1:nmeasurements
    idx1 = 10*n-10;
    nrepeats(n) = find(isnan(Data(5+idx1,:)),1)-1; % Number of (experimental repeats+1) for 1 membrane
    Exp_Data{n}=Data([5:10]+idx1,[2:nrepeats(n)]);
    %Exp_Data{n}
end

%% Base case: Calculation of concentration as function of flow rate for given K AC alpha values
for n = 1:length(Fcomparison)
    Cpoints(n,:) = MembraneModelFunction(Fcomparison(n),L1,L2,rad,P,k,alpha,D1,AC,S,plots,feedback,boundaryreaction);
end

% Plotting results from base case with set K
figure(); hold on; grid on
plot(Fcomparison,Cpoints(:,1),'-*k',Markersize=16,Linewidth=3);
plot(Fcomparison,Cpoints(:,2),'-ok',Markersize=16,Linewidth=3);
plot(Fcomparison,Cpoints(:,3),'-xk',Markersize=16,Linewidth=3);
plot(Fcomparison,Cpoints(:,4),'-dk',Markersize=16,Linewidth=3);
legend('Cbulk','Cmem-','Cmem+','Cout','fontsize', 20, 'Location', 'southeast');
h = gca; set(h,'fontsize',24,'FontName','GillSansMT');
ylabel({'Dimensionless concentration [Cn = c_p/c_b]'});
xlabel('Flow rate [mL/h]')
title('Concentrations within system (base case)')


% Comparing base case with experimental data
idx2 = find(contains(Measurements,Measurement));
mstring = '*xods';
legendset = [];

if comparebasecase == true
    figure(); hold on; grid on
    plot(Fcomparison,Cpoints(:,4),'.-b',Markersize=35,Linewidth=3);

    for m = 1:nrepeats(idx2)-1
        plot(Fmeasurements,Exp_Data{idx2}(:,m),'--k',Marker=mstring(m),Markersize=16,Linewidth=3);
        legendset = [legendset, {[' Experiment ' num2str(m)]}];
    end

    legend([' Model',legendset],'fontsize', 20, 'Location', 'southeast');
    h = gca; set(h,'fontsize',24,'FontName','GillSansMT');
    ylim([0  1]); ylabel({'Dimensionless concentration [Cn = c_p/c_b]'}); 
    xlim([1 10]); xlabel('Flow rate [mL/h]');
    title('Comparing Cout with experiments (base case)');
    text(1.1,.9925,{['k0      = ' num2str(k) ' m/s'];['alpha = ' num2str(alpha)];['L2      = ' num2str(L2*1e6) ' μm'];['AC     = ' num2str(AC/1e6) '\times10\^6/m'];['P       = ' num2str(P)]},'fontsize', 20,'HorizontalAlignment', 'left','VerticalAlignment', 'top');
    text(10*0.9925,1*0.9925,'Note that k has been set and not fit using fminsearch','fontsize', 20,'HorizontalAlignment', 'right','VerticalAlignment', 'top')

elseif comparebasecase == false
    figure(); hold on; grid on
    plot(Fcomparison,Cpoints(:,4),'.-b',Markersize=35,Linewidth=3);
    legend(' Model','fontsize', 20, 'Location', 'southeast');
    h = gca; set(h,'fontsize',24,'FontName','GillSansMT');
    ylim([0  1]); ylabel({'Dimensionless concentration [Cn = c_p/c_b]'}); 
    xlim([1 10]); xlabel('Flow rate [mL/h]');
    title('Plotting Cout (base case)');
    text(1.1,.9925,{['k0      = ' num2str(k) ' m/s'];['alpha = ' num2str(alpha)];['L2      = ' num2str(L2*1e6) ' μm'];['AC     = ' num2str(AC/1e6) '\times10\^6/m'];['P       = ' num2str(P)]},'fontsize', 20,'HorizontalAlignment', 'left','VerticalAlignment', 'top');
    text(10*0.9925,1*0.9925,'Note that k has been set and not fit using fminsearch','fontsize', 20,'HorizontalAlignment', 'right','VerticalAlignment', 'top')

end

if basecaseonly == 1
    warning('Basecaseonly = true. No fitting of data')
    % In order to fit data, use Basecaseonly = false at top of script
    return
end

%% Optimization K fit
if Kfit == true 

itK = 0; Ktest = [];
% options = optimset('Display','iter','TolFun',1e-7,'TolX',1e-7,'MaxFunEvals',150);
% Can be used as alternative to display iteration results
options = optimset('Display','none','TolFun',1e-9,'TolX',1e-9,'MaxFunEvals',150);

L2_fit = All_L2(idx2)
tofit = Exp_Data{idx2}

AnsmindevK = fminsearchbnd(@balanceK,k,0,+inf,options); % searches for the K giving the lowest deviation from the datapoints
disp(['LSQ fit value for k: ' num2str(AnsmindevK)])

for n = 1:length(Fcomparison) % Compare the found optimal value of k with experimental data
    Cpoints(n,:) = MembraneModelFunction(Fcomparison(n),L1,L2_fit,rad,P,AnsmindevK,alpha,D1,AC,S,plots,feedback,boundaryreaction);
end

% plotting comparison Shu:I have been modifing this plot
figure(); hold on; grid on 
    %plot(Fcomparison,Cpoints(:,4),'.-b',Markersize=35,Linewidth=3);
    plot(Fcomparison,Cpoints(:,4),'-b',Markersize=35,Linewidth=3);

    for m = 1:nrepeats(idx2)-1
%         %plot(Fmeasurements,Exp_Data{idx2}(:,m),'--k',Marker=mstring(m),Markersize=16,Linewidth=3);
%           plot(Fmeasurements,Exp_Data{idx2}(:,m),'o',Marker=mstring(m),Markersize=16,MarkerFaceColor='k');
          plot(Fmeasurements,Exp_Data{idx2}(:,1),'sk',Markersize=16,MarkerFaceColor='k');
          plot(Fmeasurements,Exp_Data{idx2}(:,2),'^k',Markersize=16,MarkerFaceColor='k');
%           plot(Fmeasurements,Exp_Data{idx2}(:,3),'ok',Markersize=16,MarkerFaceColor='k');
           %plot(Fmeasurements,Exp_Data{idx2}(:,4),'dk',Markersize=16,MarkerFaceColor='k');
    end

    legend([' Model',legendset],'fontsize', 20, 'Location', 'southeast');
    h = gca; set(h,'fontsize',24,'FontName','GillSansMT');
    %ylim([0  1]); ylabel({'Dimensionless concentration [c_p/c_b]'}); 
    ylim([0  1]); ylabel({'c_p/c_b'}); 
    xlim([1 10]); xlabel('Flow rate [mL/h]');
    title('Comparing modeled Cout with experiments K fit');
    %text(1.1,.9925,{['k0      = ' num2str(AnsmindevK) ' m/s'];['alpha = ' num2str(alpha)];['L2      = ' num2str(All_L2(idx2)*1e6) ' μm'];['AC     = ' num2str(AC/1e6) '\times10\^6/m'];['P       = ' num2str(P)]},'fontsize', 20,'HorizontalAlignment', 'left','VerticalAlignment', 'top');
    text(1.1,.9925,{['k_0    = ' num2str(AnsmindevK) ' m.s^{-1}'];['\alpha      = ' num2str(alpha)];['L_m   = ' num2str(All_L2(idx2)*1e6) ' μm'];['AC   = ' num2str(AC/1e6) '\times10\^6 m^{-1}'];['\epsilon      = ' num2str(P)]},'fontsize', 20,'HorizontalAlignment', 'left','VerticalAlignment', 'top');

end

%% Optimization AC fit
if ACfit == true

if Kfit == false
    error('Cannot fit AC without fitting K first')
    % Change Kfit to true at the beginning of the script
end 

itAC = 0; ACtest = [];
% options = optimset('Display','iter','TolFun',1e-7,'TolX',1e-7,'MaxFunEvals',150);
% Can be used as alternative to display iteration results
options = optimset('Display','none','TolFun',1e-3,'TolX',1e-3,'MaxFunEvals',150);

AnsmindevAC = fminsearchbnd(@balanceAC,AC,AC*(1-maxdev_AC),AC*(1+maxdev_AC),options); % searches for the K giving the lowest deviation from the datapoints
disp(['LSQ fit value for AC: ' num2str(AnsmindevAC)])

for n = 1:length(Fcomparison) % Compare the found optimal value of AC & K with experimental data
    Cpoints(n,:) = MembraneModelFunction(Fcomparison(n),L1,L2_fit,rad,P,AnsmindevK,alpha,D1,AnsmindevAC,S,plots,feedback,boundaryreaction);
end

figure(); hold on; grid on
    plot(Fcomparison,Cpoints(:,4),'.-b',Markersize=35,Linewidth=3);
    for m = 1:nrepeats(idx2)-1
        plot(Fmeasurements,Exp_Data{idx2}(:,m),'--k',Marker=mstring(m),Markersize=16,Linewidth=3);
    end
    legend([' Model',legendset],'fontsize', 20, 'Location', 'southeast');
    h = gca; set(h,'fontsize',24,'FontName','GillSansMT');
    ylim([0  1]); ylabel({'Dimensionless concentration [c_p/c_b]'}); 
    xlim([1 10]); xlabel('Flow rate [mL/h]');
    title('Comparing modeled Cout with experiments AC fit');
    text(1.1,.9925,{['k0      = ' num2str(AnsmindevK) ' m/s'];['alpha = ' num2str(alpha)];['L2      = ' num2str(All_L2(idx2)*1e6) ' μm'];['AC     = ' num2str(AnsmindevAC/1e6) '\times10\^6/m'];['P       = ' num2str(P)]},'fontsize', 20,'HorizontalAlignment', 'left','VerticalAlignment', 'top');
end

%% Sensitivity analysis of k and AC
if Sensitivity == true

Fcomparison = [1:.25:10];                    % Values of the flow rate to plot in comparing graphs
%ACspace = logspace(4,8,5);                   % Absorption coefficient (1/m)
ACspace = [1e5 2e5 3e5 4e5 1e6];    
%kspace = [1e-3 1e-2 0.05 0.1 0.5 1 10];      % Surface reaction rate (m/s)
 kspace = [1e-15 1e-9 1e-8 5e-7 1e-7 1e-6 1e-5];      % Surface reaction rate (m/s) 

L2sens =21.9e-6;% 2.5E-6;  %Shu: this number doesntchange anything

% Sensitivity of k
legendset_Sk = [];
for m = 1:length(kspace)
    for n = 1:length(Fcomparison)
        Cpoints_Sk{m}(n,:) = MembraneModelFunction(Fcomparison(n),L1,L2sens,rad,P,kspace(m),alpha,D1,AC,S,false,false,boundaryreaction);
    end
    legendset_Sk = [legendset_Sk, {[' k = ' num2str(kspace(m))]}];
end

mstring = '*xods+v^<>ph';
figure(); hold on; grid on
    for m = 1:length(kspace)
        plot(Fcomparison,Cpoints_Sk{m}(:,4),'--k',Marker=mstring(m),Markersize=16,Linewidth=3);
    end
    
    legend(legendset_Sk,'fontsize', 20, 'Location', 'east');
    h = gca; set(h,'fontsize',24,'FontName','GillSansMT');
    ylim([0  1]); ylabel({'\it{c_p/c_b}'}); 
    xlim([1 10]); xlabel('Flow rate [mL/h]');
    title(['Sensitivity analysis for k0 (default = ' num2str(k) ')'])
    text(1.1,.9925-.60,{['\alpha   = ' num2str(alpha)];['L_2  = ' num2str(L2sens*1e6) ' μm'];['AC  = ' num2str(AC/1e6) '\times10\^6 m^{-1}'];['\epsilon      = ' num2str(P)]},'fontsize', 20,'HorizontalAlignment', 'left','VerticalAlignment','top');


% Sensitivity of AC
legendset_SAC = [];

for m = 1:length(ACspace)
    for n = 1:length(Fcomparison)
        Cpoints_SAC{m}(n,:) = MembraneModelFunction(Fcomparison(n),L1,L2sens,rad,P,k,alpha,D1,ACspace(m),S,false,false,boundaryreaction);
    end
    %legendset_SAC = [legendset_SAC, {[' AC = 10^' num2str(log10(ACspace(m)))]}];
    legendset_SAC = [legendset_SAC, {[' AC = ' num2str(ACspace(m)/1e6) '\times10^6']}];
end

mstring = '*xods+v^<>ph';
figure(); hold on; grid on
    for m = 1:length(ACspace)
        plot(Fcomparison,Cpoints_SAC{m}(:,4),'--k',Marker=mstring(m),Markersize=16,Linewidth=3);
    end

    legend(legendset_SAC,'fontsize', 20, 'Location', 'southeast');
    h = gca; set(h,'fontsize',24,'FontName','GillSansMT');
    ylim([0  1]); ylabel({'\it{c_p/c_b}'}); 
    xlim([1 10]); xlabel('Flow rate [mL/h]');
    title(['Sensitivity analysis for AC (default = ' num2str(AC/1e6) '\times10^6)'])
    %text(1.1,1-.9925,{['k0      = ' num2str(k) ' m/s'];['alpha = ' num2str(alpha)];['L2      = ' num2str(L2sens*1e6) ' μm'];['P       = ' num2str(P)]},'fontsize', 20,'HorizontalAlignment', 'left','VerticalAlignment', 'bottom');
    text(1.1,.6,{['k_o    = ' num2str(k) ' m/s'];['alpha = ' num2str(alpha)];['L2      = ' num2str(L2sens*1e6) ' μm'];['P       = ' num2str(P)]},'fontsize', 20,'HorizontalAlignment', 'left','VerticalAlignment', 'bottom');
end

%% Functions

function f = balanceK(k2)
global alpha rad D1 P L1 boundaryreaction Fmeasurements S
global L2_fit tofit
global itK Ktest AC

    itK = [itK+ 1];
    Ktest = [Ktest, k2];
    Ktestpoints = zeros(length(Fmeasurements),4);
    disp(['Iteration number ' num2str(itK) ', Value for K: ' num2str(k2)])
    for n = 1:length(Fmeasurements)
        Ktestpoints(n,:) = MembraneModelFunction(Fmeasurements(n),L1,L2_fit,rad,P,k2,alpha,D1,AC,S,false,false,boundaryreaction);
    end        
    Ymodel = Ktestpoints(:,4);
    SumOfSquares =  sum((Ymodel-tofit).^2,'all');   
    f = abs(SumOfSquares);
end

function f = balanceAC(AC2)
global alpha rad D1 P L1 boundaryreaction Fmeasurements S
global L2_fit tofit
global itAC ACtest AnsmindevK  

    itAC = [itAC+ 1];
    ACtest = [ACtest, AC2];
    ACtestpoints = zeros(length(Fmeasurements),4);
    disp(['Iteration number ' num2str(itAC) ', Value for AC: ' num2str(AC2)])
    for n = 1:length(Fmeasurements)
        ACtestpoints(n,:) = MembraneModelFunction(Fmeasurements(n),L1,L2_fit,rad,P,AnsmindevK,alpha,D1,AC2,S,false,false,boundaryreaction);
    end        
    Ymodel = ACtestpoints(:,4);
    SumOfSquares =  sum((Ymodel-tofit).^2,'all');   
    f = abs(SumOfSquares);
end