import numpy as np
from scipy.interpolate import CubicSpline
import scipy as sc
from itertools import product
from itertools import cycle
import datetime
import scipy.interpolate as sc
from collections import defaultdict
from matplotlib.ticker import ScalarFormatter
import pandas as pd
import math

R = 2.4e-9 #m
T=298 # temperature [K]
kb=1.380649*10**(-23) # Boltzmann_constant [J⋅K−1]
Nav= 6.02214076*10**23 # Avogadro's number [mol-1]

ct = datetime.datetime.now().strftime('%Y%m%d_%H%M%S') # ct stores current time
ct_str=str(ct)

def get_column_contents(file_path, column_name):
    # Read the file into a DataFrame
    df = pd.read_csv(file_path, sep='\t', lineterminator='\n')
    
    # Check if the column exists
    if column_name not in df.columns:
        raise ValueError(f'Column {column_name} not found in the file.')
    
    # Return the contents of the column
    return np.flip(df[column_name].values)


def get_data_cyl(Np, Csalt, sigma_f, pH, sigma_p, m, pKa, ChiPS, b):
    ## the first pH value is the minimum possible with the specific salt concentration
    if Csalt==0.001:
        pH0=3.0
    elif Csalt == 0.1 or Csalt == 0.01:
        pH0=2.0
    elif Csalt == 0.0001:
        pH0=4.0
    elif Csalt == 0.00001:
        pH0=5.0
    base_path=r'./kal_files'
    assert(b!=0.6e-9)
    assert(sigma_f==0)
    if b==0.3e-9:
        assert(sigma_p!=0)
        if sigma_f == 0 and sigma_p != 0:
            # print(m)
            if pKa==4.5:
                if m==0.50:
                    print("read files ", pH0,pH)
                    file0 = base_path+'\cylindrical_surface_and_pol_charge_reg_R=2.5_nm_NP=100_Csalt='+str(Csalt)+'_M_pH='+str(pH0)+'_Sigma='+str(sigma_p)+'_mol_nm2_ChiPS='+str(ChiPS)+'_blanco.kal'
                    file1 = base_path+'\cylindrical_surface_and_pol_charge_reg_R=2.5_nm_NP=100_Csalt='+str(Csalt)+'_M_pH='+str(pH)+'_Sigma='+str(sigma_p)+'_mol_nm2_ChiPS='+str(ChiPS)+'_blanco.kal'
                else:
                    file0 = base_path+'\cylindrical_surface_and_pol_charge_reg_R=2.5_nm_NP=100_Csalt='+str(Csalt)+'_M_pH='+str(pH0)+'_Sigma='+str(sigma_p)+'_mol_nm2_ChiPS='+str(ChiPS)+'_m='+str(m)+'_blanco.kal'
                    file1 = base_path+'\cylindrical_surface_and_pol_charge_reg_R=2.5_nm_NP=100_Csalt='+str(Csalt)+'_M_pH='+str(pH)+'_Sigma='+str(sigma_p)+'_mol_nm2_ChiPS='+str(ChiPS)+'_m='+str(m)+'_blanco.kal'
            else:
                file0 = base_path+'\cylindrical_surface_and_pol_charge_reg_R=2.5_nm_NP=100_Csalt='+str(Csalt)+'_M_pH='+str(pH0)+'_Sigma='+str(sigma_p)+'_mol_nm2_ChiPS='+str(ChiPS)+'_pKa='+str(pKa)+'_blanco.kal'
                file1 = base_path+'\cylindrical_surface_and_pol_charge_reg_R=2.5_nm_NP=100_Csalt='+str(Csalt)+'_M_pH='+str(pH)+'_Sigma='+str(sigma_p)+'_mol_nm2_ChiPS='+str(ChiPS)+'_pKa='+str(pKa)+'_blanco.kal'
        else:
            file0 = base_path+'\cylindrical_surface_and_pol_charge_reg_R=2.5_nm_NP='+str(Np)+'_Csalt='+str(Csalt)+'_M_pH='+str(pH0)+'_Sigma='+str(sigma_p)+'_mol_nm2_ChiPS='+str(ChiPS)+'_sigma_f_nm2='+str(sigma_f)+'.kal'
            file1 = base_path+'\cylindrical_surface_and_pol_charge_reg_R=2.5_nm_NP='+str(Np)+'_Csalt='+str(Csalt)+'_M_pH='+str(pH)+'_Sigma='+str(sigma_p)+'_mol_nm2_ChiPS='+str(ChiPS)+'_sigma_f_nm2='+str(sigma_f)+'.kal'
    offset_first_layer = 8.
    sigma_p_m2=sigma_p*1e18
    M_cyl = 2.*np.pi*offset_first_layer*sigma_p_m2*b**2 #number of polymer chains
    theta_cyl = M_cyl*2.*Np
    lmin_cyl = int(np.ceil(np.sqrt((theta_cyl + np.pi*offset_first_layer*offset_first_layer)/np.pi)))
    lmax_cyl = 2*Np + offset_first_layer

    ###########################Cylindrical##################################
    
    # print(file0)
    # Load and process data for file0
    gp0_sfbox = get_column_contents(file0, 'sys : noname : grand potential')
    layers0 = get_column_contents(file0, 'lat : solution : n_layers')
    
    gp0_real = (
        gp0_sfbox
        - (get_column_contents(file0, 'mol : solvent : FH-MU - H3O')
        * get_column_contents(file0, 'state : PH : theta') if (m != 0) and (sigma_p != 0) else 0)
        - (get_column_contents(file0, 'mol : solvent : FH-MU - H3O')
        * get_column_contents(file0, 'state : funcH : theta') if sigma_f != 0 else 0)

        )
    en_po_from_real_gp0 = (
            gp0_real
            # POLYMER
            + (get_column_contents(file0, 'mol : poly : sum n FH-MU') if sigma_p != 0 else 0) # RESTRICTED
            
            # SURFACE GROUPS
            + (get_column_contents(file0, 'mol : funcsurface : sum n FH-MU') if sigma_f != 0 else 0) # RESTRICTED
        )
    en0 = en_po_from_real_gp0

    # Load and process data for file1
    layers1 = get_column_contents(file1, 'lat : solution : n_layers')
    gp_sfbox = get_column_contents(file1, 'sys : noname : grand potential')
    
    gp_real = (
        gp_sfbox
        - (get_column_contents(file1, 'mol : solvent : FH-MU - H3O')
        * get_column_contents(file1, 'state : PH : theta') if (m != 0) and (sigma_p != 0) else 0)
        - (get_column_contents(file1, 'mol : solvent : FH-MU - H3O')
        * get_column_contents(file1, 'state : funcH : theta') if sigma_f != 0 else 0)

        )
    en_po_from_real_gp = (
            gp_real
            # POLYMER
            + (get_column_contents(file1, 'mol : poly : sum n FH-MU') if sigma_p != 0 else 0) # RESTRICTED
            
            # SURFACE GROUPS
            + (get_column_contents(file1, 'mol : funcsurface : sum n FH-MU') if sigma_f != 0 else 0) # RESTRICTED
        )
    en1 = en_po_from_real_gp

    assert(len(en0) == len(layers0))
    assert(len(en1) == len(layers1))

    ###### in the first computation the pH is minimum, so no work/disjoining pressure
    if(pH0==pH):
        assert(en1.all()==en0.all())
    
    # compute pressure, stroke, work
    delta0 = (layers0 + offset_first_layer)/ (lmax_cyl)
    diff_energy0 = (-en0[:-1] + en0[1:])*kb*T/b
    diff_vol0 = (-(layers0[:-1] + offset_first_layer)**2 + (layers0[1:] + offset_first_layer)**2)*b**2*np.pi
    pres0 = - (diff_energy0 / diff_vol0)
    deltapress0 = (delta0[1:] + delta0[:-1]) * 0.5
    delta_interp = np.linspace(0., 1., 1000)
    line0 = sc.interp1d(deltapress0, pres0, fill_value='extrapolate')
    press0_lin = line0(delta_interp)
    
    delta1 = (layers1 + offset_first_layer)/ (lmax_cyl)
    diff_energy1 = (-en1[:-1] + en1[1:])*kb*T/b
    diff_vol1 = (-(layers1[:-1] + offset_first_layer)**2 + (layers1[1:] + offset_first_layer)**2)*b**2*np.pi
    pres1 = - (diff_energy1 / diff_vol1)
    deltapress1 = (delta1[1:] + delta1[:-1]) * 0.5
    delta_interp = np.linspace(0., 1., 1000)
    line1 = sc.interp1d(deltapress1, pres1, fill_value='extrapolate')
    press1_lin = line1(delta_interp)
    
    delta0lin = delta_interp[np.argmin(abs(press0_lin - 0.))]
    delta0lin = delta0[en0.argmin()]

    delta1lin = delta_interp[np.argmin(abs(press1_lin - 0.))]
    delta1lin = delta1[en1.argmin()]
    deltap_pro3 = press0_lin[np.argmin(abs(press1_lin - 0.))] - press1_lin[np.argmin(abs(press1_lin - 0.))]
    deltap_dep3 = press1_lin[np.argmin(abs(press0_lin - 0.))] - press0_lin[np.argmin(abs(press0_lin - 0.))]

    dx = 0.001
    y_heights0 = press0_lin[np.argmin(abs(press0_lin - 0.)) :  np.argmin(abs(press1_lin - 0.))]
    y_heights1 = press1_lin[np.argmin(abs(press0_lin - 0.)) :  np.argmin(abs(press1_lin - 0.))]
    d_points = delta_interp[np.argmin(abs(press0_lin - 0.)) :  np.argmin(abs(press1_lin - 0.))]
    int_bad = (np.sum(y_heights1*d_points*dx) - np.sum(y_heights0*d_points*dx))*(2*b**3*np.pi*lmax_cyl**2)
    
    x1cyl =  np.array(delta1lin)*lmax_cyl
    x0cyl = np.array(delta0lin)*lmax_cyl
    deltavolcyl = (x1cyl**2 - x0cyl**2)*np.pi*b**3
    
    index_delta0lin = int(delta0lin*lmax_cyl) - int(offset_first_layer)
    PH_total = get_column_contents(file0, 'state : PH : theta')
    PH_total = PH_total[index_delta0lin]
    Pm_total = get_column_contents(file0, 'state : Pm : theta')
    Pm_total = Pm_total[index_delta0lin]
    Poly_total = get_column_contents(file0, 'mol : poly : theta')
    Poly_total = Poly_total[index_delta0lin]
    P2_total = get_column_contents(file0, 'mon : P2 : theta')
    P2_total = P2_total[index_delta0lin]
    
    return {
        'geometry': 'cylindrical', 
        'Np': Np,
        'Csalt': Csalt,
        'sigma_f': sigma_f,
        'pH': pH,
        'sigma_p': sigma_p,
        'm': m,
        'int_bad': int_bad,
        'delta0lin': delta0lin,
        'delta1lin': delta1lin,
        'deltap_pro3': deltap_pro3,
        'deltap_dep3': deltap_dep3,
        'deltavol': deltavolcyl,
        'M': M_cyl,
        'Poly_total': Poly_total,
        'Pm_total': Pm_total,
        'PH_total': PH_total,
        'P2_total': P2_total,
        'pKa': pKa,
        'ChiPS': ChiPS,
        # Include other relevant data as needed
    }

def main():
    b = 0.3e-9
    Np = 100
    sigma_f=0
    m=0.5
    sigma_p =1
    pKa=4.5
    ChiPS = 0.4
    Csalt_range = [0.1, 0.01, 0.001, 0.0001, 0.00001]
    #Csalt=0.01
    geometry = "cylindrical"
    results=[]

    for Csalt in Csalt_range:
        pH_range = np.round(np.arange(max(2, - np.log10(Csalt)), 13.0, 1.0), 1)
        for pH in pH_range:
            if geometry == 'flat':
                print("wrong geometry")
            elif geometry == 'cylindrical':
                new_entry = get_data_cyl(Np, Csalt, sigma_f, pH, sigma_p, m, pKa, ChiPS, b)
                results.append(new_entry.values())

    df = pd.DataFrame(results, columns=new_entry.keys())

    # Save to Excel
    excel_filename = 'results_'+geometry+'.xlsx'
    df.to_excel(excel_filename, index=False)

    print(f'Results saved to {excel_filename}')

if __name__ == '__main__':
    main()
       


    
