import numpy as np
import os
import shutil
import pandas as pd
import matplotlib.pyplot as plt
import datetime
from itertools import cycle
from itertools import product
from collections import defaultdict
import scipy.interpolate as sc

T=298 # temperature [K]
kb=1.380649*10**(-23) # Boltzmann_constant [J⋅K−1]
Nav= 6.02214076*10**23 # Avogadro's number [mol-1]

def get_column_contents(file_path, column_name):
    # Read the file into a DataFrame
    df = pd.read_csv(file_path, sep='\t', lineterminator='\n')
    
    # Check if the column exists
    if column_name not in df.columns:
        raise ValueError(f'Column {column_name} not found in the file.')
    
    # Return the contents of the column
    return df[column_name].values

def get_data(geometry, sigma_p, sigma_f, pH, Csalt, Np, b, ChiPS, author):
    if geometry == 'cylindrical':
        print("wrong geometry, we are comparing with flat")  
### first look for the energy minimum in the kal files 
    elif geometry == 'flat':
########### double grafted 
        kal_file = f"./kal_files/flat_surf_pol_cr_brush_NP={Np}_Csalt={Csalt}_M_pH={pH}_Sigma={sigma_p}_mol_nm2_ChiPS={ChiPS}_Israels_a.kal"
        # Check if the file exists in the folder
        if os.path.isfile(kal_file):
            print(f"Processing file: {kal_file}")
            # offset_first_layer = 8.
            sigma_p_m2=sigma_p*1e18
            M_flat = b*sigma_p_m2*b #number of polymer chains
            theta_flat = M_flat*2.*Np
            lmin_flat = int(np.ceil(theta_flat)) + 1
            lmax_flat = 2*Np + 1
            layers1 = get_column_contents(kal_file, 'lat : solution : n_layers')
            #print(layers1)
            gp_sfbox = get_column_contents(kal_file, 'sys : noname : grand potential')
            # correct the grand potential
            gp_real = (
                gp_sfbox
                - (get_column_contents(kal_file, 'mol : solvent : FH-MU - H3O')
                * get_column_contents(kal_file, 'state : PH : theta') if sigma_p != 0 else 0)
                - (get_column_contents(kal_file, 'mol : solvent : FH-MU - H3O')
                * get_column_contents(kal_file, 'state : funcH : theta') if sigma_f != 0 else 0)

                )
            # partial open free energy from grand potential
            en_po_from_real_gp = (
                    gp_real
                    # POLYMER
                    + (get_column_contents(kal_file, 'mol : poly : sum n FH-MU') if sigma_p != 0 else 0) # RESTRICTED
                    
                    # SURFACE GROUPS
                    + (get_column_contents(kal_file, 'mol : funcsurface : sum n FH-MU') if sigma_f != 0 else 0) # RESTRICTED
                )
            en1 = en_po_from_real_gp
            gp1 = gp_real
            
            delta1 = (layers1 + 1.) / lmax_flat
            diff_energy1 = (-en1[:-1] + en1[1:]) * kb * T / b
            diff_vol1 = b * b
            pres1 = - (diff_energy1 / diff_vol1)
            deltapress1 = (delta1[1:] + delta1[:-1]) * 0.5
            delta_interp = np.linspace(0., 1., 1000)
            line1 = sc.interp1d(deltapress1, pres1, fill_value='extrapolate')
            press1_lin = line1(delta_interp)
            delta1lin = delta_interp[np.argmin(abs(press1_lin - 0.))]
            ## select the .pro file to compute the Hrms
            index_delta1lin = int(delta1lin*lmax_flat) - 1 

            print("minimum energy", index_delta1lin)
            index_delta1lin_s = "{:03d}".format(index_delta1lin)
            index_delta1lin_s_plus1 = "{:03d}".format(index_delta1lin+1)

            #adjust number of layers tp the profile that I already have
            path1 = f"./pro_files/flat_surf_pol_cr_brush_NP={Np}_Csalt={Csalt}_M_pH={pH}_Sigma={sigma_p}_mol_nm2_ChiPS={ChiPS}_Israels_a_1_n_layers={index_delta1lin_s}.pro" 
            path2 = f"./pro_files/flat_surf_pol_cr_brush_NP={Np}_Csalt={Csalt}_M_pH={pH}_Sigma={sigma_p}_mol_nm2_ChiPS={ChiPS}_Israels_a_1_n_layers={index_delta1lin_s_plus1}.pro" 
            print(path2)
            if os.path.isfile(path1):
               pro_file_name = path1
            elif os.path.isfile(path2):
               print("added one")
               pro_file_name = path2
               index_delta1lin+=1
            
            ## read alpha
            alpha_Pm =  get_column_contents(kal_file, 'mon : P2 : alpha-Pm')
            alpha_PH = get_column_contents(kal_file, 'mon : P2 : alpha-PH')
            Pm_theta =  get_column_contents(kal_file, 'state : Pm : theta')
            PH_theta =  get_column_contents(kal_file, 'state : PH : theta')
            data = {'en(po)': en1, 'layers': layers1, 'alpha_Pm': alpha_Pm,'alpha_PH': alpha_PH,  'Pm_theta':Pm_theta,'PH_theta':PH_theta}
            df_limited = pd.DataFrame(data=data)
            alpha_Pm_equi = df_limited.loc[df_limited['layers']==index_delta1lin]['alpha_Pm'].values[0]
            alpha_PH_equi = df_limited.loc[df_limited['layers']==index_delta1lin]['alpha_PH'].values[0]
            Pm_theta = df_limited.loc[df_limited['layers']==index_delta1lin]['Pm_theta'].values[0]
            PH_theta = df_limited.loc[df_limited['layers']==index_delta1lin]['PH_theta'].values[0]
            alpha_diss =  Pm_theta/(Pm_theta + PH_theta)   ## should be the same as alpha_Pm_equi

##############Hrms for doubly grafted
            z = np.genfromtxt(pro_file_name, delimiter='\t', skip_header=1, usecols=[0]) ## units of layers
            phi_double = np.genfromtxt(pro_file_name, delimiter='\t', skip_header=1, usecols=[5]) # correct?
            theta_double = get_column_contents(kal_file, 'mol : poly : theta')[index_delta1lin]   ## amount of polymer, select the correct line in the kal file
            print("theta double ", theta_double)
            dz1=1 # units of layers
            den = np.sum(phi_double*dz1)
            assert(abs(den-theta_double) < 0.001)
            num2 = np.sum((z**2)*phi_double*dz1)
            Hrms_double = (num2/den)**(1/2)

############single grafted
            kal_file_single = f"./kal_files/flat_surf_pol_cr_brush_NP={Np}_Csalt={Csalt}_M_pH={pH}_Sigma={sigma_p}_mol_nm2_ChiPS={ChiPS}_Israels.kal"  #one line kal file
            file_name_single = f"./pro_files/flat_surface_and_pol_cr_brush_NP={Np}_Csalt={Csalt}_M_pH={pH}_Sigma={sigma_p}_mol_nm2_ChiPS={ChiPS}_fig4.pro"
            z_single = get_column_contents(file_name_single, 'layer') 
            phi_single = get_column_contents(file_name_single, 'mol : poly : phi') 
            theta_single = get_column_contents(kal_file_single, 'mol : poly : theta')
            dz1=1 # units of layers
            den = np.sum(phi_single*dz1)
            print("theta single ", theta_single, den)
            assert(abs(den-theta_single) < 0.001)
            num2 = np.sum((z_single**2)*phi_single*dz1)
            Hrms_single = (num2/den)**(1/2)
        else:
            print(f"Skipping file: {kal_file} (not found in folder)")

    return {
        'geometry': geometry,
        'sigma_p': sigma_p,
        'sigma_f': sigma_f,
        'pH': pH,
        'Csalt': Csalt,
        'Np': Np,
        'b': b,
        'Hrms_single': Hrms_single,
        'Hrms_double': Hrms_double,
        'delta1lin' : delta1lin,
        'n_layers_min' : index_delta1lin,
        "alpha pm equi" : alpha_Pm_equi,
        "alpha PH equi" : alpha_PH_equi,
    }

# Parameters setup
geometry = 'flat'
Csalt_range = [0.1, 0.01, 0.001,  0.0001, 0.00001] # Israels flat
pH_range = [6.0,7.0,8.0,9.0]
sigma_f = 0 # /nm^2
author="Israels"
Np = 250
sigma_p = 0.0056
ChiPS=0
b = 0.6e-9
results = []

for Csalt,pH in product(Csalt_range,pH_range):
    new_entry = get_data(geometry, sigma_p, sigma_f, pH, Csalt, Np, b, ChiPS, author)
    results.append(new_entry.values())
df = pd.DataFrame(results, columns=new_entry.keys())
# Save to Excel
excel_filename = 'comp_results_'+geometry+'_Hrms.xlsx'
df.to_excel(excel_filename, index=False)
print(f'Results saved to {excel_filename}')


