import numpy as np
import os
import shutil
import pandas as pd
import matplotlib.pyplot as plt
import datetime
from itertools import cycle
from itertools import product
from collections import defaultdict
import scipy.interpolate as sc

T=298 # temperature [K]
kb=1.380649*10**(-23) # Boltzmann_constant [J⋅K−1]
Nav= 6.02214076*10**23 # Avogadro's number [mol-1]

def get_column_contents(file_path, column_name):
    # Read the file into a DataFrame
    df = pd.read_csv(file_path, sep='\t', lineterminator='\n')
    
    # Check if the column exists
    if column_name not in df.columns:
        raise ValueError(f'Column {column_name} not found in the file.')
    
    # Return the contents of the column
    # return np.flip(df[column_name].values)
    return df[column_name].values

def get_data(geometry, sigma_p, sigma_f, pH, Csalt, Np, b, ChiPS, author):
    if geometry == 'cylindrical':
        print("wrong geometry, we are comparing with flat")  
### first look for the energy minimum in the kal files 
    elif geometry == 'flat':
########### double grafted 
        kal_file = f"./kal_files/flat_surface_and_pol_cr_brush_NP={Np}_Csalt={round(Csalt,6)}_M_pH={pH}_Sigma={sigma_p}_mol_nm2_ChiPS={ChiPS}_fig4.kal" 
        Pm_theta =  get_column_contents(kal_file, 'state : Pm : theta')[0]
        PH_theta =  get_column_contents(kal_file, 'state : PH : theta')[0]
        alpha_diss =  Pm_theta/(Pm_theta + PH_theta)

        return {
        'geometry': geometry,
        'sigma_p': sigma_p,
        'sigma_f': sigma_f,
        'pH': pH,
        'Csalt': Csalt,
        'Np': Np,
        'b': b,
        "pm theta" : Pm_theta,
        "PH theta" : PH_theta,
        "alpha diss" : alpha_diss
    }

# Parameters setup
geometry = 'flat'
Csalt_range = np.logspace(-5,-1,13)
pH_range = [6.0,7.0,8.0,9.0]
sigma_f = 0 # /nm^2
author="Israels"
Np = 250
sigma_p = 0.0056
ChiPS=0
b = 0.6e-9
results = []

for Csalt,pH in product(Csalt_range,pH_range):
    new_entry = get_data(geometry, sigma_p, sigma_f, pH, Csalt, Np, b, ChiPS, author)
    results.append(new_entry.values())
df = pd.DataFrame(results, columns=new_entry.keys())
# Save to Excel
excel_filename = 'comp_results_'+geometry+'_alpha.xlsx'
df.to_excel(excel_filename, index=False)
print(f'Results saved to {excel_filename}')
