This README_code.md file was generated on 2025-07-02 by Lucas Spierenburg

# GENERAL INFORMATION

1. Title of Dataset: Urban Fragmentation Analysis Code

2. Author Information
    A. Principal Investigator Contact Information
        Name: Lucas Spierenburg
        Institution: TU Delft
        Address: 
        Email: l.j.spierenburg@tudelft.nl

# RECOMMENDED HARDWARE

1. Processor: Intel® Core™ i7 or equivalent
2. RAM: 16 GB of RAM (DDR4)
3. GPU: Not required for this analysis
4. Storage: 100+ GB free space for intermediate data files

# RECOMMENDED OPERATING SYSTEM

Linux (Ubuntu 22.04 or similar), macOS

# REQUIRED VERSION OF PYTHON

3.12.9

# REQUIRED LIBRARIES USED

See environment.yml for complete dependency list. Key libraries include:
- geopandas 1.0.1
- pandas 2.2.2  
- numpy 2.2.4
- scipy 1.15.2
- scikit-learn 1.6.1
- shapely 2.1.0
- rasterio 1.4.3
- pyproj 3.7.1
- networkx 3.4.2
- matplotlib 3.10.1

Install with: `conda env create -f environment.yml`

# EXTRA FILES

script_order.md specifies the execution sequence of analysis scripts.

# SEQUENCE OF SCRIPTS

1. perimeter_study.py - Define urban perimeters for Functional Urban Areas
2. extract_pbf.py - Extract infrastructure barriers from OpenStreetMap data
3. demographic_preprocess.py - Process population demographics by origin
4. coef_variance.py - Calculate demographic variance coefficients
5. adjacency_matrix.py - Build spatial adjacency matrices
6. proximity_table.py - Generate proximity relationships
7. build_covariance_matrix.py - Build demographic covariance matrices
8. build_urban_fragments.py - Identify urban fragments after removing barriers
9. generate_synthetic.py - Generate synthetic demographic distributions
10. moving_average.py - Apply spatial smoothing to demographic indicators
11. regionalization.py - Perform hierarchical clustering of demographic regions
12. overlap_analysis.py - Analyze spatial overlap patterns
13. merge_data.py - Combine all processed datasets
14. measure_city_indicators.py - Calculate final city-level fragmentation metrics

# DATA REQUIREMENTS

Input data should be placed in:
- `../data/raw/demographics/` - European population grid data by country
- `../data/raw/osm/` - OpenStreetMap PBF files for each country

The scripts will create processed data in `../data/processed/` subdirectories.

# LICENSE FOR THE CODE

MIT License

Copyright (c) 2025 Lucas Spierenburg

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.