
clear all, close all;

% import data from csv files to plot slip length profiles for different a =
% H/L

% in case of a = H/L
a = [1 1.25 1.5 2 2.5 3 4 5 6 8 10];
e = 0.500;

figurefile = ['comsol_sliplength_a_e' '\' 'comsol_sliplength_a'];

nt = length(a);
for j = 1:nt
    filename{j} = ['comsol_sliplength_a_e/sliplength_a' num2str(a(j)) '_e0' num2str(1000*e) '_highres'];
    csvfile = [filename{j} '.csv'];
    M = csvread(csvfile,8,0); % start reading from cell (9,0), numbering is zero-based
    theta(j,:) = M(:,1);
    b_Rg(j,:) = M(:,2);
end

% compute slip length profile for analytical solution of Davis and Lauga
theta_anal=-pi/3:1/180*pi:pi/2;
n = length(theta_anal);

% analytical model from Davis and Lauga, Phys. Fluids (2009)
for j=1:n
    f = @(s) s./(sinh(2.*s.*(pi-theta_anal(j)))+s.*sin(2.*theta_anal(j)))...
            .*(cos(2*theta_anal(j))+(s.*sin(2.*theta_anal(j)).*cosh(s.*pi)+sinh(s.*(pi-2.*theta_anal(j))))./sinh(s.*pi));
    b(j) = pi.*e.*integral(f,0,120);
end

% find maxima of numerical profiles
for j = 1:nt
    indexmax(j) = find(max(b_Rg(j,:)) == b_Rg(j,:));
    thetamax(j) = theta(j,indexmax(j));
    b_Rg_max(j) = b_Rg(j,indexmax(j));
end

% plot figures
map=cbrewer('seq','OrRdBlGr',nt);
mm = 0;

% plot slip length
mm = mm + 1;
figure(mm)
hold on;
for j=1:nt
    h(j)=plot(theta(j,:),b_Rg(j,:),'color',map(j,:),'marker','o','LineStyle','none');
    legendentries{j} = ['a = ' num2str(a(j))];
end
h(nt+1)=plot(theta_anal./pi.*180,b,'-k');
legendentries{nt+1} = ['anal. sol.'];
hold off
xlim([min(theta_anal./pi.*180) 90])
box on
legend(legendentries,'location','SouthWest');
legend('boxoff');
ylabel('2b/L_g')
xlabel('\theta')
title(['Slip length as function of protrusion angle for \epsilon = ' num2str(e)])

%cleanfigure;
tikzfile = [figurefile '.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');

mm = mm + 1;
figure(mm)
plot(a,thetamax,'o','color',[0.15294,0.26275,0.53725])
ylim([0 15])
legend('boxoff');
ylabel('\vartheta_{opt} [deg]')
xlabel('a')
title('\epsilon = 1/2')
tikzfile = ['comsol_sliplength_a_e' '\' 'theta_optimal_a' '.tikz'];
matlab2tikz(tikzfile, 'height', '\figureheight', 'width', '\figurewidth');