# -*- coding: utf-8 -*-
"""
Created on Wed Mar 22 13:51:39 2023

@author: necjgerzinic
"""

import pandas as pd
import numpy as np
import biogeme.database as db
import biogeme.biogeme as bio
from biogeme.expressions import Beta, log, PanelLikelihoodTrajectory
import biogeme.models as models
import biogeme.messaging as msg

df = pd.read_csv("formatted_dataset.csv",sep=',', engine='python')

database = db.Database('Access',df)
globals().update(database.variables)
database.panel('Respondent')

# Set seed
np.random.seed(0)
# Startsets for parameters
classes = 3 # actually 4, but one in class membership is fixed to 0
param=50
sets = 10

startset = np.random.uniform(-1,1,size=(sets,param))
probset  = np.random.uniform(-1,1,size=(classes,sets,param))

# Initialize two dictionaries and final LL list, to store outcomes of all the models
param_set = {}
stat_set  = {}
log_list  = []

for s in range(sets):
    # Classes 1 and 2
    # ASCs
    ASC_CAR_12  = Beta('ASC_CAR_12', startset[s,0], None,None,0)
    ASC_PT_12   = Beta('ASC_PT_12',  startset[s,1], None,None,0)
    ASC_PRIV_12 = Beta('ASC_PRI_12', startset[s,2], None,None,0)
    ASC_SHAR_12 = Beta('ASC_SHA_12', startset[s,3], None,None,0)
    ASC_FAR_12  = Beta('ASC_FAR_12', startset[s,4], None,None,0)
    # Access leg parameters
    B_TIME_12  = Beta('B_TIME_12',   startset[s,5], None,None,0)
    B_WALK_12  = Beta('B_WALK_12',   startset[s,6], None,None,0)
    B_WAIT_12  = Beta('B_WAIT_12',   startset[s,7], None,None,0)
    B_OVT_12   = Beta('B_OVT_12',    startset[s,8], None,None,0)
    # Train leg parameters
    T_TIME_12  = Beta('T_TIME_12',   startset[s,9], None,None,0)
    T_FREQ_12  = Beta('T_FREQ_12',   startset[s,10],None,None,0)
    T_TRAN_12  = Beta('T_TRAN_12',   startset[s,11],None,None,0)
    # Joint parameters
    G_COST_12  = Beta('G_COST_12',   startset[s,12],None,None,0)
    
    # Classes 3 and 4
    # ASCs
    ASC_CAR_34  = Beta('ASC_CAR_34', startset[s,13],None,None,0)
    ASC_PT_34   = Beta('ASC_PT_34',  startset[s,14],None,None,0)
    ASC_PRIV_34 = Beta('ASC_PRI_34', startset[s,15],None,None,0)
    ASC_SHAR_34 = Beta('ASC_SHA_34', startset[s,16],None,None,0)
    ASC_FAR_34  = Beta('ASC_FAR_34', startset[s,17],None,None,0)
    # Access leg parameters
    B_TIME_34  = Beta('B_TIME_34',   startset[s,18],None,None,0)
    B_WALK_34  = Beta('B_WALK_34',   startset[s,19],None,None,0)
    B_WAIT_34  = Beta('B_WAIT_34',   startset[s,20],None,None,0)
    B_OVT_34   = Beta('B_OVT_34',    startset[s,21],None,None,0)
    # Train leg parameters
    T_TIME_34  = Beta('T_TIME_34',   startset[s,22],None,None,0)
    T_FREQ_34  = Beta('T_FREQ_34',   startset[s,23],None,None,0)
    T_TRAN_34  = Beta('T_TRAN_34',   startset[s,24],None,None,0)
    # Joint parameters
    G_COST_34  = Beta('G_COST_34',   startset[s,25],None,None,0)
    
    # Utility functions for classes 1 and 2
    V10_12 =               G_COST_12 * ntc + T_TIME_12 * ntt + T_FREQ_12 * ntf + T_TRAN_12 * nto    
    V20_12 = ASC_FAR_12  + G_COST_12 * ftc + T_TIME_12 * ftt + T_FREQ_12 * ftf + T_TRAN_12 * fto    
     
    V11_12 = V10_12 +               G_COST_12 * nbc + B_TIME_12 * nbt + B_WALK_12 * nbw            
    V12_12 = V10_12 + ASC_CAR_12  + G_COST_12 * ncc + B_TIME_12 * nct + B_WALK_12 * ncw            
    V13_12 = V10_12 + ASC_PT_12   + G_COST_12 * nmc + B_TIME_12 * nmt + B_OVT_12  * nmw
    V14_12 = V10_12 + ASC_PRIV_12 + G_COST_12 * npc + B_TIME_12 * npt + B_WAIT_12 * npw            
    V15_12 = V10_12 + ASC_SHAR_12 + G_COST_12 * nsc + B_TIME_12 * nst + B_WAIT_12 * nsw            
    
    V21_12 = V20_12 +               G_COST_12 * fbc + B_TIME_12 * fbt + B_WALK_12 * fbw           
    V22_12 = V20_12 + ASC_CAR_12  + G_COST_12 * fcc + B_TIME_12 * fct + B_WALK_12 * fcw     
    V23_12 = V20_12 + ASC_PT_12   + G_COST_12 * fmc + B_TIME_12 * fmt + B_OVT_12  * fmw          
    V24_12 = V20_12 + ASC_PRIV_12 + G_COST_12 * fpc + B_TIME_12 * fpt + B_WAIT_12 * fpw           
    V25_12 = V20_12 + ASC_SHAR_12 + G_COST_12 * fsc + B_TIME_12 * fst + B_WAIT_12 * fsw       
    
    # Utility functions for classes 3 and 4
    V10_34 =               G_COST_34 * ntc + T_TIME_34 * ntt + T_FREQ_34 * ntf + T_TRAN_34 * nto    
    V20_34 = ASC_FAR_34  + G_COST_34 * ftc + T_TIME_34 * ftt + T_FREQ_34 * ftf + T_TRAN_34 * fto    
     
    V11_34 = V10_34 +               G_COST_34 * nbc + B_TIME_34 * nbt + B_WALK_34 * nbw            
    V12_34 = V10_34 + ASC_CAR_34  + G_COST_34 * ncc + B_TIME_34 * nct + B_WALK_34 * ncw            
    V13_34 = V10_34 + ASC_PT_34   + G_COST_34 * nmc + B_TIME_34 * nmt + B_OVT_34  * nmw
    V14_34 = V10_34 + ASC_PRIV_34 + G_COST_34 * npc + B_TIME_34 * npt + B_WAIT_34 * npw            
    V15_34 = V10_34 + ASC_SHAR_34 + G_COST_34 * nsc + B_TIME_34 * nst + B_WAIT_34 * nsw            
    
    V21_34 = V20_34 +               G_COST_34 * fbc + B_TIME_34 * fbt + B_WALK_34 * fbw           
    V22_34 = V20_34 + ASC_CAR_34  + G_COST_34 * fcc + B_TIME_34 * fct + B_WALK_34 * fcw     
    V23_34 = V20_34 + ASC_PT_34   + G_COST_34 * fmc + B_TIME_34 * fmt + B_OVT_34  * fmw          
    V24_34 = V20_34 + ASC_PRIV_34 + G_COST_34 * fpc + B_TIME_34 * fpt + B_WAIT_34 * fpw           
    V25_34 = V20_34 + ASC_SHAR_34 + G_COST_34 * fsc + B_TIME_34 * fst + B_WAIT_34 * fsw    
    
    
    V_12 = {11: V11_12,   12: V12_12, 13: V13_12,   14: V14_12,   15: V15_12,   21: V21_12,   22: V22_12, 23: V23_12,   24: V24_12,   25: V25_12}
    V_34 = {11: V11_34,   12: V12_34, 13: V13_34,   14: V14_34,   15: V15_34,   21: V21_34,   22: V22_34, 23: V23_34,   24: V24_34,   25: V25_34}
    av  =  {11: other_av, 12: CAR_AV, 13: other_av, 14: other_av, 15: other_av, 21: other_av, 22: CAR_AV, 23: other_av, 24: other_av, 25: other_av}
    
    # Specify nest parameters
    # mu approaches 10 -> all alternatives within the nest are fully correlated; they act like a single alternative
    # mu approaches 1  -> all alternatives within the nest are uncorrelated; they act like independent alternatives
    
    # Nesting structure for classe 1 and 3 (mode choice first)
    MU_BIKE_1 = Beta('MU_BIKE_1',startset[s,26], 1,10,0)
    MU_CAR_1  = Beta('MU_CAR_1', startset[s,27], 1,10,0)
    MU_PT_1   = Beta('MU_PT_1',  startset[s,28], 1,10,0)
    MU_PRIV_1 = Beta('MU_PRIV_1',startset[s,29], 1,10,0)
    MU_SHAR_1 = Beta('MU_SHAR_1',startset[s,30], 1,10,0)
    
    bike_1 = MU_BIKE_1, [11,21]
    car_1  = MU_CAR_1 , [12,22]
    pt_1   = MU_PT_1  , [13,23]
    priv_1 = MU_PRIV_1, [14,24]
    shar_1 = MU_SHAR_1, [15,25]
    nests_mode_1 = bike_1, car_1, pt_1, priv_1, shar_1
    
    # Nesting structure for classe 2 and 4 (station choice first)
    MU_NEAR_2 = Beta('MU_NEAR_2',startset[s,31], 1,10,0)
    MU_FAR_2  = Beta('MU_FAR_2', startset[s,32], 1,10,0)
    
    near_2 = MU_NEAR_2, [11,12,13,14,15]
    far_2  = MU_FAR_2,  [21,22,23,24,25]
    nests_station_2 = near_2, far_2     
    
    # Nesting structure for classe 1 and 3 (mode choice first)
    MU_BIKE_3 = Beta('MU_BIKE_3',startset[s,33], 1,10,0)
    MU_CAR_3  = Beta('MU_CAR_3', startset[s,34], 1,10,0)
    MU_PT_3   = Beta('MU_PT_3',  startset[s,35], 1,10,0)
    MU_PRIV_3 = Beta('MU_PRIV_3',startset[s,36], 1,10,0)
    MU_SHAR_3 = Beta('MU_SHAR_3',startset[s,37], 1,10,0)
    
    bike_3 = MU_BIKE_3, [11,21]
    car_3  = MU_CAR_3 , [12,22]
    pt_3   = MU_PT_3  , [13,23]
    priv_3 = MU_PRIV_3, [14,24]
    shar_3 = MU_SHAR_3, [15,25]
    nests_mode_3 = bike_3, car_3, pt_3, priv_3, shar_3
    
    # Nesting structure for classe 2 and 4 (station choice first)
    MU_NEAR_4 = Beta('MU_NEAR_4',startset[s,38], 1,10,0)
    MU_FAR_4  = Beta('MU_FAR_4', startset[s,39], 1,10,0)
    
    near_4 = MU_NEAR_4, [11,12,13,14,15]
    far_4  = MU_FAR_4,  [21,22,23,24,25]
    nests_station_4 = near_4, far_4  
    
    # The choice model is a discrete mixture of logit, with availability conditions
    # We calculate the conditional probability for each class
    prob_1 = PanelLikelihoodTrajectory(models.nested(V_12, av, nests_mode_1,    Choice))
    prob_2 = PanelLikelihoodTrajectory(models.nested(V_12, av, nests_station_2, Choice))
    prob_3 = PanelLikelihoodTrajectory(models.nested(V_34, av, nests_mode_3,    Choice))
    prob_4 = PanelLikelihoodTrajectory(models.nested(V_34, av, nests_station_4, Choice))

    # Class membership model
      
    Z_CLASS_AGE =       [Beta(f'Z_CLASS_AGE{c}',      probset[c,s,1], None,None,0) for c in range(classes)]      
    Z_CLASS_EDU =       [Beta(f'Z_CLASS_EDU{c}',      probset[c,s,2], None,None,0) for c in range(classes)] 
    Z_CLASS_URB =       [Beta(f'Z_CLASS_URB{c}',      probset[c,s,3], None,None,0) for c in range(classes)] 
    Z_CLASS_INC =       [Beta(f'Z_CLASS_INC{c}',      probset[c,s,4], None,None,0) for c in range(classes)] 
    Z_CLASS_INC_no =    [Beta(f'Z_CLASS_INC_no{c}',   probset[c,s,5], None,None,0) for c in range(classes)] 
    Z_CLASS_SE_use =    [Beta(f'Z_CLASS_SE_use{c}',   probset[c,s,6], None,None,0) for c in range(classes)] 
    Z_CLASS_TRAVEL =    [Beta(f'Z_CLASS_TRAVEL{c}',   probset[c,s,7], None,None,0) for c in range(classes)] 
    Z_CLASS_SE_pos =    [Beta(f'Z_CLASS_SE_pos{c}',   probset[c,s,8], None,None,0) for c in range(classes)] 
    Z_CLASS_DIGI_no =   [Beta(f'Z_CLASS_DIGI_no{c}',  probset[c,s,9], None,None,0) for c in range(classes)] 
    Z_CLASS_TT_use =    [Beta(f'Z_CLASS_TT_use{c}',   probset[c,s,10],None,None,0) for c in range(classes)] 
    Z_CLASS_DRT_no =    [Beta(f'Z_CLASS_DRT_no{c}',   probset[c,s,11],None,None,0) for c in range(classes)] 
    Z_CLASS_CAR_OWN =   [Beta(f'Z_CLASS_CAR_OWN{c}',  probset[c,s,12],None,None,0) for c in range(classes)]        
    Z_CLASS_CAR_USE =   [Beta(f'Z_CLASS_CAR_USE{c}',  probset[c,s,13],None,None,0) for c in range(classes)] 
    Z_CLASS_TRAIN_USE = [Beta(f'Z_CLASS_TRAIN_USE{c}',probset[c,s,14],None,None,0) for c in range(classes)] 
    Z_CLASS_BTM_USE =   [Beta(f'Z_CLASS_BTM_USE{c}',  probset[c,s,15],None,None,0) for c in range(classes)] 
    Z_CLASS =           [Beta(f'Z_CLASS{c}',          probset[c,s,16],None,None,0) for c in range(classes)]   
    
    W = [(Z_CLASS[c] +
          Z_CLASS_AGE[c]       * AGE + 
          Z_CLASS_URB[c]       * STED_GM +
          Z_CLASS_EDU[c]       * EDU + 
          Z_CLASS_INC[c]       * INC + 
          Z_CLASS_INC_no[c]    * INC_no +
          Z_CLASS_CAR_USE[c]   * CAR +
          Z_CLASS_TRAIN_USE[c] * TRAIN +
          Z_CLASS_BTM_USE[c]   * BTM +
          Z_CLASS_CAR_OWN[c]   * HHAUTO_N +
          Z_CLASS_TRAVEL[c]    * F_sustainable_travel +
          Z_CLASS_SE_use[c]    * F_SE_novice + 
          Z_CLASS_SE_pos[c]    * F_SE_positive + 
          Z_CLASS_DIGI_no[c]   * F_digitally_challenged +
          Z_CLASS_TT_use[c]    * F_TT_use +
          Z_CLASS_DRT_no[c]    * F_DRT_averse
          ) for c in range(classes)]
    
    W3 = 0

    probClass1 = models.logit({1:W[0],2:W[1],3:W[2],4:W3},None,1)
    probClass2 = models.logit({1:W[0],2:W[1],3:W[2],4:W3},None,2)
    probClass3 = models.logit({1:W[0],2:W[1],3:W[2],4:W3},None,3)
    probClass4 = models.logit({1:W[0],2:W[1],3:W[2],4:W3},None,4)

    probIndiv = probClass1 * prob_1 + probClass2 * prob_2 + probClass3 * prob_3 + probClass4 * prob_4
        
    # We integrate over the random variables using Monte-Carlo
    logprob = log(probIndiv)
    
    # Define level of verbosity
    logger = msg.bioMessage()
    logger.setGeneral()
    
    biogeme  = bio.BIOGEME(database,logprob)
    biogeme.modelName = 'model_start_set_' + str(s)
    biogeme.generatePickle = False
    biogeme.saveIterations = False
    biogeme.generateHtml = True
    results = biogeme.estimate()
    param_set[s] = results.getEstimatedParameters()
    stat_set[s]  = pd.DataFrame(data=results.getGeneralStatistics()).transpose()
    log_list.append(pd.DataFrame(data=results.getGeneralStatistics()).loc[0,'Final log likelihood'])
    
# Find the iteration set with the highest final LL 
best_set =   log_list.index(max(log_list))
parameters = param_set[best_set]
stats =      stat_set[best_set]






