clear
% this example is based on the data from paper:Zhou et al., 2022 Marine Geology  (https://doi.org/10.1016/j.margeo.2022.106946) 
load Hs
load WL
Depth=WL
load Tp

OBS_1=0   % need to input the distances between each observation stations 
OBS_2=140
OBS_3=OBS_2+130.1
OBS_4=OBS_3+45.8

X=[OBS_1 OBS_2 OBS_3 OBS_4]  % there are 5 stations in total, but the most seaward one is on bare flat, so only use the rest 4 stations.

%% select incident  0.1<Hs<0.2 to built the predictor
Hs_in=Hs(:,4);

ind=find(Hs_in<0.10 | Hs_in>0.20 ); % remove all the data out of this range [0.1<Hs<0.2]
  Tp(ind,:)=[];
  Depth(ind,:)=[];
  Hs(ind,:)=[];

  Tp= Tp(:,4)
  Depth=Depth(:,4)
  Hs=Hs(:,1:4)
  
  L_num=floor(OBS_4/5)   % number of wavelength to be considered, assume the smallest wavelenght is 5 meter
  
%%

for i=1:length(Tp)
   
   Hs_temp=Hs(i,:)/Hs(i,4)
   Hs_temp=fliplr(Hs_temp)
   [fitresult, gof(i)] = createFit1(X, Hs_temp)
   beta(i)=coeffvalues(fitresult)

   k(i)=disper(2*pi./Tp(i),Depth(i)) 
   L(i)=2*pi./k(i)
   Ur(i)=Hs(i,1).*L(i).^2/(Depth(i).^3)
   
   for j=1:L_num
     KLn(j,i)=1/(1+beta(i)*L(i)*j)
   end

end

%%

load Hs
load WL
Depth=WL
load Tp

Hs_in=Hs(:,4);
% ind=find(Hs_3<0.05 | Hs(:,1)<0.01 | Tp(:,1)>7)
ind=find( Hs_in<=0.20 );  % remove all the data out of this range [Hs<0.2], only predict the high wave cases
  Tp(ind,:)=[];
  Depth(ind,:)=[];
  Hs(ind,:)=[];

  Tp= Tp(:,4)
  Depth=Depth(:,4)
  Hs=Hs(:,1:4)

  for p=1:length(Tp)
      L=2*pi/disper(2*pi/Tp(p),Depth(p))
      Ur_big(p)=Hs(p,4)*L^2/Depth(p)^3
      if  Ur_big(p)>max(Ur)
          MM(p,1:3)=NaN
      else
      [KLm]=HU_method_Hs(KLn,Ur,Hs(p,4),OBS_4, Tp(p), Depth(p))  % this function is the main function of calculation
      MM(p,1)=KLm   
      
     [KLm]=HU_method_Hs(KLn,Ur,Hs(p,4),OBS_3, Tp(p), Depth(p))
      MM(p,2)=KLm 
      
      [KLm]=HU_method_Hs(KLn,Ur,Hs(p,4),OBS_2, Tp(p), Depth(p))
      MM(p,3)=KLm 
      end
      
      Ob(p,1:3)=Hs(p,1:3)/Hs(p,4)
 
  end
  
  MM_all=reshape(MM,[],1)
  Ob_all=reshape(Ob,[],1)
  
  plot(MM_all,Ob_all,'+');hold on
  plot([0 1],[0 1])

  R=1-nansum((MM_all-Ob_all).^2)/nansum((mean(Ob_all)-Ob_all).^2)

 RMSE = (nanmean((MM_all-Ob_all).^2))^0.5


