from matplotlib import pyplot as plt
import numpy as np

dataset = '103'

if dataset == '089':
    porecounts = [0.91527,0.91998,0.9188,0.91998,0.91792,0.91536,0.91851,0.91517,0.91635,0.91753,0.91713,0.91645,0.9188,0.91812,0.91871,0.919,
                  0.919,0.91851,0.92038,0.91939,0.91821,0.92107,0.92146,0.92028,0.91989,0.92116,0.92116,0.92146,0.92293,0.92175,0.91782,0.92156,
                  0.91753,0.92519,0.92057,0.92352,0.91939,0.92225,0.92185,0.92411,0.91949,0.92215,0.92166,0.92195,0.92283,0.92254,0.92038,0.9189]
    throatcounts = [0.92848,0.93187,0.93103,0.93121,0.9295,0.92775,0.92932,0.92764,0.92855,0.93034,0.9303,0.92702,0.92997,0.93027,0.93034,0.9322,
                    0.93089,0.93045,0.93351,0.93216,0.93045,0.93213,0.93235,0.93289,0.93165,0.93231,0.93289,0.93315,0.93381,0.93329,0.9287,0.9314,
                    0.92954,0.93589,0.93304,0.93516,0.93038,0.93457,0.93286,0.93468,0.9322,0.93413,0.93337,0.93417,0.93381,0.93508,0.93016,0.92979]
    pore_min = 0.82427
    throat_min = 0.82105
elif dataset == '100':
    porecounts = [0.92752, 0.92552, 0.93151, 0.92769, 0.93091, 0.93021, 0.93151, 0.92925, 0.93091, 0.9323, 0.93108, 0.92969, 0.93125, 0.93351,
                0.93169, 0.93343, 0.93395, 0.93082, 0.92917, 0.93073, 0.92891, 0.92882, 0.92656, 0.92917, 0.93099, 0.93056, 0.92925, 0.92595,
                0.9283, 0.93082, 0.92943, 0.92778, 0.92899, 0.93091, 0.92952, 0.92986, 0.93056, 0.92595, 0.93047, 0.92882, 0.92821, 0.93056,
                0.93143, 0.9303, 0.93212, 0.92812, 0.92934, 0.93221]
    throatcounts = [0.92122, 0.91752, 0.92606, 0.9218, 0.92657, 0.92569, 0.92685, 0.92474, 0.92621, 0.92661, 0.92667, 0.92544, 0.92719, 0.93107,
                    0.92639, 0.92908, 0.92951, 0.92612, 0.92465, 0.92645, 0.92318, 0.9241, 0.92193, 0.92569, 0.92651, 0.92554, 0.92263, 0.92141,
                    0.92125, 0.9263, 0.92691, 0.92346, 0.9244, 0.92685, 0.92459, 0.92584, 0.92612, 0.92021, 0.92535, 0.92394, 0.923, 0.92642,
                    0.92682, 0.9256, 0.92774, 0.92214, 0.92422, 0.9274]
    pore_min = 0.8164
    throat_min = 0.7773
elif dataset == '103':
    porecounts = [0.89432, 0.89181, 0.89553, 0.89286, 0.89391, 0.89424, 0.89213, 0.89076, 0.89084, 0.89003, 0.89157, 0.89108, 0.89108, 0.88801,
                  0.88744, 0.89189, 0.89302, 0.89149, 0.89165, 0.89108, 0.89181, 0.8859, 0.8906, 0.89213, 0.88922, 0.89116, 0.88801, 0.89238,
                  0.88793, 0.8906, 0.88785, 0.88938, 0.8872, 0.88704, 0.88882, 0.89375, 0.89116, 0.8893, 0.89133, 0.89116, 0.88979, 0.8923,
                  0.88671, 0.89035, 0.88963, 0.89173, 0.88857, 0.8855]
    throatcounts = [0.90321, 0.90179, 0.90522, 0.90396, 0.90509, 0.90561, 0.90133, 0.8992, 0.90137, 0.90101, 0.90337, 0.89887, 0.8992, 0.89651,
                    0.89729, 0.90082, 0.90137, 0.90007, 0.90214, 0.89904, 0.90101, 0.89427, 0.89897, 0.90159, 0.89936, 0.89991, 0.8969, 0.90127,
                    0.8969, 0.89735, 0.8968, 0.89703, 0.89596, 0.89615, 0.89768, 0.9038, 0.89936, 0.89612, 0.90114, 0.90052, 0.90017, 0.90078,
                    0.89518, 0.89972, 0.897, 0.9014, 0.89836, 0.89379]
    pore_min = 0.77058
    throat_min = 0.74073

porecounts = np.array(porecounts) * 100
throatcounts = np.array(throatcounts) * 100
num_v = len(porecounts)
timesteps= range(1, num_v + 1)
pore_min = np.ones(num_v) * pore_min * 100
throat_min = np.ones(num_v) * throat_min * 100

fontsize = 12
labelsize=fontsize

fig, ax1 = plt.subplots(figsize=(8, 4))
ax1.plot(timesteps, porecounts, color='black', linestyle='solid', label='pores')
ax1.plot(timesteps, throatcounts, color='red', linestyle='dashed', label='throats')
ax1.plot(timesteps, pore_min, color='black', linestyle='dotted')
ax1.plot(timesteps, throat_min, color='red', linestyle='dashdot')
ax1.annotate('always filled pores', xy=(4, pore_min[0]-0.9), xytext=(0, 5), textcoords='offset points', fontsize=fontsize, bbox=dict(fc='w'))
ax1.annotate('always filled throats', xy=(30, throat_min[0]-0.9), xytext=(0, 5), textcoords='offset points', fontsize=fontsize, bbox=dict(fc='w'))

ax1.set_ylabel('$N_i / N_{i,max}$ in %', fontsize=fontsize)
y_min = np.floor(np.min([pore_min, throat_min]) - 2)+0.5
ax1.set_ylim(y_min, 100.5)
# ax1.set_ylim(76.5, 100.5)
ax1.tick_params(labelsize=labelsize)
ax1.grid(True)

plt.legend(fontsize=fontsize)
plt.xlabel('timesteps', fontsize=fontsize)
plt.xlim([0.5, num_v+0.5])
plt.xticks(fontsize=labelsize)
plt.tight_layout()
 
#Save the figure
plt.savefig(f"network_analysis_{dataset}.png", dpi=600)
plt.show()