Type: Python scripts, data files, images
Funding: NWO DeepNL (DEEP.NL.2019.006)
Authors: S. Heijkoop, D. Rieder, M. Moura, M. Rücker, C. Spurin
Related publication: A Statistical Analysis of Fluid Interface Fluctuations: Exploring the Role of Viscosity Ratio, 2024, Entropy, 26, 774, DOI: 10.3390/e26090774
Keywords: multiphase flow, relative permeability, CO2 storage, fluid flow, carbon sequestration

** General Introduction **
This project worked on investigating three datasets with different viscosity ratio. This work starts by segmentating the datasets.
These datasets are then used to create 'fluctuation heatmaps' which are further analysed. The main goal is to quantify/explore the influence of viscosity ratio.
The viscosity ratios are M = 0.48, 0.69, 0.94 - the experimental data is denoted as 089, 100 and 103 respectively.
Be aware, this package was assembled with care, but we do not provide a guarantee of completeness. In case of questions or missing information,
please contact D. Rieder (d.r.rieder@tue.nl) or M. Rücker (m.ruecker@tue.nl)

This package contains the relevant scripts, data files and images of the publication
Following files are part of set:
- scripts: folder with Python scripts for image analysis
- data: CSV-files - extracted OpenPNM network and occupation analysis results

Note, that the raw CT images are not part of this package, due to size limitation. They are available at: [publication of data set at the Paul-Scherrer Institute ongoing, link to data will be provided in an updated version of the README]

Following external software was employed for the data evaluation:
- Python 3.10 with scikit-image v0.19.3
- DragonFly
- Jupyter Notebooks

** Description of scripts **
subfolder General:
- Calculating_Viscosity_Ratio: Script used to calculate the viscosity ratios.
- Cropping: Script to crop 3D images to the same size for the thesis/paper.
- Filtering_Segmented_Data: Script used to filter the segmentation data and also perform comparisons between filtering techniques.
- Ganglia size distribution: Script used to calculate and plot the ganglia size distribution.
- Heatmap Analysis: Script used to do calculations on the heatmap data. Create the scatter plots, 3D images, 2D heatmap images
- New_Heatmap_Code: Create the heatmaps and also the filtered heatmaps.
- Saturation Analysis: Calculate and save the saturation data as CSV. Also create the bar and scatter plot for saturation and number of ganglia.
- Timestep_Data: Combine DI + Flow segmentation data.

subfolder Segmentation:
- Matching: Script used to combine smaller 3D part segmentations into one full 3D region, due to memory limits. 
	- This resulted in an allignment issue with the three DI segmentations parts. 
	  This did not influence the non-wetting phase as it was already segmented on a device with larger memory capacity.
- Check the readme for more info on the scripts, these scripts were provided by Catherine Spuring. 

subfolder Euler:
- Minkowski_Timestep: Script used to calculate the Euler number for two connectivities over time and plot them. 
- The other scripts are also from Catherine and provide insight into how Euler can be calculated.

subfolder Occupation:
- OccupationAnalysis: conducts occupation analysis based on a time series of TIFF images
- TiffUtils: scripts for reading in tiff stacks, based on libtiff and numpy
- LabelByPhase: Labels the pore networks based on the files from the maximum ball method and TIFF images

subfolder Figures
This folder contains the scripts with raw data points and the subsequent plots as provided in the associated publication
- GangliaAndSaturation: Plot showing the development of ganglia count and average saturation over viscosity ratio (Figure 5)
- MobileFraction: Occupation analysis of the relative mobile fraction over viscosity ratio (Figure 14)
- NetworkAnalysis: Analysis of the associated pore networks (Figure 15)

** Description of data **
The CT-scans are not stored as part of this package due to size limitations, but may be retrieved from another repository: [link to PSI-repository will be provided in updated README]
- 089_labeled.csv:  OpenPNM network where each pore is labeled as belonging to phase 1 or 2, throats can be labeled as connecting only pores with 1 or 2, mixed connections are labeled as 1.5, viscosity ratio is M=0.94, timestep is 0 (Figure Appendix A.3)
- 089_occupation_analysis.csv:  results of occupation analysis for M=0.94 
- 100_occupation_analysis.csv:  results of occupation analysis for M=0.69
- 103_occupation_analysis.csv:  results of occupation analysis for M=0.48
