from matplotlib import pyplot as plt

M = [0.48, 0.69, 0.94]
Om_Savg = [33.229, 32.583, 30.867]
sigma_Savg = [0.309, 0.307, 0.127]
fontsize = 12
labelsize=fontsize

fig, ax1 = plt.subplots(figsize=(8, 4))
ax1.scatter(M, Om_Savg, color='black', marker='s')
ax1.errorbar(M, Om_Savg, yerr=sigma_Savg, fmt='_',markersize=4, capsize=5, elinewidth=1, capthick=1)
ax1.set_ylabel('$\Omega_f / S_{avg}$ in %', fontsize=fontsize)
ax1.set_ylim(30.5, 34)
ax1.tick_params(labelsize=labelsize)
ax1.grid(True)

plt.xlabel('Viscosity Ratio (M)', fontsize=fontsize)
plt.xlim([0.45, 1])
plt.xticks(fontsize=labelsize)
plt.tight_layout()
 
#Save the figure
plt.savefig("mobile_fraction.png", dpi=600)
plt.show()