from matplotlib import pyplot as plt

M = [0.48, 0.69, 0.94]
S_avg = [0.46766, 0.47668, 0.44182]
sigma_Savg = [0.00144, 0.00146, 0.000562]
N_ganglia = [652, 742, 180]
fontsize = 12
labelsize=fontsize

fig, ax1 = plt.subplots(figsize=(8, 4))
ax1.scatter(M, N_ganglia, color='red', marker='x', label='Ganglia')
ax1.set_ylabel('Number of Ganglia', fontsize=fontsize)
ax1.set_ylim(150, 850)
ax1.tick_params(labelsize=labelsize)
ax1.grid(True)
ax2 = ax1.twinx()
ax2.scatter(M, S_avg, color='blue', marker='s', s=5, label='Saturation')
ax2.errorbar(M, S_avg, yerr=sigma_Savg, fmt='_',markersize=4, capsize=5, elinewidth=1, capthick=1)
ax2.set_ylim(0.425, 0.495)
ax2.set_ylabel('Saturation NWP', fontsize=fontsize)
ax2.tick_params(labelsize=labelsize)

lines, labels = ax1.get_legend_handles_labels()
lines2, labels2 = ax2.get_legend_handles_labels()
ax2.legend(lines + lines2, labels + labels2, loc=0, fontsize=fontsize)
# ax2.legend.set_size(12)


# plt.scatter(M, N_ganglia)

plt.xlabel('Viscosity Ratio (M)', fontsize=fontsize)
# plt.ylabel('Number of Ganglia (-)', fontsize = 12)
plt.xlim([0.45, 1])
plt.xticks(fontsize=labelsize)
plt.tight_layout()
# plt.grid(True, axis='both')
# plt.legend(fontsize = 12)
 
#Save the figure
plt.savefig("NumGangliaAndSaturation.png")
plt.show()