***Impact Aware Robotics Archive***
===================================

***General Info***

Authors:
- C. Rey
- M. J. Jongeneel
- S. Dingemans

Title: Archive_015_PandaImpacts
Files:
- 230413_Archive_015_PandaImpactExperiments.h5
- README.md

Dynamics & Control Group, Faculty of Mechanical Engineering, Eindhoven University of Technology

Corresponding author: M.J. Jongeneel 

Contact Information: m.j.jongeneel@tue.nl

Eindhoven University of Technology - Faculty of Mechanical Engineering

P.O. Box 513 5600 MB Eindhoven The Netherlands

***General Introduction***

I.AM. archive as part of the Impact-Aware Robotics Archives Collection. This archive contains recordings of experiments where a Franka Emika Panda robot with a metal spherical end-effector is impacting a metal plate. The purpose of these experiments is to evaluate the limits of the robotic arm upon impact. The involved contact is between the robot and the environment, which in these recordings are a Franka Emika Panda robot and a metal plate (ImpactPlane002), respectively. All the recordings in the archive were performed at Franka Emika GmbH, Munich, Germany. More information about the dataset, the objects, and the environments used, can be found on https://impact-aware-robotics-database.tue.nl/.      

This archive is published accompanying the deliverable ``I.AM. - D1.1 - Publication of I.AM. dataset - v1.0``, see [https://i-am-project.eu/index.php/results/deliverables](https://i-am-project.eu/index.php/results/deliverables) for more info.
This research project has received funding from the European Union’s Horizon 2020 research and innovation program under grant agreement No. 871899.

***Test equipment***

The experiments involve impacting a plate (ImpactPlane002) with a Franka Emika Panda robot equipped with a spherical end-effector from different angles. The impacts happen under different angles and different speeds to test the limit of the robotic arm. The ultimate goal is to be able to predict the post-impact velocity of the robotic arm. Data was logged using a Nikon 1 J4 reference camera, and sensors from the Franka Emika robots such as joint encoders and torque sensors. Further details of the equipment are provided as metadata in each recording subfolder of the archive. 

***Description of the data in this archive***

This archive contains a total of 50 subfolders, each corresponding to a specific recording. Each folder follows the naming convention ``Rec_<timestamp>``, where the timestamp corresponds to the start time of the recording, expressed according to ISO 8601. The contents of these subfolders all have the same structure, which is described in the file called "recording_format".