theory Modest_MDP_index
  imports BitSet Graph_impl "../ds/SharedNat" "../lib/More_B_Assn"
begin



  abbreviation "small_array_assn A \<equiv> b_assn (IICF_Array.array_assn A) (\<lambda>xs. length xs < max_snat len_size_T)"

  text \<open>General\<close>

    lemma Id_list_set_rel: "\<langle>Id\<rangle>list_set_rel = {(xs, set xs) | xs. distinct xs}"
      unfolding list_set_rel_def
      apply(auto simp: br_def )
      done

    lemma Id_list_set_relI: "distinct xs \<Longrightarrow> X = set xs \<Longrightarrow> (xs, X) \<in> \<langle>Id\<rangle>list_set_rel"
      unfolding list_set_rel_def
      apply(auto simp: br_def )
      done

    lemma nth_to_list_all: "(\<And>i. i < length xs \<Longrightarrow> P (xs!i)) \<Longrightarrow> list_all P xs" 
      apply(induction xs rule: rev_induct)
      apply auto 
      apply (metis less_SucI nth_append_first)
      by (metis lessI nth_append_length)

    lemma list_all_to_nth: "list_all P xs \<Longrightarrow> i < length xs \<Longrightarrow> P (xs!i)" 
      apply(induction xs rule: rev_induct)
      apply auto 
      by (metis less_Suc_eq nth_append_first nth_append_length)

    lemma sum_list_butlast_last: "xs \<noteq> [] \<Longrightarrow> sum_list (butlast xs) + last xs = sum_list xs"
      apply(induction xs rule: rev_induct)
      by auto


  subsection \<open>Shared nat intervals\<close>

  abbreviation(input) "ind \<equiv> shared_right"
  abbreviation(input) "cnt \<equiv> shared_left"
  (*Lowest list index, inclusive*)
  abbreviation(input) "lid \<equiv> shared_right"
  (*Highest list index, exclusive*)
  abbreviation(input) "uid \<equiv> shared_sum"

  definition "in_intv sn i = (lid sn \<le> i \<and> i < uid sn)"
  definition "sn_intv sn = Collect (in_intv sn)"
  definition "ls_intv sn = [lid sn..<uid sn]"

  lemma sn_intv_alt: "sn_intv sn = {lid sn..<uid sn}"
    unfolding sn_intv_def in_intv_def
    by auto

  lemma in_intv_lbD[intro]: "in_intv sn i \<Longrightarrow> lid sn \<le> i"
    unfolding in_intv_def
    by blast

  lemma in_intv_ubD[intro]: "in_intv sn i \<Longrightarrow> i < uid sn"
    unfolding in_intv_def
    by blast

  lemma sn_intv_member[simp]: "i \<in> sn_intv sn \<longleftrightarrow> in_intv sn i"
    by (auto simp: in_intv_def sn_intv_def)

  lemma in_intvI: "lid sn \<le> i \<Longrightarrow> i < uid sn \<Longrightarrow> in_intv sn i" 
    apply(fold sn_intv_member) 
    unfolding sn_intv_alt
    by simp

  lemma finite_sn_intv[simp]: "finite (sn_intv sn)"
    unfolding sn_intv_alt
    by simp

  lemma set_ls_intv[simp]: "set (ls_intv sn) = sn_intv sn"
    unfolding ls_intv_def sn_intv_alt by simp

  lemma distinct_ls_intv[simp]: "distinct (ls_intv sn)"
    unfolding ls_intv_def
    by simp

  lemma length_ls_intv[simp]: "length (ls_intv sn) = cnt sn"
    unfolding ls_intv_def by simp

  lemma last_intv: "cnt sn > 0 \<Longrightarrow> last (ls_intv sn) = uid sn - Suc 0"
    unfolding ls_intv_def by fastforce

  lemma hd_intv: "cnt sn > 0 \<Longrightarrow> hd (ls_intv sn) = lid sn"
    unfolding ls_intv_def by force

  lemma butlast_intv: "butlast (ls_intv sn) = [lid sn..<uid sn - Suc 0]" 
    using One_nat_def butlast_upt ls_intv_def by presburger

  lemma tl_intv: "tl (ls_intv sn) = [Suc (lid sn)..<uid sn]"
    by (simp add: ls_intv_def)

  lemma ls_intv_emp[simp]: "ls_intv sn = [] \<longleftrightarrow> cnt sn = 0"
    unfolding ls_intv_def shared_sum_as_left_plus_right by force

  lemma ls_intv_nemp[simp]: "ls_intv sn \<noteq> [] \<longleftrightarrow> cnt sn > 0"
    unfolding ls_intv_def shared_sum_as_left_plus_right by force

  lemma sn_intv_emp[simp]: "sn_intv sn = {} \<longleftrightarrow> cnt sn = 0"
    unfolding sn_intv_def shared_sum_as_left_plus_right in_intv_def by auto

  lemma sn_intv_nemp[simp]: "sn_intv sn \<noteq> {} \<longleftrightarrow> cnt sn > 0"
    unfolding sn_intv_def shared_sum_as_left_plus_right in_intv_def by force
    

  lemma ls_intv_butlast_last: "cnt sn > 0 \<Longrightarrow> ls_intv sn = [lid sn..<uid sn - Suc 0] @ [uid sn - Suc 0]"
    apply(simp flip: butlast_intv)
    by(simp flip: last_intv )

  lemma in_intv_nth: "in_intv sn i \<Longrightarrow> ls_intv sn ! (i - lid sn) = i"
    unfolding ls_intv_def
    apply(subst nth_upt)
    subgoal
      apply(subst add_diff_inverse_nat)
      apply(subst not_less) 
      by auto
    subgoal
      apply(subst add_diff_inverse_nat)
      apply(subst not_less) 
      by auto
    done

  lemma ls_intv_nth: "i < cnt sn \<Longrightarrow> ls_intv sn ! i = i + lid sn"
    unfolding ls_intv_def
    apply(subst nth_upt) 
    using shared_sum_as_left_plus_right 
    by auto

  lemma i_lt_cnt_in_intv: "i < cnt sn \<Longrightarrow> in_intv sn (i + lid sn)"
    unfolding in_intv_def shared_sum_as_left_plus_right by simp

  lemma i_lt_cnt_ls_intv_in_intv: "i < cnt sn \<Longrightarrow> in_intv sn (ls_intv sn ! i)"
    by(auto simp: ls_intv_nth i_lt_cnt_in_intv)
    

  text \<open>The modest data structure contains three lists respresenting States, Transitions and 
    Branches. The list of states is a triple (tuple in this representation) which respectively 
      contains the number of transitions, first index in the list of transitions and the exitrate 
      (NaN for MDP's, so it is not modelled). 
    The list of transitions similarly is a tuple which contains respectively the number of branches 
      that the transition has as well as the first index in the branch list.
    The list of branches contains a tuple (single value in this representation) with the transition 
      probability and the index of the successor state in the state list
    Furthermore, the bitsets represent the avoid and target states which are used as self-loops.\<close>
  type_synonym modest_graph = "(nat \<times> nat) list \<times> (nat \<times> nat) list \<times> nat list"
    

  locale modest_graph_def =
    fixes SS :: "modest_graph"
  begin 
  
    definition "St = (\<lambda> (S,T,B). S) SS"
    definition "Tr = (\<lambda> (S,T,B). T) SS"
    definition "Br = (\<lambda> (S,T,B). B) SS"

    definition "E_succ_\<alpha> = (\<lambda> u. if u < length St then concat (map (\<lambda> i. map ((!) Br) (ls_intv (Tr!i))) (ls_intv (St!u))) else [])"

    abbreviation "E_\<alpha>' \<equiv> fr_graph_defs.E_\<alpha> E_succ_\<alpha>"

    lemma E_succ_eq_image_E: "set (E_succ_\<alpha> u) = E_\<alpha>' `` {u}"
      unfolding E_succ_\<alpha>_def fr_graph_defs.E_\<alpha>_def
      apply(cases "u < length St")
      apply (auto intro!: exI)
      done

    
    definition "graph_structure_branches i = {(u,v). (\<exists> j. in_intv (St!u) i \<and> in_intv (Tr!i) j \<and> v = Br!j \<and> u < length St)}" 

    definition "graph_structure_edges = {(u,v). (\<exists> i j. in_intv (St!u) i \<and> in_intv (Tr!i) j \<and> v = Br!j \<and> u < length St)}"


    definition "graph_structure_branch_index_list t = ls_intv (Tr!t)"

    lemma distinct_graph_structure_branch_index_list[simp]: "distinct (graph_structure_branch_index_list t)"
      unfolding graph_structure_branch_index_list_def by simp

    definition "graph_structure_edge_index_list s = fold (\<lambda> t a. a @ (ls_intv (Tr ! t))) (ls_intv (St ! s)) []"

    lemma "graph_structure_edge_index_list s = fold (\<lambda> t a. a @ graph_structure_branch_index_list t) (ls_intv (St ! s)) []"
      unfolding graph_structure_edge_index_list_def graph_structure_branch_index_list_def
      by simp      

    lemma indep_succs: "u < length St \<Longrightarrow> (u,v) \<in> E_\<alpha>' \<longleftrightarrow> (u,v) \<in> graph_structure_edges"
      unfolding graph_structure_edges_def fr_graph_defs.E_\<alpha>_def E_succ_\<alpha>_def 
      by fastforce

    lemma indep_succs_branchesD: "u < length St \<Longrightarrow> in_intv (St ! u) i \<Longrightarrow> (u,v) \<in> graph_structure_branches i \<Longrightarrow> (u,v) \<in> E_\<alpha>'"
      unfolding graph_structure_branches_def fr_graph_defs.E_\<alpha>_def E_succ_\<alpha>_def 
      by fastforce

    lemma indep_succs_branches: "u < length St \<Longrightarrow> (u,v) \<in> \<Union>(graph_structure_branches ` sn_intv (St ! u)) \<longleftrightarrow> (u,v) \<in> E_\<alpha>'"
      unfolding graph_structure_branches_def sn_intv_def fr_graph_defs.E_\<alpha>_def E_succ_\<alpha>_def  
      by fastforce

    lemma graph_structure_branches_to_edges: "(\<Union>i \<in> sn_intv (St!u). (graph_structure_branches i) `` {u}) = graph_structure_edges `` {u}"
      unfolding graph_structure_branches_def graph_structure_edges_def sn_intv_def
      apply auto
      done

    lemma indep_graph_structure_edges: "u < length St \<Longrightarrow> E_\<alpha>' `` {u} = graph_structure_edges `` {u}"
      using indep_succs
      by auto

  end

  lemma SS_sel_simps[simp]:
    "modest_graph_def.St (St,Tr,Br) = St"
    "modest_graph_def.Tr (St,Tr,Br) = Tr"
    "modest_graph_def.Br (St,Tr,Br) = Br"
    unfolding modest_graph_def.St_def modest_graph_def.Tr_def modest_graph_def.Br_def
    by auto


  lemmas unfolded_indep_succs = modest_graph_def.indep_succs[of _ "(_,_,_)", simplified]
  
  locale modest_graph_invar' = modest_graph_def SS for N\<^sub>s SS +
  
    assumes NS_DEF: "N\<^sub>s = length St"
  
    assumes S_in_bound: "i < length St \<Longrightarrow> uid (St!i) \<le> length Tr"
    assumes T_in_bound: "i < length Tr \<Longrightarrow> uid (Tr!i) \<le> length Br"
    assumes B_in_bound: "i < length Br \<Longrightarrow> Br!i < length St"
  
    assumes St_nonempty: "i < length St \<Longrightarrow> cnt (St!i) > 0"
    assumes Tr_nonempty: "i < length Tr \<Longrightarrow> cnt (Tr!i) > 0"
  
    (*assumes T_is_succ: "\<forall>i < length Tr. \<exists>j < length St. lid (St!j) \<le> i \<and> i < uid (St!j)"
    assumes B_is_succ: "\<forall>i < length Br. \<exists>j < length Tr. lid (Tr!j) \<le> i \<and> i < uid (Tr!j)"

    assumes S_intv_disj: "\<forall> i < length St. (\<forall> j < i. sn_intv (St ! i) \<inter> sn_intv (St ! j) = {})"*)
    assumes T_intv_disj: "i < length Tr \<Longrightarrow> j < i \<Longrightarrow> sn_intv (Tr ! i) \<inter> sn_intv (Tr ! j) = {}"

  begin

    lemma T_in_boundD: "v < length St \<Longrightarrow> t < uid (St ! v) \<Longrightarrow> t < length Tr"
      apply(drule S_in_bound) 
      by force

    lemma B_in_boundD: "t < length Tr \<Longrightarrow> b < uid (Tr ! t) \<Longrightarrow> b < length Br"
      apply(drule T_in_bound)
      by force

    lemma T_in_bound_intvD: "v < length St \<Longrightarrow> in_intv (St ! v) t \<Longrightarrow> t < length Tr"
      by(auto elim!: T_in_boundD dest: in_intv_ubD)

    lemma B_in_bound_intvD: "t < length Tr \<Longrightarrow> in_intv (Tr ! t) b \<Longrightarrow> b < length Br"
      by(auto elim!: B_in_boundD dest: in_intv_ubD)

    lemma E_\<alpha>_len_St[simp]: "E_\<alpha>' \<subseteq> {0..<N\<^sub>s} \<times> {0..<N\<^sub>s}"
      unfolding NS_DEF fr_graph_defs.E_\<alpha>_def E_succ_\<alpha>_def using B_in_bound
      apply clarsimp 
      by(auto dest!: T_in_bound_intvD B_in_bound_intvD)

    lemma finite_E_\<alpha>[simp]: "finite E_\<alpha>'"
      using finite_subset[OF E_\<alpha>_len_St] by simp

    lemma fr_graph_impl_modest: "fr_graph {0..<length St} E_succ_\<alpha>"
      apply(unfold_locales)
      subgoal
        apply(intro finite_rtrancl_Image)
        by auto
      done

    lemma succ_in_bound: 
      assumes "(u,v) \<in> E_\<alpha>'" 
      shows "v < length St"
    proof -
      obtain i j where "lid (St!u) \<le> i" and IU:"i < uid (St!u)" and "lid (Tr!i) \<le> j" and JU:"j < uid (Tr!i)" and V_DEF: "v = Br!j" and UU: "u < length St"
        using assms 
        unfolding in_intv_def fr_graph_defs.E_\<alpha>_def E_succ_\<alpha>_def
        apply clarsimp
        by blast
      hence "j < length Br"  
        by (meson B_in_boundD T_in_boundD)
      then show ?thesis 
        using B_in_bound
        unfolding NS_DEF  V_DEF 
        by fast
    qed

    lemma edge_from_transistionD:
      assumes IB: "i < length St"
      assumes JB: "in_intv (St ! i) j"
      assumes KB: "in_intv (Tr ! j) k"
      shows "(i, Br ! k) \<in> E_\<alpha>'"
      using S_in_bound T_in_bound B_in_bound
      unfolding fr_graph_defs.E_\<alpha>_def E_succ_\<alpha>_def
      using assms apply clarsimp
      by fastforce

    lemma graph_structure_edgesD:
      assumes IB: "i < length St"
      assumes JB: "in_intv (St ! i) j"
      assumes KB: "in_intv (Tr ! j) k"
      shows "(i, Br ! k) \<in> graph_structure_edges"
      unfolding graph_structure_edges_def
      using assms
      by blast

    lemma graph_structure_branchesD:
      assumes IB: "i < length St"
      assumes JB: "in_intv (St ! i) j"
      assumes KB: "in_intv (Tr ! j) k"
      shows "(i, Br ! k) \<in> graph_structure_branches j"
      unfolding graph_structure_branches_def
      using assms
      by blast

    lemma graph_structure_branches_to_B:
      assumes IB: "v < length St"
      assumes JB: "in_intv (St ! v) t"
      assumes "b = Tr ! t" 
      shows "(graph_structure_branches t)  `` {v} = (!) Br ` sn_intv b"
      unfolding graph_structure_branches_def
      apply (auto simp: assms)
      done

    lemma tn_sub_lid_lt_cnt: "v < length St \<Longrightarrow> in_intv (St!v) tn \<Longrightarrow> tn - lid (St ! v) < cnt (St ! v)"
      by(simp add: shared_sum_as_left_plus_right less_diff_conv2 in_intv_def) 

    lemma bn_sub_lid_lt_cnt: "v < length St \<Longrightarrow> in_intv (St!v) tn \<Longrightarrow> in_intv (Tr!tn) bn \<Longrightarrow> bn - lid (Tr ! tn) < cnt (Tr ! tn)"
      by(simp add: shared_sum_as_left_plus_right less_diff_conv2 in_intv_def) 

    lemma state_has_transition: assumes "v < length St" obtains tn where "in_intv (St ! v) tn"
      using St_nonempty assms i_lt_cnt_ls_intv_in_intv by blast

    lemma transition_has_branch: assumes "v < length St" and "in_intv (St ! v) tn" obtains bn where "in_intv (Tr ! tn) bn"
      using assms i_lt_cnt_ls_intv_in_intv T_in_bound_intvD Tr_nonempty by blast
  end

  locale modest_graph_invar = modest_graph_invar' N\<^sub>s SS\<^sub>c for N\<^sub>s SS\<^sub>c +
    fixes SS
    assumes SS_DEF: "SS = SS\<^sub>c"
  begin


  end

  definition "modest_graph_succ_SS_rel N SS\<^sub>c = br modest_graph_def.E_succ_\<alpha> (modest_graph_invar N SS\<^sub>c)"

  definition "modest_graph_succ_rel N \<equiv> { (SS,E_succ). (SS,E_succ) \<in> modest_graph_succ_SS_rel N SS }"


  (*definition "modest_graph_succ_rel' N = br modest_graph_def.E_succ_\<alpha> (modest_graph_invar' N)"*)

  lemma modest_graph_succ_rel_SS_eq: "(SS, E_succ) \<in> modest_graph_succ_SS_rel N SS\<^sub>c \<Longrightarrow> SS = SS\<^sub>c"
    unfolding modest_graph_succ_SS_rel_def
    by(auto simp: in_br_conv modest_graph_invar_def modest_graph_invar_axioms_def)

  lemma modest_graph_succ_rel_alt: "(SS, E_succ) \<in> modest_graph_succ_SS_rel N SS\<^sub>c \<longleftrightarrow> SS\<^sub>c = SS \<and> (SS, E_succ) \<in> modest_graph_succ_rel N"
    using modest_graph_succ_rel_SS_eq
    unfolding modest_graph_succ_SS_rel_def modest_graph_succ_rel_def br_def modest_graph_invar_def modest_graph_invar_axioms_def 
    by auto
    



  subsection \<open>A successor index for modest is a quintuple that contains the vertex, 
              a transition index, a transition end index, a branch index and a branch end index.\<close>
  type_synonym 'v modest_succ_index = "('v \<times> nat \<times> nat \<times> nat \<times> nat)"

  locale modest_successor_index_def = modest_graph_def +
    fixes IDX :: "nat modest_succ_index"
  begin

    definition "vI = (\<lambda> (v,tc,te,bc,be). v) IDX"
    definition "tcI = (\<lambda> (v,tc,te,bc,be). tc) IDX"
    definition "teI = (\<lambda> (v,tc,te,bc,be). te) IDX"
    definition "bcI = (\<lambda> (v,tc,te,bc,be). bc) IDX"
    definition "beI = (\<lambda> (v,tc,te,bc,be). be) IDX"


    definition "visited_br_in_tr i = (if i < tcI then cnt (Tr!i) else if i = tcI then bcI - lid (Tr!i) else 0)"

    definition "ci_\<alpha> = sum_list (map visited_br_in_tr (ls_intv (St!vI)))"

    definition "\<alpha> = (vI, ci_\<alpha>)"


    (*function \<alpha>_aux :: "nat modest_succ_index \<Rightarrow> nat \<Rightarrow> nat" where
      "\<alpha>_aux (v,tc,te,bc,be) i = (if i < tc then 
          \<alpha>_aux (v,tc,te,bc,be) (Suc i) + (if in_intv (Tr!i) bc then bc - lid (Tr!i) else uid (Tr!i))
        else 0)"
      by pat_completeness auto
    termination
      by(relation \<open>measure (\<lambda> ((v,tc,te,bc,be),i). tc - i)\<close>) auto

    definition "\<alpha> = \<alpha>_aux IDX (lid (St!vI))"*)

  end

  lemma modest_successor_index_simps[simp]:
    "modest_successor_index_def.vI (v,tc,te,bc,be) = v"
    "modest_successor_index_def.tcI (v,tc,te,bc,be) = tc"
    "modest_successor_index_def.teI (v,tc,te,bc,be) = te"
    "modest_successor_index_def.bcI (v,tc,te,bc,be) = bc"
    "modest_successor_index_def.beI (v,tc,te,bc,be) = be"
    unfolding modest_successor_index_def.vI_def modest_successor_index_def.tcI_def modest_successor_index_def.teI_def
      modest_successor_index_def.bcI_def modest_successor_index_def.beI_def by auto

  locale modest_successor_index_invar = modest_successor_index_def SS IDX + modest_graph_invar' N\<^sub>s SS for N\<^sub>s SS IDX +
    assumes TBOUND: "tcI < teI" 
    and BBOUND: "bcI < beI" 
    and TUPP: "teI = uid (St!vI)" 
    and BUPP: "beI = uid (Tr!tcI)"
    and TLOW: "lid (St!vI) \<le> tcI"
    and BLOW: "lid (Tr!tcI) \<le> bcI"
    and VBOUND: "vI < length St"
  begin

    lemma in_intv_tcI[simp]: "in_intv (St!vI) tcI"
      unfolding in_intv_def
      using TBOUND TUPP TLOW by simp

    lemma in_intv_bcI[simp]: "in_intv (Tr!tcI) bcI"
      unfolding in_intv_def
      using BBOUND BUPP BLOW by simp

    lemma ls_intv_nth_eq_tcI[simp]: "ls_intv (St ! vI) ! (tcI - lid (St ! vI)) = tcI"
      by(auto intro: in_intv_nth)

    lemma ls_intv_nth_eq_bcI[simp]: "ls_intv (Tr ! tcI) ! (bcI - lid (Tr ! tcI)) = bcI"
      by(auto intro: in_intv_nth)

    lemma ls_intv_nth_tcI_id_val[dest]: "ls_intv (St ! vI) ! i = tcI \<Longrightarrow> i < cnt(St ! vI) \<Longrightarrow> i = (tcI - lid (St ! vI))" 
    proof(rule ccontr)
      assume A: "i < cnt(St ! vI)" and B: "ls_intv (St ! vI) ! i = tcI" and C: "i \<noteq> tcI - shared_right (St ! vI)"
      moreover have D: "distinct (ls_intv (St ! vI))" by simp
      moreover have E: "tcI - lid (St ! vI) < shared_left (St ! vI)"
        by (simp add: VBOUND tn_sub_lid_lt_cnt)
      ultimately show False using nth_eq_iff_index_eq[OF D, simplified, OF A E] 
        by force
    qed

    lemma ls_intv_nth_bcI_id_val[dest]: "ls_intv (Tr ! tcI) ! i = bcI \<Longrightarrow> i < cnt(Tr ! tcI) \<Longrightarrow> i = (bcI - lid (Tr ! tcI))" 
    proof(rule ccontr)
      assume A: "i < cnt(Tr ! tcI)" and B: "ls_intv (Tr ! tcI) ! i = bcI" and C: "i \<noteq> bcI - shared_right (Tr ! tcI)"
      moreover have D: "distinct (ls_intv (Tr ! tcI))" by simp
      moreover have E: "bcI - lid (Tr ! tcI) < shared_left (Tr ! tcI)"
        using VBOUND bn_sub_lid_lt_cnt by auto
      ultimately show False using nth_eq_iff_index_eq[OF D, simplified, OF A E] 
        by force
    qed

    lemma tc_sub_lid_lt_cnt[simp]: "tcI - lid (St ! vI) < cnt (St ! vI)"
      using tn_sub_lid_lt_cnt[OF VBOUND in_intv_tcI] .

    lemma bc_sub_lid_lt_cnt[simp]: "bcI - lid (Tr ! tcI) < cnt (Tr ! tcI)"
      using bn_sub_lid_lt_cnt[OF VBOUND in_intv_tcI in_intv_bcI] .

    lemma beI_nonzero[simp]: "beI > 0"
      using BBOUND by simp

    lemma teI_nonzero[simp]: "teI > 0"
      using TBOUND by fastforce

    lemma teI_bound: "teI \<le> length Tr" 
      by (simp add: S_in_bound TUPP VBOUND)

    lemma tcI_bound: "tcI < length Tr" 
      using less_le_trans[OF TBOUND teI_bound] .

    lemma beI_bound: "beI \<le> length Br"
      by (simp add: T_in_bound BUPP VBOUND T_in_bound[OF tcI_bound])

    lemma bcI_bound: "bcI < length Br"
      using less_le_trans[OF BBOUND beI_bound] .

  end

  definition "modest_succ_index_SS_rel N\<^sub>s SS = br (modest_successor_index_def.\<alpha> SS) (modest_successor_index_invar N\<^sub>s SS)"

  definition "modest_succ_index_rel N\<^sub>s = {(ci,c). \<exists>SS. (ci,c) \<in> modest_succ_index_SS_rel N\<^sub>s SS}"

  lemma modest_succ_index_rel_vD: "((v,tc,te,bc,be), v',i) \<in> modest_succ_index_SS_rel N\<^sub>s SS \<Longrightarrow> v'=v"
    by(auto simp: modest_succ_index_SS_rel_def in_br_conv modest_successor_index_def.\<alpha>_def)
  
  subsection \<open>Index operations\<close>

  
  context modest_graph_def
  begin

    definition "get_transitions_of_state v =
      do{
        ASSERT(v < length St);
        let r = St ! v;
        ASSERT(shared_sum r \<le> length Tr);
        RETURN r
      }"

    definition "get_branches_of_transition t = 
      do{
        ASSERT(t < length Tr);
        let r = Tr ! t;
        ASSERT(shared_sum r \<le> length Br);
        RETURN r
      }"

    definition "get_successor_of_branch b =
      do{ 
        ASSERT(b < length Br);
        let r = Br ! b;
        ASSERT (r < length St);
        RETURN r
      }"

    definition "modest_is_empty \<equiv> (\<lambda> E_succ v. False)"

    definition "modest_index_begin v = (v,lid (St!v),uid (St!v),lid (Tr!(lid (St!v))),uid (Tr!(lid (St!v))))"

  end

  context modest_successor_index_def 
  begin
    
    definition "modest_get_state = vI"

    definition "modest_succ_at \<equiv> Br!bcI"

    definition "modest_has_successor \<equiv> (tcI < teI \<and> Suc bcI < beI) \<or> (Suc tcI < teI \<and> bcI < beI)"

    definition "modest_next_index \<equiv> (let bc' = bcI + 1 in (if bc' < beI then (vI,tcI,teI,bc',beI) else (let tc' = tcI+1 in (vI,tc',teI,lid (Tr!tc'),uid (Tr!tc')))))"

  end

  
  subsection \<open>Correctness of operations\<close>

  context modest_graph_invar'
  begin
    interpretation fr_graph "{0..<length St}" E_succ_\<alpha> using fr_graph_impl_modest .

    lemma get_transitions_of_state_refine:
      assumes "v < length St"
      shows "get_transitions_of_state v \<le> SPEC (\<lambda> r. r = St ! v \<and> shared_sum r \<le> length Tr)"
      unfolding get_transitions_of_state_def
      apply(refine_vcg)
      using S_in_bound assms 
      apply auto
      done

    lemma get_branches_of_transition_refine:
      assumes "t < length Tr"
      shows "get_branches_of_transition t \<le> SPEC (\<lambda> r. r = Tr ! t)"
      unfolding get_branches_of_transition_def
      apply(refine_vcg)
      using T_in_bound assms 
      apply auto
      done

    lemma get_successor_of_branch_refine:
      assumes "b < length Br"
      shows "get_successor_of_branch b \<le> SPEC (\<lambda> r. r = Br ! b)"
      unfolding get_successor_of_branch_def
      apply(refine_vcg)
      using B_in_bound assms 
      apply auto
      done

    lemma init_id_modest_succ_index_correct: "v < N\<^sub>s \<Longrightarrow> (modest_index_begin v, index_begin v) \<in> modest_succ_index_SS_rel N\<^sub>s SS"
      unfolding modest_succ_index_SS_rel_def modest_index_begin_def index_begin_def
        modest_successor_index_def.\<alpha>_def modest_successor_index_def.ci_\<alpha>_def modest_successor_index_def.visited_br_in_tr_def
      apply(clarsimp simp: in_br_conv in_intv_def)
      apply(rule conjI)
      subgoal
        by blast
      subgoal
        apply(unfold_locales)
        using S_in_bound T_in_bound B_in_bound shared_sum_as_left_plus_right NS_DEF
        by (auto simp:  shared_sum_as_left_plus_right St_nonempty T_in_boundD Tr_nonempty T_intv_disj )
      done
  end


  lemma sum_list_leq:  "length xs = length ys \<Longrightarrow> (\<forall>i < length xs. xs!i \<le> ys!i) \<Longrightarrow> sum_list xs \<le> sum_list ys" for xs::"nat list"
    apply(induction xs arbitrary: ys)
    apply simp
    subgoal for a xs ys
      apply(cases ys)
      apply simp
      by fastforce
    done

  lemma sum_list_eq:  "length xs = length ys \<Longrightarrow> (\<forall>i < length xs. xs!i = ys!i) \<Longrightarrow> sum_list xs = sum_list ys" for xs::"nat list"
    apply(induction xs arbitrary: ys)
    apply simp
    subgoal for a xs ys
      apply(cases ys)
      apply (metis length_0_conv)
      by fastforce
    done


  lemma sum_list_Suc_eq:  "length xs = length ys \<Longrightarrow> (\<forall>i < length xs. i \<noteq> j \<longrightarrow> xs!i = ys!i) \<Longrightarrow> j < length xs \<Longrightarrow> Suc (xs!j) = ys!j \<Longrightarrow> Suc (sum_list xs) = sum_list ys" for xs::"nat list"
  proof(induction xs arbitrary: ys j)
    case Nil
    then show ?case by simp
  next
    case (Cons x xs)
    then obtain y ys' where YS_DEF[simp]: "ys = y # ys'"
      by (metis length_Suc_conv)
    then have XS_LEN: "length xs = length ys'" 
      using Cons.prems(1) by force

    then show ?case
    proof(cases j)
      case 0
      with Cons.prems(4) have "Suc x = ys ! j" by force
      moreover from Cons.prems(2) 0 have "xs = ys'" 
        by(fastforce simp: XS_LEN intro!: nth_equalityI)
      ultimately show ?thesis
        by (simp add: "0")
    next
      case (Suc nat)

      have YA[simp]: "y = x" 
        using Cons.prems(2) Suc by force

      have A: " \<forall>i<length xs. i \<noteq> (j - Suc 0) \<longrightarrow> xs ! i = ys' ! i"
        using Cons.prems(2) Suc
        by fastforce

      have B: "j - Suc 0 < length xs" 
        using Cons.prems(3) local.Suc by auto

      have C: "Suc (xs ! (j - Suc 0)) = ys' ! (j - Suc 0)"
        using Cons.prems(4) local.Suc by force

      show ?thesis using Cons.IH[OF XS_LEN A B C]
        by force
    qed
  qed


  lemma sum_list_lt: "length xs = length ys \<Longrightarrow> (\<forall>i < length xs. xs!i \<le> ys!i) \<Longrightarrow> j < length xs \<Longrightarrow> xs!j < ys!j \<Longrightarrow> sum_list xs < sum_list ys" for xs::"nat list"
  proof(induction xs arbitrary: ys j)
    case Nil
    then show ?case by auto
  next
    case (Cons x xs)
    then obtain y ys' where YS_DEF[simp]: "ys = y # ys'"
      by (metis length_Suc_conv)
    then have XS_LEN: "length xs = length ys'" 
      using Cons.prems(1) by force

    have L1: "\<forall>i<length xs. xs ! i \<le> ys' ! i" 
        using Cons.prems(2) by force

    show ?case 
    proof(cases j)
      case 0
      hence "x < y" 
        using Cons.prems(4) by auto
      then show ?thesis 
        using sum_list_leq[OF XS_LEN L1] by force
    next
      case (Suc j')
      hence J'_LEN: "j' < length xs" using Cons.prems(3) by simp

      have LEQ: "xs ! j' < ys' ! j'" using Cons.prems(4) Suc 
        by (simp)

      have "x \<le> y"
        using Cons.prems(2) by fastforce
      with Cons.IH[OF XS_LEN L1 J'_LEN LEQ] show ?thesis by simp
    qed
  qed

  lemma concat_nth_sum_list_indices: 
    "length xss = length ds 
      \<Longrightarrow> j < length ds 
      \<Longrightarrow> (\<forall>i < j. ds ! i = length (xss ! i)) 
      \<Longrightarrow> k = ds ! j 
      \<Longrightarrow> k < length (xss ! j) 
      \<Longrightarrow> (\<forall>i > j. i < length ds \<longrightarrow> ds ! i = 0) 
      \<Longrightarrow> (concat xss) ! (sum_list ds) = (xss ! j) ! k"
    proof(induction xss arbitrary: ds rule: rev_induct)
      case Nil
      then show ?case by simp
    next
      case (snoc xs xss)

      from snoc.prems(1) obtain ds' d where DS_DEF[simp]: "ds = ds' @ [d]" 
        by (metis length_greater_0_conv neq_Nil_rev_conv)

      with snoc.prems(1) have LENEQ: "length xss = length ds'"
        by fastforce

      with snoc.prems consider (lt) "j < length ds'" | (eq) "j = length ds'"
        by fastforce

      then show ?case
      proof cases
        case lt
      
        have A: "\<forall>i<j. ds' ! i = length (xss ! i)"
          using snoc.prems(3) lt
          by (simp add: LENEQ)

        have B: "k = ds' ! j "
          using lt snoc.prems(4) by force

        have C: "k < length (xss ! j)"
          using snoc.prems(5)
          by (simp add: lt LENEQ)

        have D: "\<forall>i>j. i < length ds' \<longrightarrow> ds' ! i = 0" 
          using snoc.prems(6) by auto

        from lt have "sum_list ds = sum_list ds'" using snoc.prems(6) 
          by fastforce

        moreover have "sum_list ds' < length (concat xss)" 
          unfolding length_concat
          apply(rule sum_list_lt[where ?j=j])
          subgoal by(simp add: LENEQ)
          subgoal
            using A B C lt D
            by (metis LENEQ less_eq_nat.simps(1) less_or_eq_imp_le linorder_neqE_nat nth_map)
          subgoal using lt .
          subgoal
            using C 
            by(simp add: B nth_map[OF lt[folded LENEQ]])
          done

        ultimately show ?thesis 
          using lt LENEQ snoc.IH[OF LENEQ lt A B C D]
          by fastforce
      next
        case eq

        hence A: "(xss @ [xs]) ! j ! k = xs ! k"
          by(auto simp flip: LENEQ)

        have DK: "d = k"
          by (simp add: eq snoc.prems(4))

        have "sum_list ds = length (concat xss) + k"
          apply(clarsimp simp: length_concat DK)
          apply(rule sum_list_eq)
          subgoal by(simp add: LENEQ)
          subgoal 
            using LENEQ eq snoc.prems(3)
            by simp
          done

        with A show ?thesis
          by fastforce
      qed
    qed


  context modest_successor_index_invar
  begin

    interpretation fr_graph "{0..<length St}" E_succ_\<alpha> using fr_graph_impl_modest .

    lemma ci_\<alpha>_bound_length_E_succ: 
      shows "ci_\<alpha> < length (E_succ_\<alpha> vI)"
    proof -  
      have "sum_list (map visited_br_in_tr (ls_intv (St ! vI)))
      < sum_list (map (length \<circ> (\<lambda>i. map ((!) Br) (ls_intv (Tr ! i)))) (ls_intv (St ! vI)))"
        apply(rule sum_list_lt[where ?j="tcI - lid (St ! vI)"])
        subgoal
          by simp
        subgoal
          using BBOUND unfolding visited_br_in_tr_def BUPP 
            using shared_sum_as_left_plus_right by fastforce
        subgoal
          using tc_sub_lid_lt_cnt by simp
        subgoal
          by(auto simp: visited_br_in_tr_def BUPP shared_sum_as_left_plus_right BLOW)
        done
        
      then show ?thesis 
        unfolding ci_\<alpha>_def E_succ_\<alpha>_def
        by(clarsimp simp: VBOUND length_concat)
    qed


    lemma lt_bc_ci_\<alpha>_lt: "lid (Tr ! tcI) \<le> bn \<Longrightarrow> bn < bcI \<Longrightarrow> modest_successor_index_def.ci_\<alpha> SS (vI,tcI,teI,bn,beI) < ci_\<alpha>"
      unfolding modest_successor_index_def.ci_\<alpha>_def
      apply simp
      apply(intro sum_list_lt[where ?j="tcI - lid (St ! vI)"])
      subgoal
        by simp
      subgoal
        by(auto simp: modest_successor_index_def.visited_br_in_tr_def)
      subgoal
        by auto
      subgoal
        apply(subst nth_map)
        using BUPP BBOUND BLOW
        by(auto simp: modest_successor_index_def.visited_br_in_tr_def)
      done 

    lemma gt_bc_ci_\<alpha>_gt: "bcI < bn \<Longrightarrow> bn < beI \<Longrightarrow> ci_\<alpha> < modest_successor_index_def.ci_\<alpha> SS (vI,tcI,teI,bn,beI)"
      unfolding modest_successor_index_def.ci_\<alpha>_def
      apply simp
      apply(intro sum_list_lt[where ?j="tcI - lid (St ! vI)"])
      subgoal
        by simp
      subgoal
        by(auto simp: modest_successor_index_def.visited_br_in_tr_def)
      subgoal
        by auto
      subgoal
        apply(subst nth_map)
        using BUPP BBOUND BLOW
        by(auto simp: modest_successor_index_def.visited_br_in_tr_def)
      done 


    lemma lt_tc_ci_\<alpha>_lt: "lid (St ! vI) \<le> tn \<Longrightarrow> tn < tcI \<Longrightarrow> in_intv (Tr!tn) bn \<Longrightarrow> be = uid (Tr!tn) \<Longrightarrow> modest_successor_index_def.ci_\<alpha> SS (vI,tn,teI,bn,be) < ci_\<alpha>"
      unfolding modest_successor_index_def.ci_\<alpha>_def
      apply simp
      apply(intro sum_list_lt[where ?j="tn - lid (St ! vI)"])
      subgoal
        by simp
      subgoal
        by(auto simp: modest_successor_index_def.visited_br_in_tr_def i_lt_cnt_ls_intv_in_intv 
          intro!: less_imp_le_nat bn_sub_lid_lt_cnt[OF VBOUND] ) 
      subgoal
        using TBOUND TUPP
        by(auto simp: shared_sum_as_left_plus_right) 
      subgoal
        apply(subst nth_map)
        subgoal 
          using TBOUND TUPP
          by(auto simp: shared_sum_as_left_plus_right)
        subgoal
          apply(subst nth_map)
          subgoal
            using TBOUND TUPP
            by(auto simp: shared_sum_as_left_plus_right)
          subgoal
            using TBOUND TUPP
            by(auto simp: modest_successor_index_def.visited_br_in_tr_def in_intv_def in_intv_nth 
              intro!: bn_sub_lid_lt_cnt[OF VBOUND])
          done
        done
      done 

    lemma gt_tc_ci_\<alpha>_gt: "tcI < tn \<Longrightarrow> tn < teI \<Longrightarrow> in_intv (Tr!tn) bn \<Longrightarrow> be = uid (Tr!tn) \<Longrightarrow> ci_\<alpha> < modest_successor_index_def.ci_\<alpha> SS (vI,tn,teI,bn,be)"
      unfolding modest_successor_index_def.ci_\<alpha>_def
      apply simp
      apply(intro sum_list_lt[where ?j="tcI - lid (St ! vI)"])
      subgoal
        by simp
      subgoal
        by(auto simp: modest_successor_index_def.visited_br_in_tr_def i_lt_cnt_ls_intv_in_intv 
          intro!: less_imp_le_nat bn_sub_lid_lt_cnt[OF VBOUND] ) 
      subgoal
        using TBOUND TUPP TLOW
        by(auto simp: shared_sum_as_left_plus_right) 
      subgoal
        apply(subst nth_map)
        subgoal 
          using TBOUND TUPP TLOW
          by(auto simp: shared_sum_as_left_plus_right)
        subgoal
          apply(subst nth_map)
          subgoal
            using TBOUND TUPP TLOW
            by(auto simp: shared_sum_as_left_plus_right)
          subgoal
            using TBOUND TUPP TLOW BLOW
            by(auto simp: modest_successor_index_def.visited_br_in_tr_def in_intv_def in_intv_nth 
              intro!: bn_sub_lid_lt_cnt) 
          done
        done
      done 

      

    lemma last_id_eq_length_E_succ: 
      assumes TB: "Suc tcI = teI"
      and BB: "Suc bcI = beI"
      shows "Suc ci_\<alpha> = length (E_succ_\<alpha> vI)"
    proof -

      have aux1: "length \<circ> (\<lambda>i. map ((!) Br) (ls_intv (Tr ! i))) = (\<lambda>i. cnt (Tr ! i))" by auto

      have aux2: "a \<ge> b \<Longrightarrow> Suc (a - b) = Suc a - b" for a b by simp

      have aux3: "shared_left (St ! vI) > 0" 
        by (simp add: St_nonempty VBOUND)

      have aux4: "ls_intv (St ! vI) \<noteq> []" 
        by(simp add: aux3)


      have A1: "Suc (bcI - shared_right (Tr ! tcI)) = shared_left (Tr ! tcI)"
        apply(subst aux2) 
        by(auto simp: BB BUPP)

      have A2: "Suc tcI = shared_left (St ! vI) + shared_right (St ! vI) \<Longrightarrow> Suc i = shared_left (St ! vI) \<Longrightarrow> Suc (bcI - shared_right (Tr ! (i + shared_right (St ! vI)))) = shared_left (Tr ! (i + shared_right (St ! vI)))" for i
        apply(subgoal_tac "i + shared_right (St ! vI) = tcI") 
        using A1 apply presburger
        by force

      have B1: "Suc (visited_br_in_tr (uid (St ! vI) - Suc 0)) = last (map (\<lambda>i. if Suc i = uid (St ! vI) then Suc (visited_br_in_tr i) else visited_br_in_tr i) (ls_intv (St ! vI)))"
        by(auto simp: visited_br_in_tr_def last_map[OF aux4] TB TUPP St_nonempty VBOUND last_intv aux3 shared_sum_as_left_plus_right)

      have B2: "sum_list (map visited_br_in_tr (butlast (ls_intv (St ! vI)))) = sum_list (butlast (map (\<lambda>i. if Suc i = uid (St ! vI) then Suc (visited_br_in_tr i) else visited_br_in_tr i) (ls_intv (St ! vI))))"
        apply(rule sum_list_eq)
        subgoal by simp
        subgoal by(auto simp flip: map_butlast simp add: butlast_intv)
        done

      have "Suc (sum_list (map visited_br_in_tr (ls_intv (St ! vI)))) 
        = sum_list (map visited_br_in_tr (butlast (ls_intv (St ! vI)))) + Suc (visited_br_in_tr (uid (St ! vI) - Suc 0))"
        apply(subst ls_intv_butlast_last) 
        by (auto simp add: St_nonempty VBOUND simp flip: butlast_intv)
      also have "... = sum_list (butlast (map (\<lambda>i. if Suc i = uid (St ! vI) then Suc (visited_br_in_tr i) else visited_br_in_tr i) (ls_intv (St ! vI)))) + last (map (\<lambda>i. if Suc i = uid (St ! vI) then Suc (visited_br_in_tr i) else visited_br_in_tr i) (ls_intv (St ! vI)))"
        by (auto simp: B1 B2) 
      also have "... = sum_list (map (\<lambda>i. if Suc i = uid (St ! vI) then Suc (visited_br_in_tr i) else visited_br_in_tr i) (ls_intv (St ! vI)))"
        apply(subst sum_list_butlast_last)
        using St_nonempty VBOUND by auto
      also have "... = (\<Sum>i\<leftarrow>ls_intv (St ! vI). shared_left (Tr ! i))"
        apply(rule sum_list_eq)
        subgoal by simp
        subgoal using BB TB BUPP TUPP
          by (auto simp: visited_br_in_tr_def A1 A2 shared_sum_as_left_plus_right ls_intv_nth) 
        done

      finally show ?thesis
      unfolding ci_\<alpha>_def E_succ_\<alpha>_def
      by(clarsimp simp: VBOUND length_concat visited_br_in_tr_def BUPP ls_intv_nth  shared_sum_as_left_plus_right TUPP aux1 intro!: sum_list_eq)
    qed


    lemma branch_successor_bounds: assumes "Suc bcI < beI" shows "Suc ci_\<alpha> < length (E_succ_\<alpha> vI)"
    proof -
      obtain bn where BN_DEF: "Suc bn = beI" using beI_nonzero 
        by(cases beI; auto)
      hence A: "bcI < bn" using assms
        by fastforce

      have B: "bn < beI" using BN_DEF by simp
      
      have INV: "modest_successor_index_invar N\<^sub>s SS (vI,tcI,teI,bn,beI)" 
        using modest_successor_index_invar_axioms
        apply(unfold_locales)
        unfolding modest_successor_index_invar_def modest_successor_index_invar_axioms_def
        using A B by auto

      have "Suc ci_\<alpha> \<le> modest_successor_index_def.ci_\<alpha> SS (vI,tcI,teI,bn,beI)"
        using gt_bc_ci_\<alpha>_gt[OF A B] by simp
      also have "... < length (E_succ_\<alpha> vI)"
        using modest_successor_index_invar.ci_\<alpha>_bound_length_E_succ[OF INV] by simp
      finally show ?thesis .
    qed

    lemma transition_successor_bounds: assumes "Suc tcI < teI" shows "Suc ci_\<alpha> < length (E_succ_\<alpha> vI)"
    proof -
      obtain tn where TN: "Suc tn = teI" using teI_nonzero 
        by(cases teI; auto)
      hence A: "tcI < tn" using assms by simp
      have B: "tn < teI" using TN by simp

      have INTV_TN: "in_intv (St ! vI) tn" using TN A TLOW TUPP unfolding in_intv_def by linarith 
      then obtain bn where INTV_BN: "in_intv (Tr ! tn) bn" using transition_has_branch[OF VBOUND] by blast

      define be where "be \<equiv> uid (Tr ! tn)"

      have INV: "modest_successor_index_invar N\<^sub>s SS (vI,tn,teI,bn,be)" 
        using modest_successor_index_invar_axioms
        apply(unfold_locales)
        unfolding modest_successor_index_invar_def modest_successor_index_invar_axioms_def
        using A B by (auto simp: be_def INTV_BN)
      
      have "Suc ci_\<alpha> \<le> modest_successor_index_def.ci_\<alpha> SS (vI, tn, teI, bn, be)" 
        using gt_tc_ci_\<alpha>_gt[OF A B INTV_BN, of be]
        by(simp add: be_def)
      also have "... < length (E_succ_\<alpha> vI)"
        using modest_successor_index_invar.ci_\<alpha>_bound_length_E_succ[OF INV] by simp
      finally show ?thesis .
    qed

    lemma E_succ_\<alpha>_correct: "E_succ_\<alpha> vI ! ci_\<alpha> = Br ! bcI"
      unfolding E_succ_\<alpha>_def ci_\<alpha>_def
      apply(clarsimp simp: VBOUND)
      apply(subst concat_nth_sum_list_indices[where ?j="tcI - lid (St ! vI)" and ?k = "bcI - lid (Tr ! tcI)"])
      subgoal by simp
      subgoal by auto
      subgoal 
        apply clarsimp
        apply(subst nth_map) 
        apply(auto elim: less_trans)[]
        apply(subst nth_map)
        apply(auto elim: less_trans)[]
        unfolding visited_br_in_tr_def 
        apply clarsimp 
        apply(rule conjI) 
        apply clarsimp_all
        using ls_intv_nth tc_sub_lid_lt_cnt by fastforce+
      subgoal
        by (auto simp: visited_br_in_tr_def)
      subgoal by fastforce
      subgoal by (auto simp: visited_br_in_tr_def ls_intv_nth)
      subgoal by simp
      done

    lemma has_next_index_bounds: "has_next \<alpha> \<longleftrightarrow> Suc bcI < beI \<or> Suc tcI < teI"
      unfolding has_next_def \<alpha>_def
      using last_id_eq_length_E_succ BBOUND TBOUND branch_successor_bounds transition_successor_bounds nat_less_le
      by force

    lemma next_id_bcI_correct: "modest_successor_index_def.ci_\<alpha> SS (vI, tcI, teI, Suc bcI, beI) = Suc ci_\<alpha>"
      unfolding modest_successor_index_def.ci_\<alpha>_def
      apply(rule sum_list_Suc_eq[symmetric, where ?j="tcI - lid (St ! vI)"])
      subgoal by simp
      subgoal 
        by(auto simp: modest_successor_index_def.visited_br_in_tr_def dest!: not_less_less_Suc_eq)
      subgoal by fastforce
      subgoal by (auto simp: modest_successor_index_def.visited_br_in_tr_def Suc_diff_le[OF BLOW])
      done

    lemma next_id_tcI_correct: "Suc bcI = beI \<Longrightarrow> modest_successor_index_def.ci_\<alpha> SS (vI, Suc tcI, teI, shared_right (Tr ! Suc tcI), shared_sum (Tr ! Suc tcI)) = Suc ci_\<alpha>"
      unfolding modest_successor_index_def.ci_\<alpha>_def
      apply(rule sum_list_Suc_eq[symmetric, where ?j="tcI - lid (St ! vI)"])
      subgoal by simp
      subgoal 
        by(auto simp: modest_successor_index_def.visited_br_in_tr_def dest!: not_less_less_Suc_eq)
      subgoal by fastforce
      subgoal by (auto simp: modest_successor_index_def.visited_br_in_tr_def Suc_diff_le[OF BLOW, symmetric] BUPP)
      done

  end

  lemma statespace_unique_index_invar:
    assumes INV1: "modest_successor_index_invar N SS (v',tc',te',bc',be')"
    assumes INV2: "modest_successor_index_invar N SS (v ,tc ,te ,bc ,be )" 
    and EQ: "modest_successor_index_def.\<alpha> SS (v, tc, te, bc, be) = modest_successor_index_def.\<alpha> SS (v', tc', te', bc', be')"
    shows "v = v'" and "tc = tc'" and "te = te'" and "bc = bc'" and "be = be'" 
  proof -

    from EQ show VEQ: "v = v'" unfolding modest_successor_index_def.\<alpha>_def by force

    with INV1 INV2 show TEEQ: "te = te'" unfolding modest_successor_index_invar_def modest_successor_index_invar_axioms_def
      by clarsimp
    with INV1 INV2 show TCEQ: "tc = tc'" unfolding modest_successor_index_invar_def modest_successor_index_invar_axioms_def
      apply clarsimp 
      by (metis EQ INV1 INV2 less_irrefl_nat linorder_neqE_nat modest_successor_index_def.\<alpha>_def modest_successor_index_invar.in_intv_bcI modest_successor_index_invar.lt_tc_ci_\<alpha>_lt modest_successor_index_simps(1) modest_successor_index_simps(2) modest_successor_index_simps(3) modest_successor_index_simps(4) modest_successor_index_simps(5))
    with INV1 INV2 show BEEQ: "be = be'" unfolding modest_successor_index_invar_def modest_successor_index_invar_axioms_def
      by clarsimp
    with INV1 INV2 show BCEQ: "bc = bc'" unfolding modest_successor_index_invar_def modest_successor_index_invar_axioms_def
      by (metis EQ INV1 INV2 modest_successor_index_def.\<alpha>_def modest_successor_index_invar.gt_tc_ci_\<alpha>_gt modest_successor_index_invar.in_intv_bcI modest_successor_index_invar.lt_bc_ci_\<alpha>_lt modest_successor_index_simps(1) modest_successor_index_simps(2) modest_successor_index_simps(3) modest_successor_index_simps(4) modest_successor_index_simps(5) nat_neq_iff)
  qed


  subsection \<open>Refinement to concrete\<close>

  lemma modest_is_empty_refine_aux:
    assumes VB: "v < N\<^sub>s" 
    and GREL: "(SS,E_succ) \<in> modest_graph_succ_SS_rel N\<^sub>s SS\<^sub>c" 
    shows "RETURN (modest_graph_def.modest_is_empty SS v) \<le> mop_is_empty E_succ v"
  proof -
    from GREL interpret modest_graph_invar N\<^sub>s SS\<^sub>c SS unfolding modest_graph_succ_SS_rel_def
      by(auto simp: in_br_conv)

    from GREL have EDEF[simp]: "E_succ = E_succ_\<alpha>" unfolding modest_graph_succ_SS_rel_def
      by(auto simp: in_br_conv SS_DEF)

    obtain i where A: "i\<in>sn_intv (St ! v)" "cnt(Tr ! i) > 0"
      using state_has_transition[OF VB[unfolded NS_DEF]]
      by(auto simp: T_in_bound_intvD[OF VB[unfolded NS_DEF], THEN Tr_nonempty] )
    

    show ?thesis
      unfolding mop_is_empty_def
      apply simp
      unfolding fr_graph_defs.is_empty_def
        modest_graph_def.modest_is_empty_def modest_graph_def.E_succ_\<alpha>_def
      using VB A
      by(auto simp: NS_DEF)
  qed


  lemma modest_index_begin_refine_aux: "v < N\<^sub>s \<Longrightarrow> modest_graph_invar' N\<^sub>s SS \<Longrightarrow> RETURN (modest_graph_def.modest_index_begin SS v) \<le> \<Down>(modest_succ_index_SS_rel N\<^sub>s SS) (mop_index_begin E_succ v)"
    unfolding mop_index_begin_def
    apply(refine_vcg)
    using modest_graph_invar'.init_id_modest_succ_index_correct
    by fast


  lemma modest_get_state_refine: "((v,tc,te,bc,be),(v',i)) \<in> modest_succ_index_SS_rel N\<^sub>s SS \<Longrightarrow> 
      RETURN (modest_successor_index_def.modest_get_state (v,tc,te,bc,be)) \<le> \<Down>(node_rel' N\<^sub>s) (mop_get_state (v',i))"
    unfolding modest_successor_index_def.modest_get_state_def mop_get_state_def fr_graph_defs.get_state_def
    by (auto simp: modest_succ_index_SS_rel_def in_br_conv modest_successor_index_def.\<alpha>_def 
      modest_successor_index_invar_def modest_successor_index_invar_axioms_def modest_graph_invar_def modest_graph_invar'_def)


  lemma modest_succ_at_refine_aux:
    assumes SREL: "((v,tc,te,bc,be),(v',i)) \<in> modest_succ_index_SS_rel N\<^sub>s SS" 
    and GREL: "(SS,E_succ) \<in> modest_graph_succ_SS_rel N\<^sub>s SS\<^sub>c"        
    shows "RETURN (modest_successor_index_def.modest_succ_at SS (v,tc,te,bc,be)) \<le> \<Down>(node_rel' N\<^sub>s) (mop_graph_succ_at E_succ (v',i))"
  proof -

    from SREL interpret modest_successor_index_invar N\<^sub>s SS"(v,tc,te,bc,be)" 
      unfolding modest_succ_index_SS_rel_def by(auto simp: in_br_conv)

    from SREL have I_DEF[simp]: "i = ci_\<alpha>" "v' = v"
      unfolding modest_succ_index_SS_rel_def by(auto simp: in_br_conv \<alpha>_def)

    from GREL have E_SUCC_DEF[simp]: "E_succ = E_succ_\<alpha>"
      unfolding modest_graph_succ_SS_rel_def by(auto simp: in_br_conv)

    show ?thesis
      unfolding mop_graph_succ_at_def modest_succ_at_def fr_graph_defs.successor_at_def
        modest_succ_index_SS_rel_def modest_graph_succ_rel_def 
      using E_succ_\<alpha>_correct bcI_bound 
      by(clarsimp simp: in_br_conv NS_DEF intro!: B_in_bound)
  qed


  lemma modest_has_successor_refine_aux: 
    assumes SREL: "((v,tc,te,bc,be),(v',i)) \<in> modest_succ_index_SS_rel N\<^sub>s SS" 
    and GREL: "(SS,E_succ) \<in> modest_graph_succ_SS_rel N\<^sub>s SS\<^sub>c" 
    shows "RETURN (modest_successor_index_def.modest_has_successor (v,tc,te,bc,be)) \<le> (mop_has_succ E_succ (v',i))"
  proof -

    from SREL interpret modest_successor_index_invar N\<^sub>s SS "(v,tc,te,bc,be)" 
      unfolding modest_succ_index_SS_rel_def by(auto simp: in_br_conv)

    from SREL have I_DEF[simp]: "i = ci_\<alpha>" "v'=v"
      unfolding modest_succ_index_SS_rel_def by(auto simp: in_br_conv \<alpha>_def)

    from GREL have E_SUCC_DEF[simp]: "E_succ = E_succ_\<alpha>"
      unfolding modest_graph_succ_SS_rel_def by(auto simp: in_br_conv)


    show ?thesis
      unfolding mop_has_succ_def modest_has_successor_def fr_graph_defs.has_next_def
        modest_succ_index_SS_rel_def modest_graph_succ_rel_def 
      using branch_successor_bounds transition_successor_bounds TBOUND BBOUND 
      apply(clarsimp simp: in_br_conv) 
      using last_id_eq_length_E_succ by fastforce
  qed


  lemma modest_next_index_refine_aux: 
    assumes SREL: "((v,tc,te,bc,be),(v',i)) \<in> modest_succ_index_SS_rel N\<^sub>s SS" 
    and GREL: "(SS,E_succ) \<in> modest_graph_succ_SS_rel N\<^sub>s SS\<^sub>c" 
    and HN: "fr_graph_defs.has_next E_succ (v,i)"
    shows "RETURN (modest_successor_index_def.modest_next_index SS (v,tc,te,bc,be)) \<le> \<Down>(modest_succ_index_SS_rel N\<^sub>s SS\<^sub>c) (mop_next_id E_succ (v',i))"
  proof -

    from SREL interpret modest_successor_index_invar N\<^sub>s SS "(v,tc,te,bc,be)" 
      unfolding modest_succ_index_SS_rel_def by(auto simp: in_br_conv)

    from SREL have I_DEF[simp]: "i = ci_\<alpha>" "v'=v"
      unfolding modest_succ_index_SS_rel_def by(auto simp: in_br_conv \<alpha>_def)

    from GREL have E_SUCC_DEF[simp]: "E_succ = E_succ_\<alpha>"
      unfolding modest_graph_succ_SS_rel_def by(auto simp: in_br_conv)

    have SS\<^sub>c_eq: "SS\<^sub>c = SS"
      using GREL modest_graph_succ_rel_SS_eq by blast

    from HN have A: "(\<not> Suc bc < be \<Longrightarrow> Suc tc < te)" using has_next_index_bounds by (simp add: \<alpha>_def)

    {
      assume X: "Suc bc < be"
      have "modest_successor_index_invar N\<^sub>s SS (v, tc, te, Suc bc, be)"
        apply(unfold_locales)
        subgoal using TBOUND by simp
        subgoal using X by simp
        subgoal using TUPP by simp
        subgoal using BUPP by simp
        subgoal using TLOW by simp
        subgoal using BLOW by simp
        subgoal using VBOUND by simp
        done
    } note BINV = this

    {
      assume X: "Suc tc < te"
                                       
      have "Suc tc < length Tr" 
        using less_le_trans[OF X teI_bound[simplified]] .

      hence "cnt (Tr ! Suc tc) > 0"
        by(auto intro!: Tr_nonempty)

      hence "modest_successor_index_invar N\<^sub>s SS (v, Suc tc, te, shared_right (Tr ! Suc tc), shared_sum (Tr ! Suc tc))"
        apply(unfold_locales)
        subgoal using X by simp
        subgoal by simp
        subgoal using TUPP by simp
        subgoal using BUPP by simp
        subgoal using TLOW by simp
        subgoal using BLOW by simp
        subgoal using VBOUND by simp
        done
    } note TINV = this

    show ?thesis
      unfolding modest_next_index_def mop_next_id_def fr_graph_defs.next_index_def
      apply(refine_vcg)
      using BBOUND 
      by(auto intro!: TINV next_id_tcI_correct[simplified, symmetric] 
        simp: A modest_succ_index_SS_rel_def in_br_conv next_id_bcI_correct[simplified] BINV modest_successor_index_def.\<alpha>_def SS\<^sub>c_eq)
  qed


  definition "modest_get_transitions_of_state = (\<lambda> (St, Tr, Br) v.
    do {
      ASSERT (v < length St);
      r \<leftarrow> b_assn_open_block St (\<lambda>St. RETURN (St ! v));
      ASSERT (shared_sum r \<le> length Tr);
      RETURN r
    })"


  lemma modest_get_transitions_of_state_alt: "modest_get_transitions_of_state = modest_graph_def.get_transitions_of_state"
    unfolding modest_get_transitions_of_state_def modest_graph_def.get_transitions_of_state_def b_assn_open_block_def
    by (auto simp: Let_def)
    

  definition "modest_get_branches_of_transition = (\<lambda> (St, Tr, Br) v .
    do {
      ASSERT (v < length Tr);
      r \<leftarrow> b_assn_open_block Tr (\<lambda>Tr. RETURN (Tr ! v));
      ASSERT (shared_sum r \<le> length Br);
      RETURN r
    })"

  lemma modest_get_branches_of_transition_alt: "modest_get_branches_of_transition = modest_graph_def.get_branches_of_transition"
    unfolding modest_graph_def.get_branches_of_transition_def modest_get_branches_of_transition_def b_assn_open_block_def
    by (auto simp: Let_def)
  
  definition "modest_get_target_of_branch = (\<lambda>(St, Tr, Br) v. 
    do {
      ASSERT (v < length Br);
      r \<leftarrow> b_assn_open_block Br (\<lambda>Br. RETURN (Br ! v));
      ASSERT (r < length St);
      RETURN r
    })"

  lemma modest_get_target_of_branch_alt: "modest_get_target_of_branch = modest_graph_def.get_successor_of_branch"
    unfolding modest_graph_def.get_successor_of_branch_def modest_get_target_of_branch_def b_assn_open_block_def
    by (auto simp: Let_def)

  definition "modest_index_begin_alt = (\<lambda> SS v.
    do {
      td \<leftarrow> modest_get_transitions_of_state SS v;
      let ltd = (lid td);
      bd \<leftarrow> modest_get_branches_of_transition SS ltd;
      RETURN (v,lid td,uid td,lid bd,uid bd)
    })"


  lemma modest_index_begin_alt_refine:
    assumes INV: "modest_graph_invar' N SS"
    assumes VN: "v < N"
    shows "modest_index_begin_alt SS v \<le> RETURN (modest_graph_def.modest_index_begin SS v)"
    proof-       
      interpret modest_graph_invar' N SS using INV .
thm modest_graph_invar.axioms(1)
      note VB = VN[unfolded modest_graph_invar'.NS_DEF[OF INV]]

      show ?thesis
        unfolding modest_index_begin_alt_def modest_graph_def.modest_index_begin_def
          modest_get_transitions_of_state_alt modest_get_branches_of_transition_alt 
        apply (refine_vcg get_transitions_of_state_refine[OF VB])
        using St_nonempty T_in_boundD VB
          by (force intro: get_branches_of_transition_refine[THEN order_trans])+
    qed


  definition "modest_succ_at_alt = (\<lambda> SS (v,tc,te,bc,be).
    do{
      modest_get_target_of_branch SS bc
    })"

  lemma modest_succ_at_alt_refine: "bc < length Br \<Longrightarrow> modest_graph_invar N SS\<^sub>c (St,Tr,Br) \<Longrightarrow> modest_succ_at_alt (St,Tr,Br) (v,tc,te,bc,be) \<le> RETURN (modest_successor_index_def.modest_succ_at (St,Tr,Br) (v,tc,te,bc,be))"
    unfolding modest_succ_at_alt_def modest_successor_index_def.modest_succ_at_def 
      modest_get_target_of_branch_alt modest_graph_def.get_successor_of_branch_def
    apply(refine_vcg) 
    apply simp
    apply (simp add: modest_graph_invar_def modest_graph_invar_axioms_def modest_graph_invar'_def)
    by simp


  definition "modest_has_successor_alt = (\<lambda> SS (v,tc,te,bc,be).
    do{
      ASSERT (Suc tc \<le> te);
      ASSERT (Suc bc \<le> be);
      RETURN (Suc tc < te \<or> Suc bc < be)
    })"

  lemma modest_has_successor_alt_refine:
    assumes INV: "modest_successor_index_invar N SS (v,tc,te,bc,be)" 
    shows "modest_has_successor_alt SS (v,tc,te,bc,be) \<le> RETURN ((\<lambda>SS. modest_successor_index_def.modest_has_successor) SS (v,tc,te,bc,be))"
  proof-
    from INV interpret modest_successor_index_invar N SS "(v,tc,te,bc,be)" .

    show ?thesis
      unfolding modest_has_successor_alt_def modest_has_successor_def
      using TBOUND BBOUND by auto
  qed


  definition "modest_next_index_alt = (\<lambda> SS (v,tc,te,bc,be).
    do{
      ASSERT(Suc bc \<le> be);
      let bc' = Suc bc;
      if bc' < be then do {
        RETURN (v,tc,te,bc',be)
      }
      else do{
        ASSERT(Suc tc < te);
        let tc' = Suc tc;
        ti \<leftarrow> modest_get_branches_of_transition SS tc';
        let bc' = lid ti;
        let be' = uid ti;
        RETURN (v,tc',te,bc',be')
      }
    }
  )"

  lemma modest_next_index_alt_refine: 
    assumes INV: "modest_successor_index_invar N SS (v,tc,te,bc,be)" 
    assumes NEXT: "fr_graph_defs.has_next (modest_graph_def.E_succ_\<alpha> SS) (modest_successor_index_def.\<alpha> SS (v,tc,te,bc,be))"
    shows "modest_next_index_alt SS (v,tc,te,bc,be) \<le> RETURN (modest_successor_index_def.modest_next_index SS (v,tc,te,bc,be))"
  proof -
    from INV interpret modest_successor_index_invar N SS "(v,tc,te,bc,be)" .

    from NEXT have A: "(Suc bc < be \<or> Suc tc < te)" unfolding has_next_index_bounds by simp

    show ?thesis
      unfolding modest_next_index_alt_def modest_next_index_def modest_get_branches_of_transition_alt get_branches_of_transition_def
      apply(refine_vcg)
      using TBOUND BBOUND teI_bound A
      by(auto simp: T_in_bound) 
  qed
        

  subsubsection \<open>Correctness\<close>

  lemma modest_is_empty_correct:  "(RETURN oo modest_graph_def.modest_is_empty, mop_is_empty) \<in> (modest_graph_succ_SS_rel N SS) \<rightarrow> node_rel' N \<rightarrow> \<langle>bool_rel\<rangle>nres_rel"
    apply (refine_vcg) 
    by (auto intro: modest_is_empty_refine_aux)


  lemma modest_index_begin_correct: "(modest_index_begin_alt, mop_index_begin) \<in> (modest_graph_succ_SS_rel N SS) \<rightarrow> node_rel' N \<rightarrow> \<langle>(modest_succ_index_SS_rel N SS)\<rangle>nres_rel"
    apply(refine_vcg)
    apply(clarsimp simp: in_br_conv modest_graph_succ_SS_rel_def)
    apply(frule modest_graph_invar.SS_DEF[symmetric])
    apply(rule modest_index_begin_alt_refine[THEN order_trans])
    apply(drule modest_graph_invar.axioms(1))
    apply clarsimp
    apply assumption+
    apply(rule modest_index_begin_refine_aux[THEN order_trans])
    by (auto dest: modest_graph_invar.axioms(1))


  lemma modest_get_state_get_state_correct: "(RETURN o modest_successor_index_def.modest_get_state, mop_get_state) \<in> modest_succ_index_SS_rel N SS \<rightarrow> \<langle>node_rel' N\<rangle>nres_rel"
    apply(refine_vcg)
    by(auto intro!: modest_get_state_refine)


  lemma modest_succ_at_correct: "(modest_succ_at_alt, mop_graph_succ_at) \<in> (modest_graph_succ_SS_rel N SS\<^sub>c) \<rightarrow> (modest_succ_index_SS_rel N SS\<^sub>c) \<rightarrow> \<langle>node_rel' N\<rangle>nres_rel"
    apply (refine_vcg)
    apply(frule modest_graph_succ_rel_SS_eq)
    apply clarsimp
    apply(rule modest_succ_at_alt_refine[THEN order_trans])
    subgoal for St Tr Br x v tc te bc be v' i
      apply(clarsimp simp: modest_succ_index_SS_rel_def in_br_conv ) 
      apply(frule modest_successor_index_invar.beI_bound) 
      apply(drule modest_successor_index_invar.BBOUND)
      apply auto
      done
    apply(auto simp: modest_graph_succ_SS_rel_def in_br_conv)[]
    apply(rule modest_succ_at_refine_aux)
    by assumption+


  lemma modest_has_successor_correct: "(modest_has_successor_alt, mop_has_succ) \<in> (modest_graph_succ_SS_rel N SS\<^sub>c) \<rightarrow> (modest_succ_index_SS_rel N SS\<^sub>c) \<rightarrow> \<langle>bool_rel\<rangle>nres_rel"
    apply(refine_vcg)
    apply clarsimp
    apply(rule modest_has_successor_alt_refine[THEN order_trans])
    apply(auto simp: modest_succ_index_SS_rel_def in_br_conv dest: modest_graph_succ_rel_SS_eq)[]
    apply(rule modest_has_successor_refine_aux)
    apply(auto dest: modest_graph_succ_rel_SS_eq)
    done


  lemma modest_next_index_correct: "(uncurry modest_next_index_alt, uncurry mop_next_id) \<in> [\<lambda> (E_succ,ci). fr_graph_defs.has_next E_succ ci]\<^sub>f (modest_graph_succ_SS_rel N SS\<^sub>c) \<times>\<^sub>r (modest_succ_index_SS_rel N SS\<^sub>c) \<rightarrow> \<langle>(modest_succ_index_SS_rel N SS\<^sub>c)\<rangle>nres_rel"
    apply(clarsimp intro!: frefI nres_relI)
    apply(rule modest_next_index_alt_refine[THEN order_trans])

    apply(frule modest_graph_succ_rel_SS_eq)
    apply(auto simp: modest_succ_index_SS_rel_def in_br_conv)[]

    apply(frule modest_graph_succ_rel_SS_eq)
    apply(auto simp: modest_graph_succ_SS_rel_def modest_succ_index_SS_rel_def in_br_conv)[]

    apply (auto intro!: modest_next_index_refine_aux 
      dest: modest_graph_succ_rel_SS_eq modest_succ_index_rel_vD)
    done


  subsection \<open>LLVM Data Structures\<close>

  subsubsection \<open>Modest graph\<close>

  type_synonym modest_graphi = "
    shared_nat ptr 
  \<times> shared_nat ptr
  \<times> size_t ptr
  "

  definition modest_graph_assn_aux :: "modest_graph \<Rightarrow> modest_graphi \<Rightarrow> assn"
  where "modest_graph_assn_aux = 
     small_array_assn shared_nat_assn \<comment> \<open>List of states\<close>
  \<times>\<^sub>a small_array_assn shared_nat_assn \<comment> \<open>List of transitions\<close>
  \<times>\<^sub>a small_array_assn size_assn \<comment> \<open>List of Branches\<close>"
  
  lemma modest_graph_assn_boundsD: 
    assumes "rdomp modest_graph_assn_aux (S, B, T)"
    shows "length S < max_snat 64" and "length B < max_snat 64" and "length T < max_snat 64"
    using assms unfolding modest_graph_assn_aux_def
    apply auto
    done

  definition "modest_graph_succ_SS_assn N SS = hr_comp modest_graph_assn_aux (modest_graph_succ_SS_rel N SS)"

  definition "modest_graph_succ_assn N = hr_comp modest_graph_assn_aux (modest_graph_succ_rel N)"

  lemma modest_graph_succ_assn_alt: "modest_graph_succ_assn N E_succ Ei = (EXS SS. modest_graph_succ_SS_assn N SS E_succ Ei)"
    unfolding modest_graph_succ_SS_assn_def modest_graph_succ_rel_def modest_graph_succ_assn_def
    using modest_graph_succ_rel_SS_eq
    by (fastforce simp: fun_eq_iff hr_comp_def sep_algebra_simps)


  subsubsection \<open>Modest Graph Index\<close>

  type_synonym modest_indexi = "
    node_t 
  \<times> size_t 
  \<times> size_t 
  \<times> size_t 
  \<times> size_t
  "

  definition modest_index_assn_aux :: "nat modest_succ_index \<Rightarrow> modest_indexi \<Rightarrow> assn"
  where "modest_index_assn_aux = snat_assn' TYPE(node_T) \<times>\<^sub>a size_assn \<times>\<^sub>a size_assn \<times>\<^sub>a size_assn \<times>\<^sub>a size_assn"

  definition "modest_index_SS_assn N SS = hr_comp modest_index_assn_aux (modest_succ_index_SS_rel N SS)"

  lemma is_pure_modest_index_assn[safe_constraint_rules]: 
      "is_pure (modest_index_SS_assn N SS)" unfolding modest_index_SS_assn_def modest_index_assn_aux_def by solve_constraint

  subsection \<open>Refinement to LLVM\<close>

  sepref_def get_transitions_of_state_ll is "uncurry modest_get_transitions_of_state" :: "modest_graph_assn_aux\<^sup>k *\<^sub>a (snat_assn' TYPE(node_T))\<^sup>k \<rightarrow>\<^sub>a shared_nat_assn"
    unfolding modest_get_transitions_of_state_def modest_graph_assn_aux_def 
    apply sepref
    done


  sepref_def get_branches_of_transition_ll is "uncurry modest_get_branches_of_transition" :: "modest_graph_assn_aux\<^sup>k *\<^sub>a size_assn\<^sup>k \<rightarrow>\<^sub>a shared_nat_assn"
    unfolding modest_get_branches_of_transition_def modest_graph_assn_aux_def  
    apply sepref
    done


  sepref_def get_successor_of_branch_ll is "uncurry modest_get_target_of_branch" :: "modest_graph_assn_aux\<^sup>k *\<^sub>a size_assn\<^sup>k \<rightarrow>\<^sub>a size_assn"
    unfolding modest_get_target_of_branch_def modest_graph_assn_aux_def 
    apply sepref
    done

  sepref_def modest_is_empty_ll is "uncurry (RETURN oo modest_graph_def.modest_is_empty)" :: "(modest_graph_assn_aux)\<^sup>k *\<^sub>a (snat_assn' TYPE(node_T))\<^sup>k \<rightarrow>\<^sub>a bool1_assn"
    unfolding modest_graph_def.modest_is_empty_def
    by sepref

  sepref_def modest_index_begin_ll2 is "uncurry modest_index_begin_alt" :: "modest_graph_assn_aux\<^sup>k *\<^sub>a (snat_assn' TYPE(node_T))\<^sup>k \<rightarrow>\<^sub>a modest_index_assn_aux"
    unfolding modest_index_begin_alt_def modest_index_assn_aux_def
    modest_graph_def.St_def
    by sepref

  sepref_def modest_index_begin_ll is "uncurry modest_index_begin_alt" :: "modest_graph_assn_aux\<^sup>k *\<^sub>a (snat_assn' TYPE(node_T))\<^sup>k \<rightarrow>\<^sub>a modest_index_assn_aux"
    unfolding modest_index_begin_alt_def modest_index_assn_aux_def
    modest_graph_def.St_def
    by sepref

  sepref_def modest_get_state_ll is "RETURN o modest_successor_index_def.modest_get_state" :: "modest_index_assn_aux\<^sup>k \<rightarrow>\<^sub>a snat_assn' TYPE(node_T)"
    unfolding modest_successor_index_def.modest_get_state_def modest_index_assn_aux_def modest_successor_index_def.vI_def
    by sepref

  sepref_def modest_succ_at_alt_ll is "uncurry modest_succ_at_alt" :: "modest_graph_assn_aux\<^sup>k *\<^sub>a modest_index_assn_aux\<^sup>k \<rightarrow>\<^sub>a snat_assn' TYPE(node_T)"
    unfolding modest_succ_at_alt_def modest_index_assn_aux_def
    by sepref

  sepref_def modest_has_successor_def_ll is "uncurry modest_has_successor_alt" :: "modest_graph_assn_aux\<^sup>k *\<^sub>a modest_index_assn_aux\<^sup>k \<rightarrow>\<^sub>a bool1_assn"
    unfolding modest_has_successor_alt_def modest_index_assn_aux_def
    by sepref

  sepref_def modest_next_index_ll is "uncurry modest_next_index_alt" :: "modest_graph_assn_aux\<^sup>k *\<^sub>a modest_index_assn_aux\<^sup>d \<rightarrow>\<^sub>a modest_index_assn_aux"
    unfolding modest_next_index_alt_def  modest_index_assn_aux_def
    by sepref

  context 
    notes [fcomp_norm_unfold] = modest_graph_succ_SS_assn_def[symmetric] modest_index_SS_assn_def[symmetric]
  begin

    lemmas mop_is_empty_hnr[sepref_fr_rules] = modest_is_empty_ll.refine[FCOMP modest_is_empty_correct]
    lemmas mop_index_begin_hnr[sepref_fr_rules] = modest_index_begin_ll.refine[FCOMP modest_index_begin_correct]
    lemmas mop_get_state_hnr[sepref_fr_rules] = modest_get_state_ll.refine[FCOMP modest_get_state_get_state_correct]
    lemmas mop_graph_succ_at_hnr[sepref_fr_rules] = modest_succ_at_alt_ll.refine[FCOMP modest_succ_at_correct]
    lemmas mop_has_succ_hnr[sepref_fr_rules] = modest_has_successor_def_ll.refine[FCOMP modest_has_successor_correct]
    lemmas mop_next_id_hnr[sepref_fr_rules] = modest_next_index_ll.refine[FCOMP modest_next_index_correct]

  end

end