<!--
  IMPORTANT: If you landed here from a downloaded archive file, go to html/index.html to view this page in a browsable form!
-->
# Fast Verified SCCs for Probabilistic Model Checking

## Browsing the Theories
  You can view an [html version](Gabow_SCC_Modest/index.html) of the theories. Here are some default starting points for browsing:

  [Skeleton Algorithm](Gabow_SCC_Modest/Gabow_Skeleton.html) Abstract level and Gabow's data structure

  [SCC Algorithm](Gabow_SCC_Modest/Gabow_SCC.html) Abstract level and Gabow's data structure

  [Bit-Packed Intervals](Gabow_SCC_Modest/SharedNat.html)

  [Modest MDP Data Structure](Gabow_SCC_Modest/Modest_MDP.html)

  [LLVM Code Generation](Gabow_SCC_Modest/Gabow_SCC_Code.html)

  [Main Correctness Theorem](Gabow_SCC_Modest/Gabow_SCC_Code.html#Gabow_SCC_Code.Modest_graph_SCC_impl_correct_htriple|fact)



## Downloads
  [dist.tgz](dist.tgz)  contains the Isabelle theories

  [modest.tgz](modest.tgz) contains our modified version of Modest (~1GiB)


## Prerequisites
  * To compile the LLVM code: Working installation of [LLVM](http://releases.llvm.org/) version >= 10.0.0.
  * To re-check the proofs: Working installation of [Isabelle/HOL](https://isabelle.in.tum.de) 
    with the [Archive of Formal Proofs](https://www.isa-afp.org) installed 
    as as described on [https://www.isa-afp.org/using.shtml](https://www.isa-afp.org/using.shtml). 
    We require version = Isabelle-2022, which, at the time of writing, is the current version.
  * To replay the benchmarks: our modified version of Modest ([modest.tgz](modest.tgz))


## Viewing the Theories
  Warning: the .thy files in this arrtifact are best viewed with the [Isabelle/HOL](https://isabelle.in.tum.de) IDE.
  There is also a [html version](Gabow_SCC_Modest/index.html), that can be viewed in the browser.
  Look for html/index.html if you are viewing this file as README.md!

## Verifying the Theories and Building the LLVM code
In the main directory, run

    
On Linux: 
Make sure that the isabelle command points to your installation of Isabelle 2022. If this is not the case, we 
recommend you do this first. Run:

	isabelle build -D.


On Windows: 
You can start a cygwin terminal via $ISABELLE_HOME/Cygwin-Terminal.bat. You then have to navigate to the folder
that this projects ROOT file is in. Note that the document path is expressed in the cygwin environment. If the path to 
the ROOT is located in "E:/example/scc-artifact" then you should enter "cd /cygdrive/e/example/scc-artifact into
the terminal and run:

	isabelle build -D.
	
	
This will check all proofs, and (re)generate the files Gabow_SCC/modest_gabow.{ll,h} 
that contain the executable code.


NOTE: The sat solvers may fail on Windows in this process. If this happens, you have to rerun the process until it works.
    

## Compiling into shared library for Modest

  * Copy ./isabelle_llvm/src/lib_isabelle_llvm.c into ./Gabow_SCC
  * cd ./Gabow_SCC
  * Windows: clang modest_gabow.ll lib_isabelle_llvm.c -shared -o GabowIsabelle.dll -O3
  * Linux: clang modest_gabow.ll lib_isabelle_llvm.c -shared -o GabowIsabelle.so -O3 -fPIC
  
In Windows/Linux, this generates GabowIsabelle.dll/.so in the current folder.

## Replaying the Benchmarks

  * Place GabowIsabelle.dll/.so inside Modest_Windows/Modest_Linux inside the Modest folder
  * Open terminal in Modest_Windows/Modest_Linux 
  * Run

	(1) modest mobench Sccfull.mcsta.json 
		for the scc algorithm runtimes (~5 hours)
		
	(2) modest mobench Sccfull.lp.mcsta.json 
		for a full comparison of the runtimes (~10 hours)

  * If these commands don't work try ./modest

## Viewing the Plots

  * Open terminal in Modest_Windows/Modest_Linux
  * run

	modest moplot scatter-scc1.json
		To generate Figure 5 (requires benchmark step 1)
		
	modest moplot scatter-scc2.json
		to generate Figure 6 (requires benchmark step 1)
		
	modest moplot scatter-scc-lp.json
		to generate Figure 7 (requires benchmark step 2)

  * The resulting files are called "scatter-scc-scctime.tex",, "scatter-scc-totaltime.tex" and "scatter-scc-lp.tex"
  * Build using your favourite LaTex compiler


