section \<open>Code Generation for the Skeleton Algorithm \label{sec:skel_code}\<close>
theory Gabow_Skeleton_Code
imports 
  Gabow_Skeleton "../ds/Stack" "../lib/More_B_Assn" "../ds/Modest_MDP_index"
  
begin


subsection \<open>General Lemmas\<close>

lemma rtrancl_image_subsetI: "E \<subseteq> B \<times> A \<Longrightarrow> E\<^sup>* `` S \<subseteq> S \<union> A"
  apply auto
  by (metis Int_absorb1 Int_iff SigmaD2 rtrancl.simps)

lemma hr_comp_b_rel_Id: "hr_comp A ({(E,E)}) E Ei = A E Ei"
  unfolding hr_comp_def
  apply (auto simp: sep_algebra_simps)
  done

lemma hr_comp_diff_false1: "E' \<noteq> E \<Longrightarrow> hr_comp A ({(E',E')}) E Ei = sep_false"
  unfolding hr_comp_def
  apply (auto simp: sep_algebra_simps)
  done

lemma hr_comp_diff_false2: "E \<noteq> E' \<Longrightarrow> hr_comp A ({(E',E')}) E Ei = sep_false"
  unfolding hr_comp_def
  apply (auto simp: sep_algebra_simps)
  done

lemma hr_comp_entails: "\<forall> vi. A\<^sub>1 vi v \<turnstile> A\<^sub>2 vi v \<Longrightarrow> R\<^sub>1 \<subseteq> R\<^sub>2 \<Longrightarrow> hr_comp A\<^sub>1 R\<^sub>1 vi v \<turnstile> hr_comp A\<^sub>2 R\<^sub>2 vi v"
  unfolding hr_comp_def by(auto simp: entails_def sep_algebra_simps)

lemma pure_part_hr_compD: "pure_part (hr_comp A R x xi) \<Longrightarrow> x \<in> Range R" 
  by (meson Range_iff rdomp_hrcomp_conv rdomp_pure_part)

lemma hfref_keep_exs: "(\<forall>n. (f, g) \<in> (A n)\<^sup>k \<rightarrow>\<^sub>a B) \<Longrightarrow> (f, g) \<in> (\<lambda> c ci. EXS n. A n c ci)\<^sup>k \<rightarrow>\<^sub>a B"
  unfolding hfref_def
  apply (auto simp add: hnr_pre_ex_conv) apply(rule hn_refine_cons_post) 
  apply blast
  using entails_def by blast

lemma hfref_drop_exs: "(\<forall>n. (f, g) \<in> (A n)\<^sup>d \<rightarrow>\<^sub>a B) \<Longrightarrow> (f, g) \<in> (\<lambda> c ci. EXS n. A n c ci)\<^sup>d \<rightarrow>\<^sub>a B"
  unfolding hfref_def
  apply (auto simp add: hnr_pre_ex_conv) apply(rule hn_refine_cons_post) 
  apply blast
  unfolding invalid_assn_def pure_part_def entails_def pred_lift_def
  by blast

lemma ex_hr_comp: "(\<exists> x. hr_comp (A x) R c ci s) = hr_comp (\<lambda> c ci. EXS x. A x c ci) R c ci s"
    unfolding hr_comp_def IS_LEFT_UNIQUE_def single_valued_def 
    by (auto simp: sep_algebra_simps ) 


subsection \<open>BCONST lemmas\<close>

(* TODO: Move to central library *)
definition BCONST :: "'b \<Rightarrow> 'a \<Rightarrow> 'a" where "BCONST c m \<equiv> m"

lemma annot_BCONST: "m = BCONST c m" by (simp add: BCONST_def)

definition bind_const :: "'a \<Rightarrow> 'a nres \<Rightarrow> ('a \<Rightarrow> 'b nres) \<Rightarrow> 'b nres" 
  where "bind_const c \<equiv> Refine_Basic.bind"

lemma bind_BCONST_pat[def_pat_rules]: "Refine_Basic.bind$(BCONST$c$m)$f \<equiv> UNPROTECT (bind_const c)$m$f"
  unfolding BCONST_def bind_const_def by auto
    
lemma Let_BCONST_pat[def_pat_rules]: "Let$(BCONST$c$cc)$f \<equiv> UNPROTECT (bind_const c)$(RETURN$cc)$f"
  unfolding BCONST_def bind_const_def by auto

lemma id_op_bind_const[id_rules]: 
  "PR_CONST (bind_const c) ::\<^sub>i TYPE('a nres \<Rightarrow> ('a \<Rightarrow> 'b nres) \<Rightarrow> 'b nres)"
  by simp

  

lemma hn_bind_const[sepref_comb_rules]:
  assumes PRE: "vassn_tag \<Gamma> \<Longrightarrow> m \<le> RETURN c"
  assumes D1: "hn_refine \<Gamma> m' \<Gamma>1 Rh CP\<^sub>1 m"
  assumes D2: 
    "\<And>x'. bind_ref_tag c m \<Longrightarrow> CP_assm (CP\<^sub>1 x') \<Longrightarrow>
      hn_refine (hn_ctxt Rh c x' ** \<Gamma>1) (f' x') (\<Gamma>2 x') R (CP\<^sub>2 x') (f c)"
  assumes IMP: "\<And>x'. \<Gamma>2 x' \<turnstile> hn_ctxt Rx c x' ** \<Gamma>'"
  assumes "MK_FREE Rx fr"
  shows "hn_refine \<Gamma> (doM {x\<leftarrow>m'; r\<leftarrow>f' x; fr x; Mreturn r}) \<Gamma>' R (CP_SEQ CP\<^sub>1 CP\<^sub>2) (PR_CONST (bind_const c)$m$(\<lambda>\<^sub>2x. f x))"
proof (rule hn_refine_vassn_tagI)
  assume "vassn_tag \<Gamma>"
  then have X: "m = RETURN c \<and> x=c" if "RETURN x \<le> m" for x
    using PRE that dual_order.trans by fastforce
  
  show ?thesis  
    unfolding APP_def PROTECT2_def bind_const_def PR_CONST_def CP_SEQ_def
    apply (rule hnr_bind[where ?\<Gamma>2.0="\<lambda>x x'. \<up>(x=c) ** G x'" for G])
    apply fact
    apply (drule X) apply (clarsimp simp: sep_algebra_simps) apply (rule D2)
    unfolding bind_ref_tag_def CP_assm_def apply simp apply simp
    apply (clarsimp simp: entails_lift_extract_simps sep_algebra_simps) apply fact
    by fact
    
qed


section \<open>snat lemmas\<close>

lemma m1_notin_snat_rel: "(-1,x)\<notin>snat_rel' TYPE(size_T)"
  by (auto simp: snat_rel_def snat.rel_def snat_invar_def in_br_conv)


lemma in_snat_rel_snat: "(ii,i)\<in>snat_rel \<Longrightarrow> snat ii = i"
  by (auto dest!: in_snat_rel_int simp: snat_def)


lemma in_snat_rel_leq: "(a, j + i) \<in> snat_rel \<Longrightarrow> j \<le> snat a" 
  by (auto dest!: in_snat_rel_snat )


subsection \<open>Adaptations from @thm\<open>snat_bin_ops\<close>\<open>snat_cmp_ops\<close>\<close>

lemmas snat_simps = snat_invar_alt max_snat_def snat_eq_unat unat_word_ariths

lemma plus_snat_refine: "a + b < max_snat LENGTH('a::len2) \<Longrightarrow> (ai, a) \<in> snat_rel \<Longrightarrow> (bi, b) \<in> snat_rel \<Longrightarrow> (ai + bi, a + b) \<in> snat_rel" for ai bi ::"'a::len2 word"
  unfolding snat_rel_def snat.rel_def 
  apply (auto simp: in_br_conv snat_simps)
  done

lemma minus_snat_refine: "a \<ge> b \<Longrightarrow> (ai, a) \<in> snat_rel \<Longrightarrow> (bi, b) \<in> snat_rel \<Longrightarrow> (ai - bi, a - b) \<in> snat_rel"
  unfolding snat_rel_def snat.rel_def 
  apply (auto simp: in_br_conv snat_simps unat_sub_if')
  done

lemma lt_snat_refine: "(ai, a) \<in> snat_rel \<Longrightarrow> (bi, b) \<in> snat_rel \<Longrightarrow> a < b \<longleftrightarrow> ai < bi"
  unfolding snat_rel_def snat.rel_def 
  apply(auto simp: in_br_conv snat_simps word_less_nat_alt)
  done

lemma le_snat_refine: "(ai, a) \<in> snat_rel \<Longrightarrow> (bi, b) \<in> snat_rel \<Longrightarrow> a \<le> b \<longleftrightarrow> ai \<le> bi"
  unfolding snat_rel_def snat.rel_def 
  apply(auto simp: in_br_conv snat_simps word_le_nat_alt)
  done



subsection \<open>Sepref definitions\<close>

locale fr_graph_impl_def_loc = fr_graph_defs V0 E_succ
  for V0 and E_succ and N :: nat and D :: nat +
  fixes E_succ_assn :: "(nat succ_func) \<Rightarrow> 'ei::llvm_rep \<Rightarrow> assn"
  fixes succ_index_assn :: "nat succ_index \<Rightarrow> 'fi::llvm_rep \<Rightarrow> assn"
  fixes empty_idi :: "'ei \<Rightarrow> node_t \<Rightarrow> 1 Word.word llM"
  fixes init_idi :: "'ei \<Rightarrow> node_t \<Rightarrow> 'fi llM"
  fixes get_statei :: "'fi \<Rightarrow> node_t llM"
  fixes succ_ati :: "'ei \<Rightarrow> 'fi \<Rightarrow> node_t llM"
  fixes valid_idi :: "'ei \<Rightarrow> 'fi \<Rightarrow> 1 Word.word llM"
  fixes next_idi :: "'ei \<Rightarrow> 'fi \<Rightarrow> 'fi llM"
  fixes ni :: "size_t"
begin
  abbreviation "node_rel \<equiv> b_rel (snat_rel' TYPE(node_T)) (\<lambda>x. x<N)"
  abbreviation "node_assn \<equiv> b_assn (snat_assn' TYPE(node_T)) (\<lambda>x. x<N)"

  abbreviation "data_rel \<equiv> b_rel (snat_rel' TYPE(node_T)) (\<lambda>x. x<Suc D)"
  abbreviation "data_assn \<equiv> b_assn (snat_assn' TYPE(node_T)) (\<lambda>x. x<Suc D)"



  fun \<alpha>_node_state_inv where  
  " \<alpha>_node_state_inv (STACK i) = i"
  | "\<alpha>_node_state_inv (DONE i) = N + i"
  
  fun invar_node_state_inv where
  "invar_node_state_inv (STACK i) = (i < N)"
  | "invar_node_state_inv (DONE i) = (i < Suc D)"
  
  definition "\<alpha>_node_state N' i = (if i < N' then STACK i else DONE (i - N'))"
  
  definition "invar_node_state N' i = (i < N' + Suc D)"
  


  definition "node_state_rel N' = size_rel O br (\<alpha>_node_state N') (invar_node_state N')"
  
  definition "node_state_rel_alt' = {(nsi,ns)| nsi ns. case ns of STACK i \<Rightarrow> (nsi,i) \<in> node_rel | DONE j \<Rightarrow> (nsi-ni,j) \<in> data_rel}"
  
  
  
  lemma node_state_rel_alt_def_aux1: "D + N < max_snat 64 \<Longrightarrow> (ni, N) \<in> snat_rel \<Longrightarrow> b = DONE x2 \<Longrightarrow> (a - ni, x2) \<in> snat_rel \<Longrightarrow> x2 < Suc D \<Longrightarrow> ((a - ni) + ni, x2 + N) \<in> snat_rel"
    apply (rule plus_snat_refine)
    apply (drule nat_Suc_less_le_imp[of x2]) 
    apply auto 
    done
  
  lemma node_state_rel_alt_def_aux2: "D + N < max_snat 64 \<Longrightarrow> (ni, N) \<in> snat_rel \<Longrightarrow> \<forall>x1. b = STACK x1 \<longrightarrow> (a, x1) \<in> snat_rel \<and> x1 < N \<Longrightarrow> \<forall>x2. b = DONE x2 \<longrightarrow> (a - ni, x2) \<in> snat_rel \<and> x2 < Suc D \<Longrightarrow> (a, case b of STACK i \<Rightarrow> i| DONE j \<Rightarrow> j + N) \<in> snat_rel"
    using node_state_rel_alt_def_aux1 
    apply(auto split: node_state.splits)
    done
    
  
  lemma node_state_rel_alt_def: "D + N < max_snat 64 \<Longrightarrow> (ni, N) \<in> size_rel \<Longrightarrow> node_state_rel N = node_state_rel_alt'"
    unfolding node_state_rel_alt'_def node_state_rel_def
    apply (auto split: node_state.splits simp: in_br_conv \<alpha>_node_state_def invar_node_state_def split_ifs)
    apply (meson leI minus_snat_refine)
    apply (rule relcompI)
    using node_state_rel_alt_def_aux2
    apply blast
    apply(auto split: node_state.splits simp: in_br_conv \<alpha>_node_state_def invar_node_state_def)
    done
    
  
  
  abbreviation "node_state_assn N' \<equiv> pure (node_state_rel N')"
  
  definition "is_DONE ns \<equiv> \<exists>i. ns = DONE i"
  
  definition "is_STACK_v ns \<equiv> \<exists>v. ns = STACK v"
  
  definition "is_SOME_DONE nso \<equiv> if is_None nso then False else is_DONE (the nso)"
  
  definition "is_SOME_STACK_v nso \<equiv> if is_None nso then False else is_STACK_v (the nso)"
    
  lemma m1_notin_node_state_rel: "(-1,x) \<notin> node_state_rel N'"
    unfolding node_state_rel_def
    apply (auto split: node_state.splits simp: m1_notin_snat_rel)
    done
    
  definition [llvm_inline]: "is_DONE_impl x \<equiv> from_bool (x\<ge>ni)"
                                                     
  definition [llvm_inline]: "is_STACK_v_impl x \<equiv> from_bool (x<ni)"
  
  sublocale node: dflt_pure_option "-1" node_assn "ll_icmp_eq (-1)"
    apply unfold_locales
    subgoal
      apply (auto simp: pure_def pred_lift_extract_simps del: ext intro!: ext)
      unfolding node_state_rel_def
      apply (auto simp: snat_rel_def snat.rel_def in_br_conv snat_invar_def split: node_state.splits)
      done
    subgoal proof goal_cases
      case 1
      interpret llvm_prim_arith_setup .
      show ?case
        unfolding bool.assn_def
        apply vcg'
        done
      qed
    subgoal by simp  
    done
  
    definition node_none :: "nat option" where "node_none = None"
  
    lemmas [sepref_fr_rules] =  node.hn_None[folded node_none_def]
    sepref_register node_none 
  
  sublocale node_state: dflt_pure_option "-1" "(node_state_assn N)" "ll_icmp_eq (-1)"
    apply unfold_locales
    subgoal
      apply (auto simp: pure_def pred_lift_extract_simps del: ext intro!: ext)
      unfolding node_state_rel_def
      apply (auto simp: snat_rel_def snat.rel_def in_br_conv snat_invar_def split: node_state.splits)
      done
    subgoal proof goal_cases
      case 1
      interpret llvm_prim_arith_setup .
      show ?case
        unfolding bool.assn_def
        apply vcg'
        done
      qed
    subgoal by simp  
    done

  definition node_state_none :: "node_state option" where "node_state_none = None"

  lemmas [sepref_fr_rules] =  node_state.hn_None[folded node_state_none_def]
  sepref_register node_state_none 

  concrete_definition node_state_am_empty[llvm_code,llvm_inline] is node_state.am2_empty_def
  concrete_definition node_state_am_lookup[llvm_code,llvm_inline] is node_state.am2_lookup_def
  concrete_definition node_state_am_contains_key[llvm_code,llvm_inline] is node_state.am2_contains_key_def
  concrete_definition node_state_am_update[llvm_code,llvm_inline] is node_state.am2_update_def
  concrete_definition node_state_am_delete[llvm_code,llvm_inline] is node_state.am2_delete_def


  lemmas [unfolded node_state_am_empty.refine,sepref_fr_rules] = node_state.am2_empty_hnr node_state.am2_empty_hnr_mop
  lemmas [unfolded node_state_am_lookup.refine,sepref_fr_rules] = node_state.am2_lookup_hnr node_state.am2_lookup_hnr_mop
  lemmas [unfolded node_state_am_contains_key.refine,sepref_fr_rules] = node_state.am2_contains_key_hnr node_state.am2_contains_key_hnr_mop
  lemmas [unfolded node_state_am_update.refine,sepref_fr_rules] = node_state.am2_update_hnr node_state.am2_update_hnr_mop
  lemmas [unfolded node_state_am_delete.refine,sepref_fr_rules] = node_state.am2_delete_hnr node_state.am2_delete_hnr_mop 

end


subsection \<open>Sepref Translations\<close>

locale fr_graph_impl_loc = fr_graph_impl_def_loc V0 E_succ N D E_succ_assn succ_index_assn empty_idi 
    init_idi get_statei succ_ati valid_idi next_idi ni + fr_graph V0 E_succ
  for V0 :: "nat set" and E_succ :: "nat succ_func" and N :: nat and D::nat
  and E_succ_assn :: "(nat succ_func) \<Rightarrow> 'ei::llvm_rep \<Rightarrow> assn"
  and succ_index_assn :: "nat succ_index \<Rightarrow> 'fi::llvm_rep \<Rightarrow> assn"
  and empty_idi :: "'ei \<Rightarrow> node_t \<Rightarrow> 1 Word.word llM"
  and init_idi :: "'ei \<Rightarrow> node_t \<Rightarrow> 'fi llM"
  and get_statei :: "'fi \<Rightarrow> node_t llM"
  and succ_ati :: "'ei \<Rightarrow> 'fi \<Rightarrow> node_t llM"
  and valid_idi :: "'ei \<Rightarrow> 'fi \<Rightarrow> 1 Word.word llM"
  and next_idi :: "'ei \<Rightarrow> 'fi \<Rightarrow> 'fi llM"
  and ni
+
  assumes pure_succ_assn: "is_pure succ_index_assn"
  assumes empty_idi_ref [sepref_fr_rules]: "(uncurry empty_idi, uncurry mop_is_empty)
    \<in> E_succ_assn\<^sup>k *\<^sub>a node_assn\<^sup>k \<rightarrow>\<^sub>a bool1_assn"
  assumes init_idi_ref [sepref_fr_rules]: "(uncurry init_idi, uncurry mop_index_begin)
    \<in> E_succ_assn\<^sup>k *\<^sub>a node_assn\<^sup>k \<rightarrow>\<^sub>a succ_index_assn"
  assumes get_statei_ref [sepref_fr_rules]: "(get_statei, mop_get_state)
    \<in> succ_index_assn\<^sup>k \<rightarrow>\<^sub>a node_assn"
  assumes succ_ati_ref [sepref_fr_rules]: "(uncurry succ_ati, uncurry mop_graph_succ_at) 
    \<in> E_succ_assn\<^sup>k *\<^sub>a succ_index_assn\<^sup>k \<rightarrow>\<^sub>a node_assn"
  assumes valid_idi_ref [sepref_fr_rules]: "(uncurry valid_idi, uncurry mop_has_succ)
    \<in> E_succ_assn\<^sup>k *\<^sub>a succ_index_assn\<^sup>k \<rightarrow>\<^sub>a bool1_assn"
  assumes next_idi [sepref_fr_rules]: "(uncurry next_idi, uncurry mop_next_id)
    \<in> [\<lambda>(x, y). fr_graph_defs.has_next x y]\<^sub>a E_succ_assn\<^sup>k *\<^sub>a succ_index_assn\<^sup>d \<rightarrow> succ_index_assn"
  assumes E_BOUND: "E_\<alpha> \<subseteq> {0..<N} \<times> {0..<N}"
  assumes V0_BOUND: "V0 = {0..<N}"
  assumes D_N_BOUND: "D + N < max_snat (LENGTH(size_T))"
  assumes n_impl: "(ni, N) \<in> size_rel"
begin

  lemmas [sepref_import_param] = n_impl

  lemma mk_free_succ_assn[sepref_frame_free_rules]: "MK_FREE succ_index_assn (\<lambda>_. return\<^sub>M ())"
    apply(rule mk_free_is_pure) using pure_succ_assn .

  lemma reachable_bound: "E_\<alpha>\<^sup>*``V0 = {0..<N}"
  proof safe
    fix u v
    assume "(u,v) \<in> E_\<alpha>\<^sup>*" "u \<in> V0"
    then show "v \<in> {0..<N}"
    apply (induction rule: rtrancl_induct)
    using V0_BOUND E_BOUND by auto
  next
    fix v
    assume "v \<in> {0..<N}"
    then show "v \<in> E_\<alpha>\<^sup>*``V0"
    unfolding V0_BOUND by blast
  qed
  

  lemma card_reachable_bound: "card (E_\<alpha>\<^sup>*``V0) = N"
    using reachable_bound
    by simp

  lemma DONE_impl_refine_aux: "(a, a') \<in> snat_rel \<Longrightarrow> a' < Suc D \<Longrightarrow> (ni + a, N + a') \<in> snat_rel"
    apply (rule plus_snat_refine)
    using D_N_BOUND apply simp
    using n_impl by simp
  
  
  lemma STACK_impl_refine: "(id, STACK) \<in> node_rel \<rightarrow> node_state_rel N"
    by (auto simp: node_state_rel_def br_def \<alpha>_node_state_def invar_node_state_def)

  lemma DONE_impl_refine: "((+) ni, DONE) \<in> data_rel \<rightarrow> node_state_rel N"
    apply (clarsimp simp: node_state_rel_def br_def \<alpha>_node_state_def invar_node_state_def) 
    apply (rule relcompI)
    apply (erule DONE_impl_refine_aux; assumption)
    apply auto
    done
  
  lemma is_STACK_v_impl_refine: "(is_STACK_v_impl, is_STACK_v) \<in> node_state_rel N \<rightarrow> bool1_rel"
    unfolding is_STACK_v_impl_def is_STACK_v_def
    apply clarsimp
    using n_impl
    apply (auto simp: in_snat_rel_snat node_state_rel_def bool1_rel_def bool.rel_def in_br_conv 
                      m1_notin_snat_rel \<alpha>_node_state_def split_ifs 
               split: node_state.splits 
                dest: lt_snat_refine) 
    done

  lemma is_DONE_impl_refine: "(is_DONE_impl, is_DONE) \<in> node_state_rel N \<rightarrow> bool1_rel"
    unfolding is_DONE_impl_def is_DONE_def
    apply clarsimp
    using n_impl
    apply (auto simp: in_snat_rel_snat node_state_rel_def bool1_rel_def bool.rel_def in_br_conv 
                      m1_notin_snat_rel in_snat_rel_leq \<alpha>_node_state_def invar_node_state_def 
               split: node_state.splits 
                dest: lt_snat_refine)
    
done
  
  
  lemmas [sepref_import_param] = STACK_impl_refine is_DONE_impl_refine is_STACK_v_impl_refine DONE_impl_refine

  lemma hn_node_val[sepref_fr_rules]: "(Mreturn, RETURN o val) \<in> [\<lambda>x. \<exists>j. x = STACK j]\<^sub>a (node_state_assn N)\<^sup>k \<rightarrow> size_assn"
    apply sepref_to_hoare
    unfolding node_state_rel_alt_def[OF D_N_BOUND[simplified] n_impl] node_state_rel_alt'_def br_def 
    apply clarsimp
    apply vcg 
    done
                            
  sepref_def is_SOME_DONE_impl is "RETURN o is_SOME_DONE" :: "node_state.option_assn\<^sup>k \<rightarrow>\<^sub>a bool1_assn"
    unfolding is_SOME_DONE_def
    by sepref

  concrete_definition (in -) is_SOME_DONE_ll' [llvm_code] is fr_graph_impl_loc.is_SOME_DONE_impl_def
  lemmas [sepref_fr_rules] = is_SOME_DONE_impl.refine[unfolded is_SOME_DONE_ll'.refine[OF fr_graph_impl_loc_axioms]]
  
  
  sepref_def is_SOME_STACK_v_impl is "RETURN o is_SOME_STACK_v" :: "node_state.option_assn\<^sup>k \<rightarrow>\<^sub>a bool1_assn"
    unfolding is_SOME_STACK_v_def
    by sepref

  concrete_definition (in -) is_SOME_STACK_v_ll' [llvm_code] is fr_graph_impl_loc.is_SOME_STACK_v_impl_def
  lemmas [sepref_fr_rules] = is_SOME_STACK_v_impl.refine[unfolded is_SOME_STACK_v_ll'.refine[OF fr_graph_impl_loc_axioms]]
  
  
(*
  lemma succi_ref' [sepref_fr_rules]: "(uncurry succi, uncurry (RETURN oo op_graph_succ)) \<in> E_assn\<^sup>k *\<^sub>a node_assn\<^sup>k \<rightarrow>\<^sub>a stack_set_assn node_assn"
    using succi_ref unfolding mop_graph_succ_def by (simp add: comp_def)
  
  lemma op_graph_succ_pat [def_pat_rules]: "(``) $ E $ (insert $ v $ {}) \<equiv> op_graph_succ E v"
    by simp
*)


  definition "GS_assn = stack_assn' TYPE(size_T) node_assn \<times>\<^sub>a stack_assn' TYPE(size_T) size_assn \<times>\<^sub>a node_state.am_assn N 
    \<times>\<^sub>a stack_assn' TYPE(size_T) (succ_index_assn)"


  sepref_definition open_GS_ll is "RETURN o open_GS" :: "GS_assn\<^sup>d \<rightarrow>\<^sub>a stack_assn' TYPE(size_T) node_assn \<times>\<^sub>a stack_assn' TYPE(size_T) size_assn \<times>\<^sub>a node_state.am_assn N 
    \<times>\<^sub>a stack_assn' TYPE(size_T) (succ_index_assn)"
    unfolding GS_assn_def open_GS_def
    by sepref

  concrete_definition (in -) open_GS_ll' [llvm_code] is fr_graph_impl_loc.open_GS_ll_def
  lemmas [sepref_fr_rules] = open_GS_ll.refine[unfolded open_GS_ll'.refine[OF fr_graph_impl_loc_axioms]]


  sepref_definition close_GS_ll is "uncurry3 (RETURN oooo close_GS)" :: "(stack_assn' TYPE(size_T) node_assn)\<^sup>d *\<^sub>a (stack_assn' TYPE(size_T) size_assn)\<^sup>d *\<^sub>a (node_state.am_assn N)\<^sup>d 
    *\<^sub>a (stack_assn' TYPE(size_T) (succ_index_assn))\<^sup>d \<rightarrow>\<^sub>a GS_assn"
    unfolding GS_assn_def close_GS_def
    apply sepref
    done

  concrete_definition (in -) close_GS_ll' [llvm_code] is fr_graph_impl_loc.close_GS_ll_def
  lemmas [sepref_fr_rules] = close_GS_ll.refine[unfolded close_GS_ll'.refine[OF fr_graph_impl_loc_axioms]]


section \<open>The operations for gabow skeleton are registered here.\<close>

subsection \<open>Operation: is_done_oimpl:\<close>

  lemma is_done_oimpl_alt: "is_done_oimpl v I = is_SOME_DONE (I v)"
    unfolding is_done_oimpl_def is_SOME_DONE_def is_DONE_def 
    by (auto split: node_state.splits) 

  sepref_definition is_done_oimpl_ll is "uncurry (RETURN oo is_done_oimpl)" :: "node_assn\<^sup>k *\<^sub>a (node_state.am_assn N)\<^sup>k \<rightarrow>\<^sub>a bool1_assn" 
    unfolding is_done_oimpl_alt
    by sepref

  concrete_definition (in -) is_done_oimpl_ll' [llvm_code] is fr_graph_impl_loc.is_done_oimpl_ll_def
  lemmas [sepref_fr_rules] = is_done_oimpl_ll.refine[unfolded is_done_oimpl_ll'.refine[OF fr_graph_impl_loc_axioms]]


subsection \<open>Operation: initial_impl\<close>

  definition initial_impl' :: "(nat succ_func) \<Rightarrow> _" where
    "initial_impl' E_succ' v0 I = (
      do{ 
        g \<leftarrow> mop_is_empty E_succ' v0;
        if g then do{
          RETURN ([v0], [0::nat], I(v0 \<mapsto> STACK 0), [])
        } else do {
          uc \<leftarrow> mop_index_begin E_succ' v0;
          RETURN ([v0], [0::nat], I(v0 \<mapsto> STACK 0), [uc])
        }
      })"
  sepref_register initial_impl' :: "(nat succ_func) \<Rightarrow> nat \<Rightarrow> ((nat, node_state) i_map) \<Rightarrow> (nat list \<times> nat list \<times> (nat \<Rightarrow> node_state option) \<times> (nat succ_index) list) nres"


  lemma initial_impl_alt: "initial_impl = initial_impl' E_succ"
    unfolding initial_impl'_def GS_initial_impl_def initial_impl_def mop_is_empty_def mop_free_def
    by (clarsimp simp: index_begin_def fun_eq_iff pw_eq_iff refine_pw_simps)

    

  sepref_definition initial_ll is "uncurry2 (initial_impl')"::"E_succ_assn\<^sup>k *\<^sub>a node_assn\<^sup>k *\<^sub>a (node_state.am_assn N)\<^sup>d \<rightarrow>\<^sub>a GS_assn"
    unfolding initial_impl_alt initial_impl'_def GS_assn_def singleton_list_append
    unfolding stack_fold_custom_empty[where 'l = size_T] 
    apply (annot_snat_const "TYPE(size_T)")
    by sepref

  
  concrete_definition (in -) initial_ll' [llvm_code] is fr_graph_impl_loc.initial_ll_def
  lemmas [sepref_fr_rules] = initial_ll.refine[unfolded initial_ll'.refine[OF fr_graph_impl_loc_axioms]]


subsection \<open>Operation: path_is_empty_impl\<close>
                                                             
  sepref_definition path_is_empty_impl_ll is "RETURN o path_is_empty_impl" :: "GS_assn\<^sup>k \<rightarrow>\<^sub>a bool1_assn"
    unfolding path_is_empty_impl_def GS_assn_def GS_defs.S_def
    unfolding prod.case_distrib[where h="\<lambda>a. a=_"]
    by sepref

  concrete_definition (in -) path_is_empty_impl_ll' [llvm_code] is fr_graph_impl_loc.path_is_empty_impl_ll_def
  lemmas [sepref_fr_rules] = path_is_empty_impl_ll.refine[unfolded path_is_empty_impl_ll'.refine[OF fr_graph_impl_loc_axioms]]



  definition "select_edge_impl' E_succ' SBIP \<equiv> 
    do {
      let (S,B,I,P) = open_GS SBIP;
      if P=[] then 
        RETURN (node_none, close_GS S B I P)
      else do {
        let (vc, P') = op_list_pop_last P;
        v \<leftarrow> mop_get_state vc;
        ASSERT (\<exists>j. I v = Some (STACK j));
        j \<leftarrow> mop_map_lookup v I;
        ASSERT (length B \<ge> 1);
        if val (the j) \<ge> B ! (length B - 1) then do {
          ASSERT (snd vc < succ_count (fst vc));
          w \<leftarrow> mop_graph_succ_at E_succ' vc;
          g \<leftarrow> mop_has_succ E_succ' vc;
          P \<leftarrow> (if g then do{
            ASSERT(fr_graph_defs.has_next E_succ' vc);
            uc \<leftarrow> mop_next_id E_succ' vc; 
            mop_list_append P' uc
          } else (RETURN P'));
          RETURN (Some w, close_GS S B I P)
        } else RETURN (node_none, close_GS S B I (op_list_append P' vc))
      }
    }"

  sepref_register select_edge_impl'


  lemma select_edge_impl_alt_def: "select_edge_impl SBIP = select_edge_impl' E_succ SBIP"
    unfolding select_edge_impl_def GS_defs.sel_rem_last_def select_edge_impl'_def open_GS_def close_GS_def GS_defs.seg_start_def GS_defs.S_idx_of_def mop_get_state_def fr_graph_defs.get_state_def
    apply(cases SBIP; simp)
    apply(simp cong: if_cong)
    apply(auto simp: node_none_def neq_Nil_conv_rev split: prod.splits)
    done


  sepref_definition select_edge_impl_ll is "uncurry (PR_CONST select_edge_impl')" :: "E_succ_assn\<^sup>k *\<^sub>a GS_assn\<^sup>d \<rightarrow>\<^sub>a node.option_assn \<times>\<^sub>a GS_assn"
    unfolding select_edge_impl'_def PR_CONST_def
    apply (annot_snat_const "TYPE(size_T)")
    apply sepref
    done


  concrete_definition (in -) select_edge_impl_ll' [llvm_code] is fr_graph_impl_loc.select_edge_impl_ll_def
  lemmas [sepref_fr_rules] = select_edge_impl_ll.refine[unfolded select_edge_impl_ll'.refine[OF fr_graph_impl_loc_axioms]]


subsection \<open>Operation: is_on_stack_impl\<close>

  lemma is_on_stack_impl_alt: "is_on_stack_impl v s = is_SOME_STACK_v (GS_defs.I s v)"
    unfolding is_on_stack_impl_def GS_defs.is_on_stack_impl_def is_SOME_STACK_v_def is_STACK_v_def
    by (auto split: node_state.splits)


  sepref_definition is_on_stack_impl_ll is "uncurry (RETURN oo is_on_stack_impl)" :: "node_assn\<^sup>k *\<^sub>a GS_assn\<^sup>k \<rightarrow>\<^sub>a bool1_assn"
    unfolding GS_assn_def is_on_stack_impl_alt GS_defs.I_def
    by sepref

  concrete_definition (in -) is_on_stack_impl_ll' [llvm_code] is fr_graph_impl_loc.is_on_stack_impl_ll_def
  lemmas [sepref_fr_rules] = is_on_stack_impl_ll.refine[unfolded is_on_stack_impl_ll'.refine[OF fr_graph_impl_loc_axioms]]


subsection \<open>Operation: collapse_impl\<close>


  sepref_definition find_seg_impl_ll is "uncurry GS_defs.find_seg_impl" :: "GS_assn\<^sup>k *\<^sub>a size_assn\<^sup>k \<rightarrow>\<^sub>a size_assn"
    unfolding GS_assn_def GS_defs.find_seg_impl_def GS_defs.B_def
    unfolding prod.case_distrib[where h="length"]
    unfolding prod.case_distrib[where h="\<lambda>a. a ! _"]
    apply (annot_snat_const "TYPE(size_T)")
    by sepref

  concrete_definition (in -) find_seg_impl_ll' [llvm_code] is fr_graph_impl_loc.find_seg_impl_ll_def
  lemmas [sepref_fr_rules] = find_seg_impl_ll.refine[unfolded find_seg_impl_ll'.refine[OF fr_graph_impl_loc_axioms]]


  definition "S_idx_of_impl SBIP v \<equiv> 
    do {
      ASSERT (\<exists> j. GS_defs.I SBIP v = Some (STACK j));
      RETURN (val (the (GS_defs.I SBIP v)))
    }"
  
  sepref_definition S_idx_of_ll is "uncurry S_idx_of_impl" :: "GS_assn\<^sup>k *\<^sub>a node_assn\<^sup>k \<rightarrow>\<^sub>a size_assn"
    unfolding GS_assn_def S_idx_of_impl_def GS_defs.I_def
    by sepref

  concrete_definition (in -) S_idx_of_ll' [llvm_code] is fr_graph_impl_loc.S_idx_of_ll_def
  lemmas [sepref_fr_rules] = S_idx_of_ll.refine[unfolded S_idx_of_ll'.refine[OF fr_graph_impl_loc_axioms]]


  lemma idx_of_impl_alt_def: "GS_defs.idx_of_impl SBIP = (\<lambda> v. 
      do {
        j \<leftarrow> S_idx_of_impl SBIP v;
        ASSERT (j<length (GS_defs.S SBIP));
        i \<leftarrow> GS_defs.find_seg_impl SBIP j;
        RETURN i
      })"
    unfolding GS_defs.idx_of_impl_def GS_defs.S_idx_of_def
    unfolding S_idx_of_impl_def 
    apply(auto simp: fun_eq_iff)
    by metis

  sepref_definition idx_of_impl_ll is "uncurry GS_defs.idx_of_impl" :: "GS_assn\<^sup>k *\<^sub>a node_assn\<^sup>k \<rightarrow>\<^sub>a size_assn"
    unfolding idx_of_impl_alt_def 
    unfolding prod.case_distrib[where h="\<lambda>a. a _"]
    unfolding prod.case_distrib[where h="\<lambda>a. val (the a)"]
    unfolding prod.case_distrib[where h="\<lambda>a. a \<noteq> None"]
    by sepref
           
  concrete_definition (in -) idx_of_impl_ll' [llvm_code] is fr_graph_impl_loc.idx_of_impl_ll_def
  lemmas [sepref_fr_rules] = idx_of_impl_ll.refine[unfolded idx_of_impl_ll'.refine[OF fr_graph_impl_loc_axioms]]
  
  
  definition "collapse_impl_fr' v SBIP =    
    do { 
      i\<leftarrow>GS_defs.idx_of_impl SBIP v;
      let (S,B,I,P) = open_GS SBIP;
      ASSERT (i+1 \<le> length B);
      let B = take (i+1) B;
      RETURN (close_GS S B I P)
    }"

  lemma collapse_impl_fr_alt_def: "collapse_impl_fr v SBIP = collapse_impl_fr' v SBIP"
    unfolding collapse_impl_fr_def collapse_impl_fr'_def GS_defs.collapse_impl_def GS_defs.S_def GS_defs.B_def GS_defs.I_def GS_defs.P_def open_GS_def close_GS_def
    apply(cases SBIP)
    apply (auto split: prod.splits simp: fun_eq_iff)
    done


  sepref_definition collapse_ll is "uncurry collapse_impl_fr" :: "node_assn\<^sup>k *\<^sub>a GS_assn\<^sup>d \<rightarrow>\<^sub>a GS_assn"
    unfolding collapse_impl_fr_alt_def collapse_impl_fr'_def
    apply (annot_snat_const "TYPE(size_T)")
    apply sepref
    done

  concrete_definition (in -) collapse_ll' [llvm_code] is fr_graph_impl_loc.collapse_ll_def 
  lemmas [sepref_fr_rules] = collapse_ll.refine[unfolded collapse_ll'.refine[OF fr_graph_impl_loc_axioms]]



subsection \<open>Operation: is_done_impl\<close>

  lemma is_done_impl_alt: "is_done_impl v s = is_SOME_DONE (GS_defs.I s v)"
    unfolding is_done_impl_def GS_defs.is_done_impl_def is_SOME_DONE_def is_DONE_def
    by (auto split: node_state.splits)

  sepref_definition is_done_impl_ll is "uncurry (RETURN oo is_done_impl)" :: "node_assn\<^sup>k *\<^sub>a GS_assn\<^sup>k \<rightarrow>\<^sub>a bool1_assn"
    unfolding GS_assn_def is_done_impl_alt GS_defs.I_def
    by sepref

  concrete_definition (in -) is_done_impl_ll' [llvm_code] is fr_graph_impl_loc.is_done_impl_ll_def 
  lemmas [sepref_fr_rules] = is_done_impl_ll.refine[unfolded is_done_impl_ll'.refine[OF fr_graph_impl_loc_axioms]]


subsection \<open>Operation: push_impl\<close>

  definition push_impl' :: "(nat succ_func) \<Rightarrow> _" where 
  "push_impl' E_succ' v s \<equiv> 
    case s of (S, B, I, P) \<Rightarrow> do {
      ASSERT(length S < card(E_\<alpha>\<^sup>*``V0));
      ASSERT(length B < card(E_\<alpha>\<^sup>*``V0));
      ASSERT(length P < card(E_\<alpha>\<^sup>*``V0));
      let j = length S;
      let S = op_list_append S v;
      let B = op_list_append B j;
      let I = I(v \<mapsto> STACK j);
      g \<leftarrow> mop_is_empty E_succ' v;
      P \<leftarrow> (if g then (RETURN P) else do{ uc \<leftarrow> mop_index_begin E_succ' v; mop_list_append P uc});
      RETURN (S,B,I,P) 
    }"

  sepref_register push_impl'

  lemma push_impl_alt_def: "push_impl_fr = push_impl' E_succ"
    unfolding push_impl'_def push_impl_fr_def GS_defs.push_impl_def 
      GS_defs.push_impl_core_def Let_def mop_is_empty_def
    by (clarsimp simp: fun_eq_iff pw_eq_iff refine_pw_simps index_begin_def)
      
  lemma push_bound_aux: "n < card (E_\<alpha>\<^sup>* `` V0) \<Longrightarrow> Suc n < max_snat LENGTH(size_T)"
    using D_N_BOUND card_reachable_bound by linarith

  lemma push_bound_aux2: "n < card (E_\<alpha>\<^sup>* `` V0) \<Longrightarrow> n < N"
    using D_N_BOUND card_reachable_bound by linarith

  sepref_definition push_impl_ll is "uncurry2 (PR_CONST push_impl')" :: "E_succ_assn\<^sup>k *\<^sub>a node_assn\<^sup>k *\<^sub>a GS_assn\<^sup>d \<rightarrow>\<^sub>a GS_assn"
    unfolding GS_assn_def push_impl'_def singleton_list_append PR_CONST_def
    unfolding stack_fold_custom_empty[where 'l = size_T] 
    supply [simp] = push_bound_aux[simplified] push_bound_aux2
    apply sepref
    done

  concrete_definition (in -) push_impl_ll' [llvm_code] is fr_graph_impl_loc.push_impl_ll_def 
  lemmas [sepref_fr_rules] = push_impl_ll.refine[unfolded push_impl_ll'.refine[OF fr_graph_impl_loc_axioms]]


subsection \<open>Operation: pop_impl\<close>

  
  sepref_definition mark_as_done_ll is "uncurry4 mark_as_done" :: "(stack_assn' TYPE(size_T) node_assn)\<^sup>k *\<^sub>a (node_state.am_assn N)\<^sup>d *\<^sub>a size_assn\<^sup>k *\<^sub>a size_assn\<^sup>k *\<^sub>a data_assn\<^sup>k \<rightarrow>\<^sub>a (node_state.am_assn N)"
    unfolding mark_as_done_def GS_defs.S_def GS_assn_def
    by sepref

  concrete_definition (in -) mark_as_done_ll' [llvm_code] is fr_graph_impl_loc.mark_as_done_ll_def 
  lemmas [sepref_fr_rules] = mark_as_done_ll.refine[unfolded mark_as_done_ll'.refine[OF fr_graph_impl_loc_axioms]]


  definition "pop_impl2 SBIP i  \<equiv> 
    do {  
      let (S,B,I,P) = open_GS SBIP;
      ASSERT (length B \<ge> 1);
      let lsi = length B - 1;
      ASSERT (lsi<length B);
      let l = B ! lsi;
      let u = (if lsi + 1 = length B then length S else B ! (lsi + 1));
      I \<leftarrow> mark_as_done S I l u i;
      ASSERT (B\<noteq>[]);
      S \<leftarrow> mop_list_take (last B) S;
      ASSERT (B\<noteq>[]);
      let (_,B) = op_list_pop_last B;
      RETURN (close_GS S B I P)
    }"

    lemma "hd [(\<lambda>x. x+1)] = hd [(\<lambda>x. x+2)]"
      thm arg_cong
      apply (fo_rule arg_cong fun_cong | rule ext)+
      oops

    lemma pop_impl_fr_alt: "pop_impl_fr SBIP i = pop_impl2 SBIP i"
      unfolding pop_impl_fr_def GS_defs.pop_impl_def pop_impl2_def GS_defs.seg_start_def GS_defs.seg_end_def open_GS_def close_GS_def
      apply(cases SBIP; simp)
      apply(simp cong: if_cong)
      done


  sepref_definition pop_impl_ll is "uncurry pop_impl_fr" :: "GS_assn\<^sup>d *\<^sub>a data_assn\<^sup>k \<rightarrow>\<^sub>a GS_assn"
    unfolding pop_impl_fr_alt pop_impl2_def
    apply (annot_snat_const "TYPE(size_T)")
    apply sepref
    done

  concrete_definition (in -) pop_impl_ll' [llvm_code] is fr_graph_impl_loc.pop_impl_ll_def 
  lemmas [sepref_fr_rules] = pop_impl_ll.refine[unfolded pop_impl_ll'.refine[OF fr_graph_impl_loc_axioms]]


  sepref_register N
  sepref_register path_is_empty_impl is_on_stack_impl collapse_impl_fr 
          is_done_impl push_impl_fr pop_impl_fr select_edge_impl

 
  lemma list_to_set_rel: "distinct xs \<Longrightarrow> (xs, set xs) \<in> \<langle>Id\<rangle>list_set_rel"
    unfolding list_set_rel_def
    apply(auto simp: br_def)
    done
    

  lemma bounded_list_set_rel: "([0..<N], V0) \<in> \<langle>Id\<rangle>list_set_rel" 
    unfolding list_set_rel_def
    apply (auto simp: br_def V0_BOUND)
    done


  subsection \<open>Refinement to nfoldli\<close>

  definition "skeleton_inner_while_body2 E_succ' s = 
          do {
            \<comment> \<open>Select edge from end of path\<close>
            (vo,s) \<leftarrow> select_edge_impl' E_succ' s;

            if (vo = None) then
                pop_impl_fr s 0
            else do {
                let v = the(vo);
                \<comment> \<open>No more outgoing edges from current node on path\<close>
                ASSERT (v \<in> E_\<alpha>\<^sup>*``V0);
                if is_on_stack_impl v s then do {
                  collapse_impl_fr v s
                } else if \<not>is_done_impl v s then do {
                  \<comment> \<open>Edge to new node. Append to path\<close>
                  push_impl' E_succ' v s
                } else do {
                  \<comment> \<open>Edge to done node. Skip\<close>
                  RETURN s
                }
             }
          }"
  sepref_register skeleton_inner_while_body2 :: "(nat succ_func)
     \<Rightarrow> nat list \<times> nat list \<times> (nat \<Rightarrow> node_state option) \<times> ('v \<times> nat) list
        \<Rightarrow> (nat list \<times> nat list \<times> (nat \<Rightarrow> node_state option) \<times> ('v \<times> nat) list) nres"


  lemma skeleton_inner_while_body_alt_def: "skeleton_inner_while_body SBIP = skeleton_inner_while_body2 E_succ SBIP"
    unfolding skeleton_inner_while_body_def skeleton_inner_while_body2_def select_edge_impl_alt_def 
    apply (fo_rule arg_cong)
    apply (rule ext)
    apply (auto simp: push_impl_alt_def )
    done

  sepref_definition skeleton_inner_while_body_ll is "uncurry (PR_CONST skeleton_inner_while_body2)" :: "E_succ_assn\<^sup>k *\<^sub>a GS_assn\<^sup>d \<rightarrow>\<^sub>a GS_assn"
    unfolding PR_CONST_def
    unfolding skeleton_inner_while_body2_def 
    apply (annot_snat_const "TYPE(size_T)")
    apply sepref
    done



  concrete_definition (in -) skeleton_inner_while_body_ll' [llvm_code] is fr_graph_impl_loc.skeleton_inner_while_body_ll_def
  lemmas [sepref_fr_rules] = skeleton_inner_while_body_ll.refine[unfolded skeleton_inner_while_body_ll'.refine[OF fr_graph_impl_loc_axioms]]



  definition skeleton_impl_nfoldli :: "nat succ_func \<Rightarrow> nat oGS nres" where
    "skeleton_impl_nfoldli E_succ' \<equiv> do {
      let I=Map.empty;
      r \<leftarrow> nfoldli [0..<N] (\<lambda>_. True)(\<lambda>v0 I0 :: (nat \<Rightarrow> node_state option). do {
        v0 \<leftarrow> mop_bound_val (\<lambda> x. x < N) v0;
        ASSERT (v0 \<in> E_\<alpha>\<^sup>*``V0);
        if \<not>is_done_oimpl v0 I0 then do {
          s \<leftarrow> initial_impl' E_succ' v0 I0;

          s\<leftarrow> WHILEIT ((\<lambda>(p,D,pE). \<exists>vE. invar v0 (oGS_\<alpha> I0) (p,D,pE,vE)) o GS_defs.\<alpha> E_succ')
            (\<lambda>s. \<not>path_is_empty_impl s) 
            (skeleton_inner_while_body2 E_succ') s;
          let (S,B,I,P) = open_GS s;
          RETURN I
        } else
          RETURN I0
      }) I;
      RETURN r
    }"

  lemma skeleton_impl_nfoldli_refine: "skeleton_impl_nfoldli E_succ \<le> \<Down> Id skeleton_impl"
    unfolding skeleton_impl_nfoldli_def skeleton_impl_def open_GS_def mop_bound_val_def
    apply (simp only: Refine_Basic.nres_monad_laws)
    apply (refine_rcg LFOi_refine[where A=Id and R=Id])
    apply refine_dref_type
    apply (vc_solve (nopre) solve: asm_rl I_to_outer 
      simp: bounded_list_set_rel skeleton_inner_while_body_alt_def initial_impl_alt)
    using reachable_bound by simp

  
  lemma fold_am_custom_empty': "(let i = Map.empty in f i) = (let N'= (BCONST N N); i = op_am_custom_empty N' in f i)"
    by simp

  sepref_definition skeleton_impl_ll is "PR_CONST skeleton_impl_nfoldli" :: "E_succ_assn\<^sup>k \<rightarrow>\<^sub>a node_state.am_assn N"
    unfolding skeleton_impl_nfoldli_def PR_CONST_def
    unfolding fold_am_custom_empty' nfoldli_upt_by_while
    apply (annot_snat_const "TYPE(size_T)")
    apply sepref
    done

  concrete_definition (in -) skeleton_impl_ll' [llvm_code] is fr_graph_impl_loc.skeleton_impl_ll_def
  lemmas [sepref_fr_rules] = skeleton_impl_ll.refine[unfolded skeleton_impl_ll'.refine[OF fr_graph_impl_loc_axioms]]

end
 

lemmas [llvm_code] = stack_nth_copy_def

                                                                                             
concrete_definition modest_graph_skeleton_impl[llvm_code] is 
  skeleton_impl_ll'_def[of modest_is_empty_ll modest_index_begin_ll modest_get_state_ll modest_succ_at_alt_ll modest_has_successor_def_ll modest_next_index_ll]
interpretation fr_graph_impl_def: fr_graph_impl_def_loc 
  where N=N and D=D
  and E_succ_assn = "modest_graph_succ_SS_assn N SS" 
  and succ_index_assn = "modest_index_assn N SS"
  and empty_idi = "modest_is_empty_ll"
  and init_idi = modest_index_begin_ll
  and get_statei = modest_get_state_ll
  and succ_ati = modest_succ_at_alt_ll
  and valid_idi = modest_has_successor_def_ll
  and next_idi = modest_next_index_ll
  and ni=ni 
  for N D SS E_succ ni .


export_llvm modest_graph_skeleton_impl file "skeleton.ll"


locale modest_graph_skeleton_impl_loc = fr_graph_impl_def_loc "{0..<N}" E_succ N 0 "modest_graph_succ_SS_assn N SS" 
  "modest_index_SS_assn N SS" modest_is_empty_ll modest_index_begin_ll modest_get_state_ll modest_succ_at_alt_ll modest_has_successor_def_ll modest_next_index_ll ni
  for E_succ :: "nat succ_func" and SS and N :: nat and ni +
  assumes n_impl: "(ni, N) \<in> size_rel"
  assumes N_BOUND: "N < max_snat LENGTH(64)"
  assumes E_BOUND: "E_\<alpha> \<subseteq> {0..<N} \<times> {0..<N}"
begin

  lemma inst_fr_graph_impl_loc_in_def: "fr_graph_impl_loc {0..<N} E_succ N 0 (modest_graph_succ_SS_assn N SS) (modest_index_SS_assn N SS) modest_is_empty_ll modest_index_begin_ll modest_get_state_ll modest_succ_at_alt_ll modest_has_successor_def_ll modest_next_index_ll ni"
    apply unfold_locales 
    apply(rule rtrancl_image_subsetI[OF E_BOUND, THEN finite_subset] ) 
    apply blast
    apply solve_constraint
    using mop_is_empty_hnr apply blast
    using mop_index_begin_hnr apply blast
    using mop_get_state_hnr apply blast
    using mop_graph_succ_at_hnr apply blast
    using mop_has_succ_hnr apply blast
    using mop_next_id_hnr apply blast
    apply (rule E_BOUND)
    apply simp
    using N_BOUND apply simp
    apply (rule n_impl)
    done

  sublocale fr_graph_impl_loc "{0..<N}" E_succ N 0 "modest_graph_succ_SS_assn N SS" "modest_index_SS_assn N SS" modest_is_empty_ll 
    modest_index_begin_ll modest_get_state_ll modest_succ_at_alt_ll modest_has_successor_def_ll modest_next_index_ll ni
    using inst_fr_graph_impl_loc_in_def
    by blast




  lemma modest_graph_skeleton_impl_refines_spec: "(modest_graph_skeleton_impl ni, \<lambda>_. Refine_Basic.SPEC (outer_invar {}))
    \<in> (hr_comp (modest_graph_succ_SS_assn N SS) {(E_succ,E_succ)})\<^sup>k \<rightarrow>\<^sub>a hr_comp (node_state.am_assn N) oGS_rel"
  proof -  
    note r1 =
      modest_graph_skeleton_impl.refine[symmetric, of ni, unfolded skeleton_impl_ll'.refine[OF fr_graph_impl_loc_axioms,symmetric]]

  
    note r2 = skeleton_impl_ll.refine[unfolded PR_CONST_def]  
  
    note skeleton_impl_nfoldli_refine
    also note skeleton_impl_refine
    also note skeleton_spec
    finally have "(skeleton_impl_nfoldli E_succ, (Refine_Basic.SPEC (outer_invar {})))\<in>\<langle>oGS_rel\<rangle> nres_rel"
      by (auto simp: nres_rel_def)
    hence r3: "(skeleton_impl_nfoldli, (\<lambda>_. Refine_Basic.SPEC (outer_invar {})))\<in> {(E_succ,E_succ)} \<rightarrow> \<langle>oGS_rel\<rangle> nres_rel"
      by auto
  
    from r2[FCOMP r3, folded r1] show ?thesis unfolding modest_graph_succ_assn_alt .
  qed
  
end


lemma modest_graph_skeleton_impl_refines_spec': 
  assumes LOC: "modest_graph_skeleton_impl_loc E_succ N ni"
  shows "(modest_graph_skeleton_impl ni, \<lambda>_. Refine_Basic.SPEC (outer_invar_loc {0..<N} E_succ {}))
  \<in> (hr_comp (modest_graph_succ_assn N) {(E_succ,E_succ)})\<^sup>k \<rightarrow>\<^sub>a hr_comp (fr_graph_impl_def.node_state.am_assn 0 N N) (fr_graph.oGS_rel {0..<N} E_succ)"
proof -
  from LOC have GRP: "fr_graph {0..<N} E_succ"
    apply(unfold_locales) 
    apply(rule finite_rtrancl_Image)
    using modest_graph_skeleton_impl_loc.E_BOUND[OF LOC] 
    using finite_atLeastLessThan finite_cartesian_product rev_finite_subset apply blast
    by blast

  have AUX1: "modest_graph_succ_SS_assn N SS E_succ' Ei' \<turnstile> modest_graph_succ_assn N E_succ' Ei'" for SS E_succ' Ei' 
    unfolding modest_graph_succ_assn_alt entails_def
    by blast

  have AUX2: "\<forall> SS. (modest_graph_skeleton_impl ni, \<lambda>_. Refine_Basic.SPEC (outer_invar_loc {0..<N} E_succ {}))
  \<in> (hr_comp (modest_graph_succ_SS_assn N SS) {(E_succ,E_succ)})\<^sup>k \<rightarrow>\<^sub>a hr_comp (fr_graph_impl_def.node_state.am_assn 0 N N) (fr_graph.oGS_rel {0..<N} E_succ)"
    using modest_graph_skeleton_impl_loc.modest_graph_skeleton_impl_refines_spec[OF LOC] unfolding fr_graph.outer_invar_def[OF GRP] 
    by blast

  thus ?thesis
    apply -
    apply(drule hfref_keep_exs)
    unfolding modest_graph_succ_assn_alt ex_hr_comp 
    by blast
 
qed




lemma modest_graph_assn_E_succ_pure_partD: "pure_part (modest_graph_succ_SS_assn N SS E_succ Ei) \<Longrightarrow> E_succ = modest_graph_def.E_succ_\<alpha> SS"
  unfolding modest_graph_succ_SS_assn_def
  apply(drule pure_part_hr_compD)
  apply(clarsimp simp: Range_iff)
  apply(frule modest_graph_succ_rel_SS_eq[symmetric])
  by(auto simp: modest_graph_succ_SS_rel_def in_br_conv)


lemma modest_graph_assn_pure_partD: "pure_part (modest_graph_succ_SS_assn N SS E_succ Ei) \<Longrightarrow> fr_graph_impl_def.E_\<alpha> E_succ \<subseteq> {0..<N} \<times> {0..<N}"
  apply(frule modest_graph_assn_E_succ_pure_partD)
  unfolding modest_graph_succ_SS_assn_def
  apply(drule pure_part_hr_compD)
  apply simp
  apply(rule modest_graph_invar'.E_\<alpha>_len_St)
  apply (clarsimp simp: modest_graph_succ_SS_rel_def in_br_conv)
  apply(frule modest_graph_invar.SS_DEF[symmetric])
  by (blast intro: modest_graph_invar.axioms)

lemma pure_part_modest_graph_succ_assn: "pure_part (modest_graph_succ_assn N E_succ Ei) = (\<exists>St Tr Br. pure_part (modest_graph_succ_SS_assn N (St, Tr, Br) E_succ Ei))"
  unfolding modest_graph_succ_assn_alt hr_comp_def pure_part_def
  by(auto simp: sep_algebra_simps)


theorem list_graph_skeleton_impl_correct_htriple: "llvm_htriple 
  (snat_assn N ni ** \<up>(N < max_snat LENGTH(64)) ** modest_graph_succ_assn N E_succ Ei) 
  (modest_graph_skeleton_impl ni Ei) 
  (\<lambda>ri. EXS r. 
    snat_assn N ni ** \<up>(N < max_snat LENGTH(64)) 
    ** modest_graph_succ_assn N E_succ Ei
    ** hr_comp (fr_graph_impl_def.node_state.am_assn 0 N N) (fr_graph.oGS_rel {0..<N} E_succ) r ri 
    ** \<up>(outer_invar_loc {0..<N} E_succ {} r))"
  apply(rule htriple_pure_preI)
  apply(drule pure_part_split_conj, clarify)+
  unfolding pure_part_modest_graph_succ_assn
  apply clarify
  apply(frule modest_graph_assn_E_succ_pure_partD)
  apply(drule modest_graph_assn_pure_partD)
  apply clarsimp
  proof (goal_cases)
    case 1
    have INV: "modest_graph_skeleton_impl_loc E_succ N ni"
      apply unfold_locales 
      apply (fact|clarsimp)+
      using 1 by fastforce

    note [simp] = hr_comp_b_rel_Id
    note [vcg_rules] = modest_graph_skeleton_impl_refines_spec'[OF INV, to_hnr, THEN hn_refineD, unfolded hn_ctxt_def, of E_succ Ei, simplified]

    show ?case 
      apply(fold 1(3))
      apply vcg
      unfolding outer_invar_loc_def .
  qed



(*** THIS IS THE OLD HOARE TRIPLE ***)

theorem list_graph_skeleton_impl_correct_htriple_old: "llvm_htriple 
  (snat_assn N ni ** \<up>(N < max_snat LENGTH(64)) ** modest_graph_succ_SS_assn N SS E_succ Ei) 
  (modest_graph_skeleton_impl ni Ei) 
  (\<lambda>ri. EXS r. 
    snat_assn N ni ** \<up>(N < max_snat LENGTH(64)) 
    ** modest_graph_succ_SS_assn N SS E_succ Ei
    ** hr_comp (fr_graph_impl_def.node_state.am_assn 0 N N) (fr_graph.oGS_rel {0..<N} E_succ) r ri 
    ** \<up>(outer_invar_loc {0..<N} E_succ {} r))"
  apply(rule htriple_pure_preI)
  apply(drule pure_part_split_conj, clarify)+
  unfolding pure_part_modest_graph_succ_assn
  apply(frule modest_graph_assn_E_succ_pure_partD)
  apply(drule modest_graph_assn_pure_partD)
  apply clarsimp
  proof (goal_cases)
    case 1
    interpret modest_graph_skeleton_impl_loc E_succ SS N ni
      apply unfold_locales 
      apply (fact|clarsimp)+
      using 1 by fastforce
    note [simp] = hr_comp_b_rel_Id

    note [vcg_rules] = modest_graph_skeleton_impl_refines_spec[to_hnr, THEN hn_refineD, unfolded hn_ctxt_def, of E_succ Ei, simplified]
    show ?case 
      apply(fold 1(3))
      apply vcg'
      unfolding outer_invar_def outer_invar_loc_def .
  qed

(*** THIS IS THE OLD HOARE TRIPLE ***)

end
