section \<open>Code Generation for SCC-Computation \label{sec:scc_code}\<close>
theory Gabow_SCC_Code
imports 
  Gabow_SCC
  Gabow_Skeleton_Code
begin

section \<open>General lemmas\<close>



section \<open>Automatic Refinement to Efficient Data Structures\<close>



locale fr_graph_scc_impl_def_loc = fr_graph_impl_def_loc V0 E_succ N D E_at_assn succ_index_assn empty_idi init_idi get_statei succ_ati valid_idi next_idi ni
  for V0 and E_succ and N and D and E_at_assn and succ_index_assn and empty_idi and init_idi and get_statei and succ_ati and valid_idi and next_idi and ni
begin
  definition "node_state_am_assn = node_state.am_assn"
end


                                     
locale fr_graph_scc_impl_loc = fr_graph_impl_loc V0 E_succ N D E_at_assn succ_index_assn empty_idi init_idi get_statei succ_ati valid_idi next_idi ni + 
  fr_graph_scc_impl_def_loc V0 E_succ N D E_at_assn succ_index_assn empty_idi init_idi get_statei succ_ati valid_idi next_idi ni
  for V0 and E_succ and N and D and E_at_assn and succ_index_assn and empty_idi and init_idi and get_statei and succ_ati and valid_idi and next_idi and ni +
  assumes D_VAL: "D = N"
begin


  lemma D_bound: "D < max_snat (LENGTH(size_T))"
    using D_N_BOUND
    by (simp add: D_VAL max_snat_def)

  lemma inc_data_ll_aux: "x < D \<Longrightarrow> Suc x < max_snat 64" using D_bound by simp

  definition "build_scc_impl' = (\<lambda> s i.
    do {
      ASSERT (i < card (E_\<alpha>\<^sup>* `` V0));
      s\<leftarrow>pop_impl_fr s i;
      RETURN (op_bound_val (\<lambda>x. x<Suc D) (Suc i), s)
    })"


  lemma build_scc_impl_fr_alt_def_aux: "a < card (E_\<alpha>\<^sup>* `` V0) \<longleftrightarrow> a < D"
    by (auto simp: card_reachable_bound D_VAL)
  lemma build_scc_impl_fr_alt_def: "build_scc_impl_fr s i = build_scc_impl' s i"
    unfolding build_scc_impl_fr_def GSS_defs.build_scc_impl_def build_scc_impl'_def
    apply(simp add: pop_impl_fr_def build_scc_impl_fr_alt_def_aux)
    done

term build_scc_impl_fr

  sepref_register build_scc_impl_fr

  sepref_definition build_scc_impl_ll is "uncurry (PR_CONST build_scc_impl_fr)" :: "GS_assn\<^sup>d *\<^sub>a data_assn\<^sup>d \<rightarrow>\<^sub>a data_assn \<times>\<^sub>a GS_assn"
    unfolding build_scc_impl_fr_alt_def build_scc_impl'_def build_scc_impl_fr_alt_def_aux PR_CONST_def
    supply [simp] = inc_data_ll_aux 
    apply sepref
    done

  concrete_definition (in -) build_scc_impl_ll' [llvm_code] is fr_graph_scc_impl_loc.build_scc_impl_ll_def
  lemmas [sepref_fr_rules] = build_scc_impl_ll.refine[unfolded build_scc_impl_ll'.refine[OF fr_graph_scc_impl_loc_axioms]]


  definition open_is :: "nat \<times> nat GS \<Rightarrow> nat \<times> nat GS" where "open_is is = (case is of (i,s) \<Rightarrow> (i,s))"
  sepref_register open_is :: "nat \<times> nat list \<times> nat list \<times> (nat\<Rightarrow> node_state option) \<times> (nat \<times> nat) list
     \<Rightarrow> nat \<times> nat list \<times> nat list \<times> (nat \<Rightarrow> node_state option) \<times> (nat \<times> nat) list"

  sepref_definition open_is_ll is "RETURN o open_is" :: "(data_assn \<times>\<^sub>a GS_assn)\<^sup>d \<rightarrow>\<^sub>a data_assn \<times>\<^sub>a GS_assn"
    unfolding open_is_def
    apply sepref
    done

  concrete_definition (in -) open_is_ll' [llvm_code] is fr_graph_scc_impl_loc.open_is_ll_def
  lemmas [sepref_fr_rules] = open_is_ll.refine[unfolded open_is_ll'.refine[OF fr_graph_scc_impl_loc_axioms]]


  definition close_is :: "nat \<Rightarrow> nat GS \<Rightarrow> nat \<times> nat GS" where "close_is i s = (i,s)"
  sepref_register close_is :: "nat \<Rightarrow> (nat list \<times> nat list \<times> (nat \<Rightarrow> node_state option) \<times> (nat \<times> nat) list)
     \<Rightarrow> nat \<times> nat list \<times> nat list \<times> (nat \<Rightarrow> node_state option) \<times> (nat \<times> nat) list"

  sepref_definition close_is_ll is "uncurry (RETURN oo close_is)" :: "data_assn\<^sup>d *\<^sub>a GS_assn\<^sup>d \<rightarrow>\<^sub>a data_assn \<times>\<^sub>a GS_assn"
    unfolding close_is_def
    apply sepref
    done

  concrete_definition (in -) close_is_ll' [llvm_code] is fr_graph_scc_impl_loc.close_is_ll_def
  lemmas [sepref_fr_rules] = close_is_ll.refine[unfolded close_is_ll'.refine[OF fr_graph_scc_impl_loc_axioms]]


  definition "compute_SCC_inner_while_body2 E_succ' = (\<lambda> (i,s). 
          do {
            \<comment> \<open>Select edge from end of path\<close>

            (vo,s) \<leftarrow> select_edge_impl' E_succ' s;

            if (vo = None) then \<^cancel>\<open>TODO: Handle case distinction differently\<close>
                build_scc_impl_fr s i
            else do {
                let v = the(vo);
                \<comment> \<open>No more outgoing edges from current node on path\<close>
                ASSERT (v \<in> E_\<alpha>\<^sup>*``V0);
                if is_on_stack_impl v s then do {
                  s\<leftarrow> collapse_impl_fr v s;
                  RETURN (i, s)
                } else if \<not>is_done_impl v s then do {
                  \<comment> \<open>Edge to new node. Append to path\<close>
                  s \<leftarrow> push_impl' E_succ' v s;
                  RETURN (i, s)
                } else do {
                  \<comment> \<open>Edge to done node. Skip\<close>
                  RETURN (i, s)
                }
             }
          })"
  sepref_register compute_SCC_inner_while_body2 :: "(nat \<Rightarrow> nat list)
     \<Rightarrow> nat \<times> nat list \<times> nat list \<times> (nat \<Rightarrow> node_state option) \<times> (nat \<times> nat) list
        \<Rightarrow> (nat \<times> (nat list \<times> nat list \<times> (nat \<Rightarrow> node_state option) \<times> (nat \<times> nat) list)) nres"


  lemma compute_SCC_inner_while_body_alt_def: "compute_SCC_inner_while_body is = compute_SCC_inner_while_body2 E_succ is"
    unfolding compute_SCC_inner_while_body_def compute_SCC_inner_while_body2_def close_is_def open_is_def push_S_impl_def select_edge_S_impl_def select_edge_impl_alt_def
    apply (cases "is")
    apply clarsimp
    apply (fo_rule arg_cong)
    apply (rule ext)
    apply (auto simp: push_impl_alt_def )
    done


  sepref_definition compute_SCC_inner_while_body_ll is "uncurry (PR_CONST compute_SCC_inner_while_body2)" :: "E_at_assn\<^sup>k *\<^sub>a (data_assn \<times>\<^sub>a GS_assn)\<^sup>d \<rightarrow>\<^sub>a data_assn \<times>\<^sub>a GS_assn"
    unfolding compute_SCC_inner_while_body2_def PR_CONST_def
    apply sepref
    done


  concrete_definition (in -) compute_SCC_inner_while_body_ll' [llvm_code] is fr_graph_scc_impl_loc.compute_SCC_inner_while_body_ll_def
  lemmas [sepref_fr_rules] = compute_SCC_inner_while_body_ll.refine[unfolded compute_SCC_inner_while_body_ll'.refine[OF fr_graph_scc_impl_loc_axioms]]


  definition "output_assn_raw = data_assn \<times>\<^sub>a (node_state.am_assn N)"

  definition open_iI :: "nat \<times> nat oGS \<Rightarrow> nat \<times> nat oGS" where "open_iI iI = (case iI of (i,I) \<Rightarrow> (i,I))"
  sepref_register open_iI :: "nat \<times> (nat \<Rightarrow> node_state option) \<Rightarrow> nat \<times> ((nat, node_state) i_map)"

  sepref_definition open_iI_ll is "RETURN o open_iI" :: "output_assn_raw\<^sup>d \<rightarrow>\<^sub>a data_assn \<times>\<^sub>a (node_state.am_assn N)"
    unfolding open_iI_def output_assn_raw_def
    apply sepref
    done

  concrete_definition (in -) open_iI_ll' [llvm_code] is fr_graph_scc_impl_loc.open_iI_ll_def
  lemmas [sepref_fr_rules] = open_iI_ll.refine[unfolded open_iI_ll'.refine[OF fr_graph_scc_impl_loc_axioms]]



  definition close_iI :: "nat \<Rightarrow> nat oGS \<Rightarrow> nat \<times> nat oGS" where "close_iI i I = (i,I)"
  sepref_register close_iI :: "nat \<Rightarrow> ((nat, node_state) i_map) \<Rightarrow> nat \<times> (nat \<Rightarrow> node_state option)"

  sepref_definition close_iI_ll is "uncurry (RETURN oo close_iI)" :: "data_assn\<^sup>d *\<^sub>a (node_state.am_assn N)\<^sup>d \<rightarrow>\<^sub>a output_assn_raw"
    unfolding close_iI_def output_assn_raw_def
    apply sepref
    done

  concrete_definition (in -) close_iI_ll' [llvm_code] is fr_graph_scc_impl_loc.close_iI_ll_def
  lemmas [sepref_fr_rules] = close_iI_ll.refine[unfolded close_iI_ll'.refine[OF fr_graph_scc_impl_loc_axioms]]


  definition "compute_SCC_impl_nfoldli E_succ' \<equiv> do {
      let i = Map.empty;
      let so = close_iI 0 i;
      so \<leftarrow> nfoldli [0..<N] (\<lambda>_. True)(\<lambda>v0 (iI0 :: (nat \<times> (nat \<Rightarrow> node_state option))). do {
        v0 \<leftarrow> mop_bound_val (\<lambda> x. x < N) v0;
        ASSERT (v0 \<in> E_\<alpha>\<^sup>*``V0);
        let (i0, I0) = open_iI iI0;
        if \<not>is_done_oimpl v0 I0 then do {
          s \<leftarrow> initial_impl' E_succ' v0 I0;

          (i,s)\<leftarrow> WHILEIT (\<lambda> (i,s). (\<lambda> (SCC,p,D,pE). \<exists>vE. cscc_invar v0 (oGS_\<alpha> I0) (SCC,p,D,pE,vE)) (GSS_defs.s_\<alpha> E_succ' s i))
            (\<lambda> (_, s). \<not>path_is_empty_impl s) 
            (compute_SCC_inner_while_body2 E_succ')
            (i0,s);
          let (S,B,I,P) = open_GS s;
          RETURN (close_iI i I)
        } else
          RETURN (close_iI i0 I0)
        }) so;
      RETURN so
    }"
  sepref_register skeleton_impl_nfoldli :: "(nat \<Rightarrow> nat list) \<Rightarrow> ((nat, node_state) i_map) nres"



  lemma bounded_list_set_b_rel: "([0..<N], V0) \<in> \<langle>node_rel' N\<rangle>list_set_rel"
  proof -
    have "([0..<N], set [0..<N]) \<in> \<langle>node_rel' N\<rangle>list_set_rel"
      apply(rule list_to_set_b_rel'_setI)
      by (auto simp: list_all_length)
    thus ?thesis 
      by (simp add: V0_BOUND)
  qed 


  lemma skeleton_impl_nfoldli_refine: "compute_SCC_impl_nfoldli E_succ \<le> \<Down> Id compute_SCC_impl"
    unfolding compute_SCC_impl_nfoldli_def compute_SCC_impl_def open_GS_def open_iI_def close_iI_def initial_S_impl_def
    apply (simp only: Refine_Basic.nres_monad_laws)
    apply (simp del: conc_Id)
    apply (refine_rcg LFOi_refine[where A="node_rel' N"])
    apply refine_dref_type
    apply (vc_solve (nopre) solve: asm_rl I_to_outer 
      simp: bounded_list_set_rel compute_SCC_inner_while_body_alt_def initial_impl_alt bounded_list_set_b_rel)
    apply(auto simp add: reachable_bound) 
    done

  
  lemma fold_nat_am_custom_empty': "(let i = close_iI 0 Map.empty in f i) = (let N'= (BCONST N N); i = close_iI 0 (op_am_custom_empty N') in f i)"
    by simp


  sepref_definition compute_SCC_impl_ll is "PR_CONST compute_SCC_impl_nfoldli" :: "E_at_assn\<^sup>k \<rightarrow>\<^sub>a output_assn_raw"
    unfolding compute_SCC_impl_nfoldli_def PR_CONST_def
    unfolding fold_am_custom_empty' nfoldli_upt_by_while
    apply (annot_snat_const "TYPE(size_T)")
    supply [simp] = reachable_bound
    apply sepref
    done


  concrete_definition (in -) compute_SCC_impl_ll' [llvm_code] is fr_graph_scc_impl_loc.compute_SCC_impl_ll_def
  lemmas [sepref_fr_rules] = compute_SCC_impl_ll.refine[unfolded compute_SCC_impl_ll'.refine[OF fr_graph_scc_impl_loc_axioms]]

  definition "output_assn \<equiv> hr_comp output_assn_raw SCC_rel"

end


concrete_definition Modest_compute_SCC_impl[llvm_code] is 
  compute_SCC_impl_ll'_def[of modest_is_empty_ll modest_index_begin_ll modest_get_state_ll modest_succ_at_alt_ll modest_has_successor_def_ll modest_next_index_ll]


interpretation fr_graph_scc_impl_def: fr_graph_scc_impl_def_loc
  where E_succ=E_succ and N=N and D=N
  and E_at_assn = "modest_graph_succ_SS_assn N SS" 
  and succ_index_assn = "modest_index_SS_assn N SS"
  and empty_idi = "modest_is_empty_ll"
  and init_idi = modest_index_begin_ll
  and get_statei = modest_get_state_ll
  and succ_ati = modest_succ_at_alt_ll
  and valid_idi = modest_has_successor_def_ll
  and next_idi = modest_next_index_ll
  and ni=ni 
  for E_succ N ni .


type_synonym scc_resulti = "size_t \<times> size_t ptr"

definition Modest_compute_SCC_impl' :: "size_t \<Rightarrow> modest_graphi ptr \<Rightarrow> scc_resulti ptr \<Rightarrow> unit llM"
where [llvm_code, llvm_inline]: "Modest_compute_SCC_impl' ni Eip resp \<equiv> doM {
  Ei \<leftarrow> ll_load Eip;
  res \<leftarrow> Modest_compute_SCC_impl ni Ei;
  ll_store res resp
}"


export_llvm Modest_compute_SCC_impl' is "void compute_SCC(my_size_t, modest_graph_t *, scc_result_t *)"  
defines \<open>
  typedef uint64_t my_size_t;
  typedef my_size_t node_t;
  typedef uint64_t shared_nat_t;
  typedef uint64_t *bitset_t;

  typedef struct {
    shared_nat_t *states;
    struct {
      shared_nat_t *transitions;
      node_t *branches;
    };
  } modest_graph_t;

  typedef struct {
    my_size_t num_sccs;
    node_t *scc_map;
  } scc_result_t;
\<close>
  file "modest_gabow.ll"





    



locale Modest_graph_impl_loc = fr_graph_scc_impl_def_loc "{0..<N}" E_succ N N "modest_graph_succ_SS_assn N SS" 
  "modest_index_SS_assn N SS" modest_is_empty_ll modest_index_begin_ll modest_get_state_ll modest_succ_at_alt_ll modest_has_successor_def_ll modest_next_index_ll ni
  for E_succ and N :: nat and SS and ni +
  assumes n_impl: "(ni, N) \<in> size_rel"
  assumes N_BOUND: "2 * N < max_snat LENGTH(64)"
  assumes E_BOUND: "E_\<alpha> \<subseteq> {0..<N} \<times> {0..<N}"
begin


  sublocale fr_graph_scc_impl_loc "{0..<N}" E_succ N "N" "modest_graph_succ_SS_assn N SS" 
  "modest_index_SS_assn N SS" modest_is_empty_ll modest_index_begin_ll modest_get_state_ll modest_succ_at_alt_ll modest_has_successor_def_ll modest_next_index_ll ni
    apply unfold_locales
    apply(rule rtrancl_image_subsetI[OF E_BOUND, THEN finite_subset] ) 
    apply blast
    subgoal by solve_constraint
    using mop_is_empty_hnr apply blast
    using mop_index_begin_hnr apply blast
    using mop_get_state_hnr apply blast
    using mop_graph_succ_at_hnr apply blast
    using mop_has_succ_hnr apply blast
    using mop_next_id_hnr apply blast
    apply (rule E_BOUND)
    apply simp
    using N_BOUND apply simp
    apply (rule n_impl)
    apply simp
    done

                                                                                       
  lemma Modest_graph_skeleton_impl_refines_spec: "(Modest_compute_SCC_impl ni, \<lambda>_. compute_SCC_spec) 
    \<in> (hr_comp (modest_graph_succ_SS_assn N SS) {(E_succ,E_succ)})\<^sup>k \<rightarrow>\<^sub>a output_assn"
  proof -
  
    note r1 = Modest_compute_SCC_impl.refine[of ni, folded compute_SCC_impl_ll'.refine[OF fr_graph_scc_impl_loc_axioms]]

    note r2 = compute_SCC_impl_ll.refine[unfolded PR_CONST_def]  
    
    note skeleton_impl_nfoldli_refine
    also note compute_SCC_impl_refine
    also note compute_SCC_correct
    finally have "(compute_SCC_impl_nfoldli E_succ, compute_SCC_spec) \<in> \<langle>SCC_rel\<rangle> nres_rel"
      by (auto simp: nres_rel_def)
    hence r3: "(compute_SCC_impl_nfoldli, (\<lambda> _. compute_SCC_spec)) \<in> {(E_succ,E_succ)} \<rightarrow> \<langle>SCC_rel\<rangle> nres_rel"
      by auto
    
    from r2[FCOMP r3, unfolded r1, folded output_assn_def] show ?thesis .
  qed

end

lemma Modest_graph_skeleton_impl_refines_spec': 
  assumes LOC: "Modest_graph_impl_loc E_succ N ni"
  shows "(Modest_compute_SCC_impl ni, \<lambda>_. fr_graph_defs.compute_SCC_spec {0..<N} E_succ) 
    \<in> (hr_comp (modest_graph_succ_assn N) {(E_succ,E_succ)})\<^sup>k \<rightarrow>\<^sub>a fr_graph_scc_impl_loc.output_assn {0..<N} E_succ N N"
proof -
  from LOC have GRP: "fr_graph {0..<N} E_succ"
    apply(unfold_locales) 
    apply(rule finite_rtrancl_Image)
    using Modest_graph_impl_loc.E_BOUND[OF LOC] 
    using finite_atLeastLessThan finite_cartesian_product rev_finite_subset apply blast
    by blast

  have AUX1: "modest_graph_succ_SS_assn N SS E_succ' Ei' \<turnstile> modest_graph_succ_assn N E_succ' Ei'" for SS E_succ' Ei' 
    unfolding modest_graph_succ_assn_alt entails_def
    by blast

  have AUX2: "\<forall> SS. (Modest_compute_SCC_impl ni, \<lambda>_. fr_graph_defs.compute_SCC_spec {0..<N} E_succ)
  \<in> (hr_comp (modest_graph_succ_SS_assn N SS) {(E_succ, E_succ)})\<^sup>k \<rightarrow>\<^sub>a fr_graph_scc_impl_loc.output_assn {0..<N} E_succ N N"
    using Modest_graph_impl_loc.Modest_graph_skeleton_impl_refines_spec[OF LOC] unfolding fr_graph.outer_invar_def[OF GRP] 
    by blast

  thus ?thesis
    apply -
    apply(drule hfref_keep_exs)
    unfolding modest_graph_succ_assn_alt ex_hr_comp 
    by blast
 
qed


theorem Modest_graph_SCC_impl_correct_htriple: "llvm_htriple 
  (snat_assn N ni ** \<up>(2 * N < max_snat LENGTH(64)) ** modest_graph_succ_assn N E_succ Ei) 
  (Modest_compute_SCC_impl ni Ei) 
  (\<lambda>ri. EXS r. 
    snat_assn N ni ** \<up>(2 * N < max_snat LENGTH(64)) 
    ** modest_graph_succ_assn N E_succ Ei
    ** fr_graph_scc_impl_loc.output_assn {0..<N} E_succ N N r ri 
    ** \<up>(set r = fr_graph_defs.scc_set {0..<N} E_succ)
    ** \<up>(fr_graph_defs.ordered E_succ r))"
  apply(rule htriple_pure_preI)
  apply(drule pure_part_split_conj, clarify)+
  unfolding pure_part_modest_graph_succ_assn
  apply clarify
  apply(frule modest_graph_assn_E_succ_pure_partD)
  apply(drule modest_graph_assn_pure_partD)
  apply clarsimp
  proof (goal_cases)
    case 1
    have INV: "Modest_graph_impl_loc E_succ N ni"
      apply unfold_locales 
      apply (fact|clarsimp)+
      using 1 by fastforce

    note [simp] = hr_comp_b_rel_Id
    note [simp] = fr_graph_defs.compute_SCC_spec_def

    note [vcg_rules] = Modest_graph_skeleton_impl_refines_spec'[OF INV, to_hnr, THEN hn_refineD, unfolded hn_ctxt_def, of E_succ Ei,  simplified]

    show ?case 
      apply(fold 1(3))
      apply vcg
      unfolding outer_invar_loc_def .
  qed


(*** THIS IS THE OLD HOARE TRIPLE ***)

theorem Modest_graph_SCC_impl_correct_htriple_old: "llvm_htriple 
  (snat_assn N ni ** \<up>(2 * N < max_snat LENGTH(64)) ** modest_graph_succ_SS_assn N SS E_succ Ei) 
  (Modest_compute_SCC_impl ni Ei) 
  (\<lambda>ri. EXS r. 
    snat_assn N ni ** \<up>(2 * N  < max_snat LENGTH(64)) 
    ** modest_graph_succ_SS_assn N SS E_succ Ei
    ** fr_graph_scc_impl_loc.output_assn {0..<N} E_succ N N r ri 
    ** \<up>(set r = fr_graph_defs.scc_set {0..<N} E_succ)
    ** \<up>(fr_graph_defs.ordered E_succ r))"
  apply(rule htriple_pure_preI)
  apply(drule pure_part_split_conj, clarify)+
  apply(frule modest_graph_assn_E_succ_pure_partD)
  apply(drule modest_graph_assn_pure_partD)
  apply clarsimp
  proof (goal_cases)
    case 1
    interpret Modest_graph_impl_loc E_succ N SS ni
      apply unfold_locales 
      using 1 by auto
    note [simp] = hr_comp_b_rel_Id

    note [simp] = compute_SCC_spec_def

    note [vcg_rules] = Modest_graph_skeleton_impl_refines_spec[to_hnr, THEN hn_refineD, unfolded hn_ctxt_def, of E_succ Ei, simplified]
    show ?case 
      apply(fold 1(3))
      by vcg
  qed

(*** THIS IS THE OLD HOARE TRIPLE ***)

end

