# -*- coding: utf-8 -*-
"""
Created on Thu Dec 17 10:32:32 2020

@author: fvanriggelen
"""

#%%importing python packages 
import matplotlib.pyplot as plt
import numpy as np

plt.rcParams['image.cmap'] = 'gray_r'
plt.rcParams["figure.figsize"] = [3,2.6]
plt.rcParams.update({'font.size': 8})
plt.rcParams['font.family']='arial'

#%% defining a function that plots the image 
def pcolormesh_centre(x, y, im, xlabel, ylabel, vmin=None, vmax=None):
    """ Wrapper for pcolormesh to plot pixel centres at data points.
    """
    dx=np.diff(x)
    dy=np.diff(y)
    dx=np.hstack( (dx[0], dx, dx[-1]))
    dy=np.hstack( (dy[0], dy, dy[-1]))
    xx=np.hstack( (x, x[-1]+dx[-1]))-dx/2
    yy=np.hstack( (y, y[-1]+dy[-1]))-dy/2
    plt.figure()
    if (vmin is not None) and (vmax is not None):
        plt.pcolormesh(xx, yy, im, vmin=vmin, vmax= vmax)
    else:
        plt.pcolormesh(xx, yy, im)
    plt.xlabel(xlabel)
    plt.ylabel(ylabel)
    plt.tight_layout()
    
#%% importing the data
xx = np.loadtxt('Figure_2a_xx.txt')
yy = np.loadtxt('Figure_2a_yy.txt')
image = np.loadtxt('Figure_2a_image.txt')

#%% plotting the image and rescaling the visibility 
pcolormesh_centre(xx,yy,image,'Gate voltage $\delta$$V_{P1}$ (mV)','Gate voltage $\delta$$V_{P3}$ (mV)', vmin = np.min(image) , vmax  = 0.004)
plt.yticks(np.arange(min(yy), max(yy)+1, 50))
plt.xticks(np.arange(min(xx), max(xx)+1, 50))


plt.text(91.5,74,'(0,0)',horizontalalignment='center')
plt.tight_layout()
