set encoding iso_8859_1
set terminal postscript 12 portrait enhanced color dashed
# set terminal latex
set output "plot_DOS_DFT.ps"
# set output "histo.tex"
# set nokey
set lmargin 0
set tmargin 0
set bmargin 0
# set zeroaxis
set format y "{%2.1f}"
set format x "{%3.1f}"
set format y "{%g}"
set format x "{%g}"
# set nolabel
set xrange [-9:6]
set yrange [-3:3]
set xtics -32, 4, 20
set ytics -10, 2, 360
# set ytics  -247, 1, -245
#set ytics  ("{/Helvetica 0}" 0, "{/Helvetica 10}" 10, "{/Helvetica 20}" 20)
set mxtics (4)
set mytics (2)
show mxtics
show mytics
set multiplot
set size 0.4, 0.16
# set size square
set xlabel "{x}"
set ylabel "{{/Symbol D} E (eV/f.u.)}"
unset ylabel
#
set label "{(a)}" at graph 0.05, 0.85
set label "{Mn}" at graph 0.85, 0.85
set label "{{/Symbol G}_2}" at graph 0.4, 1.15
set format x ""
set nokey
unset xlabel
set yrange [-3:3]
set ytics -10, 2, 360
set origin 0.14,0.635
plot "FM/plot.Mn.par" using 1:2  w lines lc rgb "red"
plot "FM/plot.Mn.par" using 1:4  w lines lc rgb "black"
plot "FM/plot.Mn.par" using 1:6  w lines lc rgb "green"
plot "FM/plot.Mn.par" using 1:8  w lines lc rgb "blue"  
plot "FM/plot.Mn.par" using 1:10 w lines lc rgb "orange"
plot "FM/plot.Mn.par" using 1:12 w lines lc rgb "cyan"
plot "FM/plot.Mn.par" using 1:14 w lines lc rgb "plum" 
plot "FM/plot.Mn.par" using 1:16 w lines lc rgb "brown" 
plot "FM/plot.Mn.par" using 1:18 w lines lc rgb "grey"
plot "FM/plot.Mn.par" using 1:20 w lines lc rgb "sienna1"
plot "FM/plot.Mn.par" using 1:22 w lines lc rgb "pink"
plot "FM/plot.Mn.par" using 1:24 w lines lc rgb "sandybrown"
plot "FM/plot.Mn.par" using 1:26 w lines lc rgb "olive"
plot "FM/plot.Mn.par" using 1:28 w lines lc rgb "navy"
plot "FM/plot.Mn.par" using 1:30 w lines lc rgb "magenta"
plot "FM/plot.Mn.par" using 1:32 w lines lc rgb "salmon"    
plot "FM/plot.Mn.par" using 1:3  w lines lc rgb "red"
plot "FM/plot.Mn.par" using 1:5  w lines lc rgb "black"
plot "FM/plot.Mn.par" using 1:7  w lines lc rgb "green"
plot "FM/plot.Mn.par" using 1:8  w lines lc rgb "blue"  
plot "FM/plot.Mn.par" using 1:11 w lines lc rgb "orange"
plot "FM/plot.Mn.par" using 1:13 w lines lc rgb "cyan"
plot "FM/plot.Mn.par" using 1:15 w lines lc rgb "plum" 
plot "FM/plot.Mn.par" using 1:17 w lines lc rgb "brown" 
plot "FM/plot.Mn.par" using 1:19 w lines lc rgb "grey"
plot "FM/plot.Mn.par" using 1:21 w lines lc rgb "sienna1"
plot "FM/plot.Mn.par" using 1:23 w lines lc rgb "pink"
plot "FM/plot.Mn.par" using 1:25 w lines lc rgb "sandybrown"
plot "FM/plot.Mn.par" using 1:27 w lines lc rgb "olive"
plot "FM/plot.Mn.par" using 1:29 w lines lc rgb "navy"
plot "FM/plot.Mn.par" using 1:31 w lines lc rgb "magenta"
plot "FM/plot.Mn.par" using 1:33 w lines lc rgb "salmon"    
plot "nul" using 1:2 w lines lc rgb "black"
plot "fer" using 1:2 w lines lc rgb "black"
# plot "ETOT.AB" using 1:2 w lines dt 2 lc rgb "blue"
# plot "ETOT.HANGGAI" using 1:2 w lines dt 2 lc rgb "sienna1"
# set key samplen 0.2 at graph 0.99, 0.36
# plot "ETOT.MN3SN"  w points pt 4  ps 1.5 lc "dark-olivegreen" title "Mn_3Sn"
# set key samplen 0.2 at graph 0.99, 0.28
# plot "ETOT.FM"  w points pt 7  ps 1.3 lc "red" title "FM"
# set key samplen 0.2 at graph 0.99, 0.20
# plot "ETOT.AB"  w points pt 5  ps 1.0 lc "blue" title "AF AB" 
# set key samplen 0.2 at graph 0.99, 0.12
# plot "ETOT.HANGGAI"  w points pt 13 ps 1.3 lc "sienna1" title "Hanggai"
# set nokey
# # plot "DOS.Zn" using 1:4 w lines lc rgb "blue"
# # plot "DOS.Zn" using 1:5 w lines lc rgb "blue"
# # plot "DOS.Zn" using 1:6 w lines lc rgb "blue"
# # plot "DOS.Zn" using 1:7 w lines lc rgb "blue"
# # plot "DOS.Zn" using 1:8 w lines lc rgb "blue"
# # plot "DOS.Zn" using 1:9 w lines lc rgb "blue"
# # plot "DOS.Zn" using 1:10 w lines lc rgb "blue"
# # plot "DOS.Zn" using 1:11 w lines dashtype 2 lc rgb "green"
# # set key samplen 0.2 at graph 0.99, 0.15
# # plot "../H_STD/plot.H.2" w points pt 6  ps 0.8 lc 1 title "current augmentation"
# # plot "test" w points pt 7  ps 0.6 lc 2 title "current augmentation"
# # plot "P"  w points pt 8  ps 1.3 lc 3
# # plot "F"  w points pt 12 ps 1.3 lc 2
# set nokey
# # plot "../H_STD/line.H" w lines lt 2 t 'bla'
# 
unset label
# set yrange [1.4:2.8]
# set ytics -10, 0.20, 360
# set mytics (1)
set ylabel "{DOS (states/eV/atom)}"
set ytics -10, 2, 360
set origin 0.14,0.47
set yrange [-3:3]
set label "{(b)}" at graph 0.05, 0.85
set label "{Fe}" at graph 0.85, 0.85
plot "FM/plot.Fe.par" using 1:2  w lines lc rgb "red"
plot "FM/plot.Fe.par" using 1:4  w lines lc rgb "black"
plot "FM/plot.Fe.par" using 1:6  w lines lc rgb "green"
plot "FM/plot.Fe.par" using 1:8  w lines lc rgb "blue"  
plot "FM/plot.Fe.par" using 1:10 w lines lc rgb "orange"
plot "FM/plot.Fe.par" using 1:12 w lines lc rgb "cyan"
plot "FM/plot.Fe.par" using 1:14 w lines lc rgb "plum" 
plot "FM/plot.Fe.par" using 1:16 w lines lc rgb "brown" 
plot "FM/plot.Fe.par" using 1:3  w lines lc rgb "red"
plot "FM/plot.Fe.par" using 1:5  w lines lc rgb "black"
plot "FM/plot.Fe.par" using 1:7  w lines lc rgb "green"
plot "FM/plot.Fe.par" using 1:8  w lines lc rgb "blue"  
plot "FM/plot.Fe.par" using 1:11 w lines lc rgb "orange"
plot "FM/plot.Fe.par" using 1:13 w lines lc rgb "cyan"
plot "FM/plot.Fe.par" using 1:15 w lines lc rgb "plum" 
plot "FM/plot.Fe.par" using 1:17 w lines lc rgb "brown" 
plot "nul" using 1:2 w lines lc rgb "black"
plot "fer" using 1:2 w lines lc rgb "black"
# plot "mom.FM" using 1:2 w lines dt 2 lc rgb "red"
# plot "mom.AB" using 1:2 w lines dt 2 lc rgb "blue"
# plot "mom.HANGGAI" using 1:2 w lines dt 2 lc rgb "sienna1"
# plot "mom.MN3SN"  w points pt 4  ps 1.5 lc "dark-olivegreen" title "MN_3SN"
# # set key samplen 0.2 at graph 0.99, 0.30
# plot "mom.FM"  w points pt 7  ps 1.3 lc "red" title "FM"
# # set key samplen 0.2 at graph 0.99, 0.20
# plot "mom.AB"  w points pt 5  ps 1.0 lc "blue" title "AF AB" 
# # set key samplen 0.2 at graph 0.99, 0.10
# plot "mom.HANGGAI"  w points pt 13 ps 1.3 lc "sienna1" title "Hanggai"
# set nokey
# 
unset label
# set yrange [1.4:2.8]
# set ytics -10, 0.20, 360
# set mytics (1)
set ylabel "{spin magnetic moment ({/Symbol m}_{B}/atom)}"
unset ylabel
set xlabel "{{/Symbol e} - {/Symbol e}_F (eV)}"
set ytics -10, 1, 360
set origin 0.14,0.305
set format x "{%g}"
set yrange [-1:1]
set label "{(c)}" at graph 0.05, 0.85
set label "{Sn}" at graph 0.85, 0.85
plot "FM/plot.Sn.par" using ($1):(-$2) w lines lc rgb "red"
plot "FM/plot.Sn.par" using ($1):(-$4) w lines lc rgb "black"
plot "FM/plot.Sn.par" using ($1):(-$6) w lines lc rgb "green"
plot "FM/plot.Sn.par" using ($1):(-$8) w lines lc rgb "blue"  
plot "FM/plot.Sn.par" using ($1):(-$10) w lines lc rgb "orange"
plot "FM/plot.Sn.par" using ($1):(-$12) w lines lc rgb "cyan"
plot "FM/plot.Sn.par" using ($1):(-$14) w lines lc rgb "plum" 
plot "FM/plot.Sn.par" using ($1):(-$16) w lines lc rgb "brown" 
plot "FM/plot.Sn.par" using ($1):(-$3 ) w lines lc rgb "red"
plot "FM/plot.Sn.par" using ($1):(-$5 ) w lines lc rgb "black"
plot "FM/plot.Sn.par" using ($1):(-$7 ) w lines lc rgb "green"
plot "FM/plot.Sn.par" using ($1):(-$8 ) w lines lc rgb "blue"  
plot "FM/plot.Sn.par" using ($1):(-$11) w lines lc rgb "orange"
plot "FM/plot.Sn.par" using ($1):(-$13) w lines lc rgb "cyan"
plot "FM/plot.Sn.par" using ($1):(-$15) w lines lc rgb "plum" 
plot "FM/plot.Sn.par" using ($1):(-$17) w lines lc rgb "brown" 
plot "nul" using 1:2 w lines lc rgb "black"
plot "fer2" using 1:2 w lines lc rgb "black"
#
unset ylabel
unset xlabel
set format y ""
set format x ""
unset label
set yrange [-3:3]
set origin 0.505,0.635
set ytics -10, 2, 360
set label "{(d)}" at graph 0.05, 0.85
set label "{Mn}" at graph 0.85, 0.85
set label "{{/Symbol G}_2 /& {/Symbol G}_8}" at graph 0.4, 1.15
set nokey
plot "canted/plot.Mn.par" using 1:2  w lines lc rgb "red"
plot "canted/plot.Mn.par" using 1:4  w lines lc rgb "black"
plot "canted/plot.Mn.par" using 1:6  w lines lc rgb "green"
plot "canted/plot.Mn.par" using 1:8  w lines lc rgb "blue"  
plot "canted/plot.Mn.par" using 1:10 w lines lc rgb "orange"
plot "canted/plot.Mn.par" using 1:12 w lines lc rgb "cyan"
plot "canted/plot.Mn.par" using 1:14 w lines lc rgb "plum" 
plot "canted/plot.Mn.par" using 1:16 w lines lc rgb "brown" 
plot "canted/plot.Mn.par" using 1:18 w lines lc rgb "grey"
plot "canted/plot.Mn.par" using 1:20 w lines lc rgb "sienna1"
plot "canted/plot.Mn.par" using 1:22 w lines lc rgb "pink"
plot "canted/plot.Mn.par" using 1:24 w lines lc rgb "sandybrown"
plot "canted/plot.Mn.par" using 1:26 w lines lc rgb "olive"
plot "canted/plot.Mn.par" using 1:28 w lines lc rgb "navy"
plot "canted/plot.Mn.par" using 1:30 w lines lc rgb "magenta"
plot "canted/plot.Mn.par" using 1:32 w lines lc rgb "salmon"    
plot "canted/plot.Mn.par" using 1:3  w lines lc rgb "red"
plot "canted/plot.Mn.par" using 1:5  w lines lc rgb "black"
plot "canted/plot.Mn.par" using 1:7  w lines lc rgb "green"
plot "canted/plot.Mn.par" using 1:8  w lines lc rgb "blue"  
plot "canted/plot.Mn.par" using 1:11 w lines lc rgb "orange"
plot "canted/plot.Mn.par" using 1:13 w lines lc rgb "cyan"
plot "canted/plot.Mn.par" using 1:15 w lines lc rgb "plum" 
plot "canted/plot.Mn.par" using 1:17 w lines lc rgb "brown" 
plot "canted/plot.Mn.par" using 1:19 w lines lc rgb "grey"
plot "canted/plot.Mn.par" using 1:21 w lines lc rgb "sienna1"
plot "canted/plot.Mn.par" using 1:23 w lines lc rgb "pink"
plot "canted/plot.Mn.par" using 1:25 w lines lc rgb "sandybrown"
plot "canted/plot.Mn.par" using 1:27 w lines lc rgb "olive"
plot "canted/plot.Mn.par" using 1:29 w lines lc rgb "navy"
plot "canted/plot.Mn.par" using 1:31 w lines lc rgb "magenta"
plot "canted/plot.Mn.par" using 1:33 w lines lc rgb "salmon"    
plot "nul" using 1:2 w lines lc rgb "black"
plot "fer" using 1:2 w lines lc rgb "black"
# plot "ETOT.AB" using 1:2 w lines dt 2 lc rgb "blue"
# plot "ETOT.HANGGAI" using 1:2 w lines dt 2 lc rgb "sienna1"
# set key samplen 0.2 at graph 0.99, 0.36
# plot "ETOT.MN3SN"  w points pt 4  ps 1.5 lc "dark-olivegreen" title "Mn_3Sn"
# set key samplen 0.2 at graph 0.99, 0.28
# plot "ETOT.FM"  w points pt 7  ps 1.3 lc "red" title "FM"
# set key samplen 0.2 at graph 0.99, 0.20
# plot "ETOT.AB"  w points pt 5  ps 1.0 lc "blue" title "AF AB" 
# set key samplen 0.2 at graph 0.99, 0.12
# plot "ETOT.HANGGAI"  w points pt 13 ps 1.3 lc "sienna1" title "Hanggai"
# set nokey
# # plot "DOS.Zn" using 1:4 w lines lc rgb "blue"
# # plot "DOS.Zn" using 1:5 w lines lc rgb "blue"
# # plot "DOS.Zn" using 1:6 w lines lc rgb "blue"
# # plot "DOS.Zn" using 1:7 w lines lc rgb "blue"
# # plot "DOS.Zn" using 1:8 w lines lc rgb "blue"
# # plot "DOS.Zn" using 1:9 w lines lc rgb "blue"
# # plot "DOS.Zn" using 1:10 w lines lc rgb "blue"
# # plot "DOS.Zn" using 1:11 w lines dashtype 2 lc rgb "green"
# # set key samplen 0.2 at graph 0.99, 0.15
# # plot "../H_STD/plot.H.2" w points pt 6  ps 0.8 lc 1 title "current augmentation"
# # plot "test" w points pt 7  ps 0.6 lc 2 title "current augmentation"
# # plot "P"  w points pt 8  ps 1.3 lc 3
# # plot "F"  w points pt 12 ps 1.3 lc 2
# set nokey
# # plot "../H_STD/line.H" w lines lt 2 t 'bla'
# 
unset label
# set yrange [1.4:2.8]
# set ytics -10, 0.20, 360
# set mytics (1)
set yrange [-3:3]
set ytics -10, 2, 360
set origin 0.505,0.47
set label "{(e)}" at graph 0.05, 0.85
set label "{Fe}" at graph 0.85, 0.85
plot "canted/plot.Fe.par" using 1:2  w lines lc rgb "red"
plot "canted/plot.Fe.par" using 1:4  w lines lc rgb "black"
plot "canted/plot.Fe.par" using 1:6  w lines lc rgb "green"
plot "canted/plot.Fe.par" using 1:8  w lines lc rgb "blue"  
plot "canted/plot.Fe.par" using 1:10 w lines lc rgb "orange"
plot "canted/plot.Fe.par" using 1:12 w lines lc rgb "cyan"
plot "canted/plot.Fe.par" using 1:14 w lines lc rgb "plum" 
plot "canted/plot.Fe.par" using 1:16 w lines lc rgb "brown" 
plot "canted/plot.Fe.par" using 1:3  w lines lc rgb "red"
plot "canted/plot.Fe.par" using 1:5  w lines lc rgb "black"
plot "canted/plot.Fe.par" using 1:7  w lines lc rgb "green"
plot "canted/plot.Fe.par" using 1:8  w lines lc rgb "blue"  
plot "canted/plot.Fe.par" using 1:11 w lines lc rgb "orange"
plot "canted/plot.Fe.par" using 1:13 w lines lc rgb "cyan"
plot "canted/plot.Fe.par" using 1:15 w lines lc rgb "plum" 
plot "canted/plot.Fe.par" using 1:17 w lines lc rgb "brown" 
plot "nul" using 1:2 w lines lc rgb "black"
plot "fer" using 1:2 w lines lc rgb "black"
# plot "mom.FM" using 1:2 w lines dt 2 lc rgb "red"
# plot "mom.AB" using 1:2 w lines dt 2 lc rgb "blue"
# plot "mom.HANGGAI" using 1:2 w lines dt 2 lc rgb "sienna1"
# plot "mom.MN3SN"  w points pt 4  ps 1.5 lc "dark-olivegreen" title "MN_3SN"
# # set key samplen 0.2 at graph 0.99, 0.30
# plot "mom.FM"  w points pt 7  ps 1.3 lc "red" title "FM"
# # set key samplen 0.2 at graph 0.99, 0.20
# plot "mom.AB"  w points pt 5  ps 1.0 lc "blue" title "AF AB" 
# # set key samplen 0.2 at graph 0.99, 0.10
# plot "mom.HANGGAI"  w points pt 13 ps 1.3 lc "sienna1" title "Hanggai"
# set nokey
# 
unset label
# set yrange [1.4:2.8]
# set ytics -10, 0.20, 360
# set mytics (1)
set xlabel "{{/Symbol e} - {/Symbol e}_F (eV)}"
set format x "{%g}"
set yrange [-1:1]
set ytics -10, 1, 360
set origin 0.505,0.305
set label "{(f)}" at graph 0.05, 0.85
set label "{Sn}" at graph 0.85, 0.85
plot "canted/plot.Sn.par" using 1:2  w lines lc rgb "red"
plot "canted/plot.Sn.par" using 1:4  w lines lc rgb "black"
plot "canted/plot.Sn.par" using 1:6  w lines lc rgb "green"
plot "canted/plot.Sn.par" using 1:8  w lines lc rgb "blue"  
plot "canted/plot.Sn.par" using 1:10 w lines lc rgb "orange"
plot "canted/plot.Sn.par" using 1:12 w lines lc rgb "cyan"
plot "canted/plot.Sn.par" using 1:14 w lines lc rgb "plum" 
plot "canted/plot.Sn.par" using 1:16 w lines lc rgb "brown" 
plot "canted/plot.Sn.par" using 1:3  w lines lc rgb "red"
plot "canted/plot.Sn.par" using 1:5  w lines lc rgb "black"
plot "canted/plot.Sn.par" using 1:7  w lines lc rgb "green"
plot "canted/plot.Sn.par" using 1:8  w lines lc rgb "blue"  
plot "canted/plot.Sn.par" using 1:11 w lines lc rgb "orange"
plot "canted/plot.Sn.par" using 1:13 w lines lc rgb "cyan"
plot "canted/plot.Sn.par" using 1:15 w lines lc rgb "plum" 
plot "canted/plot.Sn.par" using 1:17 w lines lc rgb "brown" 
plot "nul" using 1:2 w lines lc rgb "black"
plot "fer2" using 1:2 w lines lc rgb "black"
#
# unset label
# set format y "{%g}"
# set yrange [-5:95]
# set ytics -15, 15, 360
# set mytics (1)
# set ylabel "{{/Symbol Q} (deg)}"
# set origin 0.60,0.32
# set label "{(e)}" at graph 0.05, 0.90
# plot "angle.FM" using 1:2 w lines dt 2 lc rgb "red"
# plot "angle.AB" using 1:2 w lines dt 2 lc rgb "blue"
# plot "angle.HANGGAI" using 1:2 w lines dt 2 lc rgb "sienna1"
# set key samplen 0.2 at graph 0.99, 0.43
# plot "angle.MN3SN"  w points pt 4  ps 1.5 lc "dark-olivegreen" title "Mn_3Sn"
# set key samplen 0.2 at graph 0.99, 0.35
# plot "angle.FM"  w points pt 7  ps 1.3 lc "red" title "FM"
# set key samplen 0.2 at graph 0.99, 0.27
# plot "angle.AB"  w points pt 5  ps 1.0 lc "blue" title "AF AB" 
# set key samplen 0.2 at graph 0.99, 0.19
# plot "angle.HANGGAI"  w points pt 13 ps 1.3 lc "sienna1" title "Hanggai"
# set nokey
# 
# set size 0.37, 0.135
# 
# unset label
# set format y "{%3.1f}"
# set yrange [5.37:5.57]
# set ytics -10, 0.1, 360
# set mytics (2)
# set ylabel "{a (\305)}"
# set origin 0.14,0.32
# set label "{(d)}" at graph 0.87, 0.84
# plot "a.FM" using 1:2 w lines dt 2 lc rgb "red"
# plot "a.AB" using 1:2 w lines dt 2 lc rgb "blue"
# plot "a.HANGGAI" using 1:2 w lines dt 2 lc rgb "sienna1"
# plot "a.MN3SN"  w points pt 4  ps 1.5 lc "dark-olivegreen" title "MN_3SN"
# # set key samplen 0.2 at graph 0.99, 0.30
# plot "a.FM"  w points pt 7  ps 1.3 lc "red" title "FM"
# # set key samplen 0.2 at graph 0.99, 0.20
# plot "a.AB"  w points pt 5  ps 1.0 lc "blue" title "AF AB" 
# # set key samplen 0.2 at graph 0.99, 0.10
# plot "a.HANGGAI"  w points pt 13 ps 1.3 lc "sienna1" title "Hanggai"
# set nokey
# 
# set format x "{}"
# set xlabel ""
# set origin 0.14,0.46
# 
# unset label
# set yrange [4.25:4.45]
# set ytics -10, 0.1, 360
# set mytics (2)
# set ylabel "{c (\305)}"
# set label "{(c)}" at graph 0.87, 0.84
# plot "c.FM" using 1:2 w lines dt 2 lc rgb "red"
# plot "c.AB" using 1:2 w lines dt 2 lc rgb "blue"
# plot "c.HANGGAI" using 1:2 w lines dt 2 lc rgb "sienna1"
# plot "c.MN3SN"  w points pt 4  ps 1.5 lc "dark-olivegreen" title "MN_3SN"
# # set key samplen 0.2 at graph 0.99, 0.30
# plot "c.FM"  w points pt 7  ps 1.3 lc "red" title "FM"
# # set key samplen 0.2 at graph 0.99, 0.20
# plot "c.AB"  w points pt 5  ps 1.0 lc "blue" title "AF AB" 
# # set key samplen 0.2 at graph 0.99, 0.10
# plot "c.HANGGAI"  w points pt 13 ps 1.3 lc "sienna1" title "Hanggai"
# set nokey
# 
# # # set key samplen 0.2 at graph 0.99, 0.10
# # set nokey
# # plot "DOS.Se" using 1:2 w lines lc rgb "red"
# # plot "DOS.Se" using 1:3 w lines lc rgb "blue"
# # plot "DOS.Se" using 1:4 w lines lc rgb "blue"
# # plot "DOS.Se" using 1:5 w lines lc rgb "blue"
# # plot "DOS.Se" using 1:6 w lines lc rgb "blue"
# # plot "DOS.Se" using 1:7 w lines lc rgb "blue"
# # plot "DOS.Se" using 1:8 w lines lc rgb "blue"
# # plot "DOS.Se" using 1:9 w lines lc rgb "blue"
# # plot "DOS.Se" using 1:10 w lines lc rgb "blue"
# # plot "DOS.Se" using 1:11 w lines dashtype 2 lc rgb "green"
# # 
# # unset label
# # set origin 0.10,0.51
# # set label "{In}" at graph 0.05, 0.90
# # # set key samplen 0.2 at graph 0.99, 0.10
# # set nokey
# # plot "DOS.In" using 1:2 w lines lc rgb "red"
# # plot "DOS.In" using 1:3 w lines lc rgb "blue"
# # plot "DOS.In" using 1:4 w lines lc rgb "blue"
# # plot "DOS.In" using 1:5 w lines lc rgb "blue"
# # plot "DOS.In" using 1:6 w lines lc rgb "blue"
# # plot "DOS.In" using 1:7 w lines lc rgb "blue"
# # plot "DOS.In" using 1:8 w lines lc rgb "blue"
# # plot "DOS.In" using 1:9 w lines lc rgb "blue"
# # plot "DOS.In" using 1:10 w lines lc rgb "blue"
# # plot "DOS.In" using 1:11 w lines dashtype 2 lc rgb "green"
# # 
# # unset label
# # set origin 0.10,0.74
# # set label "{P}" at graph 0.05, 0.90
# # # set key samplen 0.2 at graph 0.99, 0.10
# # set nokey
# # plot "DOS.P" using 1:2 w lines lc rgb "red"
# # plot "DOS.P" using 1:3 w lines lc rgb "blue"
# # plot "DOS.P" using 1:4 w lines lc rgb "blue"
# # plot "DOS.P" using 1:5 w lines lc rgb "blue"
# # plot "DOS.P" using 1:6 w lines lc rgb "blue"
# # plot "DOS.P" using 1:7 w lines lc rgb "blue"
# # plot "DOS.P" using 1:8 w lines lc rgb "blue"
# # plot "DOS.P" using 1:9 w lines lc rgb "blue"
# # plot "DOS.P" using 1:10 w lines lc rgb "blue"
# # plot "DOS.P" using 1:11 w lines dashtype 2 lc rgb "green"
# # 
# # unset label
# # # unset label
# # # set ylabel "{}"
# # # set format y "{}"
# # # set xlabel "{}"
# # # set format x "{}"
# # # set size 0.22,0.10
# # # set origin 0.30,0.05
# # # set label "{211}" at graph 0.05, 0.90
# # # set nokey
# # # plot "fort.211" w points pt 13 ps 0.2
# # # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.50,0.05
# # set label "{311}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.311" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.70,0.05
# # set label "{411}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.411" w points pt 13 ps 0.2
# # set nokey
# # 
# # 
# # set xlabel "{}"
# # set format x "{}"
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.10,0.16
# # set label "{121}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.121" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.30,0.16
# # set label "{221}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.221" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.50,0.16
# # set label "{321}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.321" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.70,0.16
# # set label "{421}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.421" w points pt 13 ps 0.2
# # set nokey
# # 
# # 
# # set xlabel "{}"
# # set format x "{}"
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.10,0.27
# # set label "{131}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.131" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.30,0.27
# # set label "{231}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.231" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.50,0.27
# # set label "{331}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.331" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.70,0.27
# # set label "{431}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.431" w points pt 13 ps 0.2
# # set nokey
# # 
# # 
# # set xlabel "{}"
# # set format x "{}"
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.10,0.38
# # set label "{141}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.141" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.30,0.38
# # set label "{241}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.241" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.50,0.38
# # set label "{341}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.341" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.70,0.38
# # set label "{441}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.441" w points pt 13 ps 0.2
# # set nokey
# # 
# # 
# # set xlabel "{}"
# # set format x "{}"
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.10,0.51
# # set label "{112}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.112" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.30,0.51
# # set label "{212}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.212" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.50,0.51
# # set label "{312}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.312" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.70,0.51
# # set label "{412}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.412" w points pt 13 ps 0.2
# # set nokey
# # 
# # 
# # set xlabel "{}"
# # set format x "{}"
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.10,0.62
# # set label "{122}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.122" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.30,0.62
# # set label "{222}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.222" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.50,0.62
# # set label "{322}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.322" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.70,0.62
# # set label "{422}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.422" w points pt 13 ps 0.2
# # set nokey
# # 
# # 
# # set xlabel "{}"
# # set format x "{}"
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.10,0.73
# # set label "{132}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.132" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.30,0.73
# # set label "{232}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.232" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.50,0.73
# # set label "{332}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.332" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.70,0.73
# # set label "{432}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.432" w points pt 13 ps 0.2
# # set nokey
# # 
# # 
# # set xlabel "{}"
# # set format x "{}"
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.10,0.84
# # set label "{142}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.142" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.30,0.84
# # set label "{242}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.242" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.50,0.84
# # set label "{342}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.342" w points pt 13 ps 0.2
# # set nokey
# # 
# # unset label
# # set ylabel "{}"
# # set format y "{}"
# # set size 0.22,0.10
# # set origin 0.70,0.84
# # set label "{442}" at graph 0.05, 0.90
# # set nokey
# # plot "fort.442" w points pt 13 ps 0.2
# # set nokey
