from pathlib import Path

import matplotlib.gridspec as gridspec
import matplotlib.image as mpimg
import matplotlib.pyplot as plt
import numpy as np
from scipy import ndimage

calc_diamond_modes = lambda x: (2 * x + 1) * (0.637 / (4 * 2.41))
calc_air_modes = lambda x: (2 * x) * (0.637 / (4 * 2.41))

offset_vincent_vega_x = 30  # 46  # um, for plotting
offset_vincent_vega_y = 24  # 18  # um, for plotting
interferometer_vincent_vega = 1e6 * np.loadtxt(
    Path("../data/samples/vincent_vega_interferometer.txt")
)
interfer_vincent_vega_width = 138.145330795  # um
interfer_vincent_vega_height = 165.774396954  # um
x_values_inter_vincent_vega = (
    np.linspace(0, interfer_vincent_vega_height, len(interferometer_vincent_vega[0]))
    - offset_vincent_vega_x
)
y_values_inter_vincent_vega = (
    np.linspace(0, interfer_vincent_vega_width, len(interferometer_vincent_vega))
    - offset_vincent_vega_y
)

print("Vincent Vega:")
print(calc_air_modes(16))
print(calc_air_modes(19))

print("Pai-Mei:")
print(calc_air_modes(22))
print(calc_air_modes(32))

offset_pai_mei_x = 22  # um, for plotting
offset_pai_mei_y = 2  # um, for plotting
interferometer_pai_mei = 1e6 * np.loadtxt(
    Path("../data/samples/pai_mei_interferometer.txt")
)
interferometer_pai_mei = ndimage.rotate(interferometer_pai_mei, 180, reshape=False)
interfer_pai_mei_width = 138.145330795  # um
interfer_pai_mei_height = 165.774396954  # um
x_values_inter_pai_mei = (
    np.linspace(0, interfer_pai_mei_height, len(interferometer_pai_mei[0]))
    - offset_pai_mei_x
)
y_values_inter_pai_mei = (
    np.linspace(0, interfer_pai_mei_width, len(interferometer_pai_mei))
    - offset_pai_mei_y
)

fig = plt.figure(figsize=(8, 6))
panel = gridspec.GridSpec(
    2, 2, width_ratios=[1, 1], wspace=0.1, hspace=0.15, figure=fig
)

ax_1 = plt.subplot(panel[0, 0])
ax_2 = plt.subplot(panel[0, 1])
ax_3 = plt.subplot(panel[1, 0])
ax_4 = plt.subplot(panel[1, 1])

ax_1.text(0.02, 0.98, "(a)", transform=ax_1.transAxes, fontsize=12, va="top")
ax_1.imshow(mpimg.imread(Path(r"../data/samples/vincent_vega_light_microscope.png")))
ax_1.axis("off")

ax_2.text(-0.28, 0.98, "(b)", transform=ax_2.transAxes, fontsize=12, va="top")
img = ax_2.pcolormesh(
    x_values_inter_vincent_vega,
    y_values_inter_vincent_vega,
    interferometer_vincent_vega,
    vmin=2.0,
    vmax=2.8,
    cmap="inferno",
)
cbar = fig.colorbar(img)
cbar.set_label("Height (µm)")
ax_2.contour(
    x_values_inter_vincent_vega,
    y_values_inter_vincent_vega,
    interferometer_vincent_vega,
    levels=[calc_air_modes(i) for i in [14, 15, 16, 17, 18, 19]],
    colors="white",
)
ax_2.set_xlim(0, 100)
ax_2.set_ylim(0, 100)
ax_2.set_ylabel("Y Position (µm)")

ax_3.text(0.02, 0.98, "(c)", transform=ax_3.transAxes, fontsize=12, va="top")
ax_3.imshow(mpimg.imread(Path(r"../data/samples/pai_mei_light_microscope.png")))
ax_3.axis("off")

ax_4.text(-0.28, 0.98, "(d)", transform=ax_4.transAxes, fontsize=12, va="top")
img = ax_4.pcolormesh(
    x_values_inter_pai_mei,
    y_values_inter_pai_mei,
    interferometer_pai_mei,
    vmin=2.7,
    vmax=4.5,
    cmap="inferno",
)
cbar = fig.colorbar(img)
cbar.set_label("Height (µm)")
ax_4.contour(
    x_values_inter_pai_mei,
    y_values_inter_pai_mei,
    interferometer_pai_mei,
    levels=[
        calc_air_modes(i) for i in [21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32]
    ],
    colors="White",
)
ax_4.set_xticks([0, 20, 40, 60, 80, 100, 120])
ax_4.set_xlim(0, 135)
ax_4.set_ylim(0, 135)
ax_4.set_xlabel("X Position (µm)")
ax_4.set_ylabel("Y Position (µm)")

fig.savefig(Path("../Fig_2.png"), dpi=600, bbox_inches="tight")
