%%
% De Winter, J. C. F., Dodou, D., Moorlag, F., Broekens, J. (2024). Social robots in education: A meta-analysis of learning outcomes. Manuscript submitted for publication. 
% https://www.researchgate.net/publication/383908660_Social_Robots_A_Meta-Analysis_of_Learning_Outcomes. 
% https://doi.org/10.13140/RG.2.2.10148.49289

% 1 Faculty of Mechanical Engineering, Delft University of Technology, The Netherlands
% 2 Leiden Institute of Advanced Computer Science, Leiden University, The Netherlands
% Corresponding author: j.c.f.dewinter@tudelft.nl

function lding =pca(r,f)
[V,D] = svd(r); % singular value decomposition
D = D(1:f,1:f); % eigenvalues
V = V(:,1:f); % eigenvectors
lding = V * sqrt(D); % the loadings are the eigenvectors multiplied by the square root of the eigenvalues
