%%
% Function taken from meanEffectSize.m (https://nl.mathworks.com/help/stats/meaneffectsize.html)

function ci = getNCTConfidenceBounds(nctval, df, quants)
bounds = [nctval + abs(10*nctval), nctval - abs(10*nctval)];
boundOptimFcn = @(nct, q) nctcdf(nctval, df, nct) - q;
if (boundOptimFcn(bounds(1), quants(2)) < 0) && (boundOptimFcn(bounds(2), quants(2)) > 0)
    % The CDF is monotonic, so the one and only zero lives in these bounds
    [ci(1), ~, errL] = fzero(@(nct_l) boundOptimFcn(nct_l, quants(2)), bounds);
else
    % 0 is outside the bounds - use nctval as the start estimate instead of
    % the bounds
    [ci(1), ~, errL] = fzero(@(nct_l) boundOptimFcn(nct_l, quants(2)), nctval);
end

% Do the same as above but for the upper CI bound
if (boundOptimFcn(bounds(1), quants(1)) < 0) && (boundOptimFcn(bounds(2), quants(1)) > 0)
    [ci(2), ~, errU] = fzero(@(nct_u) boundOptimFcn(nct_u, quants(1)), bounds);
else
    [ci(2), ~, errU] = fzero(@(nct_u) boundOptimFcn(nct_u, quants(1)), nctval);
end
end