%%
% De Winter, J. C. F., Dodou, D., Moorlag, F., Broekens, J. (2024). Social robots in education: A meta-analysis of learning outcomes. Manuscript submitted for publication. 
% https://www.researchgate.net/publication/383908660_Social_Robots_A_Meta-Analysis_of_Learning_Outcomes
% https://doi.org/10.13140/RG.2.2.10148.49289

% 1 Faculty of Mechanical Engineering, Delft University of Technology, The Netherlands
% 2 Leiden Institute of Advanced Computer Science, Leiden University, The Netherlands
% Corresponding author: j.c.f.dewinter@tudelft.nl

function [d,n] = cohend(m1,s1,n1,m2,s2,n2,sr,b)

d = (m1-m2) / sqrt(((n1-1)*s1^2+(n2-1)*s2^2)/(n1+n2-2)); % Cohen's d

if sr==1
    d = -d; % reverse sign of Cohen's d
end 

if b == 1 % sample size for within-subjects design
    n = n1;
else % sample size for between-subjects design
    n = n1 + n2;
end

if isnan(d) % if Cohen's d could not be computed, then do not output n either
    n=NaN;
end

end
