%%
% De Winter, J. C. F., Dodou, D., Moorlag, F., Broekens, J. (2024). Social robots in education: A meta-analysis of learning outcomes. Manuscript submitted for publication. 
% https://www.researchgate.net/publication/383908660_Social_Robots_A_Meta-Analysis_of_Learning_Outcomes.
% https://doi.org/10.13140/RG.2.2.10148.49289

% 1 Faculty of Mechanical Engineering, Delft University of Technology, The Netherlands
% 2 Leiden Institute of Advanced Computer Science, Leiden University, The Netherlands
% Corresponding author: j.c.f.dewinter@tudelft.nl

% this function performs an independent samples t-test on vector v1 and vector v2.
% It outputs the result in a string with means, SD, t, df, and p values.

function p = ttest2_output(v1,v2,nrdigits)

[~,p,~,stats] = ttest2(v1,v2);

v1 = v1(~isnan(v1));
v2 = v2(~isnan(v2));

M1 = mean(v1);
M2 = mean(v2);
S1 = std(v1);
S2 = std(v2);

n1 = length(v1);
n2 = length(v2);

if p < 0.001
    pstring = ' < 0.001';
else
    pstring = [' = ' sprintf('%0.3f',p)];
end

disp(['Mean (SD) 1: ' sprintf(['%0.' num2str(nrdigits) 'f'],M1) ' (' sprintf(['%0.' num2str(nrdigits) 'f'],S1) '), n = ' num2str(n1) ...
    ', Mean (SD) 2: ' sprintf(['%0.' num2str(nrdigits) 'f'],M2) ' (' sprintf(['%0.' num2str(nrdigits) 'f'],S2) '), n = ' num2str(n2) ...
    ', t(' num2str(stats.df) ') = '  sprintf('%0.2f',stats.tstat) ', p' pstring])

