################################################################################################
#Functions for calculation of yearly and monthly food intake of fish in the HW Program
#of the NIOZ
################################################################################################
me<-theme_set(theme_bw(base_size = 12))

me<-theme_update(legend.spacing = unit(0, "cm"),
                 legend.position = "right",
                 plot.margin=unit(c(0,0.2,0,0.2), "cm"),# respectively: top, right, bottom, left; refers to margin *outside* labels
                 panel.spacing = unit(0.5, "lines"),
                 strip.background = element_rect(fill = "white"))
#make use of %ni% for not in possbile
'%ni%' <- Negate('%in%') 

#Function to calculate yearly food intake (get Polynom)
TFoodIntake<-function(Data){
  Data<-Data[!is.na(Data$TDFI),]
  ExYear1<-ddply(Data,"Year",summarize,count=length(Year))
  ExYear<-ExYear1$Year[ExYear1$count>4]
  Year1<-unique(ExYear1$Year)
  Year<-Year1[!Year1 %in% ExYear]
  Data<-subset(Data,Year %in% ExYear)
  FoodI<-data.frame(Year=Year,FI=NA,D60=NA,D300=NA,integral=NA,
                    Poly=0)
  MyDataT<-data.frame(Year=NA,datum=NA,Day_nr=NA,TDFI=NA,Species=NA,Age=NA)
  Species<-Data$Species[1]
  Age<-Data$Age[1]
  
  for (s in ExYear)
  {
    #set start values
    first<-0
    second<-0
    third<-0
    low<-60
    up<-300
    mc<-data.frame(coefficients=NULL)
    #select subset for one year
    ys<-subset(Data,Year==s)
    ##select best fitting polynom
    polyfit <- function(i) ys$Day_nr <- AIC(lm(TDFI~poly(Day_nr,i,raw=TRUE),data=ys))
    p<-ifelse(length(ys$Day_nr)-1>5,
              as.integer(optimize(polyfit,interval = c(1,4))$minimum),
              as.integer(optimize(polyfit,interval = c(2,length(ys$Day_nr)-1))$minimum))
    m<-lm(TDFI~poly(Day_nr,p,raw=TRUE),data=ys)
    #write coefficients in data frame
    mc<-data.frame(m[1])
    
    #if first value is after day 60 calculate estimation
    if (min(ys$Day_nr)>60){
      first<-ys$TDFI[ys$Day_nr==min(ys$Day_nr)]*(min(ys$Day_nr)-1)/2
      low<-min(ys$Day_nr)
    }
    ##if last value is before day 300 calculate estimation
    if (max(ys$Day_nr)<300){
      second<-ys$TDFI[ys$Day_nr==max(ys$Day_nr)]*(365-max(ys$Day_nr))/2
      up<-max(ys$Day_nr)
    }
    #get polynomial function
    pol<-polynomial(coef=mc$coefficients)
    #calculate integration for polynom with own function 
    third<-CalcI(polyF=pol,upper=up,lower=low)
    #sum up all food intake and divide it by 1000
    TFIY<-sum(first,second,third)/1000
    #get model predictions 
    new<-data.frame(Year=s,FI=TFIY,D60=first,D300=second,integral=third,
                    Poly=as.character(pol))
    FoodI<-rbind(FoodI,new)
    MyData<-data.frame(Year=s,datum=NA,Day_nr=seq.int(from=low,to=up,length=100),
                       TDFI=NA,Species=Species,Age=Age)
    MyData$TDFI<-predict(m,newdata=MyData)
    MyDataT<-rbind(MyDataT,MyData) 
  }
  MyDataT$datum<-strptime(paste(MyDataT$Year, MyDataT$Day_nr), format="%Y %j")
  rownames(FoodI) <- NULL
  MyDataT<-na.exclude(MyDataT)
  
  #make Dataframe for plotting points with lines
  Data2<-Data[,c("Year","datum","Day_nr","TDFI","Species","Age")]
  MyDataT$Type<-"P"
  Data2$Type<-"D"
  DataP<-rbind(Data2,MyDataT)
  DataP$sumWW<-NA
  DataAll<-merge(DataP,FoodI[,c("Year","FI")],by="Year",all=TRUE)
  DataAll$Species[DataAll$Type %in% NA]<-Species
  DataAll$Age[DataAll$Type %in% NA]<-Age
  return(DataAll)
}

###Help function for calculating yearly Food Intake (Integration of Polynom)
CalcI<-function(polyF,upper,lower){
  zeroT<-data.frame(zeros=solve(polyF))
  if (length(zeroT$zeros[Im(zeroT$zeros)==0])>0){
    zeroI<-data.frame(zeros=zeroT$zeros[Im(zeroT$zeros)==0])
    zeroI$zeros<-Re(zeroI$zeros)
    if (any(zeroI<=upper)){zeroI<-data.frame(zeros=zeroI[zeroI$zeros<=upper,])
                           if (any(lower<=zeroI)){
                             zero<-zeroI[lower<=zeroI$zeros,]
                             l<-length(zero)
                             if (predict(polyF,lower)<0){
                               lower<-zero[1]
                               if (l>2)
                               {
                                 Integ1<-integral(expr=polyF,limits=c(lower,zero[2]))
                                 Integ2<-integral(expr=polyF,limits=c(zero[3],upper))
                                 IntegT<-sum(Integ1,Integ2) 
                               }
                               if (l==2)
                               {
                                 upper<-zero[2]
                                 IntegT<-integral(expr=polyF,limits=c(lower,upper)) 
                               }
                               if (l==1){
                                 IntegT<-integral(expr=polyF,limits=c(lower,upper))
                               }
                             
                             }else
                             {
                               Integ1<-integral(expr=polyF,limits=c(lower,zero[1]))
                               if (l>=2)
                               {
                                 Integ2<-integral(expr=polyF,limits=c(zero[2],upper))
                                 IntegT<-sum(Integ1,Integ2)
                               }else
                                 IntegT<-Integ1
                             }
                           }else IntegT<-integral(expr=polyF,limits=c(lower,upper))
    }else IntegT<-integral(expr=polyF,limits=c(lower,upper))
  }else IntegT<-integral(expr=polyF,limits=c(lower,upper))
  return(IntegT)
}

#Function for calculation monthly food intake
MonthlyFI<-function(Data){
  Data<-Data[!is.na(Data$TDFI),]
  Data$Month<-month(Data$datum)
  ExYear1<-ddply(Data,"Year",summarize,count=length(Year))
  Year<-ifelse(length(ExYear1$Year[ExYear1$count<5])>0,ExYear1$Year[ExYear1$count<5],NA)
  ExYear<-ExYear1$Year[ExYear1$count>4]
  Data<-subset(Data,Year %in% ExYear)
  MyDataT<-data.frame(Year=NA,datum=NA,Day_nr=NA,TDFI=NA,Species=NA,Age=NA)
  Species<-Data$Species[1]
  Age<-Data$Age[1]
  Month<-c(03:10)
  Days<-data.frame(Year=rep(ExYear,each=8),Month=rep(Month,times=length(ExYear)),Day=01)
  Days$Datum<-dmy(str_c(Days$Day,Days$Month,Days$Year,sep="/"))
  Days$Start<-yday(floor_date(dmy(str_c(Days$Day,Days$Month,Days$Year,sep="/")),"month"))
  Days$End<-yday(ceiling_date(dmy(str_c(Days$Day+20,Days$Month,Days$Year,sep="/")),"month")-1)
  Data2<-merge(Data,Days[,c(1,2,5:6)],by=c("Year","Month"))
  FI<-data.frame(Species=NA,Age=NA,Year=NA,Month=NA,Day_nr=NA,MFI=NA)
  
  for (s in ExYear)
  {
    #set start values
    mc<-data.frame(coefficients=NULL)
    mon<-c(3:10)
    #select subset for one year
    ys<-subset(Data2,Year==s)
    mon<-unique(unlist(ys$Month , use.names = FALSE))
    ##select best fitting polynom
    polyfit <- function(i) ys$Day_nr <- AIC(lm(TDFI~poly(Day_nr,i,raw=TRUE),data=ys))
    p<-ifelse(length(ys$Day_nr)-1>5,
              as.integer(optimize(polyfit,interval = c(1,4))$minimum),
              as.integer(optimize(polyfit,interval = c(2,length(ys$Day_nr)-1))$minimum))
    m<-lm(TDFI~poly(Day_nr,p,raw=TRUE),data=ys)
    #write coefficients in data frame
    mc<-data.frame(m[1])
    
    #get polynomial function
    pol<-polynomial(coef=mc$coefficients)
    #calculate integration for polynom with own function 
    for (u in mon){
      third<-ifelse(min(ys$Day_nr)>min(ys$Start[ys$Month==u]),sum(ys$TDFI[ys$Day_nr==min(ys$Day_nr)]*(min(ys$Day_nr)-1)/2,
                    CalcI(polyF=pol,upper=unique(unlist(ys$End[ys$Month==u])),lower=yday(min(ys$datum[ys$Month==u])))),
                    CalcI(polyF=pol,upper=unique(unlist(ys$End[ys$Month==u])),
                          lower=unique(unlist(ys$Start[ys$Month==u]))))
      FI <- rbind(FI,c(Species=Species,Age=Age,Year=s,Month=u,
                       Day_nr=as.integer(mean(ys$Day_nr[ys$Month==u])),
                       MFI=third))
    }
  }
  FI$datum<-strptime(paste(FI$Year, FI$Day_nr), format="%Y %j")
  FI<-na.exclude(FI)
  
  #make Dataframe for plotting points with lines
  return(FI)
}

GrowthYear<-function(Data){
  Spec<-unique(Data$Species)
  Data2<-Data[0,]
  for (i in Spec){
    NewD<-subset(Data,Species==i)
    Age<-unique(NewD$Age)
    for (a in Age){
      AgeD<-NewD[NewD$Age==a,]
      L<-nrow(AgeD)
      AgeD$dL<-0
      AgeD$dW<-0
      AgeD$dt<-0
      AgeD$gL<-0
      AgeD$gW<-0
      if (L >1) {
        for (j in 2:L){
          AgeD$dL[j]<-AgeD$AvgLCrus[j]-AgeD$AvgLCrus[j-1]
          AgeD$dW[j]<-log(AgeD$AFDM[j])-log(AgeD$AFDM[j-1])
          AgeD$dt[j]<-AgeD$Day[j]-AgeD$Day[j-1]
        }}
      AgeD$gL<-ifelse(AgeD$dt==0,NA,AgeD$dL/AgeD$dt)
      AgeD$gW<-ifelse(AgeD$dt==0,NA,AgeD$dW/AgeD$dt)
      AgeD2<-subset(AgeD,gW>0)
      L2<-nrow(AgeD2)
      if (L2 >1) {
        AgeD2$lnGW<-log(AgeD2$gW)
        Mod<-lm(lnGW~AvgLCrus*Day,data=AgeD2)
        AgeD$G.aN<-exp(Mod$coefficients[1])
        AgeD$G.bN<-Mod$coefficients[2]
      }
      else{
        AgeD$G.aN<-NA
        AgeD$G.bN<-NA
      }
      Data2<-rbind(Data2,AgeD)
      
    }}
  return(Data2)
}

GEst<-function(Data){
  Spec<-unique(Data$Species)
  Data$gW2<-Data$gW
  Data2<-Data[0,]
  for (s in Spec){
    Year<-unique(Data$Year)
    for (j in Year){
      Age<-unique(Data$Age)
      for (a in Age){
        NewD<-Data[c(Data$Year==j & Data$Species==s & Data$Age==a),]
        NewD$gW2<-NewD$gW
        NewD$gW<-ifelse(NewD$gW<0,NA,NewD$gW)
        NewD$gW<-ifelse(NewD$Species==154&NewD$gW<0.045&NewD$AvgLCrus<25,NA,NewD$gW)
        if (s>199){
          if (nrow(NewD)>0){
            NewD$diff<-NA
            if (nrow(NewD)>1){
              for (i in 2:nrow(NewD)){
                
                NewD$diff[i]<-NewD$Cruiseid[i]- NewD$Cruiseid[i-1]
              }
              for (i in 1){
                NewD$diff[i]<-0
              }}
            NewD$Max<-ifelse(NewD$Cruiseid[NewD$TNumCrus1000m==max(NewD$TNumCrus1000m)]==
                               max(NewD$Cruiseid),
                             NewD$Cruiseid[NewD$TNumCrus1000m==min(NewD$TNumCrus1000m)],
                             NewD$Cruiseid[NewD$TNumCrus1000m==max(NewD$TNumCrus1000m)])
            NewD$Day2<-NewD$Day+(a*365)
            NewD$GW<-ifelse(NewD$Cruiseid<=NewD$Max,
                            NewD$gW[NewD$Cruiseid==(NewD$Max+NewD$diff)],
                            NewD$gW)
            NewD$lnGW<-log(NewD$GW)
            NewD$lnGW<-ifelse(NewD$lnGW %in% -Inf,NA,NewD$lnGW)
            NewD$PredGW<-NewD$G.a*exp(NewD$G.b*NewD$AvgLCrus)
            NewD$Type<-"D"
            NewD2<-NewD[,c("Cruiseid","Species","Age","Year","AvgLCrus","Day2","gW2","GW","lnGW",
                           "PredGW","G.a","G.b","Type")]
            NewD2$r2<-NA
            NewD2$pa<-NA
            NewD2$pb<-NA
            Data2<-rbind(Data2,NewD2)
          }
        }else {
          
          if (nrow(NewD)>5 & a==0){
            NewD$diff<-NA
            for (i in 2:nrow(NewD)){
              
              NewD$diff[i]<-NewD$Cruiseid[i]- NewD$Cruiseid[i-1]
            }
            for (i in 1){
              NewD$diff[i]<-0
            }
            NewD$Max<-ifelse(NewD$Cruiseid[NewD$TNumCrus1000m==max(NewD$TNumCrus1000m)]==max(NewD$Cruiseid),
                              (NewD$Cruiseid[NewD$TNumCrus1000m==max(NewD$TNumCrus1000m)]-NewD$diff[NewD$TNumCrus1000m==max(NewD$TNumCrus1000m)]),
                              NewD$Cruiseid[NewD$TNumCrus1000m==max(NewD$TNumCrus1000m)])
            NewD$Day2<-NewD$Day+(a*365)
            NewD$GW<-ifelse(NewD$Cruiseid<=NewD$Max,
                            NA,
                            NewD$gW)
            NewD$lnGW<-log(NewD$GW)
            NewD$lnGW<-ifelse(NewD$lnGW %in% -Inf,NA,NewD$lnGW)
            if (length(which(NewD$lnGW%in%NA))>=nrow(NewD)-3){
              NewD$PredGW<-NA
              NewD$Type<-"D"
              NewD$G.b<-NA
              NewD$G.a<-NA
              NewD2<-NewD[,c("Cruiseid","Species","Age","Year","AvgLCrus","Day2","gW2","GW","lnGW",
                             "PredGW","G.a","G.b","Type")]
              NewD2$r2<-NA
              NewD2$pa<-NA
              NewD2$pb<-NA
              Data2<-rbind(Data2,NewD2)
            }else{
            Mod1<-lm(lnGW~AvgLCrus,data=NewD)
            NewD$G.b<-Mod1$coefficients[2]
            NewD$G.a<-exp(Mod1$coefficients[1])
            G.bN<-Mod1$coefficients[2]
            NewD$PredGW<-ifelse(NewD$lnGW %in% NA|NewD$G.bN>0,NA,exp(predict(Mod1,newdata=NewD)))
            NewD$PredGW<-ifelse(NewD$lnGW>=c(1000)|NewD$Age>0,NA,NewD$PredGW)
            NewD$Type<-"D"
            NewD2<-NewD[,c("Cruiseid","Species","Age","Year","AvgLCrus","Day2","gW2","GW","lnGW",
                           "PredGW","G.a","G.b","Type")]
            NewD2$r2<-NA
            NewD2$pa<-NA
            NewD2$pb<-NA
            if (G.bN<=0 & G.bN%ni%NA){
              MyData<-expand.grid(Cruiseid=NA,Species=s,Age=a,Year=j,
                                  AvgLCrus=c(1:max(NewD$AvgLCrus)),
                                  Day2=10,gW2=NA,GW=NA,lnGW=NA,PredGW=NA,G.a=NA,G.b=NA)
              MyData$lnGW<-predict(Mod1,newdata=MyData)
              MyData$PredGW<-ifelse(MyData$lnGW>=c(1000),NA,exp(MyData$lnGW))
              MyData$GW<-ifelse(MyData$lnGW>=c(1000),NA,exp(MyData$lnGW))
              MyData$Type<-"P"
              MyData$r2<-NA
              MyData$pa<-NA
              MyData$pb<-NA
              NewD3<-rbind(NewD2,MyData)
              Data2<-rbind(Data2,NewD3)
            }
            else {
              Data2<-rbind(Data2,NewD2)
            }
            }
          }else {
            if (nrow(NewD)>0){
              NewD$AvgLCrus<-ifelse(NewD$AvgLCrus %in% NaN,0,NewD$AvgLCrus)
              NewD$Day2<-NewD$Day+(a*365)
              NewD$GW<-NewD$gW
              NewD$lnGW<-ifelse(NewD$GW>0,log(NewD$GW),NA)
              NewD$PredGW<-NA
              NewD$Type<-"D"
              NewD$G.b<-NA
              NewD$G.a<-NA
              NewD2<-NewD[,c("Cruiseid","Species","Age","Year","AvgLCrus","Day2","gW2","GW","lnGW",
                             "PredGW","G.a","G.b","Type")]
              NewD2$r2<-NA
              NewD2$pa<-NA
              NewD2$pb<-NA
              Data2<-rbind(Data2,NewD2)
            }
          }
        }
      }
      
    }
    SpeD<-subset(Data2,Type=="D"&Species %in% s)

    Mod2<-lm(lnGW~AvgLCrus,data=subset(SpeD,Age%in%"0"))
#     if (s==154){
#       Mod2<-lm(lnGW~AvgLCrus,data=subset(SpeD,Age%in%"0")) 
#     }
#     if (s==155){
#       Mod2<-lm(lnGW~AvgLCrus,data=subset(SpeD,Age%in%"0")) 
#     }
#     if (s==158){
#       Mod2<-lm(lnGW~AvgLCrus,data=subset(SpeD,Age%in%"0")) 
#     }
    SpeD$PredGW<-ifelse(SpeD$PredGW %in% NA ,
                        exp(predict(Mod2,newdata=SpeD)),
                        SpeD$PredGW)
    Data2$PredGW<-ifelse(Data2$PredGW %in% NA & Data2$Type=="D" &Data2$Species %in% s | Data2$Type=="D" &Data2$Species %in% s &Data2$Age%in%c("1","2"),
                         exp(predict(Mod2,newdata=Data2)),
                         Data2$PredGW)
    SpeD$G.b<-Mod2$coefficients[2]
    SpeD$G.a<-exp(Mod2$coefficients[1])
    SpeD$Age<-"All"
    SpeD$Year<-"Full"
    SpeD$r2<-summary(Mod2)$r.squared
    SpeD$pa<-summary(Mod2)$coef[1,"Pr(>|t|)"]
    SpeD$pb<-summary(Mod2)$coef[2,"Pr(>|t|)"]
    MyData2<-expand.grid(Cruiseid=NA,Species=s,Age="All",Year="Full",
                         AvgLCrus=c(1:max(SpeD$AvgLCrus)),
                         Day2=10,gW2=NA,
                         GW=NA,lnGW=NA,PredGW=NA,G.a=exp(Mod2$coefficients[1]),G.b=Mod2$coefficients[2])
    MyData2$lnGW<-predict(Mod2,newdata=MyData2)
    MyData2$PredGW<-exp(MyData2$lnGW)
    MyData2$GW<-exp(MyData2$lnGW)
    MyData2<-MyData2[order(MyData2$Day2,MyData2$AvgLCrus),]
    MyData2$Type<-"P"
    MyData2$r2<-NA
    MyData2$pa<-NA
    MyData2$pb<-NA
    Data2<-rbind(Data2,MyData2,SpeD)
  }
  return(Data2)
}

GEst2<-function(Data){
  Spec<-unique(Data$Species)
  Data$gW2<-Data$gW
  Data2<-Data[0,]
  for (s in Spec){
    Year<-unique(Data$Year)
    for (j in Year){
      Age<-unique(Data$Age)
      for (a in Age){
        NewD<-Data[c(Data$Year==j & Data$Species==s & Data$Age==a),]
        NewD$gW2<-NewD$gW
        NewD$gW<-ifelse(NewD$gW<0,NA,NewD$gW)
        NewD$gW<-ifelse(NewD$gW<0.045&NewD$AvgLCrus<25,NA,NewD$gW)
        if (s>199){
          if (nrow(NewD)>0){
            NewD$diff<-NA
            if (nrow(NewD)>1){
              for (i in 2:nrow(NewD)){
                
                NewD$diff[i]<-NewD$Cruiseid[i]- NewD$Cruiseid[i-1]
              }
              for (i in 1){
                NewD$diff[i]<-0
              }}
            Max<-max(NewD$gW,na.rm = TRUE)
            Min<-min(NewD$gW,na.rm = TRUE)
            NewD$Max<-ifelse(NewD$Cruiseid[NewD$gW%in%Max]==
                               max(NewD$Cruiseid),
                             NewD$Cruiseid[NewD$gW==Min],
                             NewD$Cruiseid[NewD$gW%in%Max])
            NewD$Day2<-NewD$Day+(a*365)
            NewD$GW<-ifelse(NewD$Cruiseid<=NewD$Max,
                            NA,
                            NewD$gW)
            NewD$lnGW<-log(NewD$GW)
            NewD$lnGW<-ifelse(NewD$lnGW %in% -Inf,NA,NewD$lnGW)
            NewD$PredGW<-NewD$G.a*exp(NewD$G.b*NewD$AvgLCrus)
            NewD$Type<-"D"
            NewD2<-NewD[,c("Cruiseid","Species","Age","Year","AvgLCrus","Day2","gW2","GW","lnGW",
                           "PredGW","G.a","G.b","Type")]
            NewD2$r2<-NA
            NewD2$pa<-NA
            NewD2$pb<-NA
            Data2<-rbind(Data2,NewD2)
          }
        }else {
          
          if (nrow(NewD)>5 & a==0){
            NewD$diff<-NA
            for (i in 2:nrow(NewD)){
              
              NewD$diff[i]<-NewD$Cruiseid[i]- NewD$Cruiseid[i-1]
            }
            for (i in 1){
              NewD$diff[i]<-0
            }
            Max<-max(NewD$gW,na.rm = TRUE)
            NewD$Max<-ifelse(NewD$Cruiseid[NewD$gW%in%Max]==max(NewD$Cruiseid),
                             (NewD$Cruiseid[NewD$gW%in%Max]-NewD$diff[NewD$gW%in%Max]),
                             NewD$Cruiseid[NewD$gW%in%Max])
            NewD$Day2<-NewD$Day+(a*365)
            NewD$GW<-ifelse(NewD$Cruiseid<=NewD$Max,
                            NA,
                            NewD$gW)
            NewD$lnGW<-log(NewD$GW)
            NewD$lnGW<-ifelse(NewD$lnGW %in% -Inf,NA,NewD$lnGW)
            if (length(which(NewD$lnGW%in%NA))>=nrow(NewD)-3){
              NewD$PredGW<-NA
              NewD$Type<-"D"
              NewD$G.b<-NA
              NewD$G.a<-NA
              NewD2<-NewD[,c("Cruiseid","Species","Age","Year","AvgLCrus","Day2","gW2","GW","lnGW",
                             "PredGW","G.a","G.b","Type")]
              NewD2$r2<-NA
              NewD2$pa<-NA
              NewD2$pb<-NA
              Data2<-rbind(Data2,NewD2)
            }else{
              Mod1<-lm(lnGW~AvgLCrus,data=NewD,na.action=na.omit)
              NewD$G.b<-Mod1$coefficients[2]
              NewD$G.a<-exp(Mod1$coefficients[1])
              G.bN<-Mod1$coefficients[2]
              NewD$PredGW<-ifelse(NewD$lnGW %in% NA|NewD$G.bN>0,NA,exp(predict(Mod1,newdata=NewD)))
              NewD$PredGW<-ifelse(NewD$lnGW>=c(1000)|NewD$Age>0,NA,NewD$PredGW)
              NewD$Type<-"D"
              NewD2<-NewD[,c("Cruiseid","Species","Age","Year","AvgLCrus","Day2","gW2","GW","lnGW",
                             "PredGW","G.a","G.b","Type")]
              NewD2$r2<-NA
              NewD2$pa<-NA
              NewD2$pb<-NA
              if (G.bN<=0 & G.bN%ni%NA){
                MyData<-expand.grid(Cruiseid=NA,Species=s,Age=a,Year=j,
                                    AvgLCrus=c(1:max(NewD$AvgLCrus)),
                                    Day2=10,gW2=NA,GW=NA,lnGW=NA,PredGW=NA,G.a=NA,G.b=NA)
                MyData$lnGW<-predict(Mod1,newdata=MyData)
                MyData$PredGW<-ifelse(MyData$lnGW>=c(1000),NA,exp(MyData$lnGW))
                MyData$GW<-ifelse(MyData$lnGW>=c(1000),NA,exp(MyData$lnGW))
                MyData$Type<-"P"
                MyData$r2<-NA
                MyData$pa<-NA
                MyData$pb<-NA
                NewD3<-rbind(NewD2,MyData)
                Data2<-rbind(Data2,NewD3)
              }
              else {
                Data2<-rbind(Data2,NewD2)
              }
            }
          }else {
            if (nrow(NewD)>0){
              NewD$AvgLCrus<-ifelse(NewD$AvgLCrus %in% NaN,0,NewD$AvgLCrus)
              NewD$Day2<-NewD$Day+(a*365)
              NewD$GW<-NewD$gW
              NewD$lnGW<-ifelse(NewD$GW>0,log(NewD$GW),NA)
              NewD$PredGW<-NA
              NewD$Type<-"D"
              NewD$G.b<-NA
              NewD$G.a<-NA
              NewD2<-NewD[,c("Cruiseid","Species","Age","Year","AvgLCrus","Day2","gW2","GW","lnGW",
                             "PredGW","G.a","G.b","Type")]
              NewD2$r2<-NA
              NewD2$pa<-NA
              NewD2$pb<-NA
              Data2<-rbind(Data2,NewD2)
            }
          }
        }
      }
      
    }
    SpeD<-subset(Data2,Type=="D"&Species %in% s)
    
    Mod2<-lm(lnGW~AvgLCrus,data=SpeD,na.action=na.omit)
    if (s==154){
      Mod2<-lm(lnGW~AvgLCrus,data=subset(SpeD,Age%in%"0"),na.action=na.omit) 
    }
    if (s==155){
      Mod2<-lm(lnGW~AvgLCrus,data=subset(SpeD,Age%in%"0"),na.action=na.omit) 
    }
    if (s==158){
      Mod2<-lm(lnGW~AvgLCrus,data=subset(SpeD,Age%in%"0"),na.action=na.omit) 
    }
    SpeD$PredGW<-ifelse(SpeD$PredGW %in% NA ,
                        exp(predict(Mod2,newdata=SpeD)),
                        SpeD$PredGW)
    Data2$PredGW<-ifelse(Data2$PredGW %in% NA & Data2$Type=="D" &Data2$Species %in% s | Data2$Type=="D" &Data2$Species %in% s &Data2$Age%in%c("1","2"),
                         exp(predict(Mod2,newdata=Data2)),
                         Data2$PredGW)
    SpeD$G.b<-Mod2$coefficients[2]
    SpeD$G.a<-exp(Mod2$coefficients[1])
    SpeD$Age<-"All"
    SpeD$Year<-"Full"
    SpeD$r2<-summary(Mod2)$r.squared
    SpeD$pa<-summary(Mod2)$coef[1,"Pr(>|t|)"]
    SpeD$pb<-summary(Mod2)$coef[2,"Pr(>|t|)"]
    MyData2<-expand.grid(Cruiseid=NA,Species=s,Age="All",Year="Full",
                         AvgLCrus=c(1:max(SpeD$AvgLCrus)),
                         Day2=10,gW2=NA,
                         GW=NA,lnGW=NA,PredGW=NA,G.a=exp(Mod2$coefficients[1]),G.b=Mod2$coefficients[2])
    MyData2$lnGW<-predict(Mod2,newdata=MyData2)
    MyData2$PredGW<-exp(MyData2$lnGW)
    MyData2$GW<-exp(MyData2$lnGW)
    MyData2<-MyData2[order(MyData2$Day2,MyData2$AvgLCrus),]
    MyData2$Type<-"P"
    MyData2$r2<-NA
    MyData2$pa<-NA
    MyData2$pb<-NA
    Data2<-rbind(Data2,MyData2,SpeD)
  }
  return(Data2)
}

