function PaulKonva_heckbert_nicenum(x, round) {
  var e = math.floor(math.log10(x));
  var f = x / math.pow(10, e);
  var nf;
  if (round) {
    if (f < 1.5) {
      nf = 1;
    } else if (f < 3) {
      nf = 2;
    } else if (f < 7) {
      nf = 5;
    } else {
      nf = 10;
    }
  } else {
    if (f <= 1) {
      nf = 1;
    } else if (f <= 2) {
      nf = 2;
    } else if (f <= 5) {
      nf = 5;
    } else {
      nf = 10;
    }
  }
  return (nf * math.pow(10, e));
};

function PaulKonva_heckbert(dmin, dmax, m) {
  range = PaulKonva_heckbert_nicenum((dmax - dmin), false);
  lstep = PaulKonva_heckbert_nicenum(range / (m - 1), true);
  lmin = math.floor(dmin / lstep) * lstep;
  lmax = math.ceil(dmax / lstep) * lstep;
  return (math.range(lmin, lmax, lstep)._data);
};
Konva.Chart = function(config) {
  this.___init(config);
};
Konva.Chart.prototype = {
  ___init: function(config) {
    Konva.Shape.call(this, config);
    this.className = 'Chart';
    this.sceneFunc(this._sceneFunc);
    this.recalcgrid();
    this.setAttr("Xvalues", []);
    this.setAttr("Yvalues", []);
    this.setAttr("GraphStroke", []);
    this.setAttr("GraphWidth", []);

  },
  recalcgrid: function() {
    // determine innerwindow
    var xo = this.getX();
    var yo = this.getY();
    var width = this.getAttr("width");
    var height = this.getAttr("height");
    var ox = (this.getAttr("offsetx") || 25);
    var oy = (this.getAttr("offsety") || 25);
    this.setAttr("sxmin", xo + ox);
    this.setAttr("sxmax", xo + width - ox);
    this.setAttr("sxmid", xo + width / 2);
    this.setAttr("symin", yo + height - oy);
    this.setAttr("symax", yo + oy);
    this.setAttr("symid", yo + height / 2);
    // determine ranges x and y
    var xv = this.getAttr("xvalues");
    var yv = this.getAttr("yvalues");
    var Xv = this.getAttr("Xvalues");
    var Yv = this.getAttr("Yvalues");
    var xm;
    if (this.getAttr("xmin") != undefined) {
      xm = this.getAttr("xmin")
    } else {
      xm = math.min(xv);
      if (Xv != undefined) {
        for (var iX = 0; iX < Xv.length; iX++) {
          if (Xv[iX] != undefined) {
            xm = math.min(xm, math.min(Xv[iX]));
          }
        }
      }
    }
    this.setAttr("rxmin", xm);
    var xM;
    if (this.getAttr("xmax") != undefined) {
      xM = this.getAttr("xmax")
    } else {
      xM = math.max(xv);
      if (Xv != undefined) {
        for (var iX = 0; iX < Xv.length; iX++) {
          if (Xv[iX] != undefined) {
            xM = math.max(xM, math.max(Xv[iX]));
          }
        }
      }
    }
    this.setAttr("rxmax", xM);
    var ym;
    if (this.getAttr("ymin") != undefined) {
      ym = this.getAttr("ymin")
    } else {
      ym = math.min(yv);
      if (Yv != undefined) {
        for (var iY = 0; iY < Yv.length; iY++) {
          if (Yv[iY] != undefined) {
            ym = math.min(ym, math.min(Yv[iY]));
          }
        }
      }
    }
    this.setAttr("rymin", ym);

    var yM;
    if (this.getAttr("ymax") != undefined) {
      yM = this.getAttr("ymax")
    } else {
      yM = math.max(yv);
      if (Yv != undefined) {
        for (var iY = 0; iY < Yv.length; iY++) {
          if (Yv[iY] != undefined) {
            yM = math.max(yM, math.max(Yv[iY]));
          }
        }
      }
    }
    this.setAttr("rymax", yM);
    var xt = PaulKonva_heckbert(xm, xM, (this.getAttr("nxticks") || 10));
    this.setAttr("xticks", xt);
    var yt = PaulKonva_heckbert(ym, yM, (this.getAttr("nyticks") || 10));
    this.setAttr("yticks", yt);
    if (xt.length > 0) {
      xm = math.min(xm, math.min(xt));
      xM = math.max(xM, math.max(xt));
    }
    if (yt.length > 0) {
      ym = math.min(ym, math.min(yt));
      yM = math.max(yM, math.max(yt));
    }
    var dsxdvx = (width - 2 * ox) / (xM - xm);
    var rxtosx = function(x) {
      return (xo + ox + (x - xm) * dsxdvx);
    };
    this.setAttr("rxtosx", rxtosx);
    var sxtorx = function(sx) {
      return (xm + (sx - ox - xo) / dsxdvx);
    }
    this.setAttr("sxtorx", sxtorx);
    var dsydvy = (height - 2 * oy) / (yM - ym);
    var rytosy = function(y) {
      return ((height - oy + yo) - (y - ym) * dsydvy);
    };
    this.setAttr("rytosy", rytosy);
    var sytory = function(sy) {
      return (ym + (height - oy + yo - sy) / dsydvy);
    };
    this.setAttr("sytory", sytory);
  },
  _sceneFunc: function(ctx) {
    // outer border
    ctx.beginPath();
    ctx.moveTo(this.getX(), this.getY());
    ctx.lineTo(this.getX() + this.getAttr("width"), this.getY());
    ctx.lineTo(this.getX() + this.getAttr("width"), this.getY() + this.getAttr("height"));
    ctx.lineTo(this.getX(), this.getY() + this.getAttr("height"));
    ctx.lineTo(this.getX(), this.getY());
    ctx.closePath();
    ctx.lineWidth = (this.getAttr("outerWidth") || 3);
    ctx.strokeStyle = (this.getAttr("outerStroke") || "black");
    ctx.stroke();
    if (this.getAttr("outerfill") != "none") {
      ctx.fillStyle = this.getAttr("outerfill") || "white";
      ctx.fill();
    }
    // inner border
    ctx.beginPath();
    ctx.moveTo(this.getAttr("sxmin"), this.getAttr("symin"));
    ctx.lineTo(this.getAttr("sxmax"), this.getAttr("symin"));
    ctx.lineTo(this.getAttr("sxmax"), this.getAttr("symax"));
    ctx.lineTo(this.getAttr("sxmin"), this.getAttr("symax"));
    ctx.lineTo(this.getAttr("sxmin"), this.getAttr("symin"));
    ctx.closePath();
    ctx.lineWidth = (this.getAttr("innerWidth") || 1);
    ctx.strokeStyle = (this.getAttr("innerStroke") || "grey");
    ctx.stroke();
    if (this.getAttr("innerfill") != "none") {
      ctx.fillStyle = this.getAttr("innerfill") || "white";
      ctx.fill();
    }
    var rxtosx = this.getAttr("rxtosx");
    var sym = this.getAttr("symin");
    var syM = this.getAttr("symax");
    ctx.fillStyle = "black";
    var xt = this.getAttr("xticks");
    for (var i = 0; i < xt.length; ++i) {
      var sx = rxtosx(xt[i]);
      ctx.beginPath();
      ctx.moveTo(sx, sym);
      ctx.lineTo(sx, syM);
      ctx.closePath();
      ctx.strokeStyle = (this.getAttr("innerStroke") || "grey");
      ctx.setLineDash([2, 8]);
      ctx.lineWidth = (this.getAttr("innerWidth") || 1)
      ctx.stroke();
      ctx.font = this.getAttr("fontsize") + "px Verdana";
      ctx.textAlign = "center";
      ctx.fillText(math.format(xt[i], 3), sx, sym + (this.getAttr("fontsize") || 12));
    }
    var rytosy = this.getAttr("rytosy");
    var yt = this.getAttr("yticks");
    var sxm = this.getAttr("sxmin");
    var sxM = this.getAttr("sxmax");
    for (var i = 0; i < yt.length; ++i) {
      var sy = rytosy(yt[i]);
      ctx.beginPath();
      ctx.moveTo(sxm, sy);
      ctx.lineTo(sxM, sy);
      ctx.closePath();
      ctx.strokeStyle = (this.getAttr("innerStroke") || "grey");
      ctx.setLineDash([2, 8]);
      ctx.lineWidth = (this.getAttr("innerWidth") || 1)
      ctx.stroke();
      ctx.font = this.getAttr("fontsize") + "px Courier";
      ctx.textAlign = "center";
      ctx.fillText(math.format(yt[i], 3), sxm - (this.getAttr("fontsize") || 12), sy);
    }
    var xv = this.getAttr("xvalues");
    var yv = this.getAttr("yvalues");
    if (xv.length > 0) {
      ctx.setLineDash([1, 0]);
      // ctx.rect(sxm, syM, sxM, sym);
      // ctx.clip();
      ctx.beginPath();
      ctx.moveTo(rxtosx(xv[0]), rytosy(yv[0]));
      for (var i = 1; i < math.min(xv.length, yv.length); i++) {
        ctx.lineTo(rxtosx(xv[i]), rytosy(yv[i]));
      }
      ctx.lineWidth = (this.getAttr("graphWidth") || 3);
      ctx.strokeStyle = (this.getAttr("graphStroke") || "red");
      ctx.stroke();
    }
    var Xv = this.getAttr("Xvalues");
    var Yv = this.getAttr("Yvalues");
    if ((Xv != undefined) & (Yv != undefined)) {
      for (var iXY = 0; iXY < math.min(Xv.length, Yv.length); iXY++) {
        if ((Xv[iXY] != undefined) & (Yv[iXY] != undefined)) {
          for (var i = 0; i < math.min(Xv[iXY].length, Yv[iXY].length); i++) {
            ctx.beginPath();
            ctx.moveTo(rxtosx(Xv[iXY][0]), rytosy(Yv[iXY][0]));
            for (var i = 1; i < math.min(Xv[iXY].length, Yv[iXY].length); i++) {
              ctx.lineTo(rxtosx(Xv[iXY][i]), rytosy(Yv[iXY][i]));
            }
            ctx.lineWidth = (this.getAttr("GraphWidth")[iXY] || 3);
            ctx.strokeStyle = (this.getAttr("GraphStroke")[iXY] || "red");
            ctx.stroke();
          }
        }
      }
      ctx.setLineDash([1, 0]);
      // ctx.rect(sxm, syM, sxM, sym);
      // ctx.clip();

    }
    if (this.getAttr("drawcrosshair")) {
      var chsx = this.getAttr("crosshairsx");
      var chsy = this.getAttr("crosshairsy")
      var chx = this.getAttr("sxtorx")(chsx);
      var chy = this.getAttr("sytory")(chsy);
      ctx.beginPath();
      ctx.moveTo(sxm, chsy);
      ctx.lineTo(chsx, chsy);
      ctx.lineTo(chsx, sym);
      ctx.strokeStyle = (this.getAttr("crosshairStroke") || "grey");
      ctx.lineWidth = (this.getAttr("crosshairWidth") || 1)
      ctx.stroke();
      //ctx.font = (5*this.getAttr("fontsize")) + "px Courier";
      ctx.font = (this.getAttr("crosshairFont") || "20px Verdana")
      if (chsx > this.getAttr("sxmid")) {
        ctx.textAlign = "right";
        chsx -= 4;
      } else {
        ctx.textAlign = "left";
        chsx += 4;
      }
      ctx.fillStyle = ctx.strokeStyle;
      ctx.fillText(math.format(chx, 3), chsx, sym - 4);
      ctx.textAlign = "center";
      if (chsy > this.getAttr("symid")) {
        chsy -= 4;
      } else {
        chsy += 20;
      }
      ctx.fillText(math.format(chy, 3), sxm + 30, chsy - 4)
    }
  }
};

Konva.Util.extend(Konva.Chart, Konva.Shape);

function CreateCrossHairSlider(C) {
  C.setAttr("drawcrosshair", true);
  var xv = C.getAttr("xvalues");
  var index = math.floor(xv.length * 0.25);
  var yv = C.getAttr("yvalues");
  var startsx = C.getAttr("rxtosx")(xv[index]) + C.getX();
  var startsy = C.getAttr("rytosy")(yv[index]) + C.getY();
  var S = new Konva.Circle({
    x: startsx,
    y: startsy,
    radius: 10,
    strokeWidth: 4,
    draggable: true,
    chart: C
  });
  S.on('dragend', function(evt) {
    ch = this.getAttr("chart");
    chrxtosx = ch.getAttr("rxtosx");
    chrytosy = ch.getAttr("rytosy");
    chSx = this.getX() - ch.getX();
    chSy = this.getY() - ch.getY();
    var xv = ch.getAttr("xvalues");
    var yv = ch.getAttr("yvalues");
    var imin = 0;
    var dmin = math.pow(chrxtosx(xv[imin]) - chSx, 2) + math.pow(chrytosy(yv[imin]) - chSy, 2);
    for (var i = 1; i < xv.length; i++) {
      var d = math.pow(chrxtosx(xv[i]) - chSx, 2) + math.pow(chrytosy(yv[i]) - chSy, 2);
      if (d < dmin) {
        imin = i;
        dmin = d;
      }
    }
    finalsx = chrxtosx(xv[imin]);
    finalsy = chrytosy(yv[imin]);
    var Xv = ch.getAttr("Xvalues");
    var Yv = ch.getAttr("Yvalues");
    if ((Xv != undefined) & (Yv != undefined)) {
      for (var iXY = 0; iXY < math.min(Xv.length, Yv.length); iXY++) {
        if ((Xv[iXY] != undefined) & (Yv[iXY] != undefined)) {
          var Nmin = math.min(Xv[iXY].length, Yv[iXY].length);
          if (Nmin > 0) {
            var imin2 = 0;
            var dmin2 = math.pow(chrxtosx(Xv[iXY][imin2]) - chSx, 2) + math.pow(chrytosy(Yv[iXY][imin2]) - chSy, 2);
            for (var i = 1; i < Nmin; i++) {
              var d = math.pow(chrxtosx(Xv[iXY][i]) - chSx, 2) + math.pow(chrytosy(Yv[iXY][i]) - chSy, 2);
              if (d < dmin2) {
                imin2 = i;
                dmin2 = d
              }
            }
            if (dmin2 < dmin) {
              dmin = dmin2
              finalsx = ch.getAttr("rxtosx")(Xv[iXY][imin2]);
              finalsy = ch.getAttr("rytosy")(Yv[iXY][imin2]);
            }
          }
        }
      }
    }
    ch.setAttr("crosshairsx", finalsx);
    ch.setAttr("crosshairsy", finalsy);
    ch.draw();
    this.setX(finalsx + ch.getX());
    this.setY(finalsy + ch.getY());
    this.draw();
    this.getLayer().draw();
  });
  C.draw();
  return S;
};
