# -*- coding: utf-8 -*-
"""
Created on Tue Jun 22 15:14:26 2021

I measured 4 devices from -0.5 to 0.5 T -> 11 steps

@author: david
"""

n_devices = 12 #Define the number of HB you measured

import glob
import matplotlib.pyplot as plt
import numpy as np
from scipy.optimize import curve_fit
import os
abspath = os.path.abspath(__file__)
dname = os.path.dirname(abspath)
os.chdir(dname)
#Figures tricks
plt.rcParams['figure.dpi'] = 230 #Note: this is helpuful for high dpi displays such as 4k display on Windows
plt.rcParams['figure.autolayout'] = True
plt.rc('font', size=12)

#%% Loading all the files

filepath = glob.glob(r'./SQ22_22_3_avg.txt') # this is the wafer of fig 2(a)
dataW1 = np.loadtxt(filepath[0], skiprows = 1 , unpack = True)

    

filepath = glob.glob(r'./SQ22_160_6_avg.txt')
dataW2 = np.loadtxt(filepath[0], skiprows = 1 , unpack = True)
    

#%% I plot only SQ22_22_3 for now
n = 0
mu_avg = 1
mu_std = 2

lim = 500

from scipy import interpolate

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
cm = 1/2.54  # centimeters in inches
plt.figure(figsize=(9*cm, 9*cm), dpi=600)


plt.plot(dataW1[n]*1e-11, dataW1[mu_avg]*1e-5, color = 'purple')
plt.fill_between(dataW1[n]*1e-11, (dataW1[mu_avg]-dataW1[mu_std])*1e-5, (dataW1[mu_avg]+dataW1[mu_std])*1e-5 ,lw = 0, alpha=0.5, color = 'purple')
# plt.fill_between(dataW1[n]*1e-11, (dataW1[mu_avg]-2*dataW1[mu_std])*1e-5, (dataW1[mu_avg]+2*dataW1[mu_std])*1e-5 ,lw = 0, alpha=0.3, color = 'purple')
# plt.fill_between(dataW1[n]*1e-11, (dataW1[mu_avg]-3*dataW1[mu_std])*1e-5, (dataW1[mu_avg]+3*dataW1[mu_std])*1e-5 ,lw = 0, alpha=0.1, color = 'purple')

plt.plot(dataW2[n]*1e-11, dataW2[mu_avg]*1e-5, color = 'black')
plt.fill_between(dataW2[n]*1e-11, (dataW2[mu_avg]-dataW2[mu_std])*1e-5, (dataW2[mu_avg]+dataW2[mu_std])*1e-5 ,lw = 0, alpha=0.5, color = 'black')
# plt.fill_between(dataW2[n]*1e-11, (dataW2[mu_avg]-2*dataW2[mu_std])*1e-5, (dataW2[mu_avg]+2*dataW2[mu_std])*1e-5 ,lw = 0, alpha=0.3, color = 'purple')
# plt.fill_between(dataW2[n]*1e-11, (dataW2[mu_avg]-3*dataW2[mu_std])*1e-5, (dataW2[mu_avg]+3*dataW2[mu_std])*1e-5 ,lw = 0, alpha=0.1, color = 'purple')


plt.xlim(0,7)
plt.ylim(0,3.5)
plt.xlabel('n (10$^{11}$ cm$^{-2}$)')
plt.ylabel('$\mu$ (10$^{5}$ cm$^{2}$/Vs)')
