# -*- coding: utf-8 -*-
"""
Created on Tue Apr 25 10:13:12 2023

@author: david
"""
import numpy as np
import matplotlib.pyplot as plt

#taken from Phonon strain shift coefficients in Si1−xGex alloys

b_SiSi = 723 #+- 15
b_GeGe = -450 #+- 30
b_SiGe = -570 #+- 50

omega_SiSi_0 = 520.7
omega_SiGe_0 = 400.1
omega_GeGe_0 = 280.3

from sympy import solve
from sympy.abc import x, y, z


def f1(x,epsilon,omega_SiSi):
    return omega_SiSi-omega_SiSi_0+66.9*x-b_SiSi*epsilon

def f2(x,epsilon,omega_SiGe):
    return omega_SiGe - omega_SiGe_0 - 24.5*x +4.5*x**2 + 33.5*x**3 - b_SiGe*epsilon

def f3(x,epsilon,omega_GeGe):
    return omega_GeGe - omega_GeGe_0 - 19.4*x - b_GeGe*epsilon 

def f1_e(x,omega_SiSi):
    return (omega_SiSi-omega_SiSi_0+66.9*x)/b_SiSi

def f2_e(x,omega_SiGe):
    return (omega_SiGe - omega_SiGe_0 - 24.5*x +4.5*x**2 + 33.5*x**3)/b_SiGe

def f3_e(x,omega_GeGe):
    return (omega_GeGe - omega_GeGe_0 - 19.4*x)/b_GeGe

# solutions_1 = solve([f1(x,y,511),f2(x,y,296.71)], x,y)

#peaks for the virtual substrate SiSi -> 499.51 SiGe -> 406 GeGe -> 286

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

omega_SiSi = 499.53
omega_SiGe = 404.77
omega_GeGe = 288.47

xx = np.linspace(0.1,0.75,100)
# ee = np.linspace(0,2,100)
cm = 1/2.54 
fig = plt.figure(figsize=(9*cm, 7.5*cm), dpi=600)

plt.plot(xx, f1_e(xx,omega_SiSi)*100, label = 'SiSi')
plt.plot(xx, f2_e(xx,omega_SiGe)*100, label = 'SiGe')
plt.plot(xx, f3_e(xx,omega_GeGe)*100, label = 'GeGe')

solution_1 = solve([f1(x,y,omega_SiSi), f2(x,y,omega_SiGe)], x, y)
solution_2 = solve([f1(x,y,omega_SiSi), f3(x,y,omega_GeGe)], x, y)
solution_3 = solve([f2(x,y,omega_SiGe), f3(x,y,omega_GeGe)], x, y)

plt.scatter(float(solution_1[0][0]),float(solution_1[0][1]*100))
plt.scatter(float(solution_2[x]),float(solution_2[y]*100))
plt.scatter(float(solution_3[0][0]),float(solution_3[0][1]*100))

aux = [float(solution_1[0][0]),
       float(solution_2[x]),
       float(solution_3[0][0])]

x_avg = np.mean(aux)
print('Average Ge concentration = ', x_avg)

aux = [float(solution_1[0][1]*100),
       float(solution_2[y]*100),
       float(solution_3[0][1]*100)]

epsilon_mean = np.mean(aux)
print('Average Strain = ', epsilon_mean)
plt.scatter(x_avg,epsilon_mean, color = 'r')

plt.xlabel('Ge composition x')
plt.ylabel('strain (%)')
plt.legend()



#%% I fix the Ge concentration x from SIMS

x_Ge = 0.31

omega_SiSi = 499.66
omega_SiGe = 403.47
omega_GeGe = 288.47

print('From the Si-Si vibration',f1_e(x_Ge,omega_SiSi)*100)
# print('From the Si-Ge vibration',f2_e(x_Ge,omega_SiGe)*100)
# print('From the Ge-Ge vibration',f3_e(x_Ge,omega_GeGe)*100)

#%% load files

import glob

filepath = glob.glob(r'./QT875-SiSi.txt')
data_SiSi = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

filepath = glob.glob(r'./QT875-SiGe.txt')
data_SiGe = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

filepath = glob.glob(r'./QT875-GeGe.txt')
data_GeGe = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

#%% plot the Si/Si vibration

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

cm = 1/2.54 
fig = plt.figure(figsize=(9*cm, 7.5*cm), dpi=600)

x = np.arange(-15,16.6,1.5)
y = np.arange(-15,16.6,1.5)

# z = data_SiSi
# z = data_SiGe
z = data_GeGe

import matplotlib

# levels = matplotlib.ticker.MaxNLocatorMaxNLocator(nbins=15).tick_values(z.min(), z.max())
# norm = BoundaryNorm(levels, ncolors=cmap.N, clip=True)

# cmap = plt.colormaps['Greens']
plt.pcolormesh(x,y,z ,cmap=my_cmap)
cbar = plt.colorbar()
cbar.set_label('Raman Shift (cm$^{-1}$)')

plt.xlabel('x ($\mu$m)')
plt.ylabel('y ($\mu$m)')

print('mean = ',np.mean(z), '+-', np.std(z))

#%% put the numbers from the first 2D map

from sympy.abc import x, y, z
#peaks for the virtual substrate SiSi -> 499.51 SiGe -> 406 GeGe -> 286

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

omega_SiSi = 498.0
omega_SiGe = 405.86
omega_GeGe = 285.64

xx = np.linspace(0.1,0.50,100)
# ee = np.linspace(0,2,100)
cm = 1/2.54 
fig = plt.figure(figsize=(9*cm, 7.5*cm), dpi=600)

plt.plot(xx, f1_e(xx,omega_SiSi)*100, label = 'SiSi')
plt.plot(xx, f2_e(xx,omega_SiGe)*100, label = 'SiGe')
plt.plot(xx, f3_e(xx,omega_GeGe)*100, label = 'GeGe')

# plt.fill_between(xx, f1_e(xx,omega_SiSi+0.2)*100,f1_e(xx,omega_SiSi-0.2)*100)

solution_1 = solve([f1(x,y,omega_SiSi), f2(x,y,omega_SiGe)], x, y)
solution_2 = solve([f1(x,y,omega_SiSi), f3(x,y,omega_GeGe)], x, y)
solution_3 = solve([f2(x,y,omega_SiGe), f3(x,y,omega_GeGe)], x, y)

# plt.scatter(float(solution_1[0][0]),float(solution_1[0][1]*100))
# plt.scatter(float(solution_2[x]),float(solution_2[y]*100))
# plt.scatter(float(solution_3[0][0]),float(solution_3[0][1]*100))

aux = [float(solution_1[0][0]),
       float(solution_2[x]),
       float(solution_3[0][0])]

x_avg = np.mean(aux)
print('Average Ge concentration = ', x_avg)

aux = [float(solution_1[0][1]*100),
       float(solution_2[y]*100),
       float(solution_3[0][1]*100)]

epsilon_mean = np.mean(aux)
print('Average Strain = ', epsilon_mean)
plt.scatter(x_avg,epsilon_mean, color = 'r')

plt.xlabel('Ge composition x')
plt.ylabel('strain (%)')
plt.legend()

#%%
from sympy import solve
from sympy.abc import x, y, z
solutions = solve([x**2 + y - 2*2, y + 4*2], x, y)
# [{x: -sqrt(6)*sqrt(z), y: -4*z}, {x: sqrt(6)*sqrt(z), y: -4*z}]

# plt.scatter(solutions[1][0],solutions[1][1])