# -*- coding: utf-8 -*-
"""
Created on Sat Jul 10 09:53:05 2021

@author: david
"""



import imageio
import matplotlib.pyplot as plt
import warnings
import matplotlib.cbook
from skimage import color
from scipy.optimize import curve_fit
import numpy as np
from scipy.signal import savgol_filter
import scipy.special
import scipy

#%%
###############################################################################################################
#                       7 nm QW      R0NMC203_SQ21-160-6_QT724_0012
##############################################################################################################

#Note 320 px are 8 nm in this picture no21 from QT694 ok
pic= imageio.imread(r'.\7nm_QW.tif')

xx = range(len(pic[0]))
pic2 = np.sum(pic,axis=0)
xx = range(len(pic[0]))
xx = np.array(xx)

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8.6/2*cm), dpi=600)

plt.axis('off')
plt.imshow(pic, cmap = 'gray')
plt.plot(xx,-(pic2/250+100) +1000, lw = 1)

#%% fitting the sharpeness of the interfaces following  https://onlinelibrary.wiley.com/doi/full/10.1002/admi.201700622

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8.6/2*cm), dpi=600)

aux2 = pic2-min(pic2)
factor = 3/242
plt.plot(xx*factor,aux2/max(aux2), lw = 1)
aux3 = aux2/max(aux2)

#fitting the bottom interface

def sigmoid(x,a,b_1,b_2,x0_1,x0_2,c):
    return a/(1+np.exp((x-x0_1)/b_1)) + a/(1+np.exp((x0_2-x)/b_2)) +c

popt, covm = curve_fit(sigmoid, xx*factor, aux3, maxfev = 10000000, p0 = (40000,0.2,0.2,12,4,50000))
plt.plot(xx*factor,sigmoid(xx*factor,popt[0],popt[1],popt[2],popt[3],popt[4],popt[5]), lw = 1, color = 'purple', ls = '--')

print('Sharpness of the Top interface (4 tau):', '{:.2f}'.format(popt[1]*4) , '+- ','{:.2f}'.format(np.sqrt(covm[1][1])*4) , '[nm]' )
print('Sharpness of the Bottom interface (4 tau):', '{:.2f}'.format(popt[2]*4) , '+- ','{:.2f}'.format(np.sqrt(covm[2][2])*4) , '[nm]' )
print('QW thickness = ', '{:.2f}'.format(popt[3]-popt[4] ) , '+- ','{:.2f}'.format(np.sqrt(covm[3][3])+np.sqrt(covm[4][4]) ) , '[nm]' )

plt.xlabel('Position [nm]')
plt.xlim(1,14)

xx_1 = xx*factor
yy_1 = aux3
fit_1 = popt

#%%
###############################################################################################################
#                       7 nm QW Due _ R0NNP938_SQ22-73-4_0009
##############################################################################################################

#Note 320 px are 8 nm in this picture no21 from QT694 ok
pic= imageio.imread(r'.\7nm_QW_2.tif')

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8.6/2*cm), dpi=600)

xx = range(len(pic[0]))

pic2 = np.sum(pic,axis=0)
std = np.std(pic[0:len(pic)][0:],axis=0)
xx = range(len(pic[0]))
xx = np.array(xx)

plt.imshow(pic, cmap = 'gray')
plt.axis('off')

plt.plot(xx,-(pic2/250+100) +1000, lw = 1)

#%% fitting the sharpeness of the interfaces following  https://onlinelibrary.wiley.com/doi/full/10.1002/admi.201700622

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8.6/2*cm), dpi=600)

aux2 = pic2-min(pic2)
factor = 3/234
plt.plot(xx*factor,aux2/max(aux2), lw = 1)
aux3 = aux2/max(aux2)

#fitting the bottom interface

def sigmoid(x,a,b_1,b_2,x0_1,x0_2,c):
    return a/(1+np.exp((x-x0_1)/b_1)) + a/(1+np.exp((x0_2-x)/b_2)) +c

popt, covm = curve_fit(sigmoid, xx*factor, aux3, maxfev = 10000000, p0 = (40000,0.2,0.2,12,4,50000), sigma = std)
plt.plot(xx*factor,sigmoid(xx*factor,popt[0],popt[1],popt[2],popt[3],popt[4],popt[5]), lw = 1, color = 'red', ls = '--')

print('Sharpness of the Bottom interface (4 tau):', '{:.2f}'.format(popt[1]*4) , '+- ','{:.2f}'.format(np.sqrt(covm[1][1])*4) , '[nm]' )
print('Sharpness of the Top interface (4 tau):', '{:.2f}'.format(popt[2]*4) , '+- ','{:.2f}'.format(np.sqrt(covm[2][2])*4) , '[nm]' )
print('QW thickness = ', '{:.2f}'.format(popt[3]-popt[4] ) , '+- ','{:.2f}'.format(np.sqrt(covm[3][3])+np.sqrt(covm[4][4]) ) , '[nm]' )

plt.xlabel('Position [nm]')
plt.xlim(1,14)

xx_2 = xx*factor
yy_2 = aux3
fit_2 = popt

#%%
###############################################################################################################
#                       5nm QW      _ 
##############################################################################################################

#Note 320 px are 8 nm in this picture no21 from QT694 ok
pic= imageio.imread(r'.\5nm_QW.tif')

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8.6/2*cm), dpi=600)


plt.axis('off')

xx = range(len(pic[0]))
pic2 = np.sum(pic,axis=0)
xx = range(len(pic[0]))
xx = np.array(xx)

plt.imshow(pic, cmap = 'gray')
plt.plot(xx,-(pic2/250+100) +1000, lw = 1)

#%% fitting the sharpeness of the interfaces following  https://onlinelibrary.wiley.com/doi/full/10.1002/admi.201700622

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8.6/2*cm), dpi=600)

pos = xx*factor + 1.2

aux2 = pic2-min(pic2)
factor = 3/300
plt.plot(pos,aux2/max(aux2), lw = 1)
aux3 = aux2/max(aux2)

#fitting the bottom interface

def sigmoid(x,a,b_1,b_2,x0_1,x0_2,c):
    return a/(1+np.exp((x-x0_1)/b_1)) + a/(1+np.exp((x0_2-x)/b_2)) +c

popt, covm = curve_fit(sigmoid, pos, aux3, maxfev = 10000000, p0 = (40000,0.2,0.2,12,4,50000), sigma = std)
plt.plot(pos,sigmoid(pos,popt[0],popt[1],popt[2],popt[3],popt[4],popt[5]), lw = 1, color = 'red', ls = '--')

print('Sharpness of the Bottom interface (4 tau):', '{:.2f}'.format(popt[1]*4) , '+- ','{:.2f}'.format(np.sqrt(covm[1][1])*4) , '[nm]' )
print('Sharpness of the Top interface (4 tau):', '{:.2f}'.format(popt[2]*4) , '+- ','{:.2f}'.format(np.sqrt(covm[2][2])*4) , '[nm]' )
print('QW thickness = ', '{:.2f}'.format(popt[3]-popt[4] ) , '+- ','{:.2f}'.format(np.sqrt(covm[3][3])+np.sqrt(covm[4][4]) ) , '[nm]' )

plt.xlabel('Position [nm]')
plt.xlim(1,14)

xx_3 = pos
yy_3 = aux3
fit_3 = popt

#%%
###############################################################################################################
#                       9nm QW _ R0NLZ460_SQ22-20_QT751_0010
##############################################################################################################

#Note 320 px are 8 nm in this picture no21 from QT694 ok
pic= imageio.imread(r'.\8nm_QW_2.tif')

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8.6/2*cm), dpi=600)

plt.imshow(pic, cmap = 'gray')
plt.axis('off')
#imgGray = color.srgb2gray(pic)
# 65px are 9 nm 

xx = range(len(pic[0]))

pic2 = np.sum(pic,axis=0)
xx = range(len(pic[0]))
xx = np.array(xx)

plt.plot(xx,-(pic2/250+100) +1000, lw = 1)

#%% fitting the sharpeness of the interfaces following  https://onlinelibrary.wiley.com/doi/full/10.1002/admi.201700622

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8.6/2*cm), dpi=600)

pos = xx*factor + 1.1

aux2 = pic2-min(pic2)
factor = 3/300
plt.plot(pos,aux2/max(aux2), lw = 1)
aux3 = aux2/max(aux2)

#fitting the bottom interface

def sigmoid(x,a,b_1,b_2,x0_1,x0_2,c):
    return a/(1+np.exp((x-x0_1)/b_1)) + a/(1+np.exp((x0_2-x)/b_2)) +c

popt, covm = curve_fit(sigmoid, pos, aux3, maxfev = 10000000, p0 = (40000,0.2,0.2,12,4,50000), sigma = std)
plt.plot(pos,sigmoid(pos,popt[0],popt[1],popt[2],popt[3],popt[4],popt[5]), lw = 1, color = 'red', ls = '--')

print('Sharpness of the Bottom interface (4 tau):', '{:.2f}'.format(popt[1]*4) , '+- ','{:.2f}'.format(np.sqrt(covm[1][1])*4) , '[nm]' )
print('Sharpness of the Top interface (4 tau):', '{:.2f}'.format(popt[2]*4) , '+- ','{:.2f}'.format(np.sqrt(covm[2][2])*4) , '[nm]' )
print('QW thickness = ', '{:.2f}'.format(popt[3]-popt[4] ) , '+- ','{:.2f}'.format(np.sqrt(covm[3][3])+np.sqrt(covm[4][4]) ) , '[nm]' )

plt.xlabel('Position [nm]')
# print(popt[2])

plt.xlim(0.3,13)
plt.xlim(1,14)

xx_4 = pos
yy_4 = aux3
fit_4 = popt

#%%

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8.6/2*cm), dpi=600)

plt.plot(xx_1-1,yy_1, color = 'purple')
plt.plot(xx_2-1.1,yy_2*1.1, color = 'purple')
plt.plot(xx_3-1.7,yy_3, color = 'green')
plt.plot(xx_4,yy_4, color = 'blue')

plt.xlim(1,14)


#%%
plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8.6/2*cm), dpi=600)

plt.plot(xx_1-fit_1[4]+3,sigmoid(xx_1,-1,fit_1[1],fit_1[2],fit_1[3],fit_1[4],2), lw = 1, color = 'purple', ls = 'solid')
plt.plot(xx_2-fit_2[4]+3 ,sigmoid(xx_2,-1,fit_2[1],fit_2[2],fit_2[3],fit_2[4],2), lw = 1, color = 'purple', ls = 'solid')
plt.plot(xx_3-fit_3[4]+3,sigmoid(xx_3,-1,fit_3[1],fit_3[2],fit_3[3],fit_3[4],2), lw = 1, color = 'green', ls = 'solid')
plt.plot(xx_4-fit_4[4]+3,sigmoid(xx_4,-1,fit_4[1],fit_4[2],fit_4[3],fit_4[4],2), lw = 1, color = 'blue', ls = 'solid')


# plt.plot(xx_1-1,yy_1, color = 'purple')
# plt.plot(xx_2-1.1,yy_2, color = 'purple')
# plt.plot(xx_3-1.7,yy_3, color = 'green')
# plt.plot(xx_4,yy_4, color = 'blue')

plt.xlim(1,14)
plt.xlabel('Position [nm]')