# -*- coding: utf-8 -*-
"""
Created on Sat Jun 19 09:58:20 2021

@author: david
"""

#Imports
import matplotlib.pyplot as plt
import numpy as np
from scipy.optimize import curve_fit
from scipy.signal import savgol_filter
import glob

#Figures tricks
plt.rcParams['figure.dpi'] = 230 #Note: this is helpuful for high dpi displays such as 4k display on Windows
plt.rcParams['figure.autolayout'] = True
plt.rc('font', size=12)

cmap = plt.cm.get_cmap('Spectral')

# Define percolation function 
def percolation(n,a,np):
    return a*(n-np)**(1.31) 

def lin(x,a,b):
    return a*x + b

#Physical constants

e = 1.60217662*1e-19 # C
h = 6.62606057*1e-34 # m^2 kg/s

#%% importing data

filepath = glob.glob(r'./*.txt')
dataT = []
prova = []
for i in filepath:
    dataT.append(np.loadtxt(i, skiprows = 3 , unpack = True))
    prova.append(i)

Vg , n , mu = [0,1,2]

order = [1,5,6,7,8,9,10,11,12,2,3,4] #From time to time python do not load the files in the right order

dataTnew = []
for i in range(len(order)):
    dataTnew.append(dataT[order[i]-1])
#   Data sample 1

#%% getting a color map
import matplotlib.pyplot as plt
import matplotlib.colors as colors
import numpy as np

def truncate_colormap(cmap, minval=0.0, maxval=1.0, n=100):
    new_cmap = colors.LinearSegmentedColormap.from_list(
        'trunc({n},{a:.2f},{b:.2f})'.format(n=cmap.name, a=minval, b=maxval),
        cmap(np.linspace(minval, maxval, n)))
    return new_cmap

arr = np.linspace(0, 50, 100).reshape((10, 10))
fig, ax = plt.subplots(ncols=2)

cmap = plt.get_cmap('jet')
new_cmap = truncate_colormap(cmap, 0.1, 0.9)
ax[0].imshow(arr, interpolation='nearest', cmap=cmap)
ax[1].imshow(arr, interpolation='nearest', cmap=new_cmap)
plt.show()

colors = new_cmap(np.linspace(0,1,12))

#%% plot mob dens

fig , ax1 = plt.subplots(1,1)
ax1.set_xlabel('$n$ [cm$^{-2}$]')
ax1.set_ylabel('$\mu$ [cm$^2$/Vs]')

sample_no = ['1-4-3', '4-3-3', '10-3-3', '10-4-3', '10-1-3', '10-2-3', '13-2-3', '16-1-3', '6-1-3', '6-2-3','6-3-3','6-3-3']

# data1[1] = savgol_filter(data1[1], 5, 3)
# ax1.scatter(data1[0],data1[1], marker = '.', color = cmap(1/6))

a = [0,0,18,100,10,10,50,10,20,25,20,10]


for i in [0,1,2,3,4,5,6,7,8,9,10,11]:
    aux = savgol_filter(dataTnew[i][mu][a[i]:], 7, 3) 
    ax1.plot(dataTnew[i][n][a[i]:],aux, label = i, color =colors[i]) 
    
plt.legend(title = 'sample_no')

#%% plot percolation density

a = [0,0,18,100,10,10,50,10,20,25,20,10]

plt.style.use('seaborn-ticks')
plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams.update({'font.size': 6})
from matplotlib.pyplot import figure

figure(figsize = (2.0603674540682415,2.0603674540682415*(0.8)), dpi = 600)
plt.xlabel('n [cm-2]')
plt.ylabel('sigma$_{xx}$ [1/ohm]') # in C/Vs
plt.yscale('log')
n_percolation = []
c = 40
for i in [0,1,2,3,4,5,7,8,9,10,11]:
    
    sigma = (1.60217662*1e-19)*dataTnew[i][n]*dataTnew[i][mu] #caluculate sigma_xx
    
    # plt.scatter(dataTnew[i][n][a[i]:c], sigma[a[i]:c], s=80, facecolors='none', edgecolors='red', color =colors[i], label = sample_no[i])
    aux1 = dataTnew[i][n][a[i]:]
    aux2 = sigma[a[i]:]
    aux1 = aux1[::-1]
    aux2 = aux2[::-1]
    plt.scatter(aux1[a[i]:a[i]+c], aux2[a[i]:a[i]+c], color = 'red')
    # plt.scatter(aux1[:c],aux2[:c], s=80, facecolors='none', edgecolors='black', color =colors[i], label = sample_no[i])
    popt,covm = curve_fit(percolation, aux1[a[i]:a[i]+c], aux2[a[i]:a[i]+c], p0 = [1e-19,2e10], maxfev = 100000)
    err = np.sqrt(np.diag(covm))
    print("{:.2E}".format(np.mean(popt[1])))
    # print('np = ',"{:.2E}".format(popt[1]),'+-', "{:.0E}".format(err[1]), '\n')
    n_percolation.append(popt[1])
    xx = np.linspace(popt[1]*1.2, 2e11, 1000)
    plt.plot(xx, percolation(xx, popt[0], popt[1]), lw =2, color ='black')
# plt.legend(title = 'sample_no')
n_percolation=np.array(n_percolation)

# plt.xlim(0.5e11,1.5e11)
# plt.ylim(6e-5,1e-3)
#%% plot percolation

x = [0,1,2,3,4,5,6,7,8,9,10,11]

# sample_no = ['1-4-3', '4-3-3', '10-3-3', '10-4-3', '16-1-3', '13-2-3', '10-2-3', '10-1-3', '6-1-3', '6-4-3', '6-2-3','6-3-3']



plt.figure(1)
for i in range(len(sample_no)):
    plt.scatter(x[i],n_percolation[i], label = sample_no[i], color =colors[i])
    
for i in range(len(n_percolation)):
    print(n_percolation[i])

plt.errorbar(5.5, np.mean(n_percolation), yerr = np.std(n_percolation) , marker ='o', color = 'black')
print('np_average = ',"{:.2E}".format(np.mean(n_percolation)),'+-', "{:.0E}".format(np.std(n_percolation)), '\n')
plt.ylabel('$n_{percolation}$ [cm$^{-2}$]')
plt.xticks([])
#%% plot n vs Vg -> capacitance

a = [5,10,10,10,10,10,10,10,10,30,15,30]
plt.figure(3)
plt.ylabel('n [cm-2]')
plt.xlabel('V$_G$ [mV]') 

Vg , n , mu = [0,1,2]
C_tot = []
for i in range(12):
    plt.plot(dataTnew[i][0][a[i]:], dataTnew[i][1][a[i]:], color =colors[i])
    popt,covm = curve_fit(lin, dataTnew[i][Vg][a[i]:], dataTnew[i][n][a[i]:], maxfev = 100000, p0 = [1e13,1e10])
    # plt.plot(dataT[i][Vg][a[i]:], lin(dataT[i][Vg][a[i]:],popt[0], popt[1]))
    C = (1.60217662*1e-19)*popt[0]*1e7*1e4*10 #Deduce the capacitance
    err = np.sqrt(np.diag(covm))
    print(C)
    # print('C = ', '{:.2f}'.format(C), '+-', '{:.2f}'.format((1.60217662*1e-19)*err[0]*1e7*1e4*10),'nF/cm2' )
    C_tot.append(C)

C_tot=np.array(C_tot)
print(np.average(C_tot))

#%% Max Density

for i in range(12):
    print(max(dataTnew[i][n][0:100]))

#%% mobility at 6e11 cm-2

fig , ax1 = plt.subplots(1,1)

ax1.set_ylabel('$\mu$ [cm$^2$/Vs]')

# sample_no = ['1-4-3', '4-3-3', '10-3-3', '10-4-3', '16-1-3', '13-2-3', '10-2-3', '10-1-3', '6-1-3', '6-4-3', '6-2-3','6-3-3']

control = 0
mobility = []
for i in range(12):
    control = 0
    for j in range(len(dataTnew[i][n])):
        if 5.9e11 < dataTnew[i][n][j] <6.1e11 and control == 0:
            print(dataTnew[i][mu][j])
            mobility.append(dataTnew[i][mu][j])
            control = 1
mobility = np.array(mobility)

x = [0,1,2,3,4,5,7,8,9,10,11]

for i in range(len(sample_no)):
    plt.scatter(x[i],mobility[i], color =colors[i])

plt.errorbar(5.5, np.mean(mobility), yerr = np.std(mobility) , marker ='o', color = 'black')
print('mu_average = ',"{:.2E}".format(np.mean(mobility)),'+-', "{:.0E}".format(np.std(mobility)), '\n')

# plt.legend(title = 'sample_no')