# -*- coding: utf-8 -*-
"""
Created on Thu Aug  5 13:07:21 2021

@author: ddegliesposti
"""

import glob
import matplotlib.pyplot as plt
import numpy as np
from scipy.optimize import curve_fit
from scipy.signal import savgol_filter, find_peaks
import matplotlib as mpl
from core_tools.data.ds.data_set import load_by_id, load_by_uuid
from core_tools.data.ds.ds_hdf5 import save_hdf5_uuid, load_hdf5_uuid

#Figures tricks
plt.rcParams['figure.dpi'] = 230 #Note: this is helpuful for high dpi displays such as 4k display on Windows
plt.rcParams['figure.autolayout'] = True
plt.rc('font', size=12)
plt.rcParams['text.usetex'] = False

def function(x,a,c):
    return a*x**c

def lin(x,a,c):
    return a*x + c

#defining the PSD function

def PSD(array, time_step):
    '''
    Calculates the power spectral density of an array of samples
    that are evenly spaced in time
    array: sample array
    time_step: scalar, time between two points
    Returns:
    f_axis: array, positive frequencies for which the PSD is
    calculated, without the dc component
    psd: array, values of the PSD at the frequency
    points f_axis
   
    '''
    f_axis = np.fft.fftfreq(len(array), time_step)
    idx = np.argsort(f_axis)
    f_axis = f_axis[idx]
    period=time_step*len(array)
    psd=time_step*time_step*(np.abs(np.fft.fft(array)))**2/period
    psd=psd[idx]
    return f_axis[int(len(psd)/2):][1:], psd[int(len(psd)/2):][1:]


#%% Loading alla the files

from core_tools.data.ds.data_set import load_by_id, load_by_uuid
import numpy as np
import matplotlib.pyplot as plt

#Figures tricks

Amp = 100e6
plt.rcParams['figure.dpi'] = 230 #Note: this is helpuful for high dpi displays such as 4k display on Windows

# I am doing it for peak 8

uuid_peak = 1675396835978255110
uuid_slope = 1675394922686255110
uuid_top = 1675445603245255110
uuid_blockade = 1675394125940255110

#%% data coulomb peak

ds = load_hdf5_uuid(uuid_peak,  r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper\QuantumDots\1_Dev1\SanityCheck')

Vp = ds.m1.x() #
Isd = ds.m1() # Idc in 

plt.style.use('seaborn-ticks')
plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
cm = 1/2.54  # centimeters in inches

fig = plt.figure(figsize=(9*2/3*cm, 9*cm), dpi=300)

plt.plot(Vp,1e9*Isd)

plt.xlim(1751,1762)
plt.scatter(Vp[380], 1e9*Isd[380],marker = 'D', color = 'red' ) # point at the falnk
x = np.where(Vp > 1753.2)[0][0]
plt.scatter(Vp[x], 1e9*Isd[x],marker = 'D', color = 'green') # point at the top
x = np.where(Vp > 1757.7)[0][0]
plt.scatter(Vp[x], 1e9*Isd[x],marker = 'D', color = 'blue') # point at the top

plt.xlabel('$V_P$ (mV)')
plt.ylabel('I$_{SD} $(nA)')

#%% data time traces

ds_slope = load_hdf5_uuid(uuid_slope,  r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper\QuantumDots\1_Dev1\SanityCheck')


time_slope = ds_slope.m1.x() #
Isd_slope = ds_slope.m1()/Amp # Idc in 

ds_top = load_hdf5_uuid(uuid_top,  r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper\QuantumDots\1_Dev1\SanityCheck')

time_top = ds_top.m1.x() #
Isd_top = ds_top.m1()/Amp # Idc in 

ds_blockade = load_hdf5_uuid(uuid_blockade,  r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper\QuantumDots\1_Dev1\SanityCheck')

time_blockade = ds_blockade.m1.x() #
Isd_blockade = ds_blockade.m1()/Amp # Idc in 

#%% plot Isd time trace flank

plt.style.use('seaborn-ticks')
plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
cm = 1/2.54  # centimeters in inches

fig = plt.figure(figsize=(9*2/3*cm, 9/3*cm), dpi=300)

Isd_avg = []
Isd_avg.append(np.mean(Isd_slope))
Isd_avg = np.array(Isd_avg[0])
# plt.plot(time,Isd_slope, label = "{:.2F}".format(Isd_avg*1e12) )
plt.plot(time_slope,Isd_slope*1e9, label = '1732.8 (mV)', color = 'red' )
# plt.legend(loc = 2)

plt.xlabel('time (s)')
plt.ylabel('I$_{SD}$ (nA)')

#%% plot Is time trace blocakde
plt.style.use('seaborn-ticks')
plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
cm = 1/2.54  # centimeters in inches

fig = plt.figure(figsize=(9*2/3*cm, 9/3*cm), dpi=300)
Isd_avg = []
Isd_avg.append(np.mean(Isd_blockade))
Isd_avg = np.array(Isd_avg[0])
# plt.plot(time,Isd_slope, label = "{:.2F}".format(Isd_avg*1e12) )
plt.plot(time_blockade,Isd_blockade*1e9, color = 'green')

plt.xlabel('time (s)')
plt.ylabel('I$_{SD}$ (nA)')

#%% plot Is top of the peak
plt.style.use('seaborn-ticks')
plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
cm = 1/2.54  # centimeters in inches

fig = plt.figure(figsize=(9*2/3*cm, 9/3*cm), dpi=300)
Isd_avg = []
Isd_avg.append(np.mean(Isd_top))
Isd_avg = np.array(Isd_avg[0])

plt.plot(time_top,Isd_top*1e9, label = '1738.0 (mV)', color = 'blue' )
# plt.legend(loc = 2)

plt.xlabel('time (s)')
plt.ylabel('I$_{SD}$ (nA)')

#%% time domain

traces = [Isd_slope,Isd_blockade,Isd_top]
psd_avg_all = []

for i in [0,1,2]:
    aux = []
    data = traces[i] #convert everything in A
    num_segments = 10
    time_step = time_slope[1]-time_slope[0] #in seconds
    segment = []
    for i in range(num_segments):
        segment.append( data[i*int(len(data)/num_segments): (i+1)*int(len(data)/num_segments)] )
    
    new_x = time_slope[0: int(len(data)/num_segments)] 

    psd_single = []
    freq_single = []
    # plt.figure()
    for i in range(len(segment)):
        frequencies, psd = PSD(segment[i],time_step)
        psd_single.append(psd)
        freq_single.append(frequencies)
        # plt.plot(frequencies,psd*10**(3*i))
        
    plt.xscale('log')
    plt.yscale('log')
    
    freq_single = np.array(freq_single)
    psd_single = np.array(psd_single)

    aux = np.zeros(len(psd_single[0]))
    for i in range(len(psd_single)):
        aux = aux + psd_single[i]
        
    psd_avg = aux/len(psd_single)
    
    plt.plot(frequencies, psd_avg)
    psd_avg_all.append(psd_avg)
    plt.xscale('log')
    plt.yscale('log')
    
    plt.xlabel('frequency (Hz)')
    plt.ylabel('S$_I$ (A$^2$/Hz)')

plt.xlim(1/40,40)

#%% plot the psd of the three configurations

plt.style.use('seaborn-ticks')
plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42

cms = 1/2.54

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
cm = 1/2.54  # centimeters in inches

fig = plt.figure(figsize=(9*2/3*cm, 9*cm), dpi=300)

plt.plot(frequencies, psd_avg_all[0],color = 'red' )
plt.plot(frequencies, psd_avg_all[1],color = 'green' )
plt.plot(frequencies, psd_avg_all[2],color = 'blue' )

plt.xscale('log')
plt.yscale('log')
plt.xlim(1/40,40)

plt.xlabel('$f$ (Hz)')
plt.ylabel('S$_I$ (A$^2$/Hz)')
