# -*- coding: utf-8 -*-
"""
Created on Tue Jun 22 15:14:26 2021

I measured 4 devices from -0.5 to 0.5 T -> 11 steps

@author: david
"""

n_devices = 12 #Define the number of HB you measured

import glob
import matplotlib.pyplot as plt
import numpy as np
from scipy.optimize import curve_fit
import os
abspath = os.path.abspath(__file__)
dname = os.path.dirname(abspath)
os.chdir(dname)
#Figures tricks
plt.rcParams['figure.dpi'] = 230 #Note: this is helpuful for high dpi displays such as 4k display on Windows
plt.rcParams['figure.autolayout'] = True
plt.rc('font', size=12)

#Define useful functions

def mobility(Bfield,Vxx,Vxy,L,W): # mobility in cm^2/Vs
    return abs((Vxy*L*1e4)/(Bfield*Vxx*W))

def n_H(Bfield,Isd,Vxy): # density of charge carriers in cm^-2
    return abs((Bfield*Isd*1e-4)/(1.60217662*1e-19*Vxy))

def rhoxx(Vxx,Isd,ratio): # in ohm/sq
    return abs((Vxx)/((Isd)*ratio))

def rhoxy(Vxy,Isd): # in ohm/sq
    return ((Vxy/(Isd)))

# Define percolation function 
def percolation(n,a,np):
    return a*(n-np)**(1.31) 

def lin(x,a,b):
    return a*x+b

#%% Loading all the files

filepath = glob.glob(r'./SQ22_22_3/*.txt')
dataW2 = []
for i in filepath:
    dataW2.append(np.loadtxt(i, skiprows = 2 , unpack = True))
    
#%% plot percolation density

Vg = 0
n = 1
mu = 2


#%% plot average sigmaxx and percolation density

from scipy import interpolate

import matplotlib.pyplot as plt
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
cm = 1/2.54  # centimeters in inches
plt.figure(figsize=(9/2*cm, 9/2*cm), dpi=600)
ax = plt.axes()
plt.xlabel('n (10$^{11}$ cm-2)')
plt.ylabel('sigma$_{xx}$ [10$^{4}$/ohm]') # in C/Vs
plt.yscale('log')

interp = []
for i in [0,1,2,3,4,5,6,8,9,10]:
    # plt.plot(dataW2[i][n],dataW2[i][mu], color = 'blue')
    sigma = (1.60217662*1e-19)*dataW2[i][n]*dataW2[i][mu] #caluculate sigma_xx
    f = interpolate.interp1d(dataW2[i][n], sigma, kind = 'nearest')
    xnew = np.arange(0.92e11, 6.3e11, 0.01e10)
    # plt.plot(xnew, f(xnew), color = 'r')
    interp.append(f(xnew))
    
interp = np.array(interp)

avg = interp.mean(0)
std = interp.std(0)

plt.plot(xnew*1e-11, avg, color = 'purple', alpha=1)
plt.fill_between(xnew*1e-11, (avg-std), (avg+std) , alpha=0.5, lw= 0, color = 'purple')
plt.fill_between(xnew*1e-11, (avg-2*std), (avg+2*std) , alpha=0.3,lw= 0, color = 'purple')
plt.fill_between(xnew*1e-11, (avg-3*std), (avg+3*std) , alpha=0.1,lw= 0, color = 'purple')

a,b = [0,200]

popt,covm = curve_fit(percolation, xnew[a:b], avg[a:b], p0 = [1e-19,6e10], maxfev = 100000)
err = np.sqrt(np.diag(covm))
print("{:.2E}".format(popt[1]) , '+-' , "{:.2E}".format(err[1]))
xx = np.linspace(0.75e11, 1.2e11, 1000)
plt.plot(xx*1e-11, percolation(xx, popt[0], popt[1]), lw =0.75, color ='black', ls = 'solid')
plt.yscale('log')

plt.xlim(0.7,1.5)
plt.ylim(0.5*1e-4,20*1e-4)
