# -*- coding: utf-8 -*-
"""
Created on Tue Jun 22 15:14:26 2021

I measured 4 devices from -0.5 to 0.5 T -> 11 steps

@author: david
"""

n_devices = 12 #Define the number of HB you measured

import glob
import matplotlib.pyplot as plt
import numpy as np
from scipy.optimize import curve_fit
import os
abspath = os.path.abspath(__file__)
dname = os.path.dirname(abspath)
os.chdir(dname)
#Figures tricks
plt.rcParams['figure.dpi'] = 230 #Note: this is helpuful for high dpi displays such as 4k display on Windows
plt.rcParams['figure.autolayout'] = True
plt.rc('font', size=12)

#Define useful functions

def mobility(Bfield,Vxx,Vxy,L,W): # mobility in cm^2/Vs
    return abs((Vxy*L*1e4)/(Bfield*Vxx*W))

def n_H(Bfield,Isd,Vxy): # density of charge carriers in cm^-2
    return abs((Bfield*Isd*1e-4)/(1.60217662*1e-19*Vxy))

def rhoxx(Vxx,Isd,ratio): # in ohm/sq
    return abs((Vxx)/((Isd)*ratio))

def rhoxy(Vxy,Isd): # in ohm/sq
    return ((Vxy/(Isd)))

# Define percolation function 
def percolation(n,a,np):
    return a*(n-np)**(1.31) 

def lin(x,a,b):
    return a*x+b

#%% Loading all the files

filepath = glob.glob(r'./SQ22_22_3/*.txt')
dataW2 = []
for i in filepath:
    dataW2.append(np.loadtxt(i, skiprows = 2 , unpack = True))


#%% I plot only SQ22_22_3 for now
Vg = 0
n = 1
mu = 2

lim = 500

from scipy import interpolate

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
cm = 1/2.54  # centimeters in inches
plt.figure(figsize=(9/2*cm, 9/2*cm), dpi=600)

interp = []
for i in [0,1,2,3,4,5,6,8,9,10]:
    # plt.plot(dataW2[i][n],dataW2[i][mu], color = 'blue')
    
    f = interpolate.interp1d(dataW2[i][n], dataW2[i][mu], kind = 'nearest')
    xnew = np.arange(1e11, 6.3e11, 0.1e10)
    # plt.plot(xnew, f(xnew), color = 'r')
    interp.append(f(xnew))

interp = np.array(interp)

avg = interp.mean(0)
std = interp.std(0)

plt.plot(xnew*1e-11, avg*1e-5, color = 'purple')
plt.fill_between(xnew*1e-11, (avg-std)*1e-5, (avg+std)*1e-5 , alpha=0.5,lw = 0, color = 'purple')
plt.fill_between(xnew*1e-11, (avg-std)*1e-5, (avg+std)*1e-5 , alpha=0.3,lw = 0, color = 'purple')
plt.fill_between(xnew*1e-11, (avg-std)*1e-5, (avg+std)*1e-5 , alpha=0.1,lw = 0,color = 'purple')

plt.xlim(0,7)
plt.ylim(0,3.5)
plt.xlabel('n (10$^{11}$ cm$^{-2}$)')
plt.ylabel('$\mu$ (10$^{5}$ cm$^{2}$/Vs)')
