 #-*- coding: utf-8 -*-
"""
Created on Tue Jun 22 15:14:26 2021

I measured 4 devices from -0.5 to 0.5 T -> 11 steps

@author: david
"""

n_devices = 12 #Define the number of HB you measured

import glob
import matplotlib.pyplot as plt
import numpy as np
from scipy.optimize import curve_fit
import os
abspath = os.path.abspath(__file__)
dname = os.path.dirname(abspath)
os.chdir(dname)
#Figures tricks
plt.rcParams['figure.dpi'] = 230 #Note: this is helpuful for high dpi displays such as 4k display on Windows
plt.rcParams['figure.autolayout'] = True
plt.rc('font', size=12)

#%% Define the color palette

import numpy as np

# hex (string) to rgb (tuple3)
def hex2rgb(hex):
    hex_cleaned = hex.lstrip('#')
    return tuple(int(hex_cleaned[i:i+2], 16) for i in (0, 2 ,4))

# rgb (tuple3) to hex (string)
def rgb2hex(rgb):
    return '#' + ''.join([str('0' + hex(hh)[2:])[-2:] for hh in rgb])

# weighted mix of two colors in RGB space (takes and returns hex values)
def color_mixer(hex1, hex2, wt1=0.5):
    rgb1 = hex2rgb(hex1)
    rgb2 = hex2rgb(hex2)
    return rgb2hex(tuple([int(wt1 * tup[0] + (1.0 - wt1) * tup[1]) for tup in zip(rgb1, rgb2)]))

# create full palette
def create_palette(start_color, mid_color, end_color, num_colors):
    # set up steps
    # will create twice as many colors as asked for
    # to allow an explicit "mid_color" with both even and odd number of colors
    num_steps = num_colors  
    steps = np.linspace(0, 1, num_steps)[::-1]

    # create two halves of color values
    pt1 = [color_mixer(first_color, mid_color, wt) for wt in steps]
    pt2 = [color_mixer(mid_color,  last_color, wt) for wt in steps[1:]]

    # combine and subsample to get back down to 'num_colors'
    return (pt1 + pt2)[::2]

# the 3 colors you specified
first_color = rgb2hex([29,113,184]) #This is the color of Si
last_color  = rgb2hex([190,22,34])  #This is the color of Ge
mid_color   = '#fefefe'

# create hex colors
result = create_palette(first_color, mid_color, last_color, 100)

from matplotlib.colors import ListedColormap, LinearSegmentedColormap
# # my_rgbs = my_rgbs/254
my_cmap = ListedColormap(result)

#%% load files

# filepath = glob.glob(r'./CrosshHatch_Si_filetered.txt')
# data = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

filepath = glob.glob(r'./CrossHatch_Si_backgroundSubtracted.txt')
data = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

#%% plot the Si/Si vibration

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['ps.fonttype'] = 42

cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8.6/2*cm), dpi=600)

x = np.linspace(0,95,512) -45
y = np.linspace(0,95,512)-45

z = data

import matplotlib

# levels = matplotlib.ticker.MaxNLocatorMaxNLocator(nbins=15).tick_values(z.min(), z.max())
plt.xticks([-45,0,45])
plt.yticks([-45,0,45])

plt.xlim([-45,45])
plt.ylim([-45,45])

# cmap = plt.colormaps['Greens']
plt.pcolormesh(x,y,(z-np.mean(z))*1e9 ,cmap=my_cmap,vmin=-7,vmax = 7)
# plt.pcolormesh(x,y,(z-np.mean(z))*1e9 ,cmap=my_cmap,vmin=-7,vmax = 7)
cbar = plt.colorbar(orientation="horizontal",shrink = 0.5, location = 'top', ticks = ())
# cbar.set_label('z (nm)')

plt.xlabel('$x$ ($\mu$m)')
plt.ylabel('$y$ ($\mu$m)')
fig.savefig('Test.pdf', dpi=50)

#%% plot the Si/Si vibration
from scipy.fft import fft2

# Z_fft = np.fft.fft2(Z)
Z_fft = fft2(z, norm = 'ortho')

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['ps.fonttype'] = 42

freq_x = np.fft.fftfreq(x.size, x[1]-x[0])
freq_y = np.fft.fftfreq(y.size, y[1]-y[0])

Z_fft_shifted = np.fft.fftshift(Z_fft)
freq_x_shifted = np.fft.fftshift(freq_x)
freq_y_shifted = np.fft.fftshift(freq_y)

cm = 1/2.54 
fig = plt.figure(figsize=(9*cm, 7.5*cm), dpi=300)


plt.pcolormesh(freq_x_shifted,freq_y_shifted,np.abs(Z_fft_shifted)*1e9 ,cmap=my_cmap,vmax=100)
cbar = plt.colorbar()
cbar.set_label('Amplitude (a.u.)')
plt.xlabel('1/x (1/$\mu$m)')
plt.ylabel('1/y (1/$\mu$m)')
plt.xlim(-.5,.5)
plt.ylim(-.5,.5)
# cm = 1/2.54 
# fig = plt.figure(figsize=(9*cm, 7.5*cm), dpi=600)


# plt.pcolormesh(freq_x_shifted,freq_y_shifted,np.angle(Z_fft_shifted) ,cmap=my_cmap,vmax=100)
# cbar = plt.colorbar()
# cbar.set_label('Amplitude (a.u.)')
# plt.xlabel('1/x (1/$\mu$m)')
# plt.ylabel('1/y (1/$\mu$m)')


#%% histogram of the Si-Si vibration

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

cm = 1/2.54 
fig = plt.figure(figsize=(9*cm, 7.5*cm), dpi=600)

aux = z.reshape(-1)
aux = (aux-520.74)/723*100
delta_e_Si = (aux-np.mean(aux))/np.mean(aux)*100
plt.hist(delta_e_Si, bins =30)

plt.xlabel('$\Delta \epsilon/ \epsilon$ (%)')
plt.ylabel('counts')

print('mean = ', np.mean(aux))
print('std = ', np.std(aux))

plt.xlim(-8,8)

#%% correlation

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

cm = 1/2.54 
fig = plt.figure(figsize=(9*cm, 7.5*cm), dpi=600)

def lin(x,a,b):
    return a*x+b

x = data_SiSi_SiGe.ravel()
y = data_SiSi_QW.ravel()

plt.scatter(x,y, marker = '.')

plt.xlabel('Si-Si vibration in SiGe (cm$^{-1}$)')
plt.ylabel('Si-Si vibration in Si QW (cm$^{-1}$)')


xx = np.linspace(min(x),max(x),1000)
popt, covm  = curve_fit(lin,x,y)
plt.plot(xx,lin(xx,popt[0],popt[1]), color = 'black', lw = 2 )
print('a = ', popt[0], '+-', np.sqrt(covm[0][0]))

#%% strain of the QW

strain = (510.7-520.74)/723*100
dstrain = strain*(15/723)
print('strain = ', strain, '+-', dstrain)

#%% Ge concentration using the Si Si 

omega0 = 520
omega = 499.6
b_SiSi = 723
epsilon = 1.38/100

x = (omega- omega0-b_SiSi*epsilon)/66.9

print(x)



