 #-*- coding: utf-8 -*-
"""
Created on Tue Jun 22 15:14:26 2021

I measured 4 devices from -0.5 to 0.5 T -> 11 steps

@author: david
"""

n_devices = 12 #Define the number of HB you measured

import glob
import matplotlib.pyplot as plt
import numpy as np
from scipy.optimize import curve_fit
import os
abspath = os.path.abspath(__file__)
dname = os.path.dirname(abspath)
os.chdir(dname)
#Figures tricks
plt.rcParams['figure.dpi'] = 230 #Note: this is helpuful for high dpi displays such as 4k display on Windows
plt.rcParams['figure.autolayout'] = True
plt.rc('font', size=12)

#%% load files

filepath = glob.glob(r'./QT839 Si-Si in QW rotated.txt')
data_QW_839 = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

filepath = glob.glob(r'./QT839 Si-Si in SiGe rotated.txt')
data_SiGe_839 = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

filepath = glob.glob(r'./QT838-SiSi in QW-45 rotated.txt')
data_QW_838 = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

filepath = glob.glob(r'./QT838-SiSi in SiGe-45 rotated.txt')
data_SiGe_838 = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

#%% Define the color palette

import numpy as np

# hex (string) to rgb (tuple3)
def hex2rgb(hex):
    hex_cleaned = hex.lstrip('#')
    return tuple(int(hex_cleaned[i:i+2], 16) for i in (0, 2 ,4))

# rgb (tuple3) to hex (string)
def rgb2hex(rgb):
    return '#' + ''.join([str('0' + hex(hh)[2:])[-2:] for hh in rgb])

# weighted mix of two colors in RGB space (takes and returns hex values)
def color_mixer(hex1, hex2, wt1=0.5):
    rgb1 = hex2rgb(hex1)
    rgb2 = hex2rgb(hex2)
    return rgb2hex(tuple([int(wt1 * tup[0] + (1.0 - wt1) * tup[1]) for tup in zip(rgb1, rgb2)]))

# create full palette
def create_palette(start_color, mid_color, end_color, num_colors):
    # set up steps
    # will create twice as many colors as asked for
    # to allow an explicit "mid_color" with both even and odd number of colors
    num_steps = num_colors  
    steps = np.linspace(0, 1, num_steps)[::-1]

    # create two halves of color values
    pt1 = [color_mixer(first_color, mid_color, wt) for wt in steps]
    pt2 = [color_mixer(mid_color,  last_color, wt) for wt in steps[1:]]

    # combine and subsample to get back down to 'num_colors'
    return (pt1 + pt2)[::2]

# the 3 colors you specified
first_color = rgb2hex([29,113,184]) #This is the color of Si
last_color  = rgb2hex([190,22,34])  #This is the color of Ge
mid_color   = '#fefefe'

# create hex colors
result = create_palette(first_color, mid_color, last_color, 100)

from matplotlib.colors import ListedColormap, LinearSegmentedColormap
# # my_rgbs = my_rgbs/254
my_cmap = ListedColormap(result)

#%% plot the Si/Si vibration

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

cm = 1/2.54 
fig = plt.figure(figsize=(9*cm, 7.5*cm), dpi=300)

x = np.arange(-20,21.6,1.5)
y = np.arange(-20,21.6,1.5)

# z = data_QW_839
# z = data_SiGe_839
# z = data_QW_838
z = data_SiGe_838

import matplotlib

# cmap = plt.colormaps['PiYG']
plt.pcolormesh(x,y,z ,cmap=my_cmap)
plt.colorbar()

plt.xlabel('x ($\mu$m)')
plt.ylabel('y ($\mu$m)')

print(np.mean(z), np.std(z))


#%% histogram of the Si-Si vibration

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['ps.fonttype'] = 42

cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8/2*cm), dpi=300)

def gauss(x,A,x0,sigma):
    return A*np.exp(-(x-x0)**2/sigma**2)


aux = data_QW_838.reshape(-1) # This is for the 6nm QW
aux = (aux-520.7)/784*100
epsilon_QT838 = aux
weights = np.ones_like(epsilon_QT838) / len(epsilon_QT838) # I normalize the bins using the total number of entries. This way the height of each bin is counts/total entries, i.e., the probability
histo = plt.hist(epsilon_QT838, weights=weights, bins =30, color = 'purple',alpha = 0.99)

x = histo[1][1:]- (histo[1][2]-histo[1][1])/2 # histogram to the center of the bit -> change if you change the number of bins
y = histo[0]
xx = np.linspace(-1.50,-1,1000)
popt, covm  = curve_fit(gauss,x,y, maxfev = 1000000, p0 = [1,-1.38,0.2])
plt.plot(xx,gauss(xx,popt[0],popt[1], popt[2]), color = 'black', lw = 1 )

aux = data_QW_839.reshape(-1) # This is for the 6nm QW
aux = (aux-520.7)/784*100
epsilon_QT839 = aux
weights = np.ones_like(epsilon_QT839) / len(epsilon_QT839) # I normalize the bins using the total number of entries. This way the height of each bin is counts/total entries, i.e., the probability
histo = plt.hist(epsilon_QT839, weights=weights, bins =30, color = '#3d54a3',alpha = 0.99)

x = histo[1][1:]- (histo[1][2]-histo[1][1])/2 # histogram to the center of the bit -> change if you change the number of bins
y = histo[0]
xx = np.linspace(-1.50,-1,1000)
popt, covm  = curve_fit(gauss,x,y, maxfev = 1000000, p0 = [1,-1.2,0.2])
plt.plot(xx,gauss(xx,popt[0],popt[1], popt[2]), color = 'black', lw = 1 )


plt.xlabel('$\epsilon$ (%)')
plt.ylabel('probability')

print('mean_QT838_7nm QW = ', '{:.2f}'.format(np.mean(epsilon_QT838)), '+-', '{:.2f}'.format(np.std(epsilon_QT838)) )
print('mean_QT839_9nm QW = ', '{:.2f}'.format(np.mean(epsilon_QT839)), '+-', '{:.2f}'.format(np.std(epsilon_QT839)))

# plt.xlim(-10,10)

plt.xlim(-1.42,-1.18)
plt.xticks([-1.4,-1.3,-1.2])

#%% correlation

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['ps.fonttype'] = 42

def rgb_to_hex(r, g, b):
    return '#{:02x}{:02x}{:02x}'.format(r, g, b)

print(rgb_to_hex(61, 84, 163)) # this is the blue of the 9nm QW -> #3d54a3
print(rgb_to_hex(20, 123, 64)) # this is the green of the 5nm QW -> #147b40

cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8/2*cm), dpi=300)

def lin(x,a,b):
    return a*x+b

x = data_SiGe_839.ravel()
y = data_QW_839.ravel()
plt.scatter(x,y, marker = '.', alpha = 0.7, s =2, color = '#3d54a3')

xx = np.linspace(min(x),max(x),1000)
popt, covm  = curve_fit(lin,x,y)
plt.plot(xx,lin(xx,popt[0],popt[1]), color = 'black', lw = 1.5 )
print('Slope_9.0nmQW = ',  '{:.2f}'.format(popt[0]), '+-', '{:.2f}'.format(np.sqrt(covm[0][0])) )

x = data_SiGe_838.ravel()
y = data_QW_838.ravel()
plt.scatter(x,y,  marker = '.', alpha = 0.7, s =2, color = 'purple')

xx = np.linspace(min(x),max(x),1000)
popt, covm  = curve_fit(lin,x,y)
plt.plot(xx,lin(xx,popt[0],popt[1]), color = 'black', lw = 1.5 )
print('Slope_6.9nmQW = ',  '{:.2f}'.format(popt[0]), '+-', '{:.2f}'.format(np.sqrt(covm[0][0])) )
plt.yticks([510,511], labels = [510,511] )
plt.xticks([499,500], labels = [499,500])

# plt.scatter(x_1,y_1, marker = '.')

plt.xlabel('$\omega$ (cm$^{-1}$)')
plt.ylabel(' $\omega$ (cm$^{-1}$)')

# plt.legend()




