 #-*- coding: utf-8 -*-
"""
Created on Tue Jun 22 15:14:26 2021

I measured 4 devices from -0.5 to 0.5 T -> 11 steps

@author: david
"""

n_devices = 12 #Define the number of HB you measured

import glob
import matplotlib.pyplot as plt
import numpy as np
from scipy.optimize import curve_fit
import os
abspath = os.path.abspath(__file__)
dname = os.path.dirname(abspath)
os.chdir(dname)
#Figures tricks
plt.rcParams['figure.dpi'] = 230 #Note: this is helpuful for high dpi displays such as 4k display on Windows
plt.rcParams['figure.autolayout'] = True
plt.rc('font', size=12)

#%% load files

filepath = glob.glob(r'./QT838-SiSi in QW.txt')
data_SiSi_QW = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

filepath = glob.glob(r'./QT838-SiSi in SiGe.txt')
data_SiSi_SiGe = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

filepath = glob.glob(r'./QT838-SiGe in SiGe.txt')
data_SiGe = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

filepath = glob.glob(r'./QT838-GeGe in SiGe.txt')
data_GeGe = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

#%% load files tilted 45%

filepath = glob.glob(r'./QT838-SiSi in QW-45 rotated.txt')
data_SiSi_QW = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

filepath = glob.glob(r'./QT838-SiSi in SiGe-45 rotated.txt')
data_SiSi_SiGe = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

filepath = glob.glob(r'./QT838-SiGe in SiGe-45 rotated.txt')
data_SiGe = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

filepath = glob.glob(r'./QT838-GeGe in SiGe-45 rotated.txt')
data_GeGe = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

#%% Define the color palette

import numpy as np

# hex (string) to rgb (tuple3)
def hex2rgb(hex):
    hex_cleaned = hex.lstrip('#')
    return tuple(int(hex_cleaned[i:i+2], 16) for i in (0, 2 ,4))

# rgb (tuple3) to hex (string)
def rgb2hex(rgb):
    return '#' + ''.join([str('0' + hex(hh)[2:])[-2:] for hh in rgb])

# weighted mix of two colors in RGB space (takes and returns hex values)
def color_mixer(hex1, hex2, wt1=0.5):
    rgb1 = hex2rgb(hex1)
    rgb2 = hex2rgb(hex2)
    return rgb2hex(tuple([int(wt1 * tup[0] + (1.0 - wt1) * tup[1]) for tup in zip(rgb1, rgb2)]))

# create full palette
def create_palette(start_color, mid_color, end_color, num_colors):
    # set up steps
    # will create twice as many colors as asked for
    # to allow an explicit "mid_color" with both even and odd number of colors
    num_steps = num_colors  
    steps = np.linspace(0, 1, num_steps)[::-1]

    # create two halves of color values
    pt1 = [color_mixer(first_color, mid_color, wt) for wt in steps]
    pt2 = [color_mixer(mid_color,  last_color, wt) for wt in steps[1:]]

    # combine and subsample to get back down to 'num_colors'
    return (pt1 + pt2)[::2]

# the 3 colors you specified
first_color = rgb2hex([29,113,184]) #This is the color of Si
last_color  = rgb2hex([190,22,34])  #This is the color of Ge
mid_color   = '#fefefe'

# create hex colors
result = create_palette(first_color, mid_color, last_color, 100)

from matplotlib.colors import ListedColormap, LinearSegmentedColormap
# # my_rgbs = my_rgbs/254
my_cmap = ListedColormap(result)

#%% plot the Si/Si vibration

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8.6/2*cm), dpi=300)

x = np.arange(-20,21.6,1.5)
y = np.arange(-20,21.6,1.5)

plt.xlim([-20,20])
plt.ylim([-20,20])

# z = data_SiSi_QW
# z = data_SiSi_SiGe
# z = data_SiGe
z = data_GeGe

import matplotlib

# SiSi_QW = 510 511
# SiSi_SiGe = 499 500
# SiGe_SiGe = 404 406
# GeGe_SiGe = 287 290


# plt.pcolormesh(x,y,z ,cmap=my_cmap )
plt.pcolormesh(x,y,z ,cmap=my_cmap , vmin = 287, vmax = 290 )
cbar = plt.colorbar(orientation="horizontal",shrink = 0.5, location = 'top', ticks = (1.0,0.0))
# cbar.set_label('$\omega_{Si-Si}$ (cm$^{-1}$)')

# plt.tick_params(axis  ='both' , which  = 'both', length = 4 )

# plt.xticks([]),plt.yticks([])
plt.yticks([-20,0,20])
plt.xticks([-20,0,20])
plt.xlabel('$x$ ($\mu$m)')
plt.ylabel('$y$ ($\mu$m)')

#%% load all the spectra tilted 45% 

filepath = glob.glob(r'./QT838_45 rotated.txt')
data = np.loadtxt(filepath[0], skiprows = 1 , unpack = True)

filepath = glob.glob(r'./omega.txt')
omega = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

#%% 



aux = data[2:]
# aux = np.transpose(aux)

intensity = []

for i in np.arange(0,len(data)-2,1):
    # plt.scatter(omega[i],np.average(aux[i]))
    intensity.append(np.average(aux[i]))


#%% 

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

cm = 1/2.54 
fig = plt.figure(figsize=(8.6*cm, 8.6/2*cm), dpi=300)

plt.plot(omega, intensity)

plt.xlim(250,600)

plt.ylim(-100,6000)

plt.xlabel('$Raman\,Shift$ (cm$^{-1}$)')
plt.ylabel('$counts$ (a.u.)')

#%% 2D map of the over relaxation of the virtual substrate

from sympy import solve
from sympy.abc import x, y, z

#taken from Phonon strain shift coefficients in Si1−xGex alloys

b_SiSi = 723 #+- 15
b_GeGe = -450 #+- 30
b_SiGe = -570 #+- 50

omega_SiSi_0 = 520.7
omega_SiGe_0 = 400.1
omega_GeGe_0 = 280.3

def f1(x,epsilon,omega_SiSi):
    return omega_SiSi-omega_SiSi_0+66.9*x-b_SiSi*epsilon

def f2(x,epsilon,omega_SiGe):
    return omega_SiGe - omega_SiGe_0 - 24.5*x +4.5*x**2 + 33.5*x**3 - b_SiGe*epsilon

def f3(x,epsilon,omega_GeGe):
    return omega_GeGe - omega_GeGe_0 - 19.4*x - b_GeGe*epsilon 

def f1_e(x,omega_SiSi):
    return (omega_SiSi-omega_SiSi_0+66.9*x)/b_SiSi

def f2_e(x,omega_SiGe):
    return (omega_SiGe - omega_SiGe_0 - 24.5*x +4.5*x**2 + 33.5*x**3)/b_SiGe

def f3_e(x,omega_GeGe):
    return (omega_GeGe - omega_GeGe_0 - 19.4*x)/b_GeGe

xx = np.linspace(0.1,0.75,100)
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

cm = 1/2.54 
fig = plt.figure(figsize=(9*cm, 7.5*cm), dpi=600)

plt.plot(xx, f1_e(xx,data_SiSi_SiGe[0][0])*100, label = 'SiSi')
plt.plot(xx, f2_e(xx,data_SiGe[0][0])*100, label = 'SiGe')

# solution = solve([f1(x,y,data_SiSi_SiGe[0][0]), f2(x,y,data_SiGe[0][0])], x, y, real=True)

SiSi = data_SiSi_SiGe.flatten()
SiGe = data_SiGe.flatten()

epsilon = []
strain = []
for i in range(len(SiSi)):
    solution = solve([f1(x,y,SiSi[i]), f2(x,y,SiGe[i])], x, y)
    epsilon.append(float(solution[0][0]))
    strain.append(float(solution[0][1]))
    print(i)

#%%%

x = np.arange(-20,21.6,1.5)
y = np.arange(-20,21.6,1.5)
# z = np.reshape(np.array(epsilon),(28,28))
z = np.reshape(np.array(strain),(28,28))

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')

cm = 1/2.54 
fig = plt.figure(figsize=(9*cm, 7.5*cm), dpi=600)
plt.pcolormesh(x,y,z*100 ,cmap=my_cmap)
cbar = plt.colorbar()
cbar.set_label('Strain (%)', rotation=270)
plt.xlabel('x ($\mu$m)')
plt.ylabel('y ($\mu$m)')

print(np.mean(z), np.std(z))


#%% correlation coefficient


b_SiSi = 723 #+- 50 cm-1
b_GeGe = 440 #+- 50 cm-1
b_SiGe = 530 #+- 50 cm-1

#Vengard's law from https://journals.aps.org/prb/pdf/10.1103/PhysRevB.48.14276

a_Si = 0.5431  # nm
a_Ge = 0.5658  # nm

def a(x):
    return a_Si + 0.200326*x*(1-x) + (a_Ge - a_Si)*x**2

coefficient = b_SiSi/b_SiGe*(a(0.31)/a_Si)
print(coefficient)

#%% correlation coefficient SiGe 83

b_SiSi = 723 #+- 15 cm-1
b_GeGe = 440 #+- 50 cm-1
b_SiGe = 530 #+- 50 cm-1

a_Si = 0.5431 #nm
a_Ge = 0.5658  #nm

def a(x):
    return a_Si + 0.200326*x*(1-x) + (a_Ge - a_Si)*x**2

coefficient = b_GeGe/b_SiGe*(a(0.83)/a_Ge)
print(coefficient)

#%% calculating x from eq 8a
# Raman investigation of strain in heterostructures:
# Precise determination of the strain-shift coefficient of Si
# bands

a_SiSi = 61.7 # +- 0.7
omega_0 = 520.7
omega = 499.66

x = (omega_0 - omega)/a_SiSi
print(x)


