# -*- coding: utf-8 -*-
"""
Created on Mon Mar  7 11:00:21 2022

@author: david
"""

n_devices = 12 #Define the number of HB you measured

import glob
import matplotlib.pyplot as plt
import numpy as np
from scipy.optimize import curve_fit
import os
abspath = os.path.abspath(__file__)
dname = os.path.dirname(abspath)
os.chdir(dname)
#Figures
plt.rcParams['figure.dpi'] = 230 #Note: this is helpuful for high dpi displays such as 4k display on Windows
plt.rcParams['figure.autolayout'] = True
plt.rc('font', size=12)

#Define useful functions

def mobility(Bfield,Vxx,Vxy,L,W): # mobility in cm^2/Vs
    return abs((Vxy*L*1e4)/(Bfield*Vxx*W))

def n_H(Bfield,Isd,Vxy): # density of charge carriers in cm^-2
    return abs((Bfield*Isd*1e-4)/(1.60217662*1e-19*Vxy))

def rhoxx(Vxx,Isd,ratio): # in ohm/sq
    return abs((Vxx)/((Isd)*ratio))

def rhoxy(Vxy,Isd): # in ohm/sq
    return ((Vxy/(Isd)))

def lin(x,a,b):
    return a*x+b

#%% Loading all the files

filepath = glob.glob(r'./**/*.dat')
dataT = []
for i in filepath:
    dataT.append(np.loadtxt(i, skiprows = 3 , unpack = True))

#%% Dividing into Turn on and Turn off
# Vg_dac4_set	Bfield	Isd	Keithley	Vg	Vg_dac4	Vsd	Vxx	Vxy	sample
Vg_dac4_set,	Bfield,	Isd,Keithley,Vg,	Vg_dac4, Vsd, Vxx, Vxy,	sample = [0,1,2,3,4,5,6,7,8,9]

Turn_On = []
Turn_Off = []

for i in range(len(filepath)):
    if dataT[i][Vg_dac4][1] >   dataT[i][Vg_dac4][5]: #with 1 I take the turn off while with 0 Ill take the turn on
        Turn_On.append((dataT[i]))
    else:
        Turn_Off.append(dataT[(i)])
        
#%% selecting the files with the same sample
#  Vg_dac4_set	Bfield	I_leak	Isd_AC	Vg_dac4	Vg_dac9	Vsd	Vxx_AC	Vxy	sample
 #define the data range to use to calculate the MobDens. Note: start with currents as little as possible


for k in [1,2,3,4,5,6,7,8,9,10,11,12]:
    sample_no = k
    aux = []
    
    for i in range(len(Turn_On)):
        if Turn_On[i][sample][2] == sample_no:
            aux.append(Turn_On[i])

    for j in range(len(aux)):
        for i in range(len(aux[j][Isd])):
            if aux[j][Isd][i]> 0.8e-9 and aux[j][Isd][i]< 0.9e-9:
                a=i
        # plt.plot(aux[j][Vg_dac4_set][:a], aux[j][Isd][:a])

    for i in  range(len(aux)):
        fit = []
        for m in np.arange(0,a,1):
            aux1 = []
            aux2 = []
            for n in range(len(aux)):
                aux1.append(aux[n][Bfield][m])
                aux2.append(rhoxy(aux[n][Vxy][m] , aux[n][Isd][m]))
            aux1= np.array(aux1)
            aux2= np.array(aux2)
            popt0, covm0 = curve_fit(lin, aux1, aux2, maxfev = 1000)
            fit.append(popt0[0])
        fit= np.array(fit)  
        

    for i in range(len(aux)):
        if aux[i][Bfield][1]< 0.01 and aux[i][Bfield][1]> -0.01:
            aux0 = aux[i]
    
    fit= np.array(fit)
    n = 1e-4/((1.60217662*1e-19)*fit)
    plt.figure() # Mob dens
    mu = abs(1/(rhoxx(aux0[Vxx][:a], aux0[Isd][:a], 10)*n*(1.60217662*1e-19)))
    plt.plot(n, mu ,label = Turn_On[i][sample][0], )
    plt.ylabel('$ \mu$ [cm$^{2}/Vs $]')
    plt.xlabel('$n$ [cm$^{-2}$]')
    
    string = 'SQ22_160_6_Dev' + str(aux0[sample][0]) + '.txt'
    f=open(string,'w')
    f.write('#Vg [mV] \t n [cm-2] \t mu [cm2/Vs] \n')
    
    string = '#sample no' + str(aux0[sample][0]) + '\n'
    f.write(string)
    aux4 = aux0[Vg_dac4][:a]
    for m in range(len(n)):
        f.write('{0} \t {1} \t {2} \n'.format(aux4[m],n[m],mu[m]))
    f.close()
    print('sample_no = ',k)


