# -*- coding: utf-8 -*-
"""
Created on Tue Feb  7 09:13:54 2023

@author: david
"""

# 


from core_tools.data.ds.data_set import load_by_id, load_by_uuid
import numpy as np
import matplotlib.pyplot as plt
from scipy.signal import savgol_filter
from core_tools.data.ds.data_set import load_by_id, load_by_uuid
from core_tools.data.ds.ds_hdf5 import save_hdf5_uuid, load_hdf5_uuid

#Figures tricks
plt.rcParams['figure.dpi'] = 230 #Note: this is helpuful for high dpi displays such as 4k display on Windows

uuid = [1675365298260255110,
        1675369694773255110,
        1675374172802255110,
        1675378688896255110,
        1675383116499255110,
        1675387539174255110,
        1675392173980255110,
        1675396835978255110,
        1675401331663255110,
        1675406081290255110,
        1675410565470255110,
        1675415100412255110]

uuid = np.array(uuid)
for i in uuid:
# print(i)
    ds = load_hdf5_uuid(i,  r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper\QuantumDots\1_Dev1\slopes')
    x = ds.m1.x()
    y = ds.m1.y()
    
    plt.plot(x,y*1e9)

#%% find slope

peak = 0

ds = load_by_uuid(int(uuid[peak]))
x = ds.m1.x()*1e-3 # Vp in V
y = ds.m1.y() # Isd in A
plt.plot(x,y)
plt.ylabel('ISD (nA)')
plt.xlabel('V$_{P}$ (mV)')

plt.figure()
aux = np.gradient(y,x)
aux = savgol_filter(aux,7,2)
plt.plot(x,aux)
plt.ylabel('dISD/dV (A/V)')
plt.xlabel('V$_{P}$ (mV)')
plt.scatter(x[np.where(aux == max(aux))], max(aux), marker = 'o', label = peak+1)

print('slope = ', max(aux), 'A/V')
plt.legend()

#%% find slope

peak = 0
for i in [0,1,2,3,4,5,6,7,8,9]:
    ds = load_by_uuid(int(uuid[i]))
    x = ds.m1.x()*1e-3
    y = ds.m1.y()
    plt.figure(1)
    plt.plot(x,y*1e9)
    plt.scatter(x[np.where(y == max(y))], max(y*1e9), marker = 'o', label = i+1)
    plt.ylabel('ISD (nA)')
    plt.xlabel('V$_{P}$ (mV)')
    plt.figure(2)
    aux = np.gradient(y, x)
    aux = savgol_filter(aux,7,2)
    plt.plot(x,aux)
    plt.ylabel('dISD/dV (A/V)')
    plt.xlabel('V$_{P}$ (mV)')
    plt.scatter(x[np.where(aux == max(aux))], max(aux), marker = 'o', label = i+1)
    
    # print('slope = ', max(aux)*1e9, 'nA/V')
    print(max(aux))
plt.legend()