# -*- coding: utf-8 -*-
"""
Created on Wed May  3 14:28:44 2023

@author: david
"""

## needed imports 
import matplotlib.pyplot as plt
from quantify_core.data.handling import load_dataset, to_gridded_dataset, get_datadir
from scipy.signal import savgol_filter, find_peaks
import glob 
import numpy as np


#%% Define the color palette

import numpy as np

# hex (string) to rgb (tuple3)
def hex2rgb(hex):
    hex_cleaned = hex.lstrip('#')
    return tuple(int(hex_cleaned[i:i+2], 16) for i in (0, 2 ,4))

# rgb (tuple3) to hex (string)
def rgb2hex(rgb):
    return '#' + ''.join([str('0' + hex(hh)[2:])[-2:] for hh in rgb])

# weighted mix of two colors in RGB space (takes and returns hex values)
def color_mixer(hex1, hex2, wt1=0.5):
    rgb1 = hex2rgb(hex1)
    rgb2 = hex2rgb(hex2)
    return rgb2hex(tuple([int(wt1 * tup[0] + (1.0 - wt1) * tup[1]) for tup in zip(rgb1, rgb2)]))

# create full palette
def create_palette(start_color, mid_color, end_color, num_colors):
    # set up steps
    # will create twice as many colors as asked for
    # to allow an explicit "mid_color" with both even and odd number of colors
    num_steps = num_colors  
    steps = np.linspace(0, 1, num_steps)[::-1]

    # create two halves of color values
    pt1 = [color_mixer(first_color, mid_color, wt) for wt in steps]
    pt2 = [color_mixer(mid_color,  last_color, wt) for wt in steps[1:]]

    # combine and subsample to get back down to 'num_colors'
    return (pt1 + pt2)[::2]

# the 3 colors you specified
first_color = rgb2hex([29,113,184]) #This is the color of Si
last_color  = rgb2hex([190,22,34])  #This is the color of Ge
mid_color   = '#fefefe'

# create hex colors
result = create_palette(first_color, mid_color, last_color, 100)

from matplotlib.colors import ListedColormap, LinearSegmentedColormap
# # my_rgbs = my_rgbs/254
my_cmap = ListedColormap(result)

#%%


Vs_6dot_paper_0 =  [160,130,7,173]
Vs_6dot_paper_1 =  [119,160.8,113.4,160.9, 56.8, 148.4]
Vs_6dot_paper_2 =  [220,140,105,138,220,300]

Vs_Brian_A = [182.3, 170.4, 176.3, 96.6, 129,49.4,35.7,52.6,104,79.6]
Vs_Brian_B = [82.1,81.7,85.7,47.2,23,173,118.9,160.9,56.8,148.4]

QI_1 = [205,173,209,252,269,307]
QI_2 = [306,303,97]

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['ps.fonttype'] = 42

cm = 1/2.54 

fig, ax1 = plt.subplots(figsize=(8.8/2*cm, 8.0/2*cm), dpi=600)

#Plot 7nm QW

QI_tot = np.concatenate((QI_1, QI_2))
QI_tot = QI_tot/1000

ff = np.linspace(0.0,0.5,len(QI_tot))
xx = np.linspace(0.1,0.45,len(QI_tot))
plt.scatter(xx,QI_tot, s=7, facecolors='none', edgecolors='purple')
plt.plot(ff,np.mean(QI_tot) +0*xx, lw= 1, linestyle = '--', color = 'purple')
plt.fill_between(ff, np.mean(QI_tot)+np.std(QI_tot) +0*xx, np.mean(QI_tot)-np.std(QI_tot) +0*xx
                 , alpha=0.2, color = 'purple', linestyle ='None', lw = 0)

print('VS mean 7nm QW = ', '{:.0f}'.format(np.mean(QI_tot)) , '+-', '{:.0f}'.format(np.std(QI_tot)) ,'(ueV)' )

#Plot Stefan paper 

Vs_6dot_total = np.concatenate((Vs_6dot_paper_0, Vs_6dot_paper_1,Vs_6dot_paper_2))
Vs_6dot_total = Vs_6dot_total/1000

xx = np.linspace(0.55,0.95,len(Vs_6dot_total))
ff = np.linspace(0.5,1,len(Vs_6dot_total))
plt.scatter(xx,Vs_6dot_total, s=7, facecolors='none', edgecolors= '#3d54a3')
plt.plot(ff,np.mean(Vs_6dot_total) +0*xx, lw= 1, linestyle = '--', color = '#3d54a3')
plt.fill_between(ff, np.mean(Vs_6dot_total)+np.std(Vs_6dot_total) +0*xx, np.mean(Vs_6dot_total)-np.std(Vs_6dot_total) +0*xx
                 , alpha=0.2, color =  '#3d54a3', linestyle ='None', lw = 0)

print('VS mean 9nm QW = ', '{:.0f}'.format(np.mean(Vs_6dot_total)) , '+-', '{:.0f}'.format(np.std(Vs_6dot_total)) ,'(ueV)' )


plt.tick_params(
    axis='x',          # changes apply to the x-axis
    which='both',      # both major and minor ticks are affected
    bottom=True,      # ticks along the bottom edge are off
    top=True,         # ticks along the top edge are off
    labelbottom=True) # labels along the bottom edge are off

plt.ylabel('$E_{VS}$ (meV)')
plt.ylim(0,0.35)
plt.xlim(-0.1,1.1)

plt.xticks([0.25, 0.75],['6.9','9.0'])
plt.xlabel('w (nm)')

plt.yticks([0.0,0.1, 0.2,0.3])

ax2 = ax1.twinx() 
ax2.set_ylim(0, 4.061583752158)
plt.ylabel('$E_{VS}$ (K)')

#%%

from scipy.stats import ttest_ind

population1 = Vs_6dot_total
population2 = QI_tot

#equal_var = False assumes that the two distributions have different standard deviations

results = ttest_ind(population1,population2, equal_var = False)

print('Delta sigma = ', '{:.2f}'.format(results[0]) )
print('p-value = ', '{:.2f}'.format(results[1]*100), '%')

