# -*- coding: utf-8 -*-
"""
Created on Wed May  3 14:28:44 2023

@author: david
"""

## needed imports 
import matplotlib.pyplot as plt
from quantify_core.data.handling import load_dataset, to_gridded_dataset, get_datadir
from scipy.signal import savgol_filter, find_peaks
import glob 
import numpy as np


#%% Define the color palette

import numpy as np

# hex (string) to rgb (tuple3)
def hex2rgb(hex):
    hex_cleaned = hex.lstrip('#')
    return tuple(int(hex_cleaned[i:i+2], 16) for i in (0, 2 ,4))

# rgb (tuple3) to hex (string)
def rgb2hex(rgb):
    return '#' + ''.join([str('0' + hex(hh)[2:])[-2:] for hh in rgb])

# weighted mix of two colors in RGB space (takes and returns hex values)
def color_mixer(hex1, hex2, wt1=0.5):
    rgb1 = hex2rgb(hex1)
    rgb2 = hex2rgb(hex2)
    return rgb2hex(tuple([int(wt1 * tup[0] + (1.0 - wt1) * tup[1]) for tup in zip(rgb1, rgb2)]))

# create full palette
def create_palette(start_color, mid_color, end_color, num_colors):
    # set up steps
    # will create twice as many colors as asked for
    # to allow an explicit "mid_color" with both even and odd number of colors
    num_steps = num_colors  
    steps = np.linspace(0, 1, num_steps)[::-1]

    # create two halves of color values
    pt1 = [color_mixer(first_color, mid_color, wt) for wt in steps]
    pt2 = [color_mixer(mid_color,  last_color, wt) for wt in steps[1:]]

    # combine and subsample to get back down to 'num_colors'
    return (pt1 + pt2)[::2]

# the 3 colors you specified
first_color = rgb2hex([29,113,184]) #This is the color of Si
last_color  = rgb2hex([190,22,34])  #This is the color of Ge
mid_color   = '#fefefe'

# create hex colors
result = create_palette(first_color, mid_color, last_color, 100)

from matplotlib.colors import ListedColormap, LinearSegmentedColormap
# # my_rgbs = my_rgbs/254
my_cmap = ListedColormap(result)

#%%

CN_Dev1_1 =  [0.629,0.894,1.536,0.885, 1.301, 0.434, 0.687, 1.078, 0.589, 1.295]
CN_Dev2_1 =  [0.68,0.651,0.693,1.282,0.545,0.613,0.321]

CN_7nmQW = np.concatenate((CN_Dev1_1,CN_Dev2_1))

QT712sample2 = np.array([0.37171124936504196, 0.4952512362334575, 0.7068158692510337, 0.499013759162294, 0.287850724289347, 0.5740895951615889, 0.3981242304342678, 0.442311035342603, 0.32048017705972964, 0.3566376336799446] )#
QT712sample3 = np.array([0.6829924337780191, 0.6023313516436046, 0.4928849875810887, 0.7480340447540155, 0.5640862502665545, 0.6251832922960793, 0.40101299561337433, 0.40731640040635253, 0.5793152422823805,0.7518219288803235] )#
QT712sample4 = np.array([3.5775408988474315, 0.8224793893110761, 0.9308698118220636, 2.6279777728501528, 1.7047657191852554, 4.05591179219669, 0.6573027301510449, 1.4297090965272505, 1.252563305056246, 0.8980715260848259, 0.6859207867216015, 0.6205630949503094, 0.26204894198049394, 0.37422392539596344, 0.3757835917817389, 0.6377526381631393, 0.5621542760868016, 0.3515095806051314, 0.2604887909152638, 0.3553018886268044, 0.3845422864870642, 0.28566305724222246] )#
QT712sample5 = np.array([0.3224636831871508, 0.741049562753047, 0.6318600605714176, 0.3278557286650256, 0.32005373731547543, 0.4017999697307898, 0.6155760612634841, 0.2967561926966546, 0.40219445088935024, 0.3035417030525368] )
QT712sample4_4  = np.array([0.8636617817179071, 6.712505466109686, 0.8115669851414574, 4.824655066879308, 0.4961536933697024, 0.4229629173036124, 0.42617160210158767, 0.5782769615298542, 2.757224408046748, 0.15026571582454076, 0.39750772479880303] )

CN_paper_5nmQW = np.concatenate([QT712sample2 ,QT712sample3 ,QT712sample4 ,QT712sample5 ,QT712sample4_4])

#%%
plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')


cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8.6/2*cm), dpi=600)

#Plot 7nm QW

xx = np.linspace(0.55,0.95,len(CN_7nmQW))
ff = np.linspace(0.5,1,len(CN_7nmQW))

plt.scatter(xx,CN_7nmQW, s=6, facecolors='none', edgecolors='purple')
plt.plot(ff,np.mean(CN_7nmQW) +0*xx, lw= 1, linestyle = '--', color = 'purple')
plt.fill_between(ff, np.mean(CN_7nmQW)+np.std(CN_7nmQW) +0*xx, np.mean(CN_7nmQW)-np.std(CN_7nmQW) +0*xx
                 , alpha=0.2, color = 'purple', linestyle ='None', lw = 0)

#Plot Stefan paper 

ff = np.linspace(0.0,0.5,len(CN_paper_5nmQW))
xx = np.linspace(0.05,0.45,len(CN_paper_5nmQW))

import random
ciao = random.shuffle(CN_paper_5nmQW)

plt.scatter(xx,CN_paper_5nmQW, s=3, facecolors='none', edgecolors= '#147b40', marker = 'D')
plt.plot(ff,np.mean(CN_paper_5nmQW) +0*xx, lw= 1, linestyle = '--', color = '#147b40')
plt.fill_between(ff, np.mean(CN_paper_5nmQW)+np.std(CN_paper_5nmQW) +0*xx, np.mean(CN_paper_5nmQW)-np.std(CN_paper_5nmQW) +0*xx
                 , alpha=0.2, color = 'green', linestyle ='None', lw = 0)


print('CN mean 7nm QW = ', '{:.3f}'.format(np.mean(CN_7nmQW)) , '+-', '{:.3f}'.format(np.std(CN_7nmQW))  )
print('CN mean 5nm QW = ', '{:.3f}'.format(np.mean(CN_paper_5nmQW)) , '+-', '{:.3f}'.format(np.std(CN_paper_5nmQW))  )

#
plt.tick_params(
    axis='x',          # changes apply to the x-axis
    which='both',      # both major and minor ticks are affected
    bottom=True,      # ticks along the bottom edge are off
    top=True,         # ticks along the top edge are off
    labelbottom=True) # labels along the bottom edge are off

plt.ylabel('$S_{\epsilon}^{1/2} (1\, Hz)$ ($\mu$eV/Hz$^{1/2}$)')
plt.xlabel('t (nm)')
plt.yscale('log')
plt.ylim(0.1,10)
plt.xlim(-0.1,1.1)

plt.xticks([0.25, 0.75],['5.3','6.9'])

#%%

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')


cm = 1/2.54 
fig = plt.figure(figsize=(9/2*cm, 7.5/2*cm), dpi=600)

plt.plot(xx,xx, color = my_cmap(0.0))

#%%

import seaborn as sns
import matplotlib.pyplot as plt
from matplotlib.pyplot import figure
from scipy import stats

colors = ['purple','blue','green']

plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42
plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')


cm = 1/2.54 
fig = plt.figure(figsize=(9/2*cm, 7.5/2*cm), dpi=600)

plt.violinplot(CN_paper_5nmQW,positions = [5.3], showextrema = False, widths = [1.7])
plt.violinplot(CN_7nmQW,positions = [6.9], showextrema = False, widths = [1.7])

# plt.boxplot(CN_paper_5nmQW, positions=[5.3], widths = 0.3, patch_artist=True, 
#             boxprops=dict(facecolor='green', linewidth=1), 
#             medianprops = dict(color='black', linewidth=0.75), 
#             whiskerprops = dict(color='black', linewidth=0.75 ), 
#             capprops = dict(color='black', linewidth=0.75) )     
# plt.boxplot(CN_7nmQW,positions=[6.9],widths = 0.3, patch_artist=True, 
#             boxprops=dict(facecolor='purple', linewidth=1), 
#             medianprops = dict(color='black', linewidth=0.75), 
#             whiskerprops = dict(color='black', linewidth=0.75 ), 
#             capprops = dict(color='black', linewidth=0.75)) 

#
plt.tick_params(
    axis='x',          # changes apply to the x-axis
    which='both',      # both major and minor ticks are affected
    bottom=True,      # ticks along the bottom edge are off
    top=True,         # ticks along the top edge are off
    labelbottom=True) # labels along the bottom edge are off

plt.ylabel('$S_{\epsilon}^{1/2} (1\, Hz)$ ($\mu$eV/Hz$^{1/2}$)')
plt.xlabel('t (nm)')
plt.yscale('log')
plt.ylim(0.1,10)
# plt.xlim(-0.1,1.1)

# plt.xticks([0.25, 0.75],['5.3','6.9'])

