# -*- coding: utf-8 -*-
"""
Created on Thu Oct  7 12:46:40 2021

@author: david
"""

#Imports
import matplotlib.pyplot as plt
import numpy as np
from scipy.optimize import curve_fit
from scipy.signal import savgol_filter
import glob
import os
abspath = os.path.abspath(__file__)
dname = os.path.dirname(abspath)
os.chdir(dname)

#Figures tricks
plt.rcParams['figure.dpi'] = 230 #Note: this is helpuful for high dpi displays such as 4k display on Windows
plt.rcParams['figure.autolayout'] = True
plt.rc('font', size=12)

cmap = plt.cm.get_cmap('Spectral')

# Define percolation function 
def percolation(n,a,np):
    return a*(n-np)**(1.31) 
def lin(x,a,b):
    return a*x + b

#Physical constants

e = 1.60217662*1e-19 # C
h = 6.62606057*1e-34 # m^2 kg/s

#%% importing data

filepath = glob.glob(r'./*.txt')
dataT = []
for i in filepath:
    dataT.append(np.loadtxt(i, skiprows = 0 , unpack = True))
    
QW8nm = np.concatenate((dataT[0], dataT[3]), axis=1)
QW6nm = dataT[4]
QW4nm = np.concatenate((dataT[1], dataT[2]), axis=1)


# dataT=[]
# dataT = [HTcap,LTcap,ThinQW]


#%% boxPlot Mobility density

import seaborn as sns
import matplotlib.pyplot as plt
from matplotlib.pyplot import figure
from scipy import stats
colors = ['blue','purple','green']

plt.style.use('seaborn-ticks')
plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42

aux1 = QW8nm[0]/1e5     #data 1 array 1nm cap
aux2 = QW6nm[0]/1e5     # data 2 array 500C cap
aux3 = QW4nm[0]/1e5     # data3 array 4nm QW

cms = 1/2.54

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
cm = 1/2.54  # centimeters in inches
# plt.figure(figsize=(9/2*cm, 9/2*cm), dpi=300)
x = [5.3,6.9,9.0]

fig = plt.figure(figsize=(9/2*cm, 9/2*cm), dpi=600)
ax = fig.add_subplot(111)

y0 = aux1
y1 = aux2
y2 = aux3
y = np.concatenate((y0,y1,y2),axis=0)

plt.violinplot(y0,positions = [9.0], showextrema = False, widths = [1.7])
plt.violinplot(y1,positions = [6.9], showextrema = False, widths = [1.7])
plt.violinplot(y2,positions = [5.3], showextrema = False, widths = [1.7])


plt.boxplot(aux1, positions=[9.0], widths = 0.3, patch_artist=True, 
            boxprops=dict(facecolor=colors[0], linewidth=1), 
            medianprops = dict(color='black', linewidth=0.75), 
            whiskerprops = dict(color='black', linewidth=0.75 ), 
            capprops = dict(color='black', linewidth=0.75) )     
plt.boxplot(aux2,positions=[6.9],widths = 0.3, patch_artist=True, 
            boxprops=dict(facecolor=colors[1], linewidth=1), 
            medianprops = dict(color='black', linewidth=0.75), 
            whiskerprops = dict(color='black', linewidth=0.75 ), 
            capprops = dict(color='black', linewidth=0.75)) 
plt.boxplot(aux3,positions=[5.3],widths = 0.3, patch_artist=True, 
            boxprops=dict(facecolor=colors[2], linewidth=1), 
            medianprops = dict(color='black', linewidth=0.75), 
            whiskerprops = dict(color='black', linewidth=0.75 ), 
            capprops = dict(color='black', linewidth=0.75))


plt.ylabel('$\mu$ (10$^5$ cm$^{2}$/Vs)')
# plt.xlim(-0.3,0.3)
# plt.ylim(0,3)
plt.xticks(ticks = [5,7,9],labels=['5','7','9'])
plt.xlabel('$t$ (nm)')
# plt.xticks(ticks = [5,7,9])

# plt.xticks(ticks = [],labels='')
plt.yticks(ticks = [0,1,2,3])

plt.xlim(4,10)
plt.ylim(0,3.5)

#%% Violins percolation

import seaborn as sns
import matplotlib.pyplot as plt
from scipy import stats
colors = ['blue','purple','green']

plt.style.use('seaborn-ticks')
plt.rcParams['figure.autolayout'] = False
plt.rcParams['figure.constrained_layout.use'] = True
plt.rcParams['pdf.fonttype'] = 42

aux1 = QW8nm[1]/1e11     #data 1 array 1nm cap
aux2 = QW6nm[1]/1e11    # data 2 array 500C cap
aux3 = QW4nm[1]/1e11     # data3 array 4nm QW

cms = 1/2.54

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
cm = 1/2.54  # centimeters in inches
# plt.figure(figsize=(9/2*cm, 9/2*cm), dpi=300)

fig = plt.figure(figsize=(9/2*cm, 9/2*cm), dpi=600)
ax = fig.add_subplot(111)

y0 = aux1
y1 = aux2
y2 = aux3
y = np.concatenate((y0,y1,y2),axis=0)

plt.violinplot(y0,positions = [9.0], showextrema = False, widths = [1.7])
plt.violinplot(y1,positions = [6.9], showextrema = False, widths = [1.7])
plt.violinplot(y2,positions = [5.3], showextrema = False, widths = [1.7])


plt.boxplot(aux1, positions=[9.0], widths = 0.3, patch_artist=True, 
            boxprops=dict(facecolor=colors[0], linewidth=1), 
            medianprops = dict(color='black', linewidth=0.75), 
            whiskerprops = dict(color='black', linewidth=0.75 ), 
            capprops = dict(color='black', linewidth=0.75),
            whis  = 2)     
plt.boxplot(aux2,positions=[6.9],widths = 0.3, patch_artist=True, 
            boxprops=dict(facecolor=colors[1], linewidth=1), 
            medianprops = dict(color='black', linewidth=0.75), 
            whiskerprops = dict(color='black', linewidth=0.75 ), 
            capprops = dict(color='black', linewidth=0.75),
            whis  = 2) 
plt.boxplot(aux3,positions=[5.3],widths = 0.3, patch_artist=True, 
            boxprops=dict(facecolor=colors[2], linewidth=1), 
            medianprops = dict(color='black', linewidth=0.75), 
            whiskerprops = dict(color='black', linewidth=0.75 ), 
            capprops = dict(color='black', linewidth=0.75),
            whis  = 2)


plt.ylabel('$\mu$ (10$^5$ cm$^{2}$/Vs)')
# plt.xlim(-0.3,0.3)
# plt.ylim(0,3)
plt.xticks(ticks = [5,7,9],labels=['5','7','9'])
plt.xlabel('$t_{QW}$ (nm)')
# plt.xticks(ticks = [5,7,9])

# plt.xticks(ticks = [],labels='')
# plt.yticks(ticks = [0,1,2,3])
plt.yticks(ticks = [0.6,1,1.4])

plt.xlim(4,10)
plt.ylim(0.5,1.5)

