 #-*- coding: utf-8 -*-
"""
Created on Tue Jun 22 15:14:26 2021

I measured 4 devices from -0.5 to 0.5 T -> 11 steps

@author: david
"""

n_devices = 12 #Define the number of HB you measured

import glob
import matplotlib.pyplot as plt
import numpy as np
from scipy.optimize import curve_fit
import os
abspath = os.path.abspath(__file__)
dname = os.path.dirname(abspath)
os.chdir(dname)
#Figures tricks
plt.rcParams['figure.dpi'] = 230 #Note: this is helpuful for high dpi displays such as 4k display on Windows
plt.rcParams['figure.autolayout'] = True
plt.rc('font', size=12)

#%% Define the color palette

import numpy as np

# hex (string) to rgb (tuple3)
def hex2rgb(hex):
    hex_cleaned = hex.lstrip('#')
    return tuple(int(hex_cleaned[i:i+2], 16) for i in (0, 2 ,4))

# rgb (tuple3) to hex (string)
def rgb2hex(rgb):
    return '#' + ''.join([str('0' + hex(hh)[2:])[-2:] for hh in rgb])

# weighted mix of two colors in RGB space (takes and returns hex values)
def color_mixer(hex1, hex2, wt1=0.5):
    rgb1 = hex2rgb(hex1)
    rgb2 = hex2rgb(hex2)
    return rgb2hex(tuple([int(wt1 * tup[0] + (1.0 - wt1) * tup[1]) for tup in zip(rgb1, rgb2)]))

# create full palette
def create_palette(start_color, mid_color, end_color, num_colors):
    # set up steps
    # will create twice as many colors as asked for
    # to allow an explicit "mid_color" with both even and odd number of colors
    num_steps = num_colors  
    steps = np.linspace(0, 1, num_steps)[::-1]

    # create two halves of color values
    pt1 = [color_mixer(first_color, mid_color, wt) for wt in steps]
    pt2 = [color_mixer(mid_color,  last_color, wt) for wt in steps[1:]]

    # combine and subsample to get back down to 'num_colors'
    return (pt1 + pt2)[::2]

# the 3 colors you specified
first_color = rgb2hex([29,113,184]) #This is the color of Si
last_color  = rgb2hex([190,22,34])  #This is the color of Ge
mid_color   = '#fefefe'

# create hex colors
result = create_palette(first_color, mid_color, last_color, 100)

from matplotlib.colors import ListedColormap, LinearSegmentedColormap
# # my_rgbs = my_rgbs/254
my_cmap = ListedColormap(result)

#%% load files

filepath = glob.glob(r'./QT838-SiSi in QW-45 rotated.txt')
data_SiSi_QW_45 = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

filepath = glob.glob(r'./QT838-SiSi in SiGe-45 rotated.txt')
data_SiSi_SiGe_45 = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

filepath = glob.glob(r'./QT838-SiGe in SiGe-45 rotated.txt')
data_SiGe_SiGe_45 = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

filepath = glob.glob(r'./QT838-GeGe in SiGe-45 rotated.txt')
data_GeGe_SiGe_45 = np.loadtxt(filepath[0], skiprows = 0 , unpack = True)

#%% plot the Si/Si vibration

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['ps.fonttype'] = 42
# plt.rcParams['font.size'] = 1

cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8.6/2*cm), dpi=600)

x = np.arange(-20,21.6,1.5)
y = np.arange(-20,21.6,1.5)

plt.xlim([-20,20])
plt.ylim([-20,20])

z = data_SiSi_QW_45
# z = data_SiSi_SiGe_45
# z = data_SiSiR
# z = data_SiGe

print('\nSi-Si in the QW = ', '{:.2f}'.format(np.mean(data_SiSi_QW_45)), '+-', '{:.2f}'.format(np.std(data_SiSi_QW_45)) )
print('\nSi-Si in the VS = ', '{:.2f}'.format(np.mean(data_SiSi_SiGe_45)), '+-', '{:.2f}'.format(np.std(data_SiSi_SiGe_45)) )
print('\nSi-Ge in the VS = ', '{:.2f}'.format(np.mean(data_SiGe_SiGe_45)), '+-', '{:.2f}'.format(np.std(data_SiGe_SiGe_45)) )
print('\nGe-Ge in the VS = ', '{:.2f}'.format(np.mean(data_GeGe_SiGe_45)), '+-', '{:.2f}'.format(np.std(data_GeGe_SiGe_45)), '\n')

import matplotlib

# levels = matplotlib.ticker.MaxNLocatorMaxNLocator(nbins=15).tick_values(z.min(), z.max())
# norm = BoundaryNorm(levels, ncolors=cmap.N, clip=True)

# cmap = plt.colormaps['Greens']
plt.pcolormesh(x,y,z ,cmap=my_cmap, vmin = 510 , vmax = 511 )
cbar = plt.colorbar(orientation="horizontal",shrink = 0.5, location = 'top', ticks = (1.0,0.0))
# cbar.set_label('$\omega_{Si-Si}$ (cm$^{-1}$)')

# plt.tick_params(axis  ='both' , which  = 'both', length = 4 )

# plt.xticks([]),plt.yticks([])
plt.yticks([-20,0,20])
plt.xticks([-20,0,20])
plt.xlabel('$x$ ($\mu$m)')
plt.ylabel('$y$ ($\mu$m)')

#%% panel c

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['ps.fonttype'] = 42

cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8/2*cm), dpi=300)

def lin(x,a,b):
    return a*x+b

x = data_SiSi_SiGe_45.ravel()
y = data_SiSi_QW_45.ravel()

plt.scatter(x,y, marker = '.', alpha = 0.7, s =2, color = 'purple')

plt.xlabel('$\omega^{VS}_{Si-Si}$ (cm$^{-1}$)')
plt.ylabel('$\omega^{QW}_{Si-Si}$ (cm$^{-1}$)')

plt.yticks([510,511], labels = [510,511] )
plt.xticks([499,500], labels = [499,500])


plt.ylim(509.7,511)
plt.xlim(498.9,500.)



xx = np.linspace(min(x),max(x),1000)
popt, covm  = curve_fit(lin,x,y)
plt.plot(xx,lin(xx,popt[0],popt[1]), color = 'black', lw = 1 )
print('a = ', popt[0], '+-', np.sqrt(covm[0][0]))


#%% Panel d

plt.style.use(r'W:\staff-groups\tnw\ns\qt\ScappucciLab\0_Group members\Davide\6nm_QW_paper/Style.mplstyle')
plt.rcParams['pdf.fonttype'] = 42
plt.rcParams['ps.fonttype'] = 42

cm = 1/2.54 
fig = plt.figure(figsize=(8.6/2*cm, 8/2*cm), dpi=300)

aux = z.reshape(-1)
aux = (aux-520.7)/784*100
delta_e_Si = (aux-np.mean(aux))/np.mean(aux)*100
weights = np.ones_like(delta_e_Si) / len(delta_e_Si) 
histo = plt.hist(delta_e_Si, weights=weights, bins =30, color = 'purple',alpha = 0.99)

plt.xlabel('$\Delta \epsilon/ \epsilon$ (%)')
plt.ylabel('Probability')

# plt.plot(histo[1][1:]-0.2,histo[0])

x = histo[1][1:]-0.2 # histogram to the center of the bit -> change if you change the number of bins
y = histo[0]

def gauss(x,A,x0,sigma):
    return A*np.exp(-(x-x0)**2/sigma**2)

xx = np.linspace(-10,10,1000)
popt, covm  = curve_fit(gauss,x,y)
plt.plot(xx,gauss(xx,popt[0],popt[1], popt[2]), color = 'black', lw = 1 )

print('mean = ', '{:.2f}'.format(np.mean(aux)), '+-', '{:.2f}'.format(np.std(aux)))
print('std = ', '{:.2f}'.format(popt[2]) ,'+-', '{:.2f}'.format(np.sqrt(covm[2][2])) )

plt.xlim(-10,10)




