import numpy as np
import matplotlib.pyplot as plt

import matplotlib.pyplot as mpl

mpl.rc('font', family='sans-serif')
mpl.rc('text', usetex=True)

fig, axs = plt.subplots(3,3)

# Filenames
datas = ['Fig6_D1_2D.txt', \
         'Fig6_D2_2D.txt', \
         'Fig6_D3_2D.txt']


figlabel = ['$(a)$', \
            '$(b)$', \
            '$(c)$', \
            '$(d)$', \
            '$(e)$', \
            '$(f)$', \
            '$(g)$', \
            '$(h)$', \
            '$(i)$']

#my_cmap     = 'coolwarm'
#my_cmap     = 'RdYlGn'
#my_cmap     = 'turbo'
my_cmap     = 'jet'
#my_cmap     = 'viridis'
#my_fontname = "Liberation Serif"
my_fontname = "FreeSerif"
my_fontsize = 20
my_density  = 1.5
my_streamline_color = 'k'
plt.rc('font', size=18) #controls default text size
plt.rc('axes', titlesize=20) #fontsize of the title
plt.rc('axes', labelsize=20) #fontsize of the x and y labels
plt.rc('xtick', labelsize=20) #fontsize of the x tick labels
plt.rc('ytick', labelsize=20) #fontsize of the y tick labels
plt.rc('legend', fontsize=20) #fontsize of the legend

sizeX = 351
sizeY = 351

#--------------------------------------------------
X    = np.zeros(shape=(sizeX,sizeY))
Y    = np.zeros(shape=(sizeX,sizeY))
UfWf = np.zeros(shape=(sizeX,sizeY))
U    = np.zeros(shape=(sizeX,sizeY))
W    = np.zeros(shape=(sizeX,sizeY))
Vf   = np.zeros(shape=(sizeX,sizeY))
Vp   = np.zeros(shape=(sizeX,sizeY))


# Plot the circle
theta = np.linspace(0, 2 * np.pi, 100)
pc = 11.
radius = 10.
Cx = radius * np.cos(theta)
Cy = radius * np.sin(theta)

#--------------------------------------------------
# Arrow Scaling
arrow_mp = [1.6,1.1,0.7]

#--------------------------------------------------
for index in range(0,3):
    print('dataset : ',index+1)
    data = np.loadtxt(datas[index])
    for i in range (0,sizeX):
        for j in range (0,sizeY):
            X[i,j]    =  data[i*sizeY + j,0]
            Y[i,j]    =  data[i*sizeY + j,1]
            if (((X[i,j]-pc)**2. + (Y[i,j]-pc)**2.)**0.5 < radius):
                U[i,j]    =  data[i*sizeY + j,2]
                W[i,j]    =  data[i*sizeY + j,3]
                UfWf[i,j] =  data[i*sizeY + j,4]
                Vf[i,j]   =  data[i*sizeY + j,5]
                Vp[i,j]   =  data[i*sizeY + j,6]
            else:
                U[i,j]    = 0.0 
                W[i,j]    = 0.0 
                Vf[i,j]   = float("NaN") 
                Vp[i,j]   = float("NaN") 
                UfWf[i,j] = float("NaN") 


#--------------------------------------------------
    c4 = axs[0,index].pcolor(X-pc, Y-pc, Vf, cmap=my_cmap, vmin=0.0, vmax=2.0)
    fig.colorbar(c4, ax = axs[0,index], ticks=[0.0,0.5,1.0,1.5,2.0])
    axs[0,index].set_xlim(-10.0, 10.0)
    axs[0,index].set_ylim(-10.0, 10.0)
    axs[0,index].set_aspect(1.)
    #axs[0,index].set_xlabel("$X/D_p$", fontname=my_fontname, fontsize=my_fontsize)
    axs[0,0].set_ylabel("$z/D_p$", fontname=my_fontname, fontsize=my_fontsize)
    axs[0,index].annotate(figlabel[index], xy=(0.025, 0.892), xycoords="axes fraction")
    #fig.colorbar(c4, ax = axs[0,index])


#--------------------------------------------------
    c5 = axs[1,index].pcolor(X-pc, Y-pc, Vp, cmap=my_cmap, vmin=0.0, vmax=2.0)
    fig.colorbar(c5, ax = axs[1,index], ticks=[0.0,0.5,1.0,1.5,2.0])
    axs[1,index].set_xlim(-10.0, 10.0)
    axs[1,index].set_ylim(-10.0, 10.0)
    axs[1,index].set_aspect(1.)
    #axs[1,index].set_xlabel("$X/D_p$", fontname=my_fontname, fontsize=my_fontsize)
    axs[1,0].set_ylabel("$z/D_p$", fontname=my_fontname, fontsize=my_fontsize)
    axs[1,index].annotate(figlabel[3+index], xy=(0.025, 0.892), xycoords="axes fraction")
    #fig.colorbar(c5, ax = axs[1,index])


#--------------------------------------------------
    magnitude = np.sqrt(U**2 + W**2)
    lw = 2.5*magnitude / magnitude.max()
    c2 = axs[2,index].pcolor(X-pc, Y-pc, UfWf, cmap=my_cmap,vmin=0.0,vmax=np.round(np.nanmax(UfWf),3))
    fig.colorbar(c2, ax = axs[2,index], ticks=[0.0,np.around(np.nanmax(UfWf)/4,3),np.around(np.nanmax(UfWf)/2,3),np.around(np.nanmax(UfWf)*3/4,3),np.around(np.nanmax(UfWf),3)])
    # 03-01-24
    #----------------------------
    skip = (slice(None, None, 10), slice(None, None, 10))
    c1 = axs[2,index].quiver(X[skip]-pc, Y[skip]-pc, U[skip], W[skip], color=my_streamline_color, width=0.06,headwidth=8,headaxislength=2,units ='xy',angles='xy',scale=0.016*arrow_mp[index])
    #----------------------------
    #c1 = axs[2,index].streamplot(X-pc, Y-pc, U, W, density=my_density, color=my_streamline_color, linewidth=lw)
    #c2 = axs[2,index].pcolor(X-pc, Y-pc, UfWf, cmap=my_cmap)
    #c2 = axs[index].pcolor(X-pc, Y-pc, UfWf/UfWf.max(), cmap=my_cmap, vmin=0.0, vmax=1.0)
    c3 = axs[2,index].plot(Cx,Cy,color="black",linewidth=3)
    
    #fig.colorbar(c2, ax = axs[2,index])
    axs[2,index].set_xlim(-10.0, 10.0)
    axs[2,index].set_ylim(-10.0, 10.0)
    axs[2,index].set_aspect(1.)
    axs[2,index].set_xlabel("$x/D_p$", fontname=my_fontname, fontsize=my_fontsize)
    axs[2,0].set_ylabel("$z/D_p$", fontname=my_fontname, fontsize=my_fontsize)
    axs[2,index].annotate(figlabel[6+index], xy=(0.025, 0.892), xycoords="axes fraction")
#cbar = fig.colorbar(c2, ax=axs, ticks=[0.0, 1.0])
    axs[0,index].set_xticklabels([-10,0,10],fontname=my_fontname,fontsize=12)
    axs[1,index].set_xticklabels([-10,0,10],fontname=my_fontname,fontsize=12)
    axs[2,index].set_xticklabels([-10,0,10],fontname=my_fontname,fontsize=12)
    axs[0,index].set_yticklabels([-10,0,10],fontname=my_fontname,fontsize=12)
    axs[1,index].set_yticklabels([-10,0,10],fontname=my_fontname,fontsize=12)
    axs[2,index].set_yticklabels([-10,0,10],fontname=my_fontname,fontsize=12)


#--------------------------------------------------
plt.show()
# Saving it doesnt help
#plt.savefig('Fig6_10Jan2024_Direct.eps', bbox_inches='tight')
