import numpy as np
import matplotlib.pyplot as plt

import matplotlib.pyplot as mpl

mpl.rc('font', family='sans-serif')
mpl.rc('text', usetex=True)

fig, axs = plt.subplots(3,3)

# Filenames
datas = ['Fig11_D1.txt', \
         'Fig11_D2.txt', \
         'Fig11_D3.txt' ] 

figlabel = ['$(a)$', \
            '$(b)$', \
            '$(c)$', \
            '$(d)$', \
            '$(e)$', \
            '$(f)$', \
            '$(g)$', \
            '$(h)$', \
            '$(i)$']

#my_cmap     = 'coolwarm'
#my_cmap     = 'RdYlGn'
#my_cmap     = 'turbo'
my_cmap     = 'jet'
#my_cmap     = 'viridis'
#my_fontname = "Liberation Serif"
my_fontname = "FreeSerif"
my_fontsize = 20
my_density  = 1.5
my_streamline_color = 'k'
plt.rc('font', size=20) #controls default text size
plt.rc('axes', titlesize=20) #fontsize of the title
plt.rc('axes', labelsize=20) #fontsize of the x and y labels
plt.rc('xtick', labelsize=20) #fontsize of the x tick labels
plt.rc('ytick', labelsize=20) #fontsize of the y tick labels
plt.rc('legend', fontsize=20) #fontsize of the legend

sizeX = 352
sizeY = 352

#--------------------------------------------------
X    = np.zeros(shape=(sizeX,sizeY))
Y    = np.zeros(shape=(sizeX,sizeY))
T    = np.zeros(shape=(sizeX,sizeY))
T1   = np.zeros(shape=(sizeX,sizeY))
T2   = np.zeros(shape=(sizeX,sizeY))


# Plot the circle
theta = np.linspace(0, 2 * np.pi, 100)
pc = 11
radius = 10.
Cx = radius * np.cos(theta)
Cy = radius * np.sin(theta)

#--------------------------------------------------
for index in range(0,3):
    print('dataset : ',index+1)
    data = np.loadtxt(datas[index])
    for i in range (0,sizeX):
        for j in range (0,sizeY):
            X[i,j]    =  data[i*sizeY + j,0]
            Y[i,j]    =  data[i*sizeY + j,1]
            if (((X[i,j]-pc)**2. + (Y[i,j]-pc)**2.)**0.5 < radius):
                T[i,j]     = data[i*sizeY + j,2]
                T1[i,j]    = data[i*sizeY + j,3]
                T2[i,j]    = data[i*sizeY + j,4]
            else:
                T[i,j]  = float("NaN") 
                T1[i,j] = float("NaN") 
                T2[i,j] = float("NaN") 


#--------------------------------------------------
    c1 = axs[0,index].pcolor(X-pc, Y-pc, T,  cmap=my_cmap, vmin=-0.005, vmax=0.005)
    c2 = axs[1,index].pcolor(X-pc, Y-pc, T1, cmap=my_cmap, vmin=-0.005, vmax=0.005)
    c3 = axs[2,index].pcolor(X-pc, Y-pc, T2, cmap=my_cmap, vmin=-0.005, vmax=0.005)

    # axis limits
    axs[0,index].set_xlim(-10.0, 10.0)
    axs[0,index].set_ylim(-10.0, 10.0)
    axs[1,index].set_xlim(-10.0, 10.0)
    axs[1,index].set_ylim(-10.0, 10.0)
    axs[2,index].set_xlim(-10.0, 10.0)
    axs[2,index].set_ylim(-10.0, 10.0)
    axs[0,index].set_aspect(1.)
    axs[1,index].set_aspect(1.)
    axs[2,index].set_aspect(1.)
    axs[2,index].set_xlabel("$x/D_p$", fontname=my_fontname, fontsize=my_fontsize)

    # annotate fig label
    axs[0,index].annotate(figlabel[index], xy=(0.03, 0.9), xycoords="axes fraction",fontsize=20)
    axs[1,index].annotate(figlabel[3+index], xy=(0.03, 0.9), xycoords="axes fraction",fontsize=20)
    axs[2,index].annotate(figlabel[6+index], xy=(0.03, 0.9), xycoords="axes fraction",fontsize=20)

    # ticks
    axs[0,index].set_xticklabels([-10,0,10],fontname=my_fontname,fontsize=15)
    axs[1,index].set_xticklabels([-10,0,10],fontname=my_fontname,fontsize=15)
    axs[2,index].set_xticklabels([-10,0,10],fontname=my_fontname,fontsize=15)
    axs[0,index].set_yticklabels([-10,0,10],fontname=my_fontname,fontsize=15)
    axs[1,index].set_yticklabels([-10,0,10],fontname=my_fontname,fontsize=15)
    axs[2,index].set_yticklabels([-10,0,10],fontname=my_fontname,fontsize=15)

# Color bar
fig.colorbar(c3, ax = axs[0,2])
fig.colorbar(c3, ax = axs[1,2])
fig.colorbar(c3, ax = axs[2,2])

# Ylabel
axs[0,0].set_ylabel("$z/D_p$", fontname=my_fontname, fontsize=my_fontsize)
axs[1,0].set_ylabel("$z/D_p$", fontname=my_fontname, fontsize=my_fontsize)
axs[2,0].set_ylabel("$z/D_p$", fontname=my_fontname, fontsize=my_fontsize)
#--------------------------------------------------
plt.show()
